#!/usr/bin/php
<?php

define('PLUGINID', 'com.synology.TheMovieDb');
define('API_URL', 'http://api.themoviedb.org/3/');
define('BANNER_URL', 'http://cf2.imgobject.com/t/p/w500');
define('APIKEY', 'a3dc111e66105f6387e99393813ae4d5');

$DEFAULT_TYPE = 'movie';
$DEFAULT_LANG = 'enu';

$SUPPORTED_TYPE = array('movie');
$SUPPORTED_LANG = array('enu', 'cht');
$SUPPORTED_PROPERTIES = array('title');

require_once(dirname(__FILE__) . '/../search.inc.php');

function ConvertToAPILang($lang)
{
	static $map = array(
		'chs' => 'zh', 'cht' => 'zh', 'csy' => 'cs', 'dan' => 'da',
		'enu' => 'en', 'fre' => 'fr', 'ger' => 'de', 'hun' => 'hu',
		'ita' => 'it', 'jpn' => 'ja', 'krn' => 'ko', 'nld' => 'nl',
		'nor' => 'no', 'plk' => 'pl', 'ptb' => 'pt', 'ptg' => 'pt',
		'rus' => 'ru', 'spn' => 'es', 'sve' => 'sv', 'trk' => 'tr'
	);

	if (isSet($map[$lang])) {
		return $map[$lang];
	}
	return 'en';
}

function GetDownloadedQueryData($query, $lang)
{
	$query = urlencode($query);

	$json = FALSE;
	$need_refresh = TRUE;
	$dir = GetPluginDataDirectory(PLUGINID) . "/query";
	$json_path = "{$dir}/{$query}_{$lang}.json";

	if (file_exists($json_path)) {
		$lastupdated = filemtime($json_path);
		if (86400 >= (time() - $lastupdated)) {
			$json = json_decode(@file_get_contents($json_path));
			if (NULL !== $json) {
				$need_refresh = FALSE;
			}
		}
	}

	if ($need_refresh) {
		@mkdir($dir);
		$fh = @fopen($json_path, 'w');
		if (FALSE === $fh) {
			throw new Exception();
		}

		$response = HTTPGETDownload(API_URL . "search/movie?api_key=" . APIKEY . "&query={$query}&language={$lang}", $fh);
		fclose($fh);

		if (FALSE !== $response) {
			$json = json_decode(@file_get_contents($json_path));
			if (NULL === $json) {
				$json = FALSE;
				$response = FALSE;
			}
		}

		if (FALSE === $response) {
			@unlink($json_path);
		}
	}

	return $json;
}

function GetDownloadedMovieData($id, $lang)
{
	$json = FALSE;
	$need_refresh = TRUE;
    $dir = GetPluginDataDirectory(PLUGINID) . "/{$id}";
    $json_path = "{$dir}/{$lang}.json";

    // whether we need to udpate series data base on last update time
	if (file_exists($json_path)) {
		$lastupdated = filemtime($json_path);
		if (86400 >= (time() - $lastupdated)) {
            $json = file_get_contents($json_path);
            $json = json_decode($json);
			if (NULL !== $json) {
				$need_refresh = FALSE;
			}
		}
	}

	if ($need_refresh) {
		@mkdir($dir);
		$fh = @fopen($json_path, 'w');
		if (FALSE === $fh) {
			throw new Exception();
		}

        $url = API_URL . "movie/{$id}?api_key=" . APIKEY . "&language={$lang}";
        $response = HTTPGETDownload($url, $fh);
        fclose($fh);

		if (FALSE !== $response) {
            $json = json_decode(file_get_contents($json_path));
			if (NULL === $json) {
				$json = FALSE;
				$response = FALSE;
			}
		}

		if (FALSE === $response) {
			unlink($json_path);
		}
	}

    return $json;
}

function GetDownloadedCastData($id, $lang)
{
	$json = FALSE;
	$need_refresh = TRUE;
    $dir = GetPluginDataDirectory(PLUGINID) . "/{$id}";
    $json_path = "{$dir}/{$lang}_cast.json";

    // whether we need to udpate series data base on last update time
	if (file_exists($json_path)) {
		$lastupdated = filemtime($json_path);
		if (86400 >= (time() - $lastupdated)) {
            $json = file_get_contents($json_path);
            $json = json_decode($json);
			if (NULL !== $json) {
				$need_refresh = FALSE;
			}
		}
	}

	if ($need_refresh) {
		@mkdir($dir);
		$fh = @fopen($json_path, 'w');
		if (FALSE === $fh) {
			throw new Exception();
		}

        $url = API_URL . "movie/{$id}/casts?api_key=" . APIKEY;
        $response = HTTPGETDownload($url, $fh);
        fclose($fh);

		if (FALSE !== $response) {
            $json = json_decode(file_get_contents($json_path));
			if (NULL === $json) {
				$json = FALSE;
				$response = FALSE;
			}
		}

		if (FALSE === $response) {
			unlink($json_path);
		}
	}

    return $json;
}

function GetMovieInfo($movie_data, $data)
{
    $data['title'] = $movie_data->title;
    $data['tagline'] = $movie_data->tagline;
    $data['original_available'] = $movie_data->release_date;
	$data['summary'] = $movie_data->overview;

	foreach ($movie_data->genres as $item) {
		if (!in_array($item->name, $data['genre'])) {
			array_push($data['genre'], $item->name);
		}
    }

	//extra
	$data['extra'] = array();
	$data['extra'][PLUGINID] = array('reference' => array());
	$data['extra'][PLUGINID]['reference']['themoviedb'] = $movie_data->id;
	if (isset($movie_data->imdb_id)) {
		 $data['extra'][PLUGINID]['reference']['imdb'] = $movie_data->imdb_id;
	}
	if ((float)$movie_data->vote_average) {
		$data['extra'][PLUGINID]['rating'] = array('themoviedb' => (float)$movie_data->vote_average);
	}
	if (isset($movie_data->poster_path)) {
		 $data['extra'][PLUGINID]['poster'] = array(BANNER_URL . $movie_data->poster_path);
	}

    return $data;
}

function GetCastInfo($cast_data, $data)
{
    // actor
	foreach ($cast_data->cast as $item) {
		if (!in_array($item->name, $data['actor'])) {
			array_push($data['actor'], $item->name);
		}
    }

    // director & writer
	foreach ($cast_data->crew as $item) {
		if (strcasecmp($item->job, 'Director') == 0) {
			if (!in_array($item->name, $data['director'])) {
				array_push($data['director'], $item->name);
			}
        }
		if (strcasecmp($item->job, 'Writer') == 0) {
			if (!in_array($item->name, $data['writer'])) {
				array_push($data['writer'], $item->name);
			}
        }
    }

    return $data;
}

function QueryMovie($title, $query, $lang, $limit)
{
	global $DATA_TEMPLATE;

	$result = array();
	$json = GetDownloadedQueryData($query, $lang);
	if (!$json) {
		return array();
	}

	foreach($json->results as $movie) {
		similar_text(strtolower($title), strtolower($movie->title), $percent);
		if (50 > $percent) {
			continue;
		}

        // copy template
		$data = $DATA_TEMPLATE;
		$movieid = $movie->id;

        // process movie data
        $movie_data = GetDownloadedMovieData($movieid, $lang);
		if (!$movie_data) {
			continue;
		}
		$data = GetMovieInfo($movie_data, $data);

        // process cast data
		$cast_data = GetDownloadedCastData($movieid, $lang);
		if ($cast_data) {
            $data = GetCastInfo($cast_data, $data);
        }

        if ($data) {
			$result[] = $data;
			// -1: all, 0: no result, >0: limit
			if (0 === --$limit) {
				break;
			}
		}
    }

	return $result;
}

function Query($title, $year, $lang, $limit)
{
	$result = array();

	if ($year) {
		$query = $title . ' ' . $year;
		$result = QueryMovie($title, $query, $lang, $limit);
	}

	if (!count($result)) {
		$query = $title;
		$result = QueryMovie($title, $query, $lang, $limit);
	}

	return $result;
}

function Process($input, $lang, $type, $limit, $search_properties)
{
	$result = array();
	$title = $input['title'];
	$year = ParseYear($input['original_available']);
	$lang = ConvertToAPILang($lang);

	$titles = GetGuessingList($title);
	foreach ($titles as $checkTitle) {
		if (empty($checkTitle)) {
			continue;
		}
		$result = Query($checkTitle, $year, $lang, $limit);
		if (0 < count($result)) {
			break;
		}
	}

	return $result;
}

PluginRun('Process');
?>
