<?php
define('YEARBREAK', '*yearBreak*');

function GetGarbageList()
{
	$source_dict = array(
		'mini' => array('minisd', 'halfcd', 'hfcd', 'minibd', 'hdlite'),
		'bluray' => array('bdrc', 'bdrip', 'bluray', 'blu-ray', 'bd', 'brrip', 'hdrip', 'hddvd', 'hddvdrip'),
		'cam' => array('cam'),
		'dvd' => array('ddc', 'dvdrip', 'dvd', 'r1', 'r3'),
		'retail' => array('retail'),
		'dtv' => array('dsr', 'dsrip', 'hdtv', 'pdtv', 'ppv'),
		'stv' => array('stv', 'tvrip'),
		'r5' => array('r5'),
		'screener' => array('bdscr', 'dvdscr', 'dvdscreener', 'scr', 'screener'),
		'svcd' => array('svcd'),
		'vcd' => array('vcd'),
		'telecine' => array('tc', 'telecine'),
		'telesync' => array('ts', 'telesync'),
		'workprint' => array('wp', 'workprint')
	);
	$list_ext = array('3g2', '3gp', 'asf', 'asx', 'avc', 'avi', 'avs', 'bin', 'bivx', 'bup',
					'divx', 'dv', 'dvr-ms', 'evo', 'fli', 'flv', 'ifo', 'img', 'iso', 'm2t',
					'm2ts', 'm2v', 'm4v', 'mkv', 'mov', 'mp4', 'mpeg', 'mpg', 'mts', 'nrg',
					'nsv', 'nuv', 'ogm', 'ogv', 'pva', 'qt', 'rm', 'rmvb', 'sdp', 'svq3',
					'strm', 'ts', 'ty', 'vdr', 'viv', 'vob', 'vp3', 'wmv', 'wpl', 'wtv',
					'xsp', 'xvid', 'webm',
					'mp3', 'm4p', 'm4a', 'm4b', 'flac', 'aac', 'rm', 'rma', 'mpa', 'wav',
					'wma', 'ogg', 'mp2', 'ac3', 'dts', 'ape', 'mpc', 'mp+', 'mpp', 'shn', 'oga');
	$list_subs = array('multi', 'multisubs');
	$list_misc = array('cd1', 'cd2', '1cd', '2cd', 'custom', 'internal', 'repack',
					'read.nfo', 'readnfo', 'nfofix', 'proper', 'rerip', 'dubbed',
					'subbed', 'extended', 'unrated', 'xxx', 'nfo', 'dvxa',
					'sample', 'samples', 'trailer', 'trailers', 'extra', 'extras', 'bonus',
					'pv', 'ost');
	$list_format = array('ac3', 'dc', 'divx', 'fragment', 'limited', 'ogg', 'ogm',
					'ntsc', 'pal', 'avchd', 'ps3avchd', 'r1', 'r3', 'r5', '720i', '720p',
					'1080i', '1080p', 'x264', 'xvid', 'vorbis', 'aac', 'dts',
					'fs', 'ws', '1920x1080', '1280x720', 'h264');
	/* dc = directors cut, se = special edition */
	$list_edition = array('dc', 'se');
	/* famous release team */
	$list_team = array(
		'tlf', 'inf', 'silu', 'hdchina', 'cmct', 'subpig',
		'ctrlhd', 'perfectionhd', 'ill', 'mcr',
		'wiki', 'hdl', 'm794', 'hdxt', 'lulz',
		'chd', 'hds', 'mysilu', 'xtm', 'hdc', 'subhd',
		'refined', 'hv', 'ngr', 'aaf', 'outdated',
		'2hd', 'besthd', 'chakraroot'
	);

	$list_source = array_unique(array_reduce($source_dict, 'array_merge', array()));
	return array_merge($list_source, $list_ext, $list_subs, $list_misc, $list_format, $list_edition, $list_team);
}

function CleanGarbage($title, $year, $regSplit)
{
	$regex_garbage = array(
		'/CRC[ _-]?[0-9a-z]{8}/ui',
		'/[0-9]{3,4}x[0-9]{3,4}/ui'			// resolution 800x600
	);
	foreach ($regex_garbage as $regex) {
		$title = preg_replace($regex, '', $title);
	}

	$tokens = preg_split($regSplit, $title, -1, PREG_SPLIT_NO_EMPTY);
	$cleanTokens = array();
	$cleanFullTokens = array();
	$finals = array();

	$list_garbage = GetGarbageList();
	$year_in_front = true;
	foreach ($tokens as $idx => $token) {
		if (in_array(strtolower($token), $list_garbage)) {
			continue;
		}

		$cleanFullTokens[] = $token;

		/* discard anything after year */
		if (YEARBREAK === $token) {
			if (!$year_in_front) {
				$cleanTokens[] = $token;
				break;
			}
			continue;
		}

		$year_in_front = false;
		$cleanTokens[] = $token;
		$finals[] = $token;
	}

	if (!count($finals)) {
		if (!empty($cleanTokens)) {
			$finals = $cleanTokens;
		} else if (!empty($cleanFullTokens)) {
			$finals = $cleanFullTokens;
		} else {
			$finals = $tokens;
		}
	}

	return implode($finals, ' ');
}

function CleanName($title)
{
	$nowYear = @date('Y');
	$regex_year = '/([ \(\[\.\-])?([1-2][0-9]{3})([ \.\-\)\]_,+$]|$)/Uui';
	$regex_audios = array('/([^0-9])5\.1[ ]*ch(.)/ui','/([^0-9])5\.1([^0-9]?)/ui','/([^0-9])7\.1[ ]*ch(.)/ui','/([^0-9])7\.1([^0-9])/ui');

	/* parse year */
	$year = NULL;
	/* use the last matched item */
	$count = preg_match_all($regex_year, $title, $matches, PREG_SET_ORDER);
	for (--$count; 0 <= $count; --$count) {
		$testYear = $matches[$count][2];
		if (1900 < $testYear && $testYear < ($nowYear + 1)) {
			$year = $testYear;
			$title = str_replace($matches[$count][0], ' ' . YEARBREAK . ' ', $title);
			break;
		}
	}

	/* remove brackets */
	$bracket_title = $title;
	do {
		$bracket_title = trim(preg_replace('/\[[^\]]+\]/ui', '', $bracket_title, -1, $count));
	} while (0 < $count);
	do {
		$bracket_title = trim(preg_replace('/\{[^\}]+\}/ui', '', $bracket_title, -1, $count));
	} while (0 < $count);

	/* restore if empty */
	if (empty($bracket_title)) {
		$bracket_title = $title;
	}

	$title = trim(preg_replace('/[\[\]\{\}]/ui', ' ', $bracket_title));

	/* strip audio codec */
	foreach ($regex_audios as $regex) {
		$title = preg_replace($regex, ' ', $title);
	}

	/* tokenize and filter out garbage tokens */
	$checkTitle = CleanGarbage($title, $year, '/([ _\(\)+]+)/ui');
	if (empty($checkTitle)) {
		$checkTitle = $title;
	}
	$title = $checkTitle;

	$checkTitle = CleanGarbage($title, $year, '/([\.\- _\(\)+]+)/ui');
	if (empty($checkTitle)) {
		$checkTitle = $title;
	}
	$title = $checkTitle;

	if (FALSE !== strpos($title, YEARBREAK)) {
		$title = str_replace(YEARBREAK, $year, $title);
		$year = NULL;
	}

	return array($title, $year);
}
?>
