#!/usr/bin/php
<?php
define('PLUGINID', 'com.synology.TheTVDB');
define('API_URL', 'http://www.thetvdb.com/api/');
define('BANNER_URL', 'http://www.thetvdb.com/banners/');
define('APIKEY', 'D4DDDAEFAD083E6F');

$DEFAULT_TYPE = 'tvshow_episode';
$DEFAULT_LANG = 'enu';

$SUPPORTED_TYPE = array('tvshow', 'tvshow_episode');
$SUPPORTED_LANG = array();
$SUPPORTED_PROPERTIES = array('title');

require_once(dirname(__FILE__) . '/../search.inc.php');

function GetXML($xml_path)
{
	$xml = NULL;

	try {
		@$xml = new SimpleXMLElement(file_get_contents($xml_path));
	} catch (Exception $e) {
	}

	return $xml;
}

function GetDownloadedQueryData($query, $lang)
{
	$query = urlencode($query);

	$xml = FALSE;
	$need_refresh = TRUE;
	$dir = GetPluginDataDirectory(PLUGINID) . "/query";
	$xml_path = "{$dir}/{$query}.xml";

	if (file_exists($xml_path)) {
		$lastupdated = filemtime($xml_path);
		if (86400 >= (time() - $lastupdated)) {
			$xml = GetXML($xml_path);
			if (NULL !== $xml) {
				$need_refresh = FALSE;
			}
		}
	}

	if ($need_refresh) {
		@mkdir($dir);
		$fh = @fopen($xml_path, 'w');
		if (FALSE === $fh) {
			throw new Exception();
		}

		$response = HTTPGETDownload(API_URL . "GetSeries.php?language=all&seriesname={$query}", $fh);
		fclose($fh);

		if (FALSE !== $response) {
			$xml = GetXML($xml_path);
			if (NULL === $xml) {
				$xml = FALSE;
				$response = FALSE;
			}
		}

		if (FALSE === $response) {
			@unlink($xml_path);
		}
	}

	return $xml;
}

function GetDownloadedSeriesData($id, $lang)
{
	$xml = FALSE;
	$need_refresh = TRUE;
	$dir = GetPluginDataDirectory(PLUGINID) . "/{$id}";
	$xml_path = "{$dir}/{$lang}.xml";
	$zip_path = "{$dir}/{$lang}.zip";

	if (file_exists($xml_path)) {
		$lastupdated = filemtime($xml_path);
		if (86400 >= (time() - $lastupdated)) {
			$xml = GetXML($xml_path);
			if (NULL !== $xml) {
				$need_refresh = FALSE;
			}
		}
	}

	if ($need_refresh) {
		@mkdir($dir);
		$fh = @fopen($zip_path, 'w');
		if (FALSE === $fh) {
			throw new Exception();
		}

		$response = HTTPGETDownload(API_URL . APIKEY . "/series/{$id}/all/{$lang}.zip", $fh);
		fclose($fh);

		if (FALSE !== $response) {
			@exec('unzip -qq -o -d ' . escapeshellarg($dir) . ' ' . escapeshellarg($zip_path));
		}
		@unlink($zip_path);
		if (file_exists($xml_path)) {
			@touch($xml_path);
		}

		$xml = GetXML($xml_path);
		if (NULL === $xml) {
			$xml = FALSE;
			@unlink($xml_path);
		}
	}

	return $xml;
}

function GetTVShowInfo($series_data, $data)
{
	$data['title'] = (string)$series_data->Series->SeriesName;
	$data['summary'] = (string)$series_data->Series->Overview;
	$data['original_available'] = (string)$series_data->Series->FirstAired;

	$actors = preg_split('/\s*\|\s*/', trim((string)$series_data->Series->Actors), -1, PREG_SPLIT_NO_EMPTY);
	if (0 < count($actors)) {
		$data['actor'] = array_values(array_unique($actors));
	}

	$genres = preg_split('/\s*\|\s*/', trim((string)$series_data->Series->Genre), -1, PREG_SPLIT_NO_EMPTY);
	if (0 < count($genres)) {
		$data['genre'] = array_values(array_unique($genres));
	}

	$data['extra'][PLUGINID] = array('reference' => array());
	$data['extra'][PLUGINID]['reference']['thetvdb'] = (string)$series_data->Series->id;
	if ((string)$series_data->Series->IMDB_ID) {
		$data['extra'][PLUGINID]['reference']['imdb'] = (string)$series_data->Series->IMDB_ID;
	}
	if ((float)$series_data->Series->Rating) {
		$data['extra'][PLUGINID]['rating'] = array('thetvdb' => (float)$series_data->Series->Rating);
	}
	if ((string)$series_data->Series->poster) {
		$data['extra'][PLUGINID]['poster'] = array(BANNER_URL . (string)$series_data->Series->poster);
	}

	return $data;
}

function GetEpisodeInfo($series_data, $season, $episode, $data)
{
	$episode_data = FALSE;

	//Get episode data
	foreach ($series_data->Episode as $item) {
		if ($season == $item->SeasonNumber ||
			(NULL === $season && 1 == $item->SeasonNumber)) {
			if ($episode == $item->EpisodeNumber) {
				$episode_data = $item;
				break;
			}
		}
	}

	// fill series information

	$data['title'] = (string)$series_data->Series->SeriesName;
	$data['extra'] = array(PLUGINID => array());
	$data['extra'][PLUGINID]['tvshow'] = GetTVShowInfo($series_data, array());

	// return if there is no detail episode information
	if (!$episode_data) {
		return $data;
	}

	// fill episode information

	$data['season'] = (int)$episode_data->SeasonNumber;
	$data['episode'] = (int)$episode_data->EpisodeNumber;
	$data['tagline'] = (string)$episode_data->EpisodeName;
	$data['original_available'] = (string)$episode_data->FirstAired;
	$data['summary'] = (string)$episode_data->Overview;

	$writers = preg_split('/\s*\|\s*/', trim((string)$episode_data->Writer), -1, PREG_SPLIT_NO_EMPTY);
	if (0 < count($writers)) {
		$data['writer'] = array_values(array_unique($writers));
	}

	$directors = preg_split('/\s*\|\s*/', trim((string)$episode_data->Director), -1, PREG_SPLIT_NO_EMPTY);
	if (0 < count($directors)) {
		$data['director'] = array_values(array_unique($directors));
	}

	$genres = preg_split('/\s*\|\s*/', trim((string)$series_data->Series->Genre), -1, PREG_SPLIT_NO_EMPTY);
	if (0 < count($genres)) {
		$data['genre'] = array_values(array_unique($genres));
	}

	$actors = preg_split('/\s*\|\s*/', trim((string)$series_data->Series->Actors), -1, PREG_SPLIT_NO_EMPTY);
	if (0 < count($actors)) {
		$data['actor'] = array_values(array_unique($actors));
	}

	$data['extra'][PLUGINID]['reference'] = array();
	$data['extra'][PLUGINID]['reference']['thetvdb'] = (string)$episode_data->id;
	if ((string)$episode_data->IMDB_ID) {
		 $data['extra'][PLUGINID]['reference']['imdb'] = (string)$episode_data->IMDB_ID;
	}
	if ((float)$episode_data->Rating) {
		$data['extra'][PLUGINID]['rating'] = array('thetvdb' => (float)$episode_data->Rating);
	}
	if ((string)$episode_data->poster) {
		$data['extra'][PLUGINID]['poster'] = array(BANNER_URL . (string)$episode_data->poster);
	}

	return $data;
}

function QueryTVShow($title, $season, $episode, $lang, $type, $limit)
{
	global $DATA_TEMPLATE;

	$result = array();
	$xml = GetDownloadedQueryData($title, $lang);
	if (!$xml) {
		return array();
	}

	foreach($xml->Series as $series) {

		/* copy template */
		$data = $DATA_TEMPLATE;
		$seriesid = (string)$series->seriesid;
		$lang = (string)$series->language;
		$series_name = (string)$series->SeriesName;

		//Sometimes, query result will include invalid series inforamtion
		$invalid = "** Not a valid series";
		if (0 == strncmp($series_name, $invalid, strlen($invalid))) {
			continue;
		}

		$series_data = GetDownloadedSeriesData($seriesid, $lang);
		if (!$series_data) {
			continue;
		}

		switch ($type) {
			case 'tvshow':
				$data = GetTVShowInfo($series_data, $data);
				break;
			case 'tvshow_episode':
				$data = GetEpisodeInfo($series_data, $season, $episode, $data);
				break;
		}

		if ($data) {
			$result[] = $data;
			/* -1: all, 0: no result, >0: limit */
			if (0 === --$limit) {
				break;
			}
		}
	}

	return $result;
}

function Process($input, $lang, $type, $limit, $search_properties)
{
	$result = array();

	$title = $input['title'];
	$season = $input['season'];
	$episode = $input['episode'];

	$titles = GetGuessingList($title);
	foreach ($titles as $checkTitle) {
		if (empty($checkTitle)) {
			continue;
		}
		$result = QueryTVShow($checkTitle, $season, $episode, $lang, $type, $limit);
		if (0 < count($result)) {
			break;
		}
	}

	return $result;
}

PluginRun('Process');
?>
