<?php
function GetMovieInfo($path)
{
	$invalid_titles = array('sample', 'samples', 'trailer', 'trailers');
	$pathinfo = pathinfo($path);
	$path_component = array_reverse(explode('/', $path));
	/* path depth exclude share level (/volumeX/video/) and the empty root element */
	$path_depth = count($path_component) - 3;

	$title = NULL;

	/* check DVD structure */
	if (0 === strcasecmp('vob', $pathinfo['extension'])) {
		/* files in the same directory */
		$files = array_map('strtolower', (array)@scandir($pathinfo['dirname']));
		$is_dvd = is_array($files) && (in_array('video_ts.ifo', $files) || in_array('video_ts.bup', $files));

		if ($is_dvd) {
			if (2 >= $path_depth || 0 !== strcasecmp('video_ts', $path_component[1])) {
				$title = $path_component[1];
			} else {
				$title = $path_component[2];
			}
		}
	/* check BDMV structure */
	} else if (3 <= $path_depth &&
		!strcasecmp('stream', $path_component[1]) &&
		!strcasecmp('bdmv', $path_component[2])) {
		$title = $path_component[3];
	}

	if (NULL === $title) {
		$title = $pathinfo['filename'];
	}

	/* verify title name */
	for ($index = 1; $path_depth > $index; $index++) {
		list($testTitle) = CleanName($title);
		if (!in_array(strtolower($testTitle), $invalid_titles)) {
			break;
		}
		$title = $path_component[$index];
	}

	/* result */
	return CleanName($title);
}
?>
