<?php
function GuessEpisodeInfo($title, $year, $season, $checkTitle)
{
	$episode_regexps = array(
		'/(?P<show>.*?)(Season ?(?P<season>[0-9]+))(.*?)Episode ?(?P<ep>[0-9]+)([- ]?Episode ?(?P<secondEp>[0-9]+))?/ui',		// Season 3 XXXX Episode 04
		'/(?P<show>.*?)(Season ?(?P<season>[0-9]+))[\._ ]*Episode ?(?P<ep>[0-9]+)([- ]?Episode ?(?P<secondEp>[0-9]+))?/ui',		// Season 3 Episode 04
		'/(?P<show>.*?)Season ?(?P<season>[0-9]+)/ui',																			// Season 03
		'/(?P<show>.*?)([sS](?P<season>[0-9]+))[\._ ]*[eE][pP]?(?P<ep>[0-9]+)([- ]?[Ee+][pP]?(?P<secondEp>[0-9]+))?/ui',		// S03E04-E05
		'/(?P<show>.*?)[sS](?P<season>[0-9]{2})[\._\- ]+(?P<ep>[0-9]+)/ui',														// S03-03
		'/(?P<show>.*?)([^0-9]|^)(?P<season>[0-9]{1,2})[Xx](?P<ep>[0-9]+)(-[0-9]+[Xx](?P<secondEp>[0-9]+))?/ui',				// 3x03
		'/(?P<show>.*?)[\._ ]*[eE][pP]?(?P<ep>[0-9]+)([- ]?[Ee+][pP]?(?P<secondEp>[0-9]+))?/ui',							// E04-E05
		'/(?P<show>.*?)[\._ ]*[eE][pP] ?(?P<ep>[0-9]+)([- ]?[Ee+][pP] ?(?P<secondEp>[0-9]+))?/ui',							// E04-E05
		'/(?P<show>.*?)[\._ ]*Episode ?(?P<ep>[0-9]+)([- ]?Episode ?(?P<secondEp>[0-9]+))?/ui'									// Episode 04
//		'/(.*?)[^0-9a-z](?P<season>[0-9]{1,2})(?P<ep>[0-9]{2})([\.\-][0-9]+(?P<secondEp>[0-9]{2})([ \-_\.]|$)[\.\-]?)?([^0-9a-z%]|$)/ui'	// .602.
	);

	$just_episode_regexs = array(
		'/(?P<show>.*?)[\._ ]*[eE][pP]?(?P<ep>[0-9]+)([- ]?[Ee+][pP]?(?P<secondEp>[0-9]+))?/ui',								// E04-E05
		'/(?P<show>.*?)[\._ ]*Episode ?(?P<ep>[0-9]+)([- ]?Episode ?(?P<secondEp>[0-9]+))?/ui',									// Episode 04
		'/(?P<ep>[0-9]{1,3})[\. -_]of[\. -_]+[0-9]{1,3}/ui',		// 01 of 08
		'/^(?P<ep>[0-9]{1,3})[^0-9]/ui',							// 01 - Foo
		'/e[a-z]*[ \.\-_]*(?P<ep>[0-9]{2,3})([^0-9c-uw-z%]|$)/ui',	// Blah Blah ep234
		'/.*?[ \.\-_](?P<ep>[0-9]{2,3})[^0-9c-uw-z%]+/ui',			// Flah - 04 - Blah
		'/.*?[ \.\-_](?P<ep>[0-9]{2,3})$/ui',						// Flah - 04
		'/.*?[^0-9x](?P<ep>[0-9]{2,3})$/ui',						// Flah707
		'/(?P<show>.*?)[\._ ]*[eE][pP]?(?P<ep>[0-9]+)([- ]?[Ee+][pP]?(?P<secondEp>[0-9]+))?/ui',								// XXXX.14
		'/^(?P<ep>[0-9]+)$/ui'										// 01
	);

	$episode = NULL;

	/* parse season/episode */
	foreach ($episode_regexps as $regex) {
		if (0 == preg_match($regex, $checkTitle, $matches)) {
			continue;
		}

		if (isSet($matches['show']) && !empty($matches['show'])) {
			list($title) = CleanName($matches['show']);
		}
		if (isSet($matches['season']) && !empty($matches['season'])) {
			$season = $matches['season'];
		}
		if (isSet($matches['ep']) && !empty($matches['ep'])) {
			$episode = $matches['ep'];
		}
		break;
	}

	/* parse episode from file name */
	if (!$episode) {
		/* clean title first */
		if ($checkTitle !== $title) {
			$checkTitle = str_replace($title, '', $checkTitle);
		}
		foreach ($just_episode_regexs as $regex) {
			if (0 == preg_match($regex, $checkTitle, $matches)) {
				continue;
			}
			if (empty($title) && isSet($matches['show']) && !empty($matches['show'])) {
				list($title) = CleanName($matches['show']);
			}
			if (isSet($matches['ep']) && !empty($matches['ep'])) {
				$episode = $matches['ep'];
			}
			break;
		}
	}

	return array($title, $season, $episode);
}

function GetEpisodeInfo($path)
{
	$standalone_episode_regexs = array(
		'/(.*?)( \(([0-9]+)\))? - ([0-9]+)+x([0-9]+)(-[0-9]+[Xx]([0-9]+))?( - (.*))?/ui',		// Newzbin style, no _UNPACK_
		'/(.*?)( \(([0-9]+)\))?[Ss]([0-9]+)+[Ee]([0-9]+)(-[0-9]+[Xx]([0-9]+))?( - (.*))?/ui'		// standard s00e00
	);
	$season_regex = '/.*?(season|s)\s*(?P<season>[0-9]+)$/ui';	// folder for a season
	$date_regexps = array(
		'/(?P<year>[0-9]{4})[^0-9a-zA-Z]+(?P<month>[0-9]{2})[^0-9a-zA-Z]+(?P<day>[0-9]{2})([^0-9]|$)/ui',			// 2009-02-10
		'/(?P<month>[0-9]{2})[^0-9a-zA-Z]+(?P<day>[0-9]{2})[^0-9a-zA-Z(]+(?P<year>[0-9]{4})([^0-9a-zA-Z]|$)/ui',	// 02-10-2009
	);
	$whacx_regex = array('/([hHx][\.]?264)[^0-9]/ui', '/[^[0-9](720[pP])/ui', '/[^[0-9](1080[pP])/ui', '/[^[0-9](480[pP])/ui');
	$title_tagline_regex = '/^(?P<show>.*?)\s*-\s*(?P<tagline>.*?)$/ui';

	/* sync with other rules */
	$ends_with_episode = array(
		'/(Season ?(?P<season>[0-9]+))(.*?)Episode ?(?P<ep>[0-9]+)([- ]?Episode ?(?P<secondEp>[0-9]+))?$/ui',		// Season 3 XXXX Episode 04
		'/(Season ?(?P<season>[0-9]+))[\._ ]*Episode ?(?P<ep>[0-9]+)([- ]?Episode ?(?P<secondEp>[0-9]+))?$/ui',		// Season 3 Episode 04
		'/Season ?(?P<season>[0-9]+)$/ui',																			// Season 03
		'/([sS](?P<season>[0-9]+))[\._ ]*[eE][pP]?(?P<ep>[0-9]+)([- ]?[Ee+][pP]?(?P<secondEp>[0-9]+))?$/ui',		// S03E04-E05
		'/[sS](?P<season>[0-9]{2})[\._\- ]+(?P<ep>[0-9]+)$/ui',														// S03-03
		'/(?P<season>[0-9]{1,2})[Xx](?P<ep>[0-9]+)(-[0-9]+[Xx](?P<secondEp>[0-9]+))?$/ui',				// 3x03
		'/[eE][pP]?(?P<ep>[0-9]+)([- ]?[Ee+][pP]?(?P<secondEp>[0-9]+))?$/ui',							// E04-E05
		'/[eE][pP] ?(?P<ep>[0-9]+)([- ]?[Ee+][pP] ?(?P<secondEp>[0-9]+))?$/ui',							// E04-E05
		'/Episode ?(?P<ep>[0-9]+)([- ]?Episode ?(?P<secondEp>[0-9]+))?$/ui',									// Episode 04
		'/[\._ ]+(?P<ep>[0-9]{2,3})$/ui',						// 707
	);

	$pathinfo = pathinfo($path);
	$filename = $pathinfo['filename'];
	$path_component = array_reverse(explode('/', $path));
	/* path depth exclude share level (/volumeX/video/) and the empty root element */
	$path_depth = count($path_component) - 3;

	$title = NULL;
	$tagline = NULL;
	$year = NULL;
	$season = NULL;
	$episode = NULL;

	list($cleanName, $cleanYear) = CleanName($filename);

	if (2 <= $path_depth) {
		/* get season from parent directory name  */
		if (3 <= $path_depth && 0 < preg_match($season_regex, $path_component[1], $matches)) {
			$season = $matches['season'];
			/* get show name from grandparent directory name. */
			list($title, $year) = CleanName($path_component[2]);
		} else {
			list($title, $year) = CleanName($path_component[1]);
		}
	}

	if (!$title) {
		$title = $cleanName;
	}
	if (!$year) {
		$year = $cleanYear;
	}

	/* strip out episode info from title */
	foreach ($ends_with_episode as $regex) {
		$title = preg_replace($regex, '',  $title);
	}

	/* clean filename */
	$filename = CleanGarbage($filename, $year, '/([\.\- _\(\)+]+)/ui');
	foreach ($whacx_regex as $regex) {
		$filename = preg_replace($regex, ' ', $filename);
	}

	/* guessing... */
	list($title, $season, $episode) = GuessEpisodeInfo($title, $year, $season, $cleanName);
	if (!$episode) {
		list(, , $episode) = GuessEpisodeInfo($title, $year, $season, $filename);
	}

	/* parse date when episode empty */
	if (!$episode) {
		foreach ($date_regexps as $regex) {
			if (0 == preg_match($regex, $filename, $matches)) {
				continue;
			}
			$year = $matches['year'] . '-' . $matches['month'] . '-' . $matches['day'];
			break;
		}
	}

	/* no season, no episode, use the cleaned filename as title */
	if (!$season && !$episode) {
		$title = NULL;
		$checkFilename = CleanGarbage($pathinfo['filename'], $year, '/([\. _\(\)+]+)/ui');
		if (0 !== preg_match($title_tagline_regex, $checkFilename, $matches)) {
			if (isSet($matches['show']) && !empty($matches['show'])) {
				list($title) = CleanName($matches['show']);
			}
			if (isSet($matches['tagline']) && !empty($matches['tagline'])) {
				list($tagline) = CleanName($matches['tagline']);
			}
		}
		if (empty($title)) {
			$title = $cleanName;
		}
	}

	return array($title, $tagline, $year, (int)$season, (int)$episode);
}
?>
