#!/usr/bin/php
<?php

define('PLUGINID', 'com.synology.Freebase');
define('API_URL', 'https://www.googleapis.com/freebase/v1/');
define('DEPRECATED_API_URL', 'http://api.freebase.com/api/');

$DEFAULT_TYPE = 'movie';
$DEFAULT_LANG = 'enu';

$SUPPORTED_TYPE = array('movie');
$SUPPORTED_LANG = array();
$SUPPORTED_PROPERTIES = array('title');

require_once(dirname(__FILE__) . '/../search.inc.php');

function ConvertToAPILang($lang)
{
	static $map = array(
		'enu' => 'en'
	);

	if (isSet($map[$lang])) {
		return $map[$lang];
	}
	return 'en';
}

function GetQueryString($id)
{
	$actor = array("actor" => NULL);
	$actors = array($actor);

    $query = array(
		"mid"                               => "{$id}",
		"type"                              => "/film/film",
        "name"                              => NULL,
		"/film/film/tagline"                => array(),
        "/film/film/initial_release_date"   => NULL,
        "/film/film/written_by"             => array(),
        "/film/film/directed_by"            => array(),
        "/film/film/genre"                  => array(),
        "/film/film/starring"               => $actors,
    );

	return json_encode($query);
}

function GetDownloadedQueryData($query, $lang)
{
	$query = urlencode($query);

	$json = FALSE;
	$need_refresh = TRUE;
	$dir = GetPluginDataDirectory(PLUGINID) . "/query";
	$json_path = "{$dir}/{$query}.json";

	if (file_exists($json_path)) {
		$lastupdated = filemtime($json_path);
		if (86400 >= (time() - $lastupdated)) {
			$json = json_decode(@file_get_contents($json_path));
			if (NULL !== $json && !$json->error) {
				$need_refresh = FALSE;
			}
		}
	}

	if ($need_refresh) {
		@mkdir($dir);
		$fh = @fopen($json_path, 'w');
		if (FALSE === $fh) {
			throw new Exception();
		}

		$response = HTTPGETDownload(API_URL . "search?query={$query}&type='/film/film'&indent=true", $fh);
		fclose($fh);

		if (FALSE !== $response) {
			$json = json_decode(@file_get_contents($json_path));
			if (NULL === $json || $json->error) {
				$json = FALSE;
				$response = FALSE;
			}
		}

		if (FALSE === $response) {
			@unlink($json_path);
		}
	}

	return $json;
}

function GetDownloadedMovieData($id, $lang)
{
	$json = FALSE;
	$need_refresh = TRUE;
	$json_path = GetPluginDataDirectory(PLUGINID) . "/" . urlencode($id) . ".json";

    // whether we need to udpate series data base on last update time
	if (file_exists($json_path)) {
		$lastupdated = filemtime($json_path);
		if (86400 >= (time() - $lastupdated)) {
            $json = file_get_contents($json_path);
            $json = json_decode($json);
			if (NULL !== $json && !$json->error) {
				$need_refresh = FALSE;
			}
		}
	}

	if ($need_refresh) {
		@mkdir($dir);
		$fh = @fopen($json_path, 'w');
		if (FALSE === $fh) {
			throw new Exception();
		}

		$url = API_URL . "mqlread?query=" . urlencode(GetQueryString($id));
        $response = HTTPGETDownload($url, $fh);
        fclose($fh);

		if (FALSE !== $response) {
			$json = json_decode(@file_get_contents($json_path));
			if (NULL === $json || $json->error) {
				$json = FALSE;
				$response = FALSE;
			}
		}

		if (FALSE === $response) {
			@unlink($json_path);
		}
	}

	//Check data is valid
	if (NULL == $json->result) {
		$json = FALSE;
	}

    return $json;
}

function GetMovieInfo($movie_data, $data)
{
    $data['title'] = $movie_data->result->name;
    $data['tagline'] = @$movie_data->result->{'/film/film/tagline'}[0];
    $data['original_available'] = $movie_data->result->{'/film/film/initial_release_date'};

	$data['writer'] = array_values(array_unique($movie_data->result->{'/film/film/written_by'}));
	$data['director'] = array_values(array_unique($movie_data->result->{'/film/film/directed_by'}));
	$data['genre'] = array_values(array_unique($movie_data->result->{'/film/film/genre'}));

	foreach ($movie_data->result->{'/film/film/starring'} as $item) {
		if (!in_array($item->actor, $data['actor'])) {
			array_push($data['actor'], $item->actor);
		}
	}

	//extra
	$data['extra'] = array();
	$data['extra'][PLUGINID] = array('reference' => array());
	$data['extra'][PLUGINID]['reference']['freebase'] = $movie_data->result->mid;

    return $data;
}

function QueryMovie($title, $query, $lang, $limit)
{
	global $DATA_TEMPLATE;

	$result = array();
	$json = GetDownloadedQueryData($query, $lang);
	if (!$json) {
		return array();
	}

	foreach($json->result as $movie) {
		if (!isSet($movie->notable) || !isSet($movie->notable->id) || '/film/film' !== $movie->notable->id) {
			continue;
		}
		// check similarity
		similar_text(strtolower($title), strtolower($movie->name), $percent);
		if (50 > $percent) {
			continue;
		}

        // copy template
		$data = $DATA_TEMPLATE;
		$movieid = $movie->mid;

        // process movie data
        $movie_data = GetDownloadedMovieData($movieid, $lang);
		if ($movie_data) {
			$result[] = GetMovieInfo($movie_data, $data);

			// -1: all, 0: no result, >0: limit
			if (0 === --$limit) {
				break;
			}
        }
    }

	return $result;
}

function Query($title, $year, $lang, $limit)
{
	$result = array();

	if ($year) {
		$query = $title . ' ' . $year;
		$result = QueryMovie($title, $query, $lang, $limit);
	}

	if (!count($result)) {
		$query = $title;
		$result = QueryMovie($title, $query, $lang, $limit);
	}

	return $result;
}

function Process($input, $lang, $type, $limit, $search_properties)
{
	$result = array();
	$title = $input['title'];
	$year = $input['original_available'];
	$lang = ConvertToAPILang($lang);

	$titles = GetGuessingList($title);
	foreach ($titles as $checkTitle) {
		if (empty($checkTitle)) {
			continue;
		}
		$result = Query($checkTitle, $year, $lang, $limit);
		if (0 < count($result)) {
			break;
		}
	}

	return $result;
}

PluginRun('Process');

?>
