#!/bin/sh

#################################################################
# This hook is invoked when ip change
# For renew push "route {private network}"
# Usable environment variable: IFNAME,ORIGIN_ADDRESS,NEW_ADDRESS
#################################################################

PACKAGE_LOCATION="/var/packages/VPNCenter"
PKG_USERCONF_DIR="/usr/syno/etc/packages/VPNCenter"
SYNOVPN_CONF="${PKG_USERCONF_DIR}/synovpn.conf"
OPENVPN_CONF="${PACKAGE_LOCATION}/etc/openvpn/openvpn.conf"

modify_push_route () {
	if [ -z "${IFNAME}" ]; then
		return
	fi

	local ServerInfo=`/bin/cat ${OPENVPN_CONF} | /bin/grep ^server | /usr/bin/awk '{ print $2 }'`
	local OldRoute=`/bin/grep push ${OPENVPN_CONF} | /bin/grep -v ${ServerInfo}`
	local CurIP=`/sbin/ip addr show ${IFNAME} | /bin/grep "inet" | /bin/grep -v "inet6" | head -n 1 | /usr/bin/awk '{ print $2 }'`

	local NewNet=`/bin/ipcalc -n ${CurIP} | /usr/bin/cut -d= -f 2`
	local NewMask=`/bin/ipcalc -m ${CurIP} | /usr/bin/cut -d= -f 2`
	local NewRoute="push \"route ${NewNet} ${NewMask}\""

	if [ -n "${OldRoute}" -a -n "${NewRoute}" ]; then
		${PACKAGE_LOCATION}/target/scripts/openvpn.sh restart
	fi
}
post() {
	local run=`/bin/get_key_value ${SYNOVPN_CONF} runopenvpn`
	local vpnifname=`/bin/get_key_value ${SYNOVPN_CONF} vpninterface`
	if [ "yes" = "${run}" -a "${IFNAME}" = "${vpnifname}" ]; then
		modify_push_route
	fi
}
case $1 in
	--sdk-mod-ver)
		echo "1.0"
		;;
	--name)
		;;
	--pkg-ver)
		;;
	--vendor)
		;;
	--pre)
		;;
	--post)
		post
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
