#!/bin/sh

#################################################################
# This hook is invoked when ip change
#################################################################

PACKAGE_LOCATION="/var/packages/VPNCenter"
PKG_USERCONF_DIR="/usr/syno/etc/packages/VPNCenter"
SYNOVPN_CONF="${PKG_USERCONF_DIR}/synovpn.conf"
L2TP_CONF="${PACKAGE_LOCATION}/etc/l2tp/xl2tpd.conf"

post () {
	local run=`/bin/get_key_value ${SYNOVPN_CONF} runl2tpd`
	if [ "yes" = "${run}" ]; then
		local OldIp=`/bin/grep listen-addr ${L2TP_CONF} | cut -d'=' -f 2`
		${PACKAGE_LOCATION}/target/bin/synovpnnet update_l2tp_if
		local NewIp=`/bin/grep listen-addr ${L2TP_CONF} | cut -d'=' -f 2`
		if [ "${OldIp}" != "${NewIp}" ]; then
			${PACKAGE_LOCATION}/target/bin/synovpnnet restore_psk
			${PACKAGE_LOCATION}/target/scripts/l2tpd.sh restart
		fi
	fi
}

case $1 in
	--sdk-mod-ver)
		echo "1.0"
		;;
	--name)
		;;
	--pkg-ver)
		;;
	--vendor)
		;;
	--pre)
		;;
	--post)
		post
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
