#!/bin/sh
#
# radiusd	Start the radius daemon.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
#
#    Copyright (C) 2001-2008 The FreeRADIUS Project http://www.freeradius.org

prefix=/var/packages/VPNCenter/target
exec_prefix=${prefix}
sbindir=${exec_prefix}/sbin
localstatedir=${prefix}/var
logdir=${localstatedir}/log/radius
rundir=${localstatedir}/run/radiusd
sysconfdir=${prefix}/etc
confdir=/var/packages/VPNCenter/etc/syno_conf

RADIUSD=$sbindir/vpnauthd
RADDBDIR=${sysconfdir}/raddb
DESC="FreeRADIUS"

#
#  See 'man radiusd' for details on command-line options.
#
ARGS="-t"

test -f $RADIUSD || exit 1
test -f $RADDBDIR/radiusd.conf || exit 1

if [ ! -d $rundir ] ; then
    mkdir $rundir
#    chown radmin:radius $rundir
    chmod 775 $rundir
fi

if [ ! -d $logdir ] ; then
    mkdir $logdir
#    chown radmin:radius $logdir
    chmod 770 $logdir
    chmod g+s $logdir
fi

if [ ! -f $logdir/radius.log ]; then
        touch $logdir/radius.log
fi

#chown radmin:radius $logdir/radius.log
chmod 660 $logdir/radius.log

CheckPidFile()
{
	if [ -f $1 ]; then
		if [ -d /proc/`cat $1` ]; then
			return 0
		fi
	fi
	return 1

}

SYNOVPN_CONF="/usr/syno/etc/packages/VPNCenter/synovpn.conf"
RunPPTP=`/bin/get_key_value ${SYNOVPN_CONF} runpptpd`
RunL2TP=`/bin/get_key_value ${SYNOVPN_CONF} runl2tpd`
RunOpenVPN=`/bin/get_key_value ${SYNOVPN_CONF} runopenvpn`

case "$1" in
  start)
	if [ "${RunPPTP}" != "yes" -a "${RunL2TP}" != "yes" -a "${RunOpenVPN}" != "yes" ]; then
		exit 0
	fi

        ln -sf ${prefix}/etc/radiusclient /etc/

	CheckPidFile $rundir/radiusd.pid
	Ret=$?
	if [ $Ret -eq 0 ]; then 
		exit 0
	fi

	if [ -d $confdir ] ; then
		chmod 600 $confdir/*
	fi

	echo -n "Starting $DESC:"
	initctl start pkg-VPNCenter-vpnauthd
	;;
  stop)
	CheckPidFile /var/run/accel-pppd.pid
	RetPPTP=$?
	CheckPidFile /var/run/xl2tpd.pid
	RetL2TP=$?
	CheckPidFile /var/run/ovpn_server.pid
	RetOpenVPN=$?

	if [ $RetPPTP -eq 0 -o $RetL2TP -eq 0 -o $RetOpenVPN -eq 0 ]; then 
		exit 0
	fi

        #remove link of radiusclient config
        /bin/rm -f /etc/radiusclient

	[ -z "$2" ] && echo -n "Stopping $DESC: "
	status=$(initctl status pkg-VPNCenter-vpnauthd | grep "start")
	if [ "" != "$status" ]; then
		initctl stop pkg-VPNCenter-vpnauthd
	fi
	[ -f $rundir/radiusd.pid ] && /bin/rm -rf $rundir/radiusd.pid
	;;
  reload|force-reload)
	echo "Reloading $DESC configuration files."
	status=$(initctl status pkg-VPNCenter-vpnauthd | grep "start")
	if [ "" != "$status" ]; then
		initctl reload pkg-VPNCenter-vpnauthd
	fi
	;;
  force-restart)
	status=$(initctl status pkg-VPNCenter-vpnauthd | grep "start")
	if [ "" != "$status" ]; then
		initctl stop pkg-VPNCenter-vpnauthd
	fi
	sleep 3
	sh $0 start
	;;
  restart)
	sh $0 stop quiet
	sleep 3
	sh $0 start
	;;
  check)
  	$RADIUSD -C $ARGS
	;;
  *)
        echo "Usage: $0 {start|stop|reload|restart|check}"
        exit 1
esac

exit 0
