#!/bin/sh
#
# Start the L2TP server daemon
#

PKG_USERCONF_DIR="/usr/syno/etc/packages/VPNCenter"
LOCALIP=`/bin/get_key_value ${PKG_USERCONF_DIR}/l2tp/xl2tpd.conf "local ip"`
PKG_TARGET="/var/packages/VPNCenter/target"
KERNEL_VERSION=`uname -r`
IPTABLES_MODULE_LIST="/usr/syno/etc.defaults/iptables_modules_list"
MTU=`/bin/cat ${PKG_USERCONF_DIR}/l2tp/options.xl2tpd | grep mtu | sed 's/^.*mtu //g'`
MSS=$((MTU-44))
TMP_L2TP_FILE="/tmp/vpnl2tpserver"

SERVICE="l2tp"
BIN_IPTABLESTOOL="/usr/syno/bin/iptablestool"
BIN_SYNOMODULETOOL="/usr/syno/bin/synomoduletool"
if [ -x "/usr/sbin/ipsec" ]; then
	SBIN_IPSEC="/usr/sbin/ipsec"
elif [ -x "/usr/local/sbin/ipsec" ]; then
	SBIN_IPSEC="/usr/local/sbin/ipsec"
else
	exit 1
fi

# where the private directory and the config files are
IPSEC_CONFS="${PKG_USERCONF_DIR}/l2tp"
export IPSEC_CONFS

reverse_modules() {
	local modules=$1
	local mod
	local ret=""

	for mod in $modules; do
	    ret="$mod $ret"
	done

	echo $ret
}

IPSec_Mod=""
if [ -f "${IPTABLES_MODULE_LIST}" ]; then
	. ${IPTABLES_MODULE_LIST}

	for mod in $PPP_MODULES; do
		if [ -e "/lib/modules/$mod" ]; then
			IPSec_Mod="${IPSec_Mod} ${mod}"
		fi
	done
	for mod in $L2TP_MODULES; do
		if [ -e "/lib/modules/$mod" ]; then
			IPSec_Mod="${IPSec_Mod} ${mod}"
		fi
	done
	for mod in $KERNEL_MODULES_CORE; do
		if [ -e "/lib/modules/$mod" ]; then
			IPSec_Mod="${IPSec_Mod} ${mod}"
		fi
	done
	for mod in $KERNEL_MODULES_COMMON; do
		if [ -e "/lib/modules/$mod" ]; then
			IPSec_Mod="${IPSec_Mod} ${mod}"
		fi
	done
	for mod in $KERNEL_MODULES_NAT; do
		if [ -e "/lib/modules/$mod" ]; then
			IPSec_Mod="${IPSec_Mod} ${mod}"
		fi
	done
else
	. ${PKG_TARGET}/scripts/vpn_modules.sh

	for mod in $L2TP_MODULES; do
		if [ -e "/lib/modules/$mod" ]; then
			IPSec_Mod="${IPSec_Mod} ${mod}"
		fi
	done
fi

for mod in $IPSec_MODULES; do
	if [ -e "/lib/modules/$mod" ]; then
		IPSec_Mod="${IPSec_Mod} ${mod}"
	fi
done

start() {
	Run=`/bin/get_key_value ${PKG_USERCONF_DIR}/synovpn.conf runl2tpd`
	if [ "yes" != "$Run" ]; then
		exit 0;
	fi

	touch $TMP_L2TP_FILE

	echo "Starting L2TP server: "
	if [ -x ${BIN_SYNOMODULETOOL} ]; then
		$BIN_SYNOMODULETOOL --insmod $SERVICE ${IPSec_Mod}
	elif [ -x ${BIN_IPTABLESTOOL} ]; then
		$BIN_IPTABLESTOOL --insmod $SERVICE ${IPSec_Mod}
	fi

	if [ -n "`pidof xl2tpd`" ]; then
	   echo "Already running"
	   return
	fi
	if [ ! -d "/var/run/xl2tpd" ]; then
		/bin/mkdir -p /var/run/xl2tpd
	fi
	/usr/sbin/xl2tpd -c ${PKG_USERCONF_DIR}/l2tp/xl2tpd.conf -p /var/run/xl2tpd.pid
	echo 1 > /proc/sys/net/ipv4/ip_forward

	/sbin/iptables -t nat -A POSTROUTING -s ${LOCALIP}/24 -j MASQUERADE
	/sbin/iptables -t mangle -A PRIMITIVE_FORWARD -i ppp3+ -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss "${MSS}"
	for f in /proc/sys/net/ipv4/conf/*;
	do
		echo 0 > $f/send_redirects;
		echo 0 > $f/accept_redirects;
	done
	${SBIN_IPSEC} addconn --checkconfig --verbose
	if [ $? != 0 ]; then
		exit 1
	fi

	#clear pluto dir to avoid unexpected shutdown
	/bin/rm -f /var/run/pluto/*

	${SBIN_IPSEC} setup start
	${PKG_TARGET}/scripts/radiusd.sh start
}

stop() {
	Run=`/bin/get_key_value ${PKG_USERCONF_DIR}/synovpn.conf runl2tpd`
	if [ "yes" != "$Run" ] || [ ! -f "${TMP_L2TP_FILE}" ]; then
		exit 0;
	fi

	rm -f "${TMP_L2TP_FILE}"

	local modules=`reverse_modules "${IPSec_Mod}"`
	echo -n "Shutting down L2TP server: "

	#disconnect clients
	if [ -n "${LOCALIP}" ]; then
		/bin/kill `ps aux | /bin/grep pppd | /bin/grep l2tp | /bin/grep "${LOCALIP}" | awk '{print $1;}'` 2>/dev/null
	fi

		/sbin/iptables -t nat -D POSTROUTING -s ${LOCALIP}/24 -j MASQUERADE
		/sbin/iptables -t mangle -D PRIMITIVE_FORWARD -i ppp3+ -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss "${MSS}"

	/bin/kill `cat /var/run/xl2tpd.pid` 2>/dev/null
	${SBIN_IPSEC} setup stop
	sleep 1
	if [ -n "`pidof xl2tpd`" ]; then
	    echo "Failed to stop xl2tpd"
	fi

	if [ -x ${BIN_SYNOMODULETOOL} ]; then
		$BIN_SYNOMODULETOOL --rmmod $SERVICE $modules
	elif [ -x ${BIN_IPTABLESTOOL} ]; then
		$BIN_IPTABLESTOOL --rmmod $SERVICE $modules
	fi

	${PKG_TARGET}/scripts/radiusd.sh stop
}

case "$1" in
	start)
		start
	;;
	stop)
		stop
	;;
	restart|reload)
		stop
		start
	;;
	*)
	echo "Usage: $0 {start|stop|restart}"
	exit 1
esac
exit $?
