#!/bin/sh
#
# Start the PPTP server daemon
#

PKG_USERCONF_DIR="/usr/syno/etc/packages/VPNCenter"
LOCALIP=`grep "^gw-ip-address" ${PKG_USERCONF_DIR}/pptp/accel-pppd.conf | cut -d'=' -f 2`
PKG_TARGET="/var/packages/VPNCenter/target"
IPTABLES_MODULE_LIST="/usr/syno/etc.defaults/iptables_modules_list"
SERVICE="pptp"
BIN_IPTABLESTOOL="/usr/syno/bin/iptablestool"
BIN_SYNOMODULETOOL="/usr/syno/bin/synomoduletool"
MTU=`/bin/cat ${PKG_USERCONF_DIR}/pptp/accel-pppd.conf | grep mtu | cut -d'=' -f 2`
MSS=$((MTU-44))

reverse_modules() {
	local modules=$1
	local mod
	local ret=""

	for mod in $modules; do
	    ret="$mod $ret"
	done

	echo $ret
}

PPTP_Mod=""
if [ -f "${IPTABLES_MODULE_LIST}" ]; then
	. ${IPTABLES_MODULE_LIST}

	for mod in $PPP_MODULES; do
		if [ -e "/lib/modules/$mod" ]; then
			PPTP_Mod="${PPTP_Mod} ${mod}"
		fi
	done

	for mod in $PPTP_MODULES; do
		if [ -e "/lib/modules/$mod" ]; then
			PPTP_Mod="${PPTP_Mod} ${mod}"
		fi
	done
	for mod in $KERNEL_MODULES_CORE; do
		if [ -e "/lib/modules/$mod" ]; then
			PPTP_Mod="${PPTP_Mod} ${mod}"
		fi
	done
	for mod in $KERNEL_MODULES_COMMON; do
		if [ -e "/lib/modules/$mod" ]; then
			PPTP_Mod="${PPTP_Mod} ${mod}"
		fi
	done
	for mod in $KERNEL_MODULES_NAT; do
		if [ -e "/lib/modules/$mod" ]; then
			PPTP_Mod="${PPTP_Mod} ${mod}"
		fi
	done
else
	. ${PKG_TARGET}/scripts/vpn_modules.sh

	for mod in $PPTP_MODULES; do
		if [ -e "/lib/modules/$mod" ]; then
			PPTP_Mod="${PPTP_Mod} ${mod}"
		fi
	done
fi


start() {
	Run=`/bin/get_key_value ${PKG_USERCONF_DIR}/synovpn.conf runpptpd`
	if [ "yes" != "$Run" ]; then
		exit 0;
	fi

	echo -n "Starting PPTP server: "
	if [ -x ${BIN_SYNOMODULETOOL} ]; then
		$BIN_SYNOMODULETOOL --insmod $SERVICE ${PPTP_Mod}
	elif [ -x ${BIN_IPTABLESTOOL} ]; then
		$BIN_IPTABLESTOOL --insmod $SERVICE ${PPTP_Mod}
	fi

	if [ -n "`pidof accel-pppd`" ]; then
	   echo "Already running"
	   return
	fi
	${PKG_TARGET}/sbin/accel-pppd -c ${PKG_USERCONF_DIR}/pptp/accel-pppd.conf -d -p /var/run/accel-pppd.pid
	echo 1 > /proc/sys/net/ipv4/ip_forward

        /sbin/iptables -t nat -A POSTROUTING -s ${LOCALIP}/24 -j MASQUERADE
		/sbin/iptables -t mangle -A PRIMITIVE_FORWARD -i ppp2+ -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss "${MSS}"

	${PKG_TARGET}/scripts/radiusd.sh start
}
stop() {
	local modules=`reverse_modules "${PPTP_Mod}"`
	echo -n "Shutting down PPTP server: "

        /sbin/iptables -t nat -D POSTROUTING -s ${LOCALIP}/24 -j MASQUERADE
		/sbin/iptables -t mangle -D PRIMITIVE_FORWARD -i ppp2+ -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss "${MSS}"

	${PKG_TARGET}/bin/accel-cmd shutdown hard 2>/dev/null

	PPTP_PID=`cat /var/run/accel-pppd.pid`
	time=1
	while true; do
		/bin/sleep 1
		if [ $time -ge 10 ]; then
			break
		fi
		time=$(($time + 1))
		if [ -d /proc/${PPTP_PID} ]; then
			echo "Wait for stoping accel-pppd"
		else
			break
		fi
	done

	#echo 0 > /proc/sys/net/ipv4/ip_forward

	if [ -x ${BIN_SYNOMODULETOOL} ]; then
		$BIN_SYNOMODULETOOL --rmmod $SERVICE $modules
	elif [ -x ${BIN_IPTABLESTOOL} ]; then
		$BIN_IPTABLESTOOL --rmmod $SERVICE $modules
	fi

	${PKG_TARGET}/scripts/radiusd.sh stop
}

case "$1" in
	start)
		start
	;;
	stop)
		stop
	;;
	restart|reload)
		stop
		start
	;;
	condrestart)
		if [ -r /opt/var/run/accel-pppd.pid ]; then
			stop
			start
		fi
	;;
	*)
	echo "Usage: $0 {start|stop|restart|condrestart}"
	exit 1
esac
exit $?
