#!/bin/sh

###############################################################
#   This script should be hooked when interface name changed
#   Usable environment variable:
#	ORIGIN_IFNAME_NUM ORIGIN_IFNAME_1 ... ORIGIN_IFNAME_N
#	IFNAME_NUM IFNAME_1 ... IFNAME_N
#	RESULT
#
#   Note: The script should bear to be invoked multiple times 
###############################################################

#Conf dir/file definition
DIR_PKG_TOP=/var/packages/VPNCenter
FILE_PKG_INFO=${DIR_PKG_TOP}/INFO
FILE_PKG_ENABLE=${DIR_PKG_TOP}/enabled
DIR_PKG_RESOURCE=${DIR_PKG_TOP}/target
SYNOVPNNET=${DIR_PKG_RESOURCE}/bin/synovpnnet

PackageInfoGet(){
    if [ -f "${FILE_PKG_INFO}" ]; then
	PKG_NAME=`/bin/get_key_value ${FILE_PKG_INFO} package`
	PKG_VERSION=`/bin/get_key_value ${FILE_PKG_INFO} version`
	PKG_VENDOR=`/bin/get_key_value ${FILE_PKG_INFO} maintainer`
	PKG_MODVER=`/bin/get_key_value ${FILE_PKG_INFO} sdkmodversion`
    else
	echo "package info file does not exist!";
	exit 1;
    fi
}

PackageEnableGet(){
    if [ -f "${FILE_PKG_ENABLE}" ]; then
        PKG_ENABLE=1;
    else
        PKG_ENABLE=0;
    fi
}

#At begining, acquire package settings
PackageInfoGet

case $1 in
    --sdk-mod-ver)
	#Print SDK support version
	echo ${PKG_MODVER};
    ;;
    --name)
	#Print package name
	echo ${PKG_NAME};
    ;;
    --pkg-ver)
	#Print package version
	echo ${PKG_VERSION};
    ;;
    --vendor)
	#Print package vendor
	echo ${PKG_VENDOR};
    ;;
    --pre)
    ;;
    --post)
	#Check action success or not
	if [ "0" != "${RESULT}" ]; then
		return
	fi

	if [ "${ORIGIN_IFNAME_NUM}" != "${IFNAME_NUM}" ]; then
		return
	fi

	if [ 1 -ne "${IFNAME_NUM}" ]; then
		return
	fi

	${SYNOVPNNET} sync_if --old="${ORIGIN_IFNAME_1}" --new="${IFNAME_1}"
    ;;
    *)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
    ;;
esac

