#!/bin/sh

PRIVATE_LOCATION="/var/packages/VPNCenter/target"
PKG_USERCONF_DIR="/usr/syno/etc/packages/VPNCenter"
SSL_CA="/usr/local/etc/certificate/VPNCenter/OpenVPN/syno-ca-cert.pem"
SSL_SERVER_CRT="/usr/local/etc/certificate/VPNCenter/OpenVPN/cert.pem"
SSL_SERVER_KEY="/usr/local/etc/certificate/VPNCenter/OpenVPN/privkey.pem"
SSL_INTERMEDIATE_CA="/usr/local/etc/certificate/VPNCenter/OpenVPN/chain.pem"
CA_BUNDLE="${PKG_USERCONF_DIR}/openvpn/keys/ca_bundle.crt"
OPENSSL="/bin/openssl"

CreateBundleCA()
{
	local subject=`${OPENSSL} x509 -noout -in $1 -subject | /bin/sed 's/^subject= //g'`
	local issuer=`${OPENSSL} x509 -noout -in $1 -issuer | /bin/sed 's/^issuer= //g'`

	if [ "${subject}" != "${issuer}" ]; then
		for crt in `/usr/bin/find /usr/share/ca-certificates -name "*.crt"`
		do
			subject=`${OPENSSL} x509 -noout -in ${crt} -subject | /bin/sed 's/^subject= //g'`
			if [ "${subject}" = "${issuer}" ]; then
				CreateBundleCA ${crt}
				issuer=`${OPENSSL} x509 -noout -in ${crt} -issuer | /bin/sed 's/^subject= //g'`
				if [ "${subject}" = "${issuer}" ]; then
					break
				fi
			fi
		done
	fi

	cat $1 >> ${CA_BUNDLE}
}

copy_cert()
{
	if [ -f ${PKG_USERCONF_DIR}/no-intercrt ]; then
		rm ${PKG_USERCONF_DIR}/no-intercrt
	fi

	rm ${CA_BUNDLE}
	rm ${PKG_USERCONF_DIR}/openvpn/keys/ca.crt

	if [ -e ${SSL_CA} ]; then
		cp ${SSL_CA} ${PKG_USERCONF_DIR}/openvpn/keys/ca.crt
	elif [ -e ${SSL_INTERMEDIATE_CA} ]; then
		cp ${SSL_INTERMEDIATE_CA} ${PKG_USERCONF_DIR}/openvpn/keys/ca.crt
		CreateBundleCA ${PKG_USERCONF_DIR}/openvpn/keys/ca.crt
	else
		touch ${PKG_USERCONF_DIR}/no-intercrt
	fi

	cp ${SSL_SERVER_CRT} ${PKG_USERCONF_DIR}/openvpn/keys/server.crt
	cp ${SSL_SERVER_KEY} ${PKG_USERCONF_DIR}/openvpn/keys/server.key
}
case "$1" in
	OpenVPN)
		copy_cert
		${PRIVATE_LOCATION}/scripts/openvpn.sh restart
		;;
	copy_cert_only)
		copy_cert
		;;
	*)
		echo "Usage: $0 {OpenVPN}" >&2
		exit 1
		;;
esac
