#!/bin/sh
# Copyright (c) 2000-2008 Synology Inc. All rights reserved.
Upgrade=0

echo "Update photoImage table to test new table existence"
su -l admin -c "/usr/syno/pgsql/bin/psql photo -c \"update photo_image set updated = '0' where id=0\""   
Ret=$?
if [ $Ret = 1 ]; then
   Ret=1
   Script="/var/packages/PhotoStation/target/photo_scripts/sql/upgrade/001_photo_upgrade.pgsql"
   Upgrade=1
else
   Ret=0
fi

if [ $Ret = 1 ]; then      
   su -l admin -c "/usr/syno/pgsql/bin/psql photo < $Script"
   if [ $? != 0 ]; then
      echo "Failed to upgrade photo database"
      exit
   fi
   /usr/syno/bin/synoindex -R photo
fi

if [ $Upgrade -eq 1 -a -d "/var/services/photo/" ]; then
   echo "Stop creating thumbnails ..."
   killall synothumb
   killall convert
   echo "Removing all thumbnails ..."
   find /var/services/photo/ -name "SYNOPHOTO:THUMB_*" -exec rm \"{}\" \;
   echo "Start recreating thumbnails ..."
   find /var/services/photo/ -type d | grep -v @eaDir > /tmp/thumb_dir_list
   mv /tmp/thumb_dir_list $SZF_THUMB_CREATE_QUEUE
   kill -s SIGUSR1 `cat /var/run/synomkthumbd.pid`
fi
            
# TODO: this upgrade script shall be able to remove.

