BEGIN;

create table photo_image
(
  id serial NOT NULL,
  path text NOT NULL,
  name text NOT NULL,
  title text,
  description text,
  album text,
  size int4,
  resolutionx int4,
  resolutiony int4,
  camera_make varchar(100),
  camera_model varchar(100),
  exposure varchar(20),
  aperture varchar(20),
  iso int4,
  timetaken varchar(64),
  updated char(1),
  version int4 DEFAULT 0,
  CONSTRAINT photo_pkey PRIMARY KEY (id),
  CONSTRAINT photo_image_path_key UNIQUE (path)
);

create table photo_comment
(
  id serial NOT NULL,
  photo_id int8 NOT NULL,
  name varchar(100),
  email varchar(128),
  comment text,
  date timestamp,
  CONSTRAINT photo_comment_pkey PRIMARY KEY (id),
  CONSTRAINT photo_comment_photo_id_fkey1 FOREIGN KEY (photo_id)
      REFERENCES photo_image (id) MATCH SIMPLE
      ON UPDATE RESTRICT ON DELETE CASCADE
);

create INDEX photo_comment_photoid_index ON photo_comment USING hash  (photo_id);

CREATE TABLE video_comment
(
  id serial NOT NULL,
  path text NOT NULL,
  name varchar(100),
  email varchar(128),
  "comment" text,
  date timestamp,
  updated char(1),
  CONSTRAINT video_comment_pkey PRIMARY KEY (id)
); 

CREATE TABLE video_desc
(
  id serial NOT NULL,
  path text NOT NULL,
  title text,
  description text,
  updated char(1),
  CONSTRAINT video_pkey PRIMARY KEY (id),
  CONSTRAINT video_path_key UNIQUE (path)
);
  
alter table photo_user ADD COLUMN lock_pass bool DEFAULT false;
alter table photo_user ADD COLUMN admin bool DEFAULT false;
alter table photo_share ADD COLUMN cover text;
alter table photo_share ADD COLUMN comment bool DEFAULT true;

COMMIT;
