#!/bin/sh
# Copyright (c) 2000-2013 Synology Inc. All rights reserved.

GREP="/bin/grep"
SQLITE="/usr/syno/bin/sqlite3"

echo "Check root folder (/) in photo_share table or not"
SQL="SELECT count(sharename) FROM photo_share WHERE sharename='/'"
db=$1

$SQLITE "$db" "$SQL" | $GREP "0" > /dev/null 2>&1
hasRootFolder=$?

if [ $hasRootFolder = 0 ]; then
	username=$(echo $db | sed 's/^.*homes\///g')
	username=$(echo $username | sed "s/\/.*$//g")

	echo "Re-index personal photo db of [$username] due to no root folder in photo_share"
	/usr/syno/bin/synoindex -R user:"$username" > /dev/null 2>&1
fi

