#!/bin/sh
# Copyright (c) 2000-2011 Synology Inc. All rights reserved.

HOMES_DIR="/var/services/homes"
EADIR="@eaDir"
DB_FILE=".SYNOPPSDB"
SQLITE="/usr/syno/bin/sqlite3"
FB_SYNC_CONF_FILE="SYNOPHOTO_ALBUM.fbsync"
FB_SYNC_CONF_FILE_DEPRECATED="SYNOPHOTO:ALBUM.fbsync"
PHOTO_PKG_PATH='/var/packages/PhotoStation/target/photo'
targetConfPath=""
OLDIFS=$IFS
IFS="
"
name="$1"
if [ "$name" = "" ]; then
    exit
fi

photoDir=${HOMES_DIR}"/"${name}"/photo"
dbFile=${photoDir}"/"${DB_FILE}

if [ ! -f "$dbFile" ]; then
    exit
fi

echo "Get fb token from databse"
token=$($SQLITE $dbFile "select config_value from photo_config where config_key='fb_token'")
token=$(echo $token | sed "s/^ //g")
if [ "$token" = "" ]; then
    exit
fi

echo "Get upload setting from databse"
useOrig=$($SQLITE $dbFile "select config_value from photo_config where config_key='share_upload_orig'")
useOrig=$(echo $useOrig | sed "s/^ //g")
origSetting=""
if [ "$useOrig" = "on" ]; then
	origSetting="-o"
fi

echo "Get photo shares from databse"
names=$($SQLITE $dbFile "select sharename from photo_share")

for n in $names;
do
    n=$(echo $n | sed "s/^ //g")

    sub_folder=$(echo $n | sed "s/^.*\///g")
    if [ $sub_folder = $n ]; then
        targetConfPath="${photoDir}/${EADIR}/${n}/${FB_SYNC_CONF_FILE}"
		if [ ! -f "$targetConfPath" ]; then
			targetConfPath="${photoDir}/${EADIR}/${n}/${FB_SYNC_CONF_FILE_DEPRECATED}"
		fi
    else
        parent_folder=$(echo $n | sed "s/\/.*$//g")
        targetConfPath="${photoDir}/${parent_folder}/${EADIR}/${sub_folder}/${FB_SYNC_CONF_FILE}"
		if [ ! -f "$targetConfPath" ]; then
			targetConfPath="${photoDir}/${parent_folder}/${EADIR}/${sub_folder}/${FB_SYNC_CONF_FILE_DEPRECATED}"
		fi
    fi

    if [ -f "$targetConfPath" ]; then
        echo "Syncing album: $n"
        /usr/bin/php -n -d extension_dir=/lib/php/extensions -d extension=syno_compiler.so -d extension=curl.so $PHOTO_PKG_PATH/facebook/fbsync.php $origSetting -t "$token" -c "$targetConfPath" "${photoDir}/${n}" 
    fi
done

IFS=$OLDIFS # restore the field separator
