<?php

require_once('photo_tag.inc.php');

class PhotoTagAPI extends WebAPI {
    function __construct() {
        parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
    }

    protected function Process() {
        csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

        if (!strcasecmp($this->method, "list")) {
            $this->PhotoTagList();
        } else {
            csSYNOPhotoMisc::CheckSessionTimeOut(true);

            if (!strcasecmp($this->method, "people_tag")) {
                $this->AddPeopleTag();
            } elseif (!strcasecmp($this->method, "geo_tag")) {
                $this->AddGeoDescTag(1);
            } elseif (!strcasecmp($this->method, "desc_tag")) {
                $this->AddGeoDescTag(2);
            } elseif (!strcasecmp($this->method, "delete")) {
                $this->Delete();
            } elseif (!strcasecmp($this->method, "people_tag_confirm")) {
                $this->PeopleTagConfirm();
            }
        }
    }

    /**
     *  @params - $id like: photo_dir_name, video_dir_name
     */
    private function GetItemInfo($id)
    {
        $arr = explode('_', $id);
        if (3 !== count($arr)) {
            return false;
        }
        if (!in_array($arr[0], array('photo', 'video'))) {
            return false;
        }
        // get id
        $dirName = @pack('H*', $arr[1]);
        $fileName = @pack('H*', $arr[2]);
        $filePath = $dirName === '/' ? $fileName : $dirName.'/'.$fileName;
        $realPath = realpath(SYNOPHOTO_SERVICE_REAL_DIR.'/'.$filePath);
        if (0 !== strncmp($realPath, SYNOPHOTO_SERVICE_REAL_DIR."/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
            return false;
        }
        $table = ('photo' === $arr[0]) ? 'photo_image' : 'video';
        if ('root' === SYNOPHOTO_ADMIN_USER) {
            $row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('id', $table, 'path', $realPath);
        } else {
            $row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('id', $table, 'path', $filePath);
        }
        $data['id'] = $row['id'];
        $data['path'] = $realPath;
        $data['sharePath'] = $filePath;
        $data['isPhoto'] = ('photo' === $arr[0]) ? true : false;

        return $data;
    }

    private function GetParams_PeopleTagConfirm()
    {
        if (!isset($_REQUEST['id']) || !isset($_REQUEST['tag_id']) || !isset($_REQUEST['confirm'])) {
            return false;
        }
        if (!in_array($_REQUEST['confirm'], array('true', 'false'))) {
            return false;
        }
        $params['confirm'] = $_REQUEST['confirm'];
        if (false === ($data = $this->GetItemInfo($_REQUEST['id']))) {
            return false;
        }
        if (false === $data['isPhoto']) {
            return false;
        }
        $params['id'] = $data['id'];
        $params['sharePath'] = $data['sharePath'];
        $params['isPhoto'] = $data['isPhoto'];
        $arr = explode('tag_', $_REQUEST['tag_id']);
        if (2 !== count($arr)) {
            return false;
        }
        $params['tag_id'] = $arr[1];
        return $params;
    }

    private function GetParams_PeopleTag()
    {
        if (!isset($_REQUEST['id']) || !isset($_REQUEST['tag_id']) ||
            !isset($_REQUEST['x']) || !isset($_REQUEST['y']) ||
            !isset($_REQUEST['width']) || !isset($_REQUEST['height'])) {
            return false;
        }
        if (!is_numeric($_REQUEST['x']) || !is_numeric ($_REQUEST['y']) || !is_numeric ($_REQUEST['width']) || !is_numeric($_REQUEST['height'])) {
            return false;
        }
        $params['x'] = floatval($_REQUEST['x']);
        $params['y'] = floatval($_REQUEST['y']);
        $params['width'] = floatval($_REQUEST['width']);
        $params['height'] = floatval($_REQUEST['height']);

        if (1 < $params['x'] || 0 > $params['x'] ||
            1 < $params['y'] || 0 > $params['y'] ||
            1 < $params['width'] || 0 >= $params['width'] ||
            1 < $params['height'] || 0 >= $params['height']) {
            return false;
        }

        if (false === ($data = $this->GetItemInfo($_REQUEST['id']))) {
            return false;
        }
        $params['id'] = $data['id'];
        $params['path'] = $data['path'];
        $params['sharePath'] = $data['sharePath'];
        if (false === $data['isPhoto']) {
            return false;
        }
        $params['isPhoto'] = $data['isPhoto'];

        $arr = explode('tag_', $_REQUEST['tag_id']);
        if (2 !== count($arr)) {
            return false;
        }
        $params['tag_id'] = $arr[1];
        return $params;
    }

    private function GetParams_Tag()
    {
        if (!isset($_REQUEST['id']) || !isset($_REQUEST['tag_id'])) {
            return false;
        }
        $params['ids'] = array();
        $ids = explode(',', $_REQUEST['id']);
        foreach ($ids as $id) {
            if (false === ($data = $this->GetItemInfo($id))) {
                return false;
            }
            $info['id'] = $data['id'];
            $info['path'] = $data['path'];
            $info['sharePath'] = $data['sharePath'];
            $info['isPhoto'] = $data['isPhoto'];
            array_push($params['ids'], $info);
        }

        // get tag id
        $params['tag_ids'] = array();
        $arr = explode(',', $_REQUEST['tag_id']);
        foreach ($arr as $tagID) {
            $split = explode('tag_', $tagID);
            if (2 !== count($split)) {
                return false;
            }
            array_push($params['tag_ids'], $split[1]);
        }
        return $params;
    }

	private function GetParams_Delete()
	{
		if (!isset($_REQUEST['id']) ||
			(!isset($_REQUEST['tag_id']) && !isset($_REQUEST['item_tag_id'])) ||
			(isset($_REQUEST['tag_id']) && isset($_REQUEST['item_tag_id']))) {
			return false;
		}
		$params['ids'] = array();
		$ids = explode(',', $_REQUEST['id']);
		foreach ($ids as $id) {
			if (false === ($data = $this->GetItemInfo($id))) {
				return false;
			}
			$info['id'] = $data['id'];
			$info['path'] = $data['path'];
			$info['sharePath'] = $data['sharePath'];
			$info['isPhoto'] = $data['isPhoto'];
			array_push($params['ids'], $info);
		}

		// get tag id
		$params['tag_ids'] = array();
		if (isset($_REQUEST['tag_id'])) {
			$arr = explode(',', $_REQUEST['tag_id']);
			foreach ($arr as $tagID) {
				$split = explode('tag_', $tagID);
				if (2 !== count($split)) {
					return false;
				}
				array_push($params['tag_ids'], $split[1]);
			}
		}
		// get item_tag_id
		$params['item_tag_ids'] = array();
		if (isset($_REQUEST['item_tag_id'])) {
			$arr = explode(',', $_REQUEST['item_tag_id']);
			foreach ($arr as $photoTagID) {
				$split = explode('item_tag_', $photoTagID);
				if (2 !== count($split)) {
					return false;
				}
				array_push($params['item_tag_ids'], $split[1]);
			}
		}
        return $params;
	}

    private function GetParams_List($id, $type)
    {
        if (false === ($data = $this->GetItemInfo($id))) {
            return false;
        }
        $params['id'] = $data['id'];
        $params['path'] = $data['path'];
        $params['isPhoto'] = $data['isPhoto'];

        $params['type'] = explode(',', $type);
        foreach ($params['type'] as $type) {
            if (!in_array($type, array('people', 'geo', 'desc'))) {
                return false;
            }
        }
        $params['additional'] = explode(',', $_REQUEST['additional']);
        return $params;
    }

    private function GetPhotoResolution_800px($path)
    {
        $file_name = basename($path);
        $dir = substr($path, 0, strlen($path) - strlen($file_name));

        if (false === SYNOPhotoEA::checkFilePathByDirFile($dir, $file_name, SYNOPhotoEA::FILE_THUMB_L, $thumbLargePath)) {
            return false;
        }
        $img = imagecreatefromjpeg ($thumbLargePath);
        $x = imagesx ($img);
        $y = imagesy ($img);
        imagedestroy ($img);
        $data['x'] = $x;
        $data['y'] = $y;
        return $data;
    }

    function GetTotalPhotoVideoByTagID($tagID)
    {
        // photo
        $query = "SELECT count(id) FROM photo_image_label WHERE label_id={$tagID}";
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
        if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        $photoCount = $row[0];

        // video
        $query = "SELECT count(id) FROM photo_video_label WHERE label_id={$tagID}";
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
        if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        $videoCount = $row[0];

        $total = $photoCount + $videoCount;
        return $total;
    }


    private function CheckTagExsit($tagID, $category)
    {
        $query = 'SELECT count(id) FROM photo_label WHERE id=? AND category=?';
        $sqlParam = array($tagID, $category);
        if (false === ($db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam))) {
            return false;
        }
       	if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        if (1 !== (int)$row[0]) {
            return false;
        }
        return true;
    }

    private function CheckPhotoTagExist($tagID, $photoID)
    {
        $query = 'SELECT count(id) FROM photo_image_label WHERE image_id=? AND label_id=?';
        $sqlParam = array($photoID, $tagID);
        if (false === ($db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam))) {
            return false;
        }
       	if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        if (1 > (int)$row[0]) {
            return false;
        }
        return true;
    }

    private function CheckVideoTagExist($tagID, $videoPath)
    {
        $query = 'SELECT count(id) FROM photo_video_label WHERE video_path=? AND label_id=?';
        $sqlParam = array($videoPath, $tagID);
        if (false === ($db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam))) {
            return false;
        }
       	if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        if (1 !== (int)$row[0]) {
            return false;
        }
        return true;
    }

    private function CheckVideoExist($videoPath)
    {
        $query = 'SELECT count(id) FROM video WHERE path=?';
        $sqlParam = array($videoPath);
        if (false === ($db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam))) {
            return false;
        }
       	if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        if (1 !== (int)$row[0]) {
            return false;
        }
        return true;
    }

    private function GetPhotoPeopleTagInfo($data)
    {
        if (!empty($data['info'])) {
            $info = json_decode($data['info'], true);
            $people['x'] = $info['x'];
            $people['y'] = $info['y'];
            $people['width'] = $info['width'];
            $people['height'] = $info['height'];
        }
        return $people;
    }

    private function FormAdditional($data, $params, $type)
    {
        if (in_array('info', $params['additional'])) {
            if ('people' === $type) {
                $people = $this->GetPhotoPeopleTagInfo($data);
                $people['name'] = $data['name'];
                $people['is_confirmed'] = PHOTO_DB_IsTrue($data['status']);
                $additional['info'] = $people;
            } elseif ('geo' === $type) {
                $geo['name'] = $data['name'];
                $info = json_decode($data['label_info'], true);
                $geo['lat'] = $info['lat'];
                $geo['lng'] = $info['lng'];
		$geo['place_id'] = $info['placeId'];
                $geo['address'] = (null === $info['address']) ? '' : $info['address'];
                $additional['info'] = $geo;
            } elseif ('desc' === $type) {
                $desc['name'] = $data['name'];
                $additional['info'] = $desc;
            }
        }
        if (in_array('extra', $params['additional'])) {
            if ('people' === $type) {
                $additional['extra'] = $data['info'];
            } elseif ('geo' === $type) {
                $additional['extra'] = $data['label_info'];
            } elseif ('desc' === $type) {
                $additional['extra'] = $data['info'];
            }
        }
        if (in_array('count', $params['additional'])) {
            $total = $this->GetTotalPhotoVideoByTagID($data['label_id']);
            $additional['count'] = (int)$total;
        }
        return $additional;
    }

    private function FromTags($result, $params)
    {
        $tags = array();
        if (in_array('people', $params['type'])) {
            foreach ($result['person'] as $people) {
                unset($tag);
                $tag['id'] = 'tag_'.$people['label_id'];
				$tag['item_tag_id'] = 'item_tag_'.$people['id'];
                $tag['type'] = 'people';
                $tag['name'] = $people['name'];
                $additional = $this->FormAdditional($people, $params, 'people');
                if (null !== $additional) {
                    $tag['additional'] = $additional;
                }
                array_push($tags, $tag);
            }
        }
        if (in_array('geo', $params['type'])) {
            foreach ($result['place'] as $geo) {
                unset($tag);
                $tag['id'] = 'tag_'.$geo['label_id'];
				$tag['item_tag_id'] = 'item_tag_'.$geo['id'];
                $tag['type'] = 'geo';
                $tag['name'] = $geo['name'];
                $additional = $this->FormAdditional($geo, $params, 'geo');
                if (null !== $additional) {
                    $tag['additional'] = $additional;
                }
                array_push($tags, $tag);
            }
        }
        if (in_array('desc', $params['type'])) {
            foreach ($result['general'] as $desc) {
                unset($tag);
                $tag['id'] = 'tag_'.$desc['label_id'];
				$tag['item_tag_id'] = 'item_tag_'.$desc['id'];
                $tag['type'] = 'desc';
                $tag['name'] = $desc['name'];
                $additional = $this->FormAdditional($desc, $params, 'desc');
                if (null !== $additional) {
                    $tag['additional'] = $additional;
                }
                array_push($tags, $tag);
            }
        }
        return $tags;
    }

    private function PhotoTagList()
    {
	$tags = array();
	if (!isset($_REQUEST['id']) || !isset($_REQUEST['type'])) {
		$this->SetError(WEBAPI_ERR_BAD_REQUEST);
		goto End;
	}

        $ids = explode(',', $_REQUEST['id']);
        foreach ($ids as $id) {
		if (false === ($params = $this->GetParams_List($id, $_REQUEST['type']))) {
		    $this->SetError(WEBAPI_ERR_BAD_REQUEST);
		    goto End;
		}
		if (count($ids) > 1) {
			$tag = array();
			$tag['photoId'] = $id;
			$tag['tags'] = $this->GetPhotoTagList($params);
		} else {
			$tag = $this->GetPhotoTagList($params);
		}
		array_push($tags, $tag);
	}

	if (count($ids) > 1) {
		$resp['tags'] = $tags;
	} else {
		$resp['tags'] = $tags[0];
	}

        $this->SetResponse($resp);
    End:
        return;
    }

    private function GetPhotoTagList($params)
    {
	// database query
        if ($params['isPhoto']) {
            $result = SYNOPHOTO_LABEL_UTIL_GetPhotoLabels($params['id']);
        } else {
            $result = SYNOPHOTO_LABEL_UTIL_GetVideoLabels($params['path']);
        }

        // form to webapi format
        $tags = $this->FromTags($result, $params);

        return $tags;
    }

    private function AddGeoDescTag($category)
    {
        if (false === ($params = $this->GetParams_Tag())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // check permmision
        foreach ($params['ids'] as $idData) {
            $albumName = dirname($idData['sharePath']);
            if (!csSYNOPhotoMisc::CheckAlbumManageable($albumName)) {
                $this->SetError(PHOTOSTATION_PHOTO_TAG_ACCESS_DENY);
                goto End;
            }
        }

        // check tag exist
        foreach ($params['tag_ids'] as $tagID) {
            if (false === $this->CheckTagExsit($tagID, $category)) {
                $this->SetError(PHOTOSTATION_PHOTO_TAG_NOT_EXIST);
                goto End;
            }
        }

        $failCount = 0;
        $duplicateCount = 0;
        foreach ($params['ids'] as $idData) {
            if ($idData['isPhoto']) {
                foreach ($params['tag_ids'] as $tagID) {
                    if (true === $this->CheckPhotoTagExist($tagID, $idData['id'])) {
                        $failCount++;
                        $duplicateCount++;
                        continue;
                    }
                    if (false === SYNOPHOTO_LABEL_UTIL_AddPhotoLabel($idData['id'], $tagID)) {
                        $failCount++;
                        continue;
                    }
                }
            } else {
                foreach ($params['tag_ids'] as $tagID) {
                    if (false === $this->CheckVideoExist(('root' === SYNOPHOTO_ADMIN_USER) ? $idData['path'] : $idData['sharePath'])) {
                        $failCount++;
                        continue;
                    }

                    if (true === $this->CheckVideoTagExist($tagID, ('root' === SYNOPHOTO_ADMIN_USER) ? $idData['path'] : $idData['sharePath'])) {
                        $failCount++;
                        $duplicateCount++;
                        continue;
                    }
                    if (false === SYNOPHOTO_LABEL_UTIL_AddVideoLabel($idData['path'], $tagID)) {
                        $failCount++;
                        continue;
                    }
                }
            }
        }
        if ($failCount === count($params['ids']) * count($params['tag_ids'])) {
            if (count($params['ids']) == $duplicateCount) {
                $this->SetError(PHOTOSTATION_PHOTO_TAG_DUPLICATE);
            } else {
                $this->SetError(PHOTOSTATION_PHOTO_TAG_ADD_GEO_DESC_FAIL);
            }
            goto End;
        }

    End:
        return;
    }

    function InsertPeopleTag($image_id, $label_id, $info_new='')
    {
        $query = 'INSERT INTO photo_image_label (image_id, label_id, info_new) VALUES (?, ?, ?);';
        $sqlParam = array($image_id, $label_id, $info_new);
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
        if (false === $db_result) {
            return false;
        }

        SYNOPHOTO_LABEL_UTIL_UpdatePhotoMetadata($image_id, 0);
        return true;
    }

    function UpdateTagStatus($type, $photoId, $tagId, $confirm)
    {
        $query = "UPDATE photo_image_label SET status=? WHERE image_id=? and label_id=?";
        $sqlConfirm = ('true' === $confirm) ? 't' : 'f';
        $sqlParam = array($sqlConfirm, $photoId, $tagId);
        if (false === ($dbResult = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam))) {
            return false;
        }
        return true;
    }

    private function PeopleTagConfirm()
    {
        if (false === ($params = $this->GetParams_PeopleTagConfirm())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // check permmision
        $albumName = dirname($params['sharePath']);
        if (!csSYNOPhotoMisc::CheckAlbumManageable($albumName)) {
            $this->SetError(PHOTOSTATION_PHOTO_TAG_ACCESS_DENY);
            goto End;
        }

        // check tag exist
        if (false === $this->CheckTagExsit($params['tag_id'], 0)) {
            $this->SetError(PHOTOSTATION_PHOTO_TAG_NOT_EXIST);
            goto End;
        }

        // update confirm
        if (false === $this->UpdateTagStatus('photo', $params['id'], $params['tag_id'], $params['confirm'])) {
            $this->SetError(PHOTOSTATION_PHOTO_TAG_PEOPLE_TAG_CONFIRM_FAIL);
            goto End;
        }
    End:
        return;
    }

    private function AddPeopleTag()
    {
        if (false === ($params = $this->GetParams_PeopleTag())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // check permmision
        $albumName = dirname($params['sharePath']);
        if (!csSYNOPhotoMisc::CheckAlbumManageable($albumName)) {
            $this->SetError(PHOTOSTATION_PHOTO_TAG_ACCESS_DENY);
            goto End;
        }

        // check tag exist
        if (false === $this->CheckTagExsit($params['tag_id'], 0)) {
            $this->SetError(PHOTOSTATION_PHOTO_TAG_NOT_EXIST);
            goto End;
        }

        // tag can't duplicate in the same photo
        if (true === $this->CheckPhotoTagExist($params['tag_id'], $params['id'])) {
            $this->SetError(PHOTOSTATION_PHOTO_TAG_DUPLICATE);
            goto End;
        }

        // add people tag
        $info_new = json_encode(
            array(
                'x' => $params['x'],
                'y' => $params['y'],
                'width' => $params['width'],
                'height' => $params['height']
            )
        );
        if (false === $this->InsertPeopleTag($params['id'], $params['tag_id'], $info_new)) {
            $this->SetError(PHOTOSTATION_PHOTO_TAG_ADD_PEOPLE_FAIL);
            goto End;
        }

        // get photo_image_label id
        $row = SYNOPHOTO_LABEL_UTIL_GetOneImageLabel($params['id'], $params['tag_id']);
        $photo_label_id = $row['id'];

        // perform face detect for tag area
        if ('on' === csSYNOPhotoMisc::GetConfigDB("photo", "enable_face_recognition", "photo_config")) {
            $cmd = sprintf("%s -T %s %s", SYNOPHOTO_FACE_RECOG_TOOL, $photo_label_id, escapeshellarg($params['path']));
            @exec($cmd);
        }
    End:
        return;
    }

    private function Delete()
    {
        if (false === ($params = $this->GetParams_Delete())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // check permmision
        foreach ($params['ids'] as $idData) {
            $albumName = dirname($idData['sharePath']);
            if (!csSYNOPhotoMisc::CheckAlbumManageable($albumName)) {
                $this->SetError(PHOTOSTATION_PHOTO_TAG_ACCESS_DENY);
                goto End;
            }
        }

        foreach ($params['ids'] as $idData) {
			if (!empty($params['item_tag_ids'])) {
				foreach ($params['item_tag_ids'] as $photoTagID) {
					SYNOPHOTO_LABEL_UTIL_DeleteItemLabel($photoTagID, $idData['isPhoto']);
				}
			}
			if (!empty($params['tag_ids'])) {
				foreach ($params['tag_ids'] as $tagID) {
					// get id
					if ($idData['isPhoto']) {
						$row = SYNOPHOTO_LABEL_UTIL_GetOneImageLabel($idData['id'], $tagID);
					} else {
						$row = SYNOPHOTO_LABEL_UTIL_GetOneVideoLabel($idData['path'], $tagID);
					}
					$itemID = $row['id'];
					SYNOPHOTO_LABEL_UTIL_DeleteItemLabel($itemID, $idData['isPhoto']);
				}
			}
        }

    End:
        return;
    }
}

$api = new PhotoTagAPI();
$api->Run();


?>
