<?PHP

require_once('photo.inc.php');
require_once('albumutil.php');
require_once('photoutil.php');

class PhotoAPI extends WebAPI
{
	function __construct()
	{
		parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
	}

	protected function Process()
	{
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache();
		if (!strcasecmp($this->method, "list")) {
			session_write_close();
			$this->ListItem();
		} else if (!strcasecmp($this->method, "getinfo")) {
			session_write_close();
			$this->GetInfo();
		} else {
			csSYNOPhotoMisc::CheckSessionTimeOut(true);

			if (!strcasecmp($this->method, "edit")) {
				$this->Edit();
			}
			if (!strcasecmp($this->method, "delete")) {
				$this->DeleteItem();
			}
			if (!strcasecmp($this->method, "copy")) {
				$this->CopyItem();
			}
		}
	}

	private function GetInfo()
	{
		$ret = false;
		$resp = array();
		/* return when lack of params */
		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
			goto End;
		}

		$additional = isset($_REQUEST['additional']) ? $_REQUEST['additional'] : '';
		$ids = explode(',', $_REQUEST['id']);
		foreach ($ids as $id_str) {
			$id_arr = explode('_', $id_str);
			if (3 !== count($id_arr) || ('photo' !== $id_arr[0] && 'video' !== $id_arr[0])) {
				continue;
			}
			$albumName = @pack('H*', $id_arr[1]);
			$fileName = @pack('H*', $id_arr[2]);
			$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName . "/" . $fileName);
			if (0 !== strncmp($path, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
				continue;
			}

			if (!csSYNOPhotoMisc::CheckAlbumAccessible($albumName)) {
				continue;
			}

			if (@file_exists($path)) {
				if (false !== ($item = PhotoAPIUtil::getItemByPath($path, $additional, $id_arr[0], false))) {
					$resp[] = $item;
				}
			}
		}
		$ret = true;
		$this->SetResponse($resp);
		End:
			return $ret;
	}

	private function ListItem()
	{
		$ret = false;
		$resp = array();
		$items = array();
		/* return when lack of params */
		if (!isset($_REQUEST['offset']) || !isset($_REQUEST['limit']) || !isset($_REQUEST['type'])) {
			$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
			goto End;
		}

		/* required params setting */
		$offset = $_REQUEST['offset'];
		$limit = $_REQUEST['limit'];
		$type = $_REQUEST['type'];
		if (!is_numeric($offset) || !is_numeric($limit)) {
			$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
			goto End;
		}
		if (!strstr($type, 'photo') && !strstr($type, 'video')) {
			$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
			goto End;
		}

		/* optional params setting */
		global $SYNOPHOTO_ALLOW_SORT_TYPE;
		$sort_by = $_REQUEST['sort_by'];
		if (!in_array($sort_by, $SYNOPHOTO_ALLOW_SORT_TYPE)) {
			$sort_by = 'filename';
		}
		$sort_direction = (isset($_REQUEST['sort_direction']) && 'desc' === $_REQUEST['sort_direction']) ? 'desc' : 'asc';
		$filter_smart = isset($_REQUEST['filter_smart']) ? $_REQUEST['filter_smart'] : '';
		$filter_tag = isset($_REQUEST['filter_tag']) ? $_REQUEST['filter_tag'] : '';
		$filter_album = isset($_REQUEST['filter_album']) ? $_REQUEST['filter_album'] : '';
		$additional = isset($_REQUEST['additional']) ? $_REQUEST['additional'] : '';
		$taken_date = isset($_REQUEST['taken_date']) ? $_REQUEST['taken_date'] : "";
		$gps = isset($_REQUEST['gps']) ? $_REQUEST['gps'] : false;

		if ('' !== $filter_album) {
			$arr = explode('_', $filter_album);
			if ('album' !== $arr[0]) {
				$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
				goto End;
			}
			if (false === ($albumPath = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . @pack('H*', $arr[1])))) {
				$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
				goto End;
			}
			$albumName = empty($arr[1]) ? '/' : @pack('H*', $arr[1]);
			if (!csSYNOPhotoMisc::CheckAlbumAccessible($albumName)) {
				$this->SetError(PHOTOSTATION_PHOTO_ACCESS_DENY);
				goto End;
			}

			$personalAlbumPath = @pack('H*', $arr[1]);
		} else {
			$albumPath = SYNOPHOTO_SERVICE_REAL_DIR;
			$personalAlbumPath = '';
		}

		if ('root' !== SYNOPHOTO_ADMIN_USER) { //personal photo station
			if ('' !== $filter_album && '' !== $personalAlbumPath) {
				$escPath = PHOTO_DB_EscapeParam($personalAlbumPath . '/%');
			} else {
				$escPath = PHOTO_DB_EscapeParam($personalAlbumPath . '%');
			}
		} else {
			$escPath = PHOTO_DB_EscapeParam($albumPath . '/%');
		}

		$total = 0;
        /* unconfirmed people tag */
        if (strstr($type, 'photo') && SYNOPHOTO_UNCONFIRM_TAG_ID === $filter_tag) {
            $list = AlbumAPIUtil::GetUnConfirmItemList($limit, $offset);
            foreach ($list as $key => $value) {
                if (false !== ($item = PhotoAPIUtil::getItemByPath($key, $additional, 'photo', false))) {
                    $items[] = $item;
                }
            }
			$total = $list['total'];
		} elseif ('' === $filter_smart && '' === $filter_tag && $gps) {
		// speed up for loading mapview in real Albums
			$query = "SELECT * FROM photo_image WHERE gps <> '' AND path LIKE '" . $escPath . "' ";
			$queryCount = "SELECT count(*) FROM photo_image WHERE gps <> '' AND path LIKE '" . $escPath . "' ";
			$sqlParam = array();
			$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
			if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && count($albumCondition['albumCond']) > 0) {
				$query .= "AND (" . implode(' OR ', $albumCondition['albumCond']) . ') ';
				$queryCount .= "AND (" . implode(' OR ', $albumCondition['albumCond']) . ') ';
				$sqlParam = array_merge($sqlParam, $albumCondition['sqlParam']);
			}

			if ('root' === SYNOPHOTO_ADMIN_USER) {
				$limitCond = (0 > (int)$limit) ? '' : "LIMIT {$limit}";
			} else {
				$limitCond = (0 > (int)$limit) ? 'LIMIT -1' : "LIMIT {$limit}";
			}
			$query = "$query {$limitCond} OFFSET $offset";

			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
			while ($row = PHOTO_DB_FetchRow($db_result)) {
				if ('root' === SYNOPHOTO_ADMIN_USER) {
					$fullPath = $row['path'];
				} else {
					$fullPath = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $row['path']);
				}

				$obj = null;
				if (SYNOPHOTO_SERVICE_REAL_DIR === dirname($fullPath)) {
					$obj['id'] = 'photo_' . bin2hex('/') . '_' . bin2hex(basename($row['path']));
				} else {
					$dir = substr($fullPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1, strrpos($fullPath, '/') - strlen(SYNOPHOTO_SERVICE_REAL_DIR) - 1);
					$obj['id'] = 'photo_' . bin2hex($dir) . '_' . bin2hex(basename($row['path']));
				}

				$obj['type'] = 'photo';
				$obj['info']['name'] = $row['name'];
				$obj['info']['title'] = $row['title'];
				$obj['info']['createdate'] = $row['create_time'];
				$obj['info']['size'] = $row['size'];
				$obj['info']['takendate'] = $row['timetaken'];
				$obj['info']['resolutionx'] = $row['resolutionx'];
				$obj['info']['resolutiony'] = $row['resolutiony'];
				$obj['info']['description'] = $row['description'];
				$obj['info']['rotated'] = (0 === (int)$row['version'] %2) ? false : true;
				$obj['info']['rotate_version'] = (int)$row['version'];

				$obj['additional']['photo_exif']['gps'] = json_decode($row['gps'], true);
				$obj['additional']['photo_exif']['version'] = $row['version'];
				$obj['additional']['photo_exif']['takendate'] = $row['timetaken'];
				$obj['additional']['photo_exif']['camera'] = $row['camera_make'];
				$obj['additional']['photo_exif']['camera_model'] = $row['camera_model'];
				$obj['additional']['photo_exif']['exposure'] = $row['exposure'];
				$obj['additional']['photo_exif']['aperture'] = $row['aperture'];
				$obj['additional']['photo_exif']['iso'] = $row['iso'];

				$thumbnail = AlbumAPIUtil::GetThumbStatus($fullPath, false, true, $row['resolutionx'], $row['resolutiony'], $obj['info']['rotated']);
				$obj['thumbnail_status'] = $thumbnail['status'];

				$items[] = $obj;
			}

			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $queryCount, $sqlParam);
			$row = PHOTO_DB_FetchRow($db_result);
			$total = $row[0];

        } elseif ('' === $filter_smart) {
			/* filter by albumname and tag */
			$sqlParam = array();
			$photoQuery = '';
			if (strstr($type, 'photo')) {
				$photoQuery = "SELECT A.path as path, A.name as filename, A.timetaken as takendate, A.create_time as createdate, B.date as commentdate, 'photo' as type ";
				$photoQuery .= "FROM photo_image A LEFT JOIN photo_comment B ON A.id = B.photo_id AND B.date = (SELECT MAX(photo_comment.date) FROM photo_comment LEFT JOIN photo_image ON photo_comment.photo_id = photo_image.id) ";
				$photoQuery .= "WHERE A.path LIKE '" . $escPath . "' ";
				if ('' !== $taken_date) {
					if ($taken_date === '1970-01-01') {
						$photoQuery .= "AND (A.timetaken IS NULL OR date(A.timetaken)='1970-01-01') ";
					} else {
						$photoQuery .= "AND date(A.timetaken)='" . $_REQUEST['taken_date'] . "' ";
					}
				}
				if ('' !== $filter_tag) {
					$photoQuery .= "AND A.id IN (SELECT photo_image_label.image_id FROM photo_image_label LEFT JOIN  photo_image ON photo_image_label.image_id = photo_image.id WHERE (" . PhotoAPIUtil::getLabelIDConstraint($filter_tag) . ") AND status = 't') ";
				}
				if ($gps) {
					$photoQuery .= "AND A.gps <> '' ";
				}
				$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition('A');
				if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && count($albumCondition['albumCond']) > 0) {
					$photoQuery .= "AND (" . implode(' OR ', $albumCondition['albumCond']) . ') ';
					$sqlParam = array_merge($sqlParam, $albumCondition['sqlParam']);
				}
			}
			$videoQuery = '';
			if (strstr($type, 'video')) {
				$videoQuery = "SELECT A.path as path, A.title as filename, A.mdate as takendate, A.date as createdate, B.date as commentdate, 'video' as type ";
				$videoQuery .= "FROM video A LEFT JOIN video_comment B ON A.path = B.path AND B.date = (SELECT MAX(video_comment.date) FROM video_comment LEFT JOIN video ON video_comment.path = video.path) ";
				$videoQuery .= "WHERE A.path LIKE '" . $escPath . "' ";
				if ('' !== $taken_date) {
					if ($taken_date === '1970-01-01') {
						$videoQuery .= "AND (A.mdate IS NULL OR date(A.mdate)='1970-01-01') ";
					} else {
						$videoQuery .= "AND date(A.mdate)='" . $_REQUEST['taken_date'] . "' ";
					}
				}
				if ('' !== $filter_tag) {
					$videoQuery .= "AND A.path IN (SELECT photo_video_label.video_path FROM photo_video_label LEFT JOIN video ON  photo_video_label.video_path = video.path WHERE (" . PhotoAPIUtil::getLabelIDConstraint($filter_tag) . "))";
				}
				$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition('A');
				if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && count($albumCondition['albumCond']) > 0) {
					$videoQuery .= "AND (" . implode(' OR ', $albumCondition['albumCond']) . ') ';
					$sqlParam = array_merge($sqlParam, $albumCondition['sqlParam']);
				}
			}
			if ('root' === SYNOPHOTO_ADMIN_USER) {
				$limitCond = (0 > (int)$limit) ? '' : "LIMIT {$limit}";
			} else {
				$limitCond = (0 > (int)$limit) ? 'LIMIT -1' : "LIMIT {$limit}";
			}
			if ('' !== $photoQuery && '' !== $videoQuery) {
				$query = "$photoQuery UNION $videoQuery ORDER BY $sort_by $sort_direction {$limitCond} OFFSET $offset";
				$queryCount = "SELECT COUNT(*) FROM ($photoQuery UNION $videoQuery) AS totalCount";
			} elseif ('' === $photoQuery) {
				$query = "$videoQuery ORDER BY $sort_by $sort_direction {$limitCond} OFFSET $offset";
				$queryCount = "SELECT COUNT(*) FROM ($videoQuery) AS totalCount";
			} else {
				$query = "$photoQuery ORDER BY $sort_by $sort_direction {$limitCond} OFFSET $offset";
				$queryCount = "SELECT COUNT(*) FROM ($photoQuery) AS totalCount";
			}

			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
			$getRealPath = ('root' === SYNOPHOTO_ADMIN_USER) ? false : true;
			while ($row = PHOTO_DB_FetchRow($db_result)) {
				if (false !== ($item = PhotoAPIUtil::getItemByPath($row['path'], $additional, $row['type'], $getRealPath))) {
					$items[] = $item;
				}
			}
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $queryCount, $sqlParam);
			$row = PHOTO_DB_FetchRow($db_result);
			$total = $row[0];
		} else {
			/* for smart album */
			$arr = explode('_', $filter_smart);
			if ('smart' !== $arr[0]) {
				$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
				goto End;
			}
			$albumName = @pack('H*', $arr[1]);
			$data = array(
				"name" => $albumName,
				"offset" => 0,
				"limit" => -1
			);
			if ('' !== $taken_date) {
				$data['taken_date'] = $taken_date;
			}
			$smart = json_decode(SmartAlbum::ListItem(json_encode($data)), true);
			if (!$smart['success']) {
				$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
				goto End;
			}
			$itemLists = $smart['data']['itemList'];

            // sorting and set limit, offset
            $sortItems = array();
            $sortItems = AlbumAPIUtil::SortItem($itemLists, $sort_by, $sort_direction, $offset, $limit);

			foreach ($sortItems as $row) {
				if (!strstr($type, $row['type'])) {
					continue;
				}

				if (false !== ($item = PhotoAPIUtil::getItemByPath($row['path'], $additional, $row['type'], false))) {
					if ($gps) {
						// special filter for map view
						if (null !== $item['additional']['photo_exif']['gps']) {
							$items[] = $item;
						}
					} else {
						$items[] = $item;
					}
				}
			}
			// TODO the total with gps=true will be wrong
			$total = $smart['data']['total'];
		}

		/* set return data */
		$resp['total'] = $total;
		$resp['offset'] = (-1 == $limit || $offset + $limit > $total) ? $total : $offset + $limit;
		$resp['items'] = $items;
		$this->SetResponse($resp);
		$ret = true;
		End:
			return $ret;
	}

	private function Edit()
	{
		$ret = false;
		$resp = array();
		/* return when lack of params */
		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
			goto End;
		}

		/* set optional params */
		$title = isset($_REQUEST['title']) ? $_REQUEST['title'] : '';
		$description = isset($_REQUEST['description']) ? $_REQUEST['description'] : '';

		/* update records */
		$ids = explode(',', $_REQUEST['id']);
		foreach ($ids as $idStr) {
			$id_arr = explode('_', $idStr);
			$albumName = @pack('H*', $id_arr[1]);
			$fileName = @pack('H*', $id_arr[2]);
			$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName . "/" . $fileName);
			if (0 !== strncmp($path, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
				continue;
			}

			if (!csSYNOPhotoMisc::CheckAlbumManageable($albumName)) {
				continue;
			}
			if (isset($_REQUEST['title']) || isset($_REQUEST['description'])) {
				$dbPath = $this->GetDbPath($path);
				if ('photo' === $id_arr[0]) {
					$require_update = false;
					$query = "UPDATE photo_image SET ";
					if (isset($_REQUEST['title'])) {
						$query .= "title = '" . PHOTO_DB_EscapeParam($_REQUEST['title']) . "' ";
						$require_update = true;
					}
					if (isset($_REQUEST['description'])) {
						if ($require_update) {
							$query .= ", ";
						}
						$query .= "description = '" . PHOTO_DB_EscapeParam($_REQUEST['description']) . "' ";
						$require_update = true;

						//update metadata
						$cmd = sprintf('%s -M"set %s %s" %s', SYNO_EXIFTOOL_FILE, "Xmp.dc.description", str_replace('"', '\"', $_REQUEST['description']), escapeshellarg($path));
						@exec($cmd);
						$cmd = sprintf('%s -M"set %s %s" %s', SYNO_EXIFTOOL_FILE, "Iptc.Application2.Caption", str_replace('"', '\"', $_REQUEST['description']), escapeshellarg($path));
						@exec($cmd);
					}
					$query .= "WHERE path = '" . PHOTO_DB_EscapeParam($dbPath) . "'";
					PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
				} elseif ('video' === $id_arr[0]) {
					$require_update = false;
					$query = "UPDATE video_desc SET ";
					if (isset($_REQUEST['title'])) {
						$query .= "title = '" . PHOTO_DB_EscapeParam($_REQUEST['title']) . "' ";
						$require_update = true;
					}
					if (isset($_REQUEST['description'])) {
						if ($require_update) {
							$query .= ", ";
						}
						$query .= "description = '" . PHOTO_DB_EscapeParam($_REQUEST['description']) . "' ";
					}
					$query .= "WHERE path = '" . PHOTO_DB_EscapeParam($dbPath) . "'";

					$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
					if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
						$query = "INSERT INTO video_desc (path, title, description) VALUES (?, ?, ?)";
						$sqlParam = array($dbPath, $title, $description);
						PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
					}
				}
			}
			if (isset($_REQUEST['gps_lat']) && isset($_REQUEST['gps_lng'])) {
				if (is_numeric($_REQUEST['gps_lat']) && is_numeric($_REQUEST['gps_lng'])) {
					SYNOPHOTO_GPS_UTIL_SetGPSLatLng($path, $_REQUEST['gps_lat'], $_REQUEST['gps_lng']);
				}
			}
		}
		$ret = true;
		End:
			return $ret;
	}

	private function DeleteItem()
	{
		$ret = false;
		/* return when lack of params */
		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
			goto End;
		}

		/* delete records */
		$ids = explode(',', $_REQUEST['id']);
		foreach ($ids as $idStr) {
			self::OutputSingleSpace();

			$id_arr = explode('_', $idStr);
			$albumName = @pack('H*', $id_arr[1]);
			$fileName = @pack('H*', $id_arr[2]);
			if (!csSYNOPhotoMisc::CheckAlbumManageable($albumName)) {
				continue;
			}
			$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName . "/" . $fileName);
			if (0 !== strncmp($path, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
				continue;
			}
			$isPhoto = 'photo' === $id_arr[0] ? true : false;
			SYNOPHOTO_ADMIN_DeleteItemByPath($path, $isPhoto);
			SYNOPHOTO_LABEL_UTIL_Check_Photo_Label();
		}

		$ret = true;
		End:
			return $ret;
	}

	private function CopyItem()
	{
		$ret = false;
		$resp = array();
		/* return when lack of params */
		if (!isset($_REQUEST['id']) || !isset($_REQUEST['sharepath']) || !isset($_REQUEST['mode']) || !isset($_REQUEST['duplicate'])) {
			$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
			goto End;
		}

		/* set params */
		$destShareName = @pack('H*', $_REQUEST['sharepath']);
		$destPath = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $destShareName);
		if (0 !== strncmp($destPath, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1) &&
			0 !== strcmp($destPath, SYNOPHOTO_SERVICE_REAL_DIR)) {
			$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
			goto End;
		}
		$mode = $_REQUEST['mode'];
		if ('copy' !== $mode && 'move' !== $mode) {
			$this->SetError(PHOTOSTATION_PHOTO_BAD_PARAMS);
			goto End;
		}
		$dup = $_REQUEST['duplicate'];
		$is_overwritten = 'overwritten' === $dup ? true : false;

		if (!csSYNOPhotoMisc::CheckAlbumUploadable('' == $destShareName ? '/' : $destShareName)) {
			$this->SetError(PHOTOSTATION_PHOTO_ACCESS_DENY);
			goto End;
		}

		$ids = explode(',', $_REQUEST['id']);
		foreach ($ids as $idStr) {
			self::OutputSingleSpace();

			$id_arr = explode('_', $idStr);
			$albumName = @pack('H*', $id_arr[1]);
			$fileName = @pack('H*', $id_arr[2]);
			$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName . "/" . $fileName);
			if (0 !== strncmp($path, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
				continue;
			}

			if (!csSYNOPhotoMisc::CheckAlbumManageable($albumName)) {
				continue;
			}

			$dbPath = $this->GetDbPath($path);
			/* get item id first */
			if ('photo' === $id_arr[0]) {
				$query = "SELECT id FROM photo_image WHERE path = '" . PHOTO_DB_EscapeParam($dbPath) . "'";
			} elseif ('video' === $id_arr[0]) {
				$query = "SELECT id FROM video WHERE path = '" . PHOTO_DB_EscapeParam($dbPath) . "'";
			}
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			if ($row = PHOTO_DB_FetchRow($db_result)) {
				$id = $row['id'];
				if ('copy' === $mode) {
					if ('photo' === $id_arr[0]) {
						SYNOPHOTO_ADMIN_CopyOnePhoto($destShareName, $id, $is_overwritten);
						@exec("/usr/syno/bin/synomkthumb -a " . escapeshellarg($destPath));
					} elseif ('video' === $id_arr[0]) {
						SYNOPHOTO_ADMIN_CopyOneVideo($destShareName, $id, $is_overwritten);
					}
				} elseif ('move' === $mode) {
					if ('photo' === $id_arr[0]) {
						SYNOPHOTO_ADMIN_MoveOnePhoto($destShareName, $id, $is_overwritten);
						@exec("/usr/syno/bin/synomkthumb -a " . escapeshellarg($destPath));
					} elseif ('video' === $id_arr[0]) {
						SYNOPHOTO_ADMIN_MoveOneVideo($destShareName, $id, $is_overwritten);
					}
				}
				csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
			}
		}

		$ret = true;
		End:
			return $ret;
	}

	private function GetDbPath($path)
	{
		return substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
	}
}

$api = new PhotoAPI();
$api->Run();
