<?PHP

set_time_limit(0);

require_once('file.inc.php');

class FileAPI extends WebAPI
{
	function __construct()
	{
		parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
	}

	protected function Process()
	{
		$this->Init();

		csSYNOPhotoMisc::CheckSessionTimeOut(true);

		if (!strcasecmp($this->method, "uploadphoto")) {
			$this->UploadFile(true);
		}
		if (!strcasecmp($this->method, "uploadvideo")) {
			$this->UploadFile(false);
		}
	}

	private function Init()
	{
		session_start();

		$_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier'] = csSYNOPhotoMisc::GetSessionIdentifier();
		if (isset($_REQUEST['session'])) {
			csSYNOPhotoMisc::RestoreSession();
		}
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	}

	private function UploadFile($isPhoto)
	{
		$ret = false;
		/* return when lack of params */
		if (!isset($_REQUEST['dest_folder_path']) || !isset($_REQUEST['duplicate']) || !isset($_REQUEST['filename']) || !isset($_REQUEST['mtime'])) {
				$this->SetError(PHOTOSTATION_FILE_BAD_PARAMS);
				goto End;
		}

		/* set required params */
		$destShareName = $_REQUEST['dest_folder_path'];
		if ('' === $destShareName) {
			if (!csSYNOPhotoMisc::CheckAlbumUploadable('/')) {
				$this->SetError(PHOTOSTATION_FILE_ACCESS_DENY);
				goto End;
			}
		} elseif (!csSYNOPhotoMisc::CheckAlbumUploadable($destShareName)) {
			$this->SetError(PHOTOSTATION_FILE_ACCESS_DENY);
			goto End;
		}

		$fileName = $_REQUEST['filename'];
		if ($isPhoto && !csSYNOPhotoMisc::IsPhotoFile($fileName)) {
			$this->SetError(PHOTOSTATION_FILE_FILE_EXT_ERR);
			goto End;
		}
		if (!$isPhoto && !csSYNOPhotoMisc::IsVideoFile($fileName)) {
			$this->SetError(PHOTOSTATION_FILE_FILE_EXT_ERR);
			goto End;
		}

		$destDir = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $destShareName);
		if (!file_exists($destDir)) {
			$this->SetError(PHOTOSTATION_FILE_DIR_NOT_EXISTS);
			goto End;
		}
		if (0 !== strncmp($destDir, SYNOPHOTO_SERVICE_REAL_DIR . "/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1) && $destDir !== SYNOPHOTO_SERVICE_REAL_DIR) {
			$this->SetError(PHOTOSTATION_FILE_BAD_PARAMS);
			goto End;
		}

		$mtime = $_REQUEST['mtime'];

		$dup = $_REQUEST['duplicate'];
		$overwrite = ('ignore' === $dup) ? 0 : (('overwrite' === $dup) ? 1 : 2);	// default is rename

		/* set all uploaded file data */
		$files = array();
		$files['original'] = isset($_FILES['original']) ? $_FILES['original'] : null;
		$files['thumb_small'] = isset($_FILES['thumb_small']) ? $_FILES['thumb_small'] : null;
		$files['thumb_large'] = isset($_FILES['thumb_large']) ? $_FILES['thumb_large'] : null;
		$files['high'] = isset($_FILES['high']) ? $_FILES['high'] : null;
		$files['medium'] = isset($_FILES['medium']) ? $_FILES['medium'] : null;
		$files['low'] = isset($_FILES['low']) ? $_FILES['low'] : null;
		$files['mobile'] = isset($_FILES['mobile']) ? $_FILES['mobile'] : null;
		$files['iphone'] = isset($_FILES['iphone']) ? $_FILES['iphone'] : null;
		$files['android'] = isset($_FILES['android']) ? $_FILES['android'] : null;
		$files['flv'] = isset($_FILES['flv']) ? $_FILES['flv'] : null;

		$destPath = $destDir . "/" . $fileName;

		if (@file_exists($destPath)) {
			if (0 === $overwrite) {
				//ignore
				$ret = false;
				goto End;
			} else if (2 === $overwrite) {
				//rename
				$dir = pathinfo($destPath, PATHINFO_DIRNAME);
				$name = pathinfo($destPath, PATHINFO_FILENAME);
				$ext = pathinfo($destPath, PATHINFO_EXTENSION);

				$rename_suffix = 0;
				$rename_path = $destPath;

				while (file_exists($rename_path)) {
					$rename_path = "$dir/$name" . "_" . (++$rename_suffix) . ".$ext";
				}

				$destPath = $rename_path;
			}
		}

		$IsOldEAFilePrefix = csSYNOPhotoMisc::IsOldEAFilePrefix();

		/* set all destination file path */
		$destEADir = SYNOPhotoEA::getEADirPath($destPath);
		$smallPath = $destEADir . "/" . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_THUMB_M, $IsOldEAFilePrefix);
		$largePath = $destEADir . "/" . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_THUMB_XL, $IsOldEAFilePrefix);
		$vHighPath = $destEADir . "/" . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_H_MP4, $IsOldEAFilePrefix);
		$vMediumPath = $destEADir . "/" . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_M_MP4, $IsOldEAFilePrefix);
		$vLowPath = $destEADir . "/" . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_L_MP4, $IsOldEAFilePrefix);
		$vFlvPath = $destEADir . "/" . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_FLV, $IsOldEAFilePrefix);
		$vMobilePath = $destEADir . "/" . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_MOBILE_MP4, $IsOldEAFilePrefix);
		$vIPhonePath = $destEADir . "/" . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_MOBILE_IPHONE, $IsOldEAFilePrefix);
		$vAndroidPath = $destEADir . "/" . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_FILM_MOBILE_ANDROID, $IsOldEAFilePrefix);

		@mkdir($destDir, 0777, true);
		@mkdir($destEADir, 0777, true);

		/* write all existed files */
		$this->writeFile($files['thumb_small']['tmp_name'], $smallPath);
		$this->writeFile($files['thumb_large']['tmp_name'], $largePath);
		if (!$isPhoto) {
			$this->writeFile($files['high']['tmp_name'], $vHighPath);
			$this->writeFile($files['medium']['tmp_name'], $vMediumPath);
			$this->writeFile($files['low']['tmp_name'], $vLowPath);
			$this->writeFile($files['flv']['tmp_name'], $vFlvPath);
			$this->writeFile($files['mobile']['tmp_name'], $vMobilePath);
			$this->writeFile($files['iphone']['tmp_name'], $vIPhonePath);
			$this->writeFile($files['android']['tmp_name'], $vAndroidPath);
		}
		$ret = $this->writeFile($files['original']['tmp_name'], $destPath);

		/* trigger index */
		if (!empty($files['original']) && $ret) {
			@touch($destPath, $mtime / 1000);
			$path_part = pathinfo($rename_path ? $rename_path : $fileName);
			if (isset($_REQUEST['title'])) {
				$path_part['title'] = $_REQUEST['title'];
			}
			if (isset($_REQUEST['description'])) {
				$path_part['description'] = $_REQUEST['description'];
			}

			$this->SYNOPHOTO_UPLOAD_DoIndex($destPath, trim($destShareName . "/" . $path_part['basename'], "/"), $path_part);
			$this->SYNOPHOTO_UPLOAD_DoExtractPreview($destPath);
		}

		$ret = true;
	End:
		return $ret;
	}

	private function writeFile($tmpPath, $destPath)
	{
		if (empty($tmpPath)) {
			return false;
		}
		if (!is_uploaded_file($tmpPath)) {
			return false;
		}
		if (!move_uploaded_file($tmpPath, $destPath)) {
			return false;
		}
		@chmod($destPath, 0777);
		return true;
	}

	/* copy from file_upload.php */
	private function SYNOPHOTO_UPLOAD_DoIndex($path, $partial_path, $path_parts)
	{
		@exec("/usr/syno/bin/synoindex -a " . escapeshellarg($path) . " > /dev/null 2>&1");
		@exec("/usr/syno/bin/synophotoio -a " . escapeshellarg($path) . " > /dev/null 2>&1");

		if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)) {
			$destination_path = $partial_path;
		} else {
			$destination_path = SYNOPHOTO_SERVICE_REAL_DIR_PATH . $partial_path;
		}

		if (csSYNOPhotoMisc::IsPhotoFile($path)) {
			$name = PHOTO_DB_EscapeParam($path_parts['basename']);
			$title = PHOTO_DB_EscapeParam(isset($path_parts['title']) ? $path_parts['title'] : $path_parts['filename']);
			$description = PHOTO_DB_EscapeParam(isset($path_parts['description']) ? $path_parts['description'] : '');

			$query = "UPDATE photo_image SET title = ?, description = ?, name = ? WHERE path = ?";
			$sqlParam = array($title, $description, $name, $destination_path);

			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
			if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
				$query = "INSERT INTO photo_image (path, name, title, description) VALUES (?, ?, ?, ?)";
				$sqlParam = array($destination_path, $name, $title, $description);
				PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
			}

			// sync with fb
			$albumName = str_replace(basename($partial_path), "", $partial_path);
			$arr = explode("/", trim($albumName, "/"));

			if (1 < count($arr)) {
				$albumName = $arr[0]."/".$arr[1];
			} else {
				$albumName = $arr[0];
			}

			$this->SYNOPHOTO_UPLOAD_StartSyncWithFb($albumName);

		} elseif (csSYNOPhotoMisc::IsVideoFile($path)) {
			$title = isset($path_parts['title']) ? $path_parts['title'] : $path_parts['filename'];
			$description = isset($path_parts['description']) ? $path_parts['description'] : '';

			$query = "UPDATE video_desc SET title = ?, description = ? WHERE path = ?";
			$sqlParam = array($title, $description, $destination_path);

			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
			if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
				$query = "INSERT INTO video_desc (path, title, description) VALUES (?, ?, ?)";
				$sqlParam = array($destination_path, $title, $description);
				PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
			}
		}
	}

	private function SYNOPHOTO_UPLOAD_DoExtractPreview($path) {
		@exec("/usr/syno/bin/synophoto_dsm_user --extractpreview " . escapeshellarg($path) . " > /dev/null 2>&1");
	}

	/* copy from file_upload.php */
	private function SYNOPHOTO_UPLOAD_StartSyncWithFb($albumName)
	{
		if (!csSYNOPhotoMisc::issetToSyncWithFb($albumName)) {
			return;
		}
		$token = csSYNOPhotoMisc::GetConfigDB("photo", "fb_token", "photo_config");
		$confPath = csSYNOPhotoMisc::getFbSyncConfPath($albumName);
		$albumPath = SYNOPHOTO_SERVICE_REAL_DIR . "/" . $albumName;
		$useOrig = (csSYNOPhotoMisc::GetConfigDB("photo", "share_upload_orig", "photo_config") == 'on')? '-o':'';
		$command = "/usr/syno/bin/synophoto_sns_utils --pidfile \"".$confPath.".set\" --fbsync \"$useOrig -t '$token' -c " . escapeshellarg($confPath) . " " . escapeshellarg($albumPath) . "\"";
		@exec($command." > /dev/null 2>&1");
	}
}

$api = new FileAPI();
$api->Run();
