<?php

require_once('album.inc.php');

class AlbumAPIUtil {

    /**
     * @param $parentAlbumName 
     * @param $data 
     * @return 
     *   id - success 
     *   -1 - general fail
     *   -2 - no upload right
     *   -3 - not admin
     *   -4 - album hsa exist
     */
    static function SYNOPHOTO_ADMIN_AddAlbum($parentAlbumName = '', $params)
    {
        if (null !== $params['sort_by'] || null !== $params['sort_direction'] ||
            null !== $params['allow_comment'] || null !== $params['type'] || null !== $params['password']) {
            if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
                return -3;
            }
        } else {
            if (!csSynoPhotoMisc::CheckAlbumUploadable(('' === $parentAlbumName) ? '/' : $parentAlbumName)) {
                return -2;
            }
        }


        $album_data = array();
        // only 1st level share can set 'allow_comment'
        if ('' === $parentAlbumName) {
            if (null === $params['allow_comment']) {
                $album_data['comment'] = ('on' === csSYNOPhotoMisc::GetConfigDB("photo", "album_def_allow_comment", "photo_config")) ? 't' : 'f';
            } else {
                $album_data['comment'] = ('true' === $params['allow_comment']) ? 't' : 'f';
            }
        } else {
            $album_data['comment'] = 'f';
        }

        $album_name = stripcslashes($params['name']);
        $album_data['sharename'] = ($parentAlbumName == '') ? $album_name : $parentAlbumName.'/'.$album_name;
        $album_data['title'] = stripcslashes($params['title']);
        $album_data['description'] = stripcslashes($params['description']);
        $album_data['public'] = ((null === $params['type']) || ('public' === $params['type'])) ? 't' : 'f';
        $album_data['is_subdir'] = ($parentAlbumName == '') ? 'f' : 't';
        $album_data['password'] = (null !== $params['password']) ? md5($params['password']) : '';

        $path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$album_data['sharename'];

        $createID = SYNOPHOTO_ADMIN_AddAlbumToDB($album_data, $path);
        if ('album existed' === $createID) {
            return -4;
        }

        //sort
        $data = array();
        $data['type'] = (null !== $params['sort_by']) ? self::ConvertToSortCode($params['sort_by']) : -1;
        $data['order'] = (null !== $params['sort_by']) ? self::ConvertToSortDirectionCode($params['sort_direction']) : 0;
        csSYNOPhotoAlbum::GetAlbumInstance()->SaveAlbumThumbSortType($album_data['sharename'], $data);

        csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
        return $createID;
    }

    /**
     * @param $shareName 
     * @param $params 
     * @return 
     *   0 - success
     *  -1 - general fail
     *  -2 - no manage right
     *  -3 - not admin
     */
    static function SYNOPHOTO_ADMIN_UpdateAlbum($shareName, $params)
    {
        // description, title - manage right
        if ((null !== $params['description'] || null !== $params['title']) && null === $params['sort_by'] && null === $params['sort_direction'] &&
            null === $params['allow_comment'] && null === $params['type'] && null === $params['password']) {
            if (!csSynoPhotoMisc::CheckAlbumManageable(('' === $shareName) ? '/' : $shareName)) {
                return -2;
            }
        // not changed
        } elseif (null === $params['description'] && null === $params['title'] && null === $params['sort_by'] && null === $params['sort_direction'] &&
                  null === $params['allow_comment'] && null === $params['type'] && null === $params['password']) {
            return 0;
        } else {
        // title, sort_by, sort_direction, allow_comment, type, password - admin
            if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
                return -3;
            }
        }

        if ('' === $shareName) {
            $shareName = '/';
        }


        $setCondition = array();
        if (null !== $params['title']) {
            $setValue = "title = '".PHOTO_DB_EscapeParam(stripcslashes($params['title']))."'";
            array_push($setCondition, $setValue);
        }
        if (null !== $params['description']) {
            $setValue = "description = '".PHOTO_DB_EscapeParam(stripcslashes($params['description']))."'";
            array_push($setCondition, $setValue);
        }

        if (null !== $params['type']) {
            $query = "Select * from photo_share where sharename = ?";
            $sqlParam = array($shareName);
            $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
            if ($row = PHOTO_DB_FetchRow($db_result)) {
                $shareid = $row['shareid'];
            } else {
                return -1;
            }

            switch ($params['type']) {
                case 'public':
                    $setValue = "public = 't', password = ''";
                    array_push($setCondition, $setValue);

                    /* clear access right table if album is public */
                    $query_access = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where shareid = ".$shareid;
                    $db_result_access = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_access);
                    break;
                case 'private':
                    $setValue = "public = 'f', password = ''";
                    array_push($setCondition, $setValue);

                    /* remove all permissions if album is password */
                    $query_access = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where shareid = ".$shareid;
                    $db_result_access = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_access);
                    $query_access = "Delete from " . PHOTO_UPLOAD_RIGHT_TABLE . " where shareid = ".$shareid;
                    $db_result_access = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_access);
                    $query_access = "Delete from " . PHOTO_MANAGE_RIGHT_TABLE . " where shareid = ".$shareid;
                    $db_result_access = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_access);
                    break;
                case 'password':
                    $setValue = "public = 'f',password='".md5($params['password'])."'";
                    array_push($setCondition, $setValue);

                    /* remove all permissions if album is password */
                    $query_access = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where shareid = ".$shareid;
                    $db_result_access = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_access);
                    $query_access = "Delete from " . PHOTO_UPLOAD_RIGHT_TABLE . " where shareid = ".$shareid;
                    $db_result_access = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_access);
                    $query_access = "Delete from " . PHOTO_MANAGE_RIGHT_TABLE . " where shareid = ".$shareid;
                    $db_result_access = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_access);
                    break;
            }
        }

        if (null !== $params['allow_comment']) {
            if($params['allow_comment'] == 'true') {
                $setValue = "comment = 't'";
                array_push($setCondition, $setValue);
            } else {
                $setValue = "comment = 'f'";
                array_push($setCondition, $setValue);
            }
        }

        $setString = implode(',', $setCondition);
        $query = "Update photo_share set {$setString} where sharename = '".PHOTO_DB_EscapeParam($shareName)."'";
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

        //sort
        $data = array();
        if (null !== $params['sort_by']) {
            $data['type'] = self::ConvertToSortCode($params['sort_by']);
        }
        if (null !== $params['sort_direction']) {
            $data['order'] = self::ConvertToSortDirectionCode($params['sort_direction']);
        }
        if ('/' !== $shareName) {
            csSYNOPhotoAlbum::GetAlbumInstance()->SaveAlbumThumbSortType($shareName, $data);
        }
        csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
        return 0;
    }

    static function ConvertToTypeName($type) {
        switch ($type) {
        case 0:
            $typeName = 'album';
            break;
        case 1:
            $typeName = 'photo';
            break;
        case 2:
            $typeName = 'video';
            break;
        default:
            break;
        }
        return $typeName;
    }

    static function ConvertToSortDirection($value) {
        switch ($value) {
        case -1:
            $sortDirection = 'default';
            break;
        case 0:
            $sortDirection = 'asc';
            break;
        case 1:
            $sortDirection = 'desc';
            break;
        default:
            break;
        }
        return $sortDirection;
    }

    static function ConvertToSortDirectionCode($name) {
        switch ($name) {
        case 'default':
            $sortCode = -1;
            break;
        case 'asc':
            $sortCode = 0;
            break;
        case 'desc':
            $sortCode = 1;
            break;
        default:
            break;
        }
        return $sortCode;
    }

    static function ConvertToSortName($type) {
        switch ($type) {
        case -1:
            $sortBy = 'default';
            break;
        case 0:
            $sortBy = 'filename';
            break;
        case 1:
            $sortBy = 'takendate';
            break;
        case 2:
            $sortBy = 'createdate';
            break;
        case 3:
            $sortBy = 'preference';
            break;
        default:
            break;
        }
        return $sortBy;
    }

    static function ConvertToSortCode($name) {
        switch ($name) {
        case 'default':
            $sortCode = -1;
            break;
        case 'filename':
            $sortCode = 0;
            break;
        case 'takendate':
            $sortCode = 1;
            break;
        case 'createdate':
            $sortCode = 2;
            break;
        case 'preference':
            $sortCode = 3;
            break;
        default:
            break;
        }
        return $sortCode;
    }

    static function FilterByType($items, $type)
    {
        $filterItems = array();
        foreach ($items as $item) {
            $typeName = self::ConvertToTypeName($item['itemType']);
            if (in_array($typeName, $type)) {
                array_push($filterItems, $item);
            }
        }
        return $filterItems;
    }

    static function SortItem($photo_video_items, $sortBy, $sortDirection, $offset, $limit) {
        $itemsSort = array();

        // sort by photo, video
        if ('filename' === $sortBy) {
            if ('asc' === $sortDirection) {
                usort($photo_video_items, 'self::SortFilename_ASC');
            } else {
                usort($photo_video_items, 'self::SortFilename_DESC');
            }
        } elseif ('takendate' === $sortBy) {
            if ('asc' === $sortDirection) {
                usort($photo_video_items, 'self::SortTakendate_ASC');
            } else {
                usort($photo_video_items, 'self::SortTakendate_DESC');
            }
        } elseif ('createdate' === $sortBy) {
            if ('asc' === $sortDirection) {
                usort($photo_video_items, 'self::SortCreatedate_ASC');
            } else {
                usort($photo_video_items, 'self::SortCreatedate_DESC');
            }
        }

        if (false === $offset && false === $limit) {
            return $photo_video_items;
        }
        // set offset and limit
        $cutItemsSort = array();
        if (0 > (int)$limit) {
            $cutItemsSort = array_slice($photo_video_items, $offset);
        } else {
            $cutItemsSort = array_slice($photo_video_items, $offset, $limit);
        }

        return $cutItemsSort;
    }

    private function ExtractItem($items, &$albumItems, &$photo_video_items) {
        $index = count($items);
        foreach ($items as $key => $item) {
            if ('album' !== self::ConvertToTypeName($item['itemType'])) {
                $index = $key;
                break;
            }
        }
        $albumItems = array_slice($items, 0, $index);
        $photo_video_items = array_slice($items, $index);
    }

    private function SortFilename_ASC($a, $b) {
        if ($a['name'] == $b['name']) {
            return 0;
        }
        return ($a['name'] < $b['name']) ? -1 : 1;
    }

    private function SortFilename_DESC($a, $b) {
        if ($a['name'] == $b['name']) {
            return 0;
        }
        return ($a['name'] > $b['name']) ? -1 : 1;
    }

    private function SortTakendate_ASC($a, $b) {
        if ($a['takendate'] == $b['takendate']) {
            return ($a['name'] < $b['name']) ? -1 : 1;
        }
        return ($a['takendate'] < $b['takendate']) ? -1 : 1;
    }

    private function SortTakendate_DESC($a, $b) {
        if ($a['takendate'] == $b['takendate']) {
            return ($a['name'] > $b['name']) ? -1 : 1;
        }
        return ($a['takendate'] > $b['takendate']) ? -1 : 1;
    }

    private function SortCreatedate_ASC($a, $b) {
        if ($a['createdate'] == $b['createdate']) {
            return ($a['name'] < $b['name']) ? -1 : 1;
        }
        return ($a['createdate'] < $b['createdate']) ? -1 : 1;
    }

    private function SortCreatedate_DESC($a, $b) {
        if ($a['createdate'] == $b['createdate']) {
            return ($a['name'] > $b['name']) ? -1 : 1;
        }
        return ($a['createdate'] > $b['createdate']) ? -1 : 1;
    }

    private function SortPreference($items, $sharePath) {
        $sort = csSYNOPhotoAlbum::GetAlbumThumbSortType($sharePath);
        $list = array();
        $result = array();
        if (!empty($sort['list'])) {
            $list = $sort['list'];
            $preArr = array();
            foreach ($list as $key) {
                foreach ($items as $item) {
                    if ($key === $item['name']) {
                        array_push($result, $item);
                    }
                }
            }
            
            // rest photo and video item
            foreach ($items as $item) {
                if (!in_array($item, $result)) {
                    array_push($result, $item);
                }
            }

        } else {
            $result = $items;
        }
        
        return $result;
    }

    /*
     *  @return [string] broken / small, large
     */
    static function GetThumbStatus($path, $needSize, $blCalculateThumbByOrig, $orig_resolutionx = false, $orig_resolutiony = false, $blThumbRotated = false) {
        /* special case for gif, return original file */
        $info = pathinfo($path);
        if ('gif' === strtolower($info['extension'])) {
            $ret['status'] = 'small,large';
            if ($needSize) {
                $imgInfo = @getImageSize($path);
				$mtime = @filemtime($path);
                $ret['size']['preview']['resolutionx'] = $imgInfo[0];
                $ret['size']['preview']['resolutiony'] = $imgInfo[1];
                $ret['size']['preview']['mtime'] = $mtime;
                $ret['size']['small']['resolutionx'] = $imgInfo[0];
                $ret['size']['small']['resolutiony'] = $imgInfo[1];
                $ret['size']['small']['mtime'] = $mtime;
                $ret['size']['large']['resolutionx'] = $imgInfo[0];
                $ret['size']['large']['resolutiony'] = $imgInfo[1];
                $ret['size']['large']['mtime'] = $mtime;
            }
            return $ret;
        }

        if ($needSize) {
            $ret['size']['preview']['resolutionx'] = 0;
            $ret['size']['preview']['resolutiony'] = 0;
            $ret['size']['small']['resolutionx'] = 0;
            $ret['size']['small']['resolutiony'] = 0;
            $ret['size']['large']['resolutionx'] = 0;
            $ret['size']['large']['resolutiony'] = 0;
        }

        $file_name = basename($path);
        $dir = substr($path, 0, strlen($path) - strlen($file_name));

        if (SYNOPhotoEA::checkFilePathByDirFile($dir, $file_name, SYNOPhotoEA::FILE_THUMB_M_FAIL, $thumbSmallBroken) &&
            SYNOPhotoEA::checkFilePathByDirFile($dir, $file_name, SYNOPhotoEA::FILE_THUMB_XL_FAIL, $thumbLargeBroken)) {
            $ret['status'] = 'broken';
        } else {
            $thumbStatus = array();
            if (SYNOPhotoEA::checkFilePathByDirFile($dir, $file_name, SYNOPhotoEA::FILE_THUMB_PREVIEW, $thumbPreviewPath)) {
                array_push($thumbStatus, 'preview');
                if ($needSize) {
                    $ret['size']['preview'] = self::GetThumbSize($path, $thumbPreviewPath);
                    $ret['size']['preview']['mtime'] = $mtime = @filemtime($thumbPreviewPath);
                }
            }
            if (SYNOPhotoEA::checkFilePathByDirFile($dir, $file_name, SYNOPhotoEA::FILE_THUMB_M, $thumbSmallPath)) {
                array_push($thumbStatus, 'small');
                if ($needSize) {
					if ($blCalculateThumbByOrig) {
						$ret['size']['small'] = self::CalculateThumbSize($orig_resolutionx, $orig_resolutiony, $blThumbRotated, SYNOPHOTO_THUMBMEDIUM_WIDTH);
					} else {
						$ret['size']['small'] = self::GetThumbSize($path, $thumbSmallPath);
					}
                    $ret['size']['small']['mtime'] = $mtime = @filemtime($thumbSmallPath);
                }
            }
            if (SYNOPhotoEA::checkFilePathByDirFile($dir, $file_name, SYNOPhotoEA::FILE_THUMB_XL, $thumbLargePath)) {
                array_push($thumbStatus, 'large');
                if ($needSize) {
					if ($blCalculateThumbByOrig) {
						$ret['size']['large'] = self::CalculateThumbSize($orig_resolutionx, $orig_resolutiony, $blThumbRotated, SYNOPHOTO_THUMBXLARGE_WIDTH);
					} else {
						$ret['size']['large'] = self::GetThumbSize($path, $thumbLargePath);
					}
                    $ret['size']['large']['mtime'] = $mtime = @filemtime($thumbLargePath);
                }
            }
            $ret['status'] = implode(',', $thumbStatus);
        }

        return $ret;
	}

	static function CalculateThumbSize($orig_resolutionx, $orig_resolutiony, $blThumbRotated, $thumbWidth)
	{
		$thumb['resolutionx'] = $thumb['resolutiony'] = 0;
		if (0 >= $orig_resolutionx || 0 >= $orig_resolutiony || 0 >= $thumbWidth) {
			goto End;
		}
		$ratio = $orig_resolutionx / $orig_resolutiony;
		if (0 >= $ratio) {
			goto End;
		}
		if ($orig_resolutionx >= $orig_resolutiony) {
			$thumb['resolutionx'] = !$blThumbRotated ? $thumbWidth : ceil($thumbWidth / $ratio);
			$thumb['resolutiony'] = !$blThumbRotated ? ceil($thumbWidth / $ratio) : $thumbWidth;
		} else {
			$thumb['resolutionx'] = !$blThumbRotated ? ceil($thumbWidth * $ratio) : $thumbWidth;
			$thumb['resolutiony'] = !$blThumbRotated ? $thumbWidth : ceil($thumbWidth * $ratio);
		}
	End:
		return $thumb;
	}

    static function GetThumbSize($imgPath, $thumbPath) {
        $thumbInfo = @getImageSize($thumbPath);
        $ret = array(
            'resolutionx' => $thumbInfo[0],
            'resolutiony' => $thumbInfo[1]
        );

        $info = pathinfo($imgPath);
        if (!in_array(strtolower($info['extension']), array('jpeg', 'bmp', 'png', 'jpg', 'jpe'/*, 'image/tiff'*/))) {
            goto END;
        }

        $imgInfo = @getImageSize($imgPath);
        $rotated = ($thumbInfo[0] > $thumbInfo[1] && $imgInfo[0] <= $imgInfo[1]) || ($thumbInfo[0] <= $thumbInfo[1] && $imgInfo[0] > $imgInfo[1]);

        if ($rotated && $thumbInfo[0] > $imgInfo[1]) {
            $ret['resolutionx'] = $imgInfo[1];
            $ret['resolutiony'] = $imgInfo[0];
        } else if (!$rotated && $thumbInfo[0] > $imgInfo[0]) {
            $ret['resolutionx'] = $imgInfo[0];
            $ret['resolutiony'] = $imgInfo[1];
        }

    END:
        return $ret;
    }

	static function FillThumbStatus(&$item, $coverPath, $needThumbSize, $blCalculateThumbByOrig, $orig_resolutionx = false, $orig_resolutiony = false, $blThumbRotated = false)
	{
		if ('' !== $coverPath) {
			$thumbnail = self::GetThumbStatus($coverPath, $needThumbSize, $blCalculateThumbByOrig, $orig_resolutionx, $orig_resolutiony, $blThumbRotated);
		} else {
			$thumbnail = array('status' => 'default');
			if ($needThumbSize) {
				$thumbnail['size'] = array(
					'preview' => array('resolutionx' => 0, 'resolutiony' => 0),
					'small' => array('resolutionx' => 0, 'resolutiony' => 0),
					'large' => array('resolutionx' => 0, 'resolutiony' => 0)
				);
			}
		}

		$item['thumbnail_status'] = $thumbnail['status'];
		if ($needThumbSize) {
			if (!is_array($item['additional'])) {
				$item['additional'] = array();
			}
			$item['additional']['thumb_size'] = $thumbnail['size'];
			$item['additional']['thumb_size']['sig'] = bin2hex($coverPath);
		}
	}

    static function GetAlbumPermission($sharePath) {
        $permission['browse'] = csSYNOPhotoMisc::CheckAlbumAccessible($sharePath);
        $permission['upload'] = csSYNOPhotoMisc::CheckAlbumUploadable($sharePath);
        $permission['manage'] = csSYNOPhotoMisc::CheckAlbumManageable($sharePath);
        return $permission;
    }

	static function GetUnConfirmItemList($limit=false, $offset=false)
	{
        $result = array();

        $offsetCond = '';
        if (false !== $limit && false !== $offset) {
            $limitCond = (0 > $limit) ? '' : "LIMIT {$limit}";
            $offsetCond = " {$limitCond} OFFSET {$offset}";
        }

        $query = "SELECT photo_image.path FROM photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id WHERE status='f'";
        $queryCount = "SELECT COUNT(DISTINCT photo_image.path) FROM photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id WHERE status='f'";
        $albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
        $sqlParam = array();
        if(count($albumCondition['albumCond']) > 0 && !isset( $_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
            $query .= " AND (".implode(' OR ', $albumCondition['albumCond']).' )';
            $queryCount .= " AND (".implode(' OR ', $albumCondition['albumCond']).' )';
            $query .= " ORDER BY photo_image.create_time DESC";
            $query .= $offsetCond;
            $sqlParam = $albumCondition['sqlParam'];
            $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
        } else {
            $query .= " ORDER BY photo_image.create_time DESC";
            $query .= $offsetCond;
            $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
        }
        while (false !== ($row = PHOTO_DB_FetchRow($db_result))) {
            if ($row['path']) {
                $result[SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']] = SYNOPHOTO_ITEM_TYPE_PHOTO;
            }
        }
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $queryCount, $sqlParam);
        $row = PHOTO_DB_FetchRow($db_result);
        $result['total'] = $row[0];
        return $result;
    }

    /*
     *  @param $videoPath video full path
     */
    static function GetConvertedVideoInfo($videoPath)
    {
        $dPath = substr($videoPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
        $query = "SELECT * FROM video_convert WHERE video_path = ?";
        $sqlParam = array($dPath);
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
        $videoArr = array();
        while ($videoInfo = PHOTO_DB_FetchRow($db_result)) {
            $videoQuality['id'] = bin2hex(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$videoInfo['convert_file_path']);
            $videoQuality['container'] = $videoInfo['container_type'];
            $videoQuality['vcodec'] = $videoInfo['vcodec'];
            $videoQuality['acodec'] = $videoInfo['acodec'];
            $videoQuality['resolutionx'] = $videoInfo['resolutionx'];
            $videoQuality['resolutiony'] = $videoInfo['resolutiony'];
            $videoQuality['video_bitrate'] = $videoInfo['video_bitrate'];
            $videoQuality['audio_bitrate'] = $videoInfo['audio_bitrate'];
            $videoQuality['video_profile'] = $videoInfo['video_profile'];
            $videoQuality['video_level'] = $videoInfo['video_level'];
            $videoQuality['profile_name'] = self::GetConvertedName($videoInfo['convert_file_path']);
            array_push($videoArr, $videoQuality);
        }
        return $videoArr;
    }

    static function GetConvertedName($convertPath)
    {
        $fileName = basename($convertPath);
        $pool = array(SYNOPhotoEA::FILE_FILM_FLV, SYNOPhotoEA::FILE_FILM_H264_MP4, SYNOPhotoEA::FILE_FILM_H_MP4, SYNOPhotoEA::FILE_FILM_M_MP4, SYNOPhotoEA::FILE_FILM_L_MP4,
                      SYNOPhotoEA::FILE_FILM_MOBILE_MP4, SYNOPhotoEA::FILE_FILM_MOBILE_IPHONE, SYNOPhotoEA::FILE_FILM_MOBILE_ANDROID);
        foreach ($pool as $name) {
            $oldName = SYNOPhotoEA::SYNO_PHOTO_PREFIX_OLD.$name;
            $newName = SYNOPhotoEA::SYNO_PHOTO_PREFIX.$name;
            if ($oldName === $fileName || $newName === $fileName) {
                if (SYNOPhotoEA::FILE_FILM_FLV === $name) {
                    $ret = 'flv';
                } elseif (SYNOPhotoEA::FILE_FILM_H264_MP4 === $name) {
                    $ret = 'orig_h264';
                } elseif (SYNOPhotoEA::FILE_FILM_MPEG4_MP4 === $name) {
                    $ret = 'orig_mp4';
                } elseif (SYNOPhotoEA::FILE_FILM_H_MP4 === $name) {
                    $ret = 'high';
                } elseif (SYNOPhotoEA::FILE_FILM_M_MP4 === $name) {
                    $ret = 'medium';
                } elseif (SYNOPhotoEA::FILE_FILM_L_MP4 === $name) {
                    $ret = 'low';
                } elseif (SYNOPhotoEA::FILE_FILM_MOBILE_MP4 === $name) {
                    $ret = 'mobile';
                } elseif (SYNOPhotoEA::FILE_FILM_MOBILE_IPHONE === $name) {
                    $ret = 'orig_iphone';
                } elseif (SYNOPhotoEA::FILE_FILM_MOBILE_ANDROID === $name) {
                    $ret = 'orig_android';
                } elseif (SYNOPhotoEA::FILE_FILM_CONVERT_MPEG4_MP4 === $name) {
                    $ret = 'convert_mp4';
                }
                break;
            }
        }
        return $ret;
    }

    static function IsAlbumCommentalbGlobal($checkSession = false)
    {
        $blAllowUserComment = ('on' === csSYNOPhotoMisc::GetConfigDB("photo", "allow_user_comment", "photo_config"));
        $blAllowGuestComment = ('on' === csSYNOPhotoMisc::GetConfigDB("photo", "allow_guest_comment", "photo_config"));

        if ($blAllowGuestComment) {
            return true;
        } elseif ($blAllowUserComment) {
            if ($checkSession) {
                csSYNOPhotoMisc::CheckSessionTimeOut(true);
                return true;
            } else {
                if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) || isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
                    return true;
                }
            }
        }

        return false;
    }
}

?>
