<?php
$includePath = dirname(__FILE__).'/picasa';
ini_set('include_path', $includePath);

require_once 'Zend/Loader.php';

Zend_Loader::loadClass('Zend_Gdata');
Zend_Loader::loadClass('Zend_Gdata_AuthSub');
Zend_Loader::loadClass('Zend_Gdata_Photos');
Zend_Loader::loadClass('Zend_Gdata_Photos_UserQuery');
Zend_Loader::loadClass('Zend_Gdata_Photos_AlbumQuery');
Zend_Loader::loadClass('Zend_Gdata_Photos_PhotoQuery');
Zend_Loader::loadClass('Zend_Gdata_App_Extension_Category');

require_once 'include/SYNOPhotoEA.php';

$cmdOpts = getopt('t:n:u:a:c:o');
if ($cmdOpts !== false) {
	SYNOPHOTO_PICASA_doBatchUpload($cmdOpts, $argv);
	exit(0);
}

require_once("include/syno_conf.php");

define('SYNOPHOTO_DEFAULT_ALBUM_NAME', 'PhotoStation');

if(isSet($_GET['token'])) {
	echo SYNOPHOTO_PICASA_setToken();
	exit;
}

if (isSet($_GET['action']) && 'start_authSub' == $_GET['action']) {
	echo SYNOPHOTO_PICASA_startAuthSub();
	exit;
}

if (preg_match('/^(upload|upload_new|get_user|get_album)$/', $_POST['action'])) {
	if (!isSet($_POST['token'])) {
		$result['success'] = false;
		return json_encode($result);
	}
	$client = Zend_Gdata_AuthSub::getHttpClient($_POST['token']);
	$picasa = new Zend_Gdata_Photos($client);
}

switch ($_POST['action']) {
case 'get_user':
	echo SYNOPHOTO_PICASA_getUser();
	break;
case 'upload':
	echo SYNOPHOTO_PICASA_uploadOnePhoto();
	break;
case 'upload_new':
	echo SYNOPHOTO_PICASA_uploadOnePhoto_new();
	break;
case 'get_album':
	echo SYNOPHOTO_PICASA_getAlbum();
	break;
case 'multi_upload_new':
	echo SYNOPHOTO_PICASA_startMultiUpload_new();
	break;
case 'get_upload_status':
	echo SYNOPHOTO_PICASA_GetUploadStatus();
	break;
case 'cancel_upload':
	echo SYNOPHOTO_PICASA_CancelUpload();
	break;
}

function SYNOPHOTO_PICASA_getUser()
{
	global $picasa;
	$result['success'] = false;
	try {
		$query = new Zend_Gdata_Photos_UserQuery();
		$query->setUser('default');
		$query->setType('entry');
		$userEntry = $picasa->getUserEntry($query);
		$result['user'] = array();
		$result['user']['name'] = $userEntry->getGphotoNickName()->text;
		$result['user']['image'] = $userEntry->getGphotoThumbnail()->text;
		$result['success'] = true;
	} catch (Zend_Gdata_App_Exception $e) {
		$result['user'] = null;
		$result['error'] = $e->getMessage();
	}
	return json_encode($result);
}


//TODO change to update server
function SYNOPHOTO_PICASA_startAuthSub()
{
	$authServer = "http://update.synology.com/PhotoStation/Picasa/index.php?url=".urlencode(SYNOPHOTO_PICASA_getCurrentUrl());
	header("Location: {$authServer}");
}

function SYNOPHOTO_PICASA_setToken()
{
	$token = Zend_Gdata_AuthSub::getAuthSubSessionToken($_GET['token']);
	$client = Zend_Gdata_AuthSub::getHttpClient($token);
	$picasa = new Zend_Gdata_Photos($client);
	try {
		$callback = '_onPicasaLogin';
		$query = new Zend_Gdata_Photos_UserQuery();
		$query->setUser('default');
		$query->setType('entry');
		$userEntry = $picasa->getUserEntry($query);
		$name = $userEntry->getGphotoNickName()->text;
		$image = $userEntry->getGphotoThumbnail()->text;
		$closeWindow = "
			<html>
			<head>
				<script>
				function loadHandler(){
					var callback = '$callback';
					var token = '$token';
					var name = '$name';
					var picture = '$image';
					if (callback) {
						eval('callback = window.opener.' + callback);
						callback(token, name, picture);
					}
					window.close();
				}
				</script>
			</head>
			<body onload='loadHandler()'></body>
			</html>";
		return $closeWindow;

	} catch (Zend_Gdata_App_Exception $e) {
		echo "Error: " . $e->getMessage();
	}
}

function SYNOPHOTO_PICASA_getCurrentUrl()
{
	$php_request_uri = htmlentities(substr($_SERVER['REQUEST_URI'], 0,
	strcspn($_SERVER['REQUEST_URI'], "\n\r")), ENT_QUOTES);

	if (isset($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS']) == 'on') {
		$protocol = 'https://';
	} else {
		$protocol = 'http://';
	}
    $host = $_SERVER['HTTP_HOST'];
	return $protocol . $host . $php_request_uri;
}

function SYNOPHOTO_PICASA_uploadOnePhoto($albumId = null)
{
	global $picasa;
	$result['success'] = false;
	if (!isSet($_POST['path']) || !isSet($_POST['token']) || !isSet($_POST['type'])) {
		$result['error'] = "Bad arguments";
		return json_encode($result);
	}
	$path = $_POST['path'];

	if ($_POST['type'] === '0') {
		$albumEntry = SYNOPHOTO_PICASA_addAlbum($_POST["newAlbumName"]);
	} else {
		$albumEntry = SYNOPHOTO_PICASA_getAlbum_by_Id($_POST["albumId"]);
	}

	if (empty($albumEntry)) {
		$result['error'] = "Get album falis.";
		return json_encode($result);
	}
	$useOrig = (csSYNOPhotoMisc::GetConfigDB("photo", "share_upload_orig", "photo_config") == 'on')? true:false;
	$status = SYNOPHOTO_PICASA_upload($path, $albumEntry, $_POST['message'], $useOrig);
	$result['success'] = $status['success'];
	$result['error'] = $status['error'];
	return json_encode($result);
}

function SYNOPHOTO_PICASA_uploadOnePhoto_new($albumId = null)
{
	global $picasa;
	$result['success'] = false;
	if (!isSet($_POST['id']) || !isSet($_POST['token']) || !isSet($_POST['type'])) {
		$result['error'] = "Bad arguments";
		return json_encode($result);
	}
	$idarr = split('_', $_POST['id']);
	$path = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . @pack('H*', $idarr[1]) . "/" . @pack('H*', $idarr[2]));

	if ($_POST['type'] === '0') {
		$albumEntry = SYNOPHOTO_PICASA_addAlbum($_POST["newAlbumName"]);
	} else {
		$albumEntry = SYNOPHOTO_PICASA_getAlbum_by_Id($_POST["albumId"]);
	}

	if (empty($albumEntry)) {
		$result['error'] = "Get album falis.";
		return json_encode($result);
	}
	$useOrig = (csSYNOPhotoMisc::GetConfigDB("photo", "share_upload_orig", "photo_config") == 'on')? true:false;
	$status = SYNOPHOTO_PICASA_upload($path, $albumEntry, $_POST['message'], $useOrig);
	$result['success'] = $status['success'];
	$result['error'] = $status['error'];
	return json_encode($result);
}

function SYNOPHOTO_PICASA_upload($filePath, $albumEntry, $message=null, $useOrig)
{
	global $picasa;
	$result = array();

	$image = $filePath;// upload original file

	if (!$useOrig) {
		if (SYNOPhotoEA::checkFilePath($filePath, SYNOPhotoEA::FILE_THUMB_XL, $XLimage)) {
			$image = $XLimage;
		}
	}

	$fd = $picasa->newMediaFileSource($image);
	$result['success'] = false;
	$mimeType = SYNOPHOTO_PICASA_GetPhotoMimeType($image);
	if (null === $mimeType) {
		return $result;
	}
	$fd->setContentType($mimeType);
	$entry = new Zend_Gdata_Photos_PhotoEntry();
	$entry->setMediaSource($fd);
	$entry->setTitle($picasa->newTitle(basename($filePath)));
	if (!empty($message)) {
		$entry->setSummary($picasa->newSummary($message));
	}
	try {
		$photoEntry = $picasa->insertPhotoEntry($entry, $albumEntry);
	} catch (Zend_Gdata_App_Exception $e) {
		$result['success'] = false;
		$result['error'] = $e->getMessage();
		return $result;
	}
	$result['success'] = true;
	return $result;
}

function SYNOPHOTO_PICASA_startMultiUpload_new()
{
	$result['success'] = false;
	$list_file = SYNOPHOTO_PICASA_GetNameList_new($_POST['albumName'], $_POST['photoList'], $_POST['prog_id']);
	$progressFile = SYNOPHOTO_PICASA_UPLOAD_PROGRESS_FILE.".".$_POST['prog_id'];
	$token = $_POST['token'];
	$useOrig = (csSYNOPhotoMisc::GetConfigDB("photo", "share_upload_orig", "photo_config") == 'on')? '-o':'';
	if ('0' == $_POST['type']) {
		$commend = "/usr/syno/bin/synophoto_sns_utils --picasaupload \"$useOrig -t '$token' -u $progressFile -n ".escapeshellarg($_POST['newAlbumName'])." $list_file\"";
	} else {
		$commend = "/usr/syno/bin/synophoto_sns_utils --picasaupload \"$useOrig -t '$token' -u '$progressFile' -a ".escapeshellarg($_POST['albumId'])." '$list_file'\"";
	}

	@exec($commend." > /dev/null 2>&1");
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_PICASA_GetNameList_new($albumName, $photoList, $prog_id)
{
	$id_litst = explode(",", $photoList);
	$result['files'] = array();
	foreach ($id_litst as $id) {
		$arr = split('_', $id);
		$name = @pack('H*', $arr[2]);
		$title = $name;
		$real_path = SYNOPHOTO_SERVICE_REAL_DIR . "/" . @pack('H*', $arr[1]) . "/" . $name;
		if (FALSE == @stat($real_path)) {
			continue;
		}
		$item = array();
		$item['file'] = $real_path;
		$item['message'] = $title;
		$result['files'][] = $item;
	}
	$list_file = SYNOPHOTO_PICASA_UPLOAD_PROGRESS_FILE.".".$prog_id.".list";
	$handle = @fopen($list_file, "w");
	@fwrite($handle, json_encode($result));
	fclose($handle);
	return $list_file;
}

function SYNOPHOTO_PICASA_doBatchUpload($cmdOpts, $argv)
{
	global $picasa;
	$token = $cmdOpts['t'];
	$albumName = $cmdOpts['n'];
	$progressFile = $cmdOpts['u'];
	$albumID = $cmdOpts['a'];
	$uploadList = $argv[count($argv)-1];
	$useOrig = isSet($cmdOpts['o'])? true:false;

	$client = Zend_Gdata_AuthSub::getHttpClient($token);
	$picasa = new Zend_Gdata_Photos($client);

	//get albumEntry
	if(empty($albumID) && !empty($albumName)) {
		//create new album
		$albumEntry = SYNOPHOTO_PICASA_addAlbum($albumName);
	} else if (!empty($albumID)){
		$albumEntry = SYNOPHOTO_PICASA_getAlbum_by_Id($albumID);
	}
	if (empty($albumEntry)) {
		SYNOPHOTO_PICASA_writeProgress($progressFile, 0, 0, '', true, true, "Failed to get albumEntry.");
		exit(1);
	}
	if (false === ($uploadFileList = SYNOPHOTO_PICASA_getUploadFileList($uploadList))){
		//read file fail
		SYNOPHOTO_PICASA_writeProgress($progressFile, 0, 0, '', true, true, "Failed to load $uploadList.");
		exit(1);
	}

	$total = 0;
	$files = array();
	foreach($uploadFileList as $file) {
		$st = stat($file["file"]);
		if($st && is_file($file["file"])) {
			$file["size"] = $st["size"];
			$files[] = $file;
			$total += $st["size"];
		}
	}
	$uploadFileList = $files;

	$uploaded = 0;
	foreach($uploadFileList as $file){
		if (!file_exists($uploadList)) {
			// For user cancle upload task.
			break;
		}
		SYNOPHOTO_PICASA_writeProgress($progressFile, $uploaded, $total, $file["file"], false, true);
		$status = SYNOPHOTO_PICASA_upload($file['file'], $albumEntry, null, $useOrig);
		if (!$status['success']) {
			SYNOPHOTO_PICASA_writeProgress($progressFile, $uploaded, $total, '', true, true, $status['error']);
			exit(0);
		}
		$uploaded += $file["size"];
	}
	SYNOPHOTO_PICASA_writeProgress($progressFile, $total, $total, '', true, true);
}

function SYNOPHOTO_PICASA_writeProgress($progressPath, $progress, $total, $filePath, $hasResult, $result, $message=null)
{
	$dir = dirname($progressPath);
	$tmpFilePath = tempnam($dir, "PICASAUPLOAD");
	if($tmpFilePath) {
		$data = array();
		if($hasResult) {
			$data["success"] = $result ? true:false;
			if (!empty($message)) {
				$data["message"] = $message;
			}
		}
		else {
			$data["progress"] = $progress;
			$data["total"] = $total;
			$data["file"] = $filePath;
		}
		if(file_put_contents($tmpFilePath, json_encode($data)) != FALSE) {
			rename($tmpFilePath, $progressPath);
		}
	}
}

function SYNOPHOTO_PICASA_getUploadFileList($uploadList)
{
	$data = file_get_contents($uploadList);
	if($data != FALSE) {
		$obj = json_decode($data, true);
		if($obj && is_array($obj["files"])) {
			return $obj["files"];
		}
	}
	return false;
}

function SYNOPHOTO_PICASA_GetUploadStatus()
{
	$result = array();
	$result['success'] = 'uploading';
	$result['name'] = __(photo_str_init);
	$result['percent'] = 0;

	$listFile = SYNOPHOTO_PICASA_UPLOAD_PROGRESS_FILE.".".$_POST['prog_id'].".list";

	if (!file_exists($listFile)) {
		$result['success'] = 'canceling';
		return json_encode($result);
	}
	$progressFile = SYNOPHOTO_PICASA_UPLOAD_PROGRESS_FILE.".".$_POST['prog_id'];
	$handle = @fopen($progressFile, "r");
	if ($handle) {
		$content = fread($handle, 8192);
		fclose($handle);
		$json = json_decode($content);
		$result['success'] = 'uploading';
		if ($json->{'success'}) {
			$result['success'] = 'finish';
			if ($json->{'message'}) {
				$result['message'] = $json->{'message'};
			}
		} else {
			$result['name'] = basename($json->{'file'});
			$result['percent'] = $json->{'progress'} / $json->{'total'};
		}
	}
	return json_encode($result);
}

function SYNOPHOTO_PICASA_CancelUpload()
{
	$list_file = SYNOPHOTO_PICASA_UPLOAD_PROGRESS_FILE.".".$_POST['prog_id'].".list";
	if (@file_exists($list_file)) {
		@unlink($list_file);
	}
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_PICASA_addAlbum($name)
{
	global $picasa;

    $entry = new Zend_Gdata_Photos_AlbumEntry();
    $entry->setTitle($picasa->newTitle($name));

    $newEntry = $picasa->insertAlbumEntry($entry);
    if ($newEntry) {
		return $newEntry;
    } else {
        return false;
    }
}

function SYNOPHOTO_PICASA_getAlbum_by_Name($albumName)
{
	global $picasa;
	$query = new Zend_Gdata_Photos_AlbumQuery();
	$query->setUser('default');
	$query->setAlbumName($albumName);
	$query->setType('entry');
	try {
		$albumEntry = $picasa->getAlbumEntry($query);
		return $albumEntry;
	} catch (Zend_Gdata_App_Exception $e) {
		return null;
	}
}

function SYNOPHOTO_PICASA_getAlbum_by_Id($albumID)
{
	global $picasa;
	$query = new Zend_Gdata_Photos_AlbumQuery();
	$query->setUser('default');
	$query->setAlbumId($albumID);
	$query->setType('entry');
	try {
		$albumEntry = $picasa->getAlbumEntry($query);
		return $albumEntry;
	} catch (Zend_Gdata_App_Exception $e) {
		return null;
	}
}

function SYNOPHOTO_PICASA_getAlbum()
{
	global $picasa;
	$result['success'] = false;
	try {
		$query = new Zend_Gdata_Photos_UserQuery();
		$query->setUser('default');
		$userFeed = $picasa->getUserFeed(null, $query);
		$albums = array();
		foreach ($userFeed as $entry) {
			if ($entry instanceof Zend_Gdata_Photos_AlbumEntry) {
				$item['name'] = (string)$entry->getTitle();
				$item['id'] = (string)$entry->getGphotoId();
				$item['count'] = (string)$entry->getGphotoNumphotos();
				if (intval($item['count']) >= 1000) {
					continue;
				}
				$albums[] = $item;
			}
		}
		$result['success'] = true;
		$result['albums'] = $albums;
	} catch (Zend_Gdata_App_Exception $e) {
		$result['error'] = $e->message();
	}
	return json_encode($result);
}

function SYNOPHOTO_PICASA_GetPhotoMimeType($path)
{
	$SYNOPHOTO_PICASA_MIME = array(
		'jpg' => 'image/jpeg',
		'jpeg' => 'image/jpeg',
		'jpe' => 'image/jpeg',
		'bmp' => 'image/bmp',
		'gif' => 'image/gif',
		'png' => 'image/png'
	);

	$path = strtolower($path);
	$path_parts = pathinfo($path);
	$extension = $path_parts['extension'];
	if (array_key_exists($extension, $SYNOPHOTO_PICASA_MIME)) {
		return $SYNOPHOTO_PICASA_MIME[$extension];
	}
	return null;
}

?>
