<?php
/*!
 * album list operation
 */
class csSYNOSmartAlbum {
	private $_dbh;
	private $escapeStr = '';
	private static $instance = null;
	private static $video_convert_type_condition;

	function __construct()
	{
		$this->_dbh = csSYNOPhotoDB::GetDBInstance()->_dbh;
		$this->escapeStr = csSYNOPhotoDB::GetDBInstance()->escapeStr;
	}

	static function GetSmartAlbumInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self;
		}
		return self::$instance;
	}

	/**
	 *  WebAPI interface
	 */
	function ListSmartAlbum()
	{
		$returnJson = array(
			"success" => false
		);

		$data = array(
			"total" => 0,
			"albumList" => array()
		);

		$isAdmin = isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']);

		//convert smart album file into array
		if (!$smartAlbumList = csSYNOSmartAlbum::ReadSmartAlbumFile()) {
			$returnJson["data"] = $data;
			$returnJson["success"] = true;
			return json_encode($returnJson);
		}

		if (!is_array($smartAlbumList["smart_albums"])) {
			$returnJson["data"] = $data;
			$returnJson["success"] = true;
			return json_encode($returnJson);
		}

		foreach ($smartAlbumList["smart_albums"] as $key => $album) {

			if (!$isAdmin && 0 >= csSYNOSmartAlbum::GetItemCountInSmartAlbum($album)) {
				continue;
			}

			if (!$album['show_photo'] && !$album['show_video']) {
				$album['show_photo'] = true;
				$album['show_video'] = true;
			}

			$data["albumList"][] = array(
				"name" => (string)$key,
				//"desc" => $album["desc"],
				"desc" => "",
				"cover" => csSYNOSmartAlbum::GetCoverOfSmartAlbum($album)
			);
			$data["total"]++;
		}

		$returnJson["data"] = $data;
		$returnJson["success"] = true;

		return json_encode($returnJson);
	}

	/**
	 *  WebAPI interface
	 */
	function ListItem($data)
	{
		$returnJson = array(
			"success" => false
		);

		if (!$json = json_decode($data, true)) {
			csSYNOPhotoMisc::Synophoto_Mobile_Log('not valid json format');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		if (!isset($json['name']) || 0 >= strlen($json['name'])) {
			csSYNOPhotoMisc::Synophoto_Mobile_Log('some field is not set');
			$returnJson["error"]["code"] = 102;
			$returnJson["error"]["message"] = 'Bad Parameter';
			return json_encode($returnJson);
		}

		$smartAlbumName = $json['name'];
		$offset = (int)$json['offset'] > 0 ? (int)$json['offset']: 0;
		$limit = (int)$json['limit'] > 0 ? (int)$json['limit']: 0;

		$data = array(
			"total" => 0,
			"itemList" => array()
		);

		//convert smart album file into array
		if (!$smartAlbumList = csSYNOSmartAlbum::ReadSmartAlbumFile()) {
			$returnJson["data"] = $data;
			$returnJson["success"] = true;
			return json_encode($returnJson);
		}

		if (!is_array($smartAlbumList["smart_albums"])) {
			$returnJson["data"] = $data;
			$returnJson["success"] = true;
			return json_encode($returnJson);
		}

		$album = $smartAlbumList["smart_albums"][$smartAlbumName];
		if (empty($album)) {
			$returnJson["data"] = $data;
			$returnJson["success"] = true;
			return json_encode($returnJson);
		}

		if (!$album['show_photo'] && !$album['show_video']) {
			$album['show_photo'] = true;
			$album['show_video'] = true;
		}

		$data["total"] = csSYNOSmartAlbum::GetItemCountInSmartAlbum($album);
		$data["itemList"] = csSYNOSmartAlbum::GetItemsInSmartAlbum($album, $offset, $limit);

		$returnJson["data"] = $data;
		$returnJson["success"] = true;

		return json_encode($returnJson);
	}

	private function ReadSmartAlbumFile()
	{
		$smartAlbumFile = SYNOPHOTO_SERVICE_DIR."/".SYNOPHOTO_EADIR.'/smart_album.json';

		//test whether smart album file config exist or not
		if (!@file_exists($smartAlbumFile)) {
			return null;
		}

		//get contents from smart album config file
		if (!$smartAlbumJsonStr = @file_get_contents($smartAlbumFile)) {
			return null;
		}

		//parse contents
		if (!$smartAlbumList = json_decode($smartAlbumJsonStr, true)) {
			return null;
		}

		return $smartAlbumList;
	}

	private function GetItemsInSmartAlbum($album, $offset = 0, $limit = 0)
	{
		$returnList = array();

		$offset = (int)$offset > 0 ? (int)$offset : 0;
		$limit = (int)$limit > 0 ? (int)$limit : 0;

		if ($album['show_photo']) {
			$photoSqlCond = csSYNOSmartAlbum::GetSmartAlbumToSqlCondition($album, 'photo');
		}
		if ($album['show_video']) {
			$videoSqlCond = csSYNOSmartAlbum::GetSmartAlbumToSqlCondition($album, 'video');
		}

		$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
		if (!count($albumCondition['albumCond'])) {
			goto END;
		}
		$albumCondition['albumCond'] = implode(' OR ', $albumCondition['albumCond']);

		//query photos
		if ($photoSqlCond['cond']) {
			$query =
				"SELECT * FROM photo_image WHERE {$photoSqlCond['cond']} AND ({$albumCondition['albumCond']})".
				($limit > 0 ? " LIMIT $limit" : "").($offset > 0 ? " OFFSET $offset;" : ";");

			$dbResult = csSYNOSmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
			$dbResult->execute(array_merge($photoSqlCond['param'], $albumCondition['sqlParam']));

			while (false !== ($row = $dbResult->fetch())) {
				$item = array(
					'type' => 'photo',
					'id' => $row['id'],
					'path' => SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'],
					'name' => $row['name'],
					'title' => $row['title'],
					'description' => $row['description']
				);

				$returnList[] = $item;
			}
		}

		//query videos
		if ($videoSqlCond['cond']) {
			$query =
				"SELECT id, path, title, description FROM (SELECT description, video.* FROM video LEFT JOIN video_desc ON video.path = video_desc.path) video ".
				"WHERE {$videoSqlCond['cond']} AND ({$albumCondition['albumCond']})".($limit > 0 ? " LIMIT $limit" : "").($offset > 0 ? " OFFSET $offset;" : ";");

			$dbResult = csSYNOSmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
			$dbResult->execute(array_merge($videoSqlCond['param'], $albumCondition['sqlParam']));

			while (false !== ($row = $dbResult->fetch())) {
				$item = array(
					'type' => 'video',
					'id' => $row['id'],
					'path' => SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'],
					'title' => $row['title'],
					'description' => $row['description']
				);

				$returnList[] = $item;
			}
		}

	END:
		return $returnList;
	}

	private function GetItemCountInSmartAlbum($album)
	{
		$returnCount = 0;

		if ($album['show_photo']) {
			$photoSqlCond = csSYNOSmartAlbum::GetSmartAlbumToSqlCondition($album, 'photo');
		}
		if ($album['show_video']) {
			$videoSqlCond = csSYNOSmartAlbum::GetSmartAlbumToSqlCondition($album, 'video');
		}

		$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
		if (!count($albumCondition['albumCond'])) {
			goto END;
		}
		$albumCondition['albumCond'] = implode(' OR ', $albumCondition['albumCond']);

		if ($photoSqlCond['cond']) {
			$query = "SELECT COUNT(*) FROM photo_image WHERE {$photoSqlCond['cond']} AND ({$albumCondition['albumCond']});";

			$dbResult = csSYNOSmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
			$dbResult->execute(array_merge($photoSqlCond['param'], $albumCondition['sqlParam']));

			if (false !== ($row = $dbResult->fetch())) {
				$returnCount += (int)$row[0];
			}
		}

		if ($videoSqlCond['cond']) {
			$query = "SELECT COUNT(*) FROM (SELECT description, video.* FROM video LEFT JOIN video_desc ON video.path = video_desc.path) video ".
				"WHERE {$videoSqlCond['cond']} AND ({$albumCondition['albumCond']});";

			$dbResult = csSYNOSmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
			$dbResult->execute(array_merge($videoSqlCond['param'], $albumCondition['sqlParam']));

			if (false !== ($row = $dbResult->fetch())) {
				$returnCount += (int)$row[0];
			}
		}

	END:
		return $returnCount;
	}

	private function GetCoverOfSmartAlbum($album)
	{
		$returnCover = '';

		$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
		if (!count($albumCondition['albumCond'])) {
			goto END;
		}
		$albumCondition['albumCond'] = implode(' OR ', $albumCondition['albumCond']);

		if ($album['show_photo']) {
			$photoSqlCond = csSYNOSmartAlbum::GetSmartAlbumToSqlCondition($album, 'photo');

			if ($photoSqlCond['cond']) {
				$query = "SELECT path, create_time FROM photo_image WHERE {$photoSqlCond['cond']} AND ({$albumCondition['albumCond']}) ORDER BY create_time DESC LIMIT 1;";

				$dbResult = csSYNOSmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
				$dbResult->execute(array_merge($photoSqlCond['param'], $albumCondition['sqlParam']));

				if (false !== ($row = $dbResult->fetch())) {
					$returnCover = array(
						'type' => 'photo',
						'path' => SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']
					);
					$photoCTime = $row['create_time'];
				}
			}
		}

		if ($album['show_video']) {
			$videoSqlCond = csSYNOSmartAlbum::GetSmartAlbumToSqlCondition($album, 'video');

			if ($videoSqlCond['cond']) {
				$query = "SELECT path, date FROM (SELECT description, video.* FROM video LEFT JOIN video_desc ON video.path = video_desc.path) video ".
					"WHERE {$videoSqlCond['cond']} AND ({$albumCondition['albumCond']}) ORDER BY date DESC LIMIT 1;";

				$dbResult = csSYNOSmartAlbum::GetSmartAlbumInstance()->_dbh->prepare($query);
				$dbResult->execute(array_merge($videoSqlCond['param'], $albumCondition['sqlParam']));

				if (false !== ($row = $dbResult->fetch())) {
					if (!photoCTime || ($row['date'] > $photoCTime)) {
						$returnCover = array(
							'type' => 'video',
							'path' => SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path']
						);
					}
				}
			}
		}

	END:
		return $returnCover;
	}

	private function GetSmartAlbumToSqlCondition($album, $type)
	{
		$returnCond = array(
			'cond' => array(),
			'param' => array()
		);

		if (!is_array($album["rule_sets"])) {
			goto END;
		}

		foreach ($album["rule_sets"] as $ruleSetKey => $ruleSet) {
			if (!$ruleCond = csSYNOSmartAlbum::GetRuleSetToSqlCondition($ruleSet, $type)) {
				continue;
			}

			$returnCond['cond'][] = $ruleCond['cond'];
			$returnCond['param'] = array_merge($returnCond['param'], $ruleCond['param']);
		}

		$returnCond['cond'] = "(".implode(") AND (", $returnCond['cond']).")";

	END:
		return $returnCond;
	}

	private function GetRuleSetToSqlCondition($ruleSet, $type)
	{
		$returnCond = array(
			'cond' => array(),
			'param' => array()
		);

		if (!is_array($ruleSet) || empty($ruleSet)) {
			goto END;
		}

		foreach ($ruleSet as $key => $rule) {
			if (!$ruleCond = csSYNOSmartAlbum::GetRuleToSqlCondition($rule, $type)) {
				continue;
			}

			$returnCond['cond'][] = $ruleCond['cond'];
			$returnCond['param'] = array_merge($returnCond['param'], $ruleCond['param']);
		}

		$returnCond['cond'] = "(".implode(") AND (", $returnCond['cond']).")";

	END:
		return $returnCond;
	}

	private function GetRuleToSqlCondition($rule, $type)
	{
		$returnCond = array(
			'cond' => '',
			'param' => array()
		);

		if (('photo' !== $type && 'video' !== $type) ||
			!isset($rule['field']) || '' == $rule['field'] ||
			!isset($rule['operator']) || '' == $rule['operator'] ||
			!isset($rule['value'])  || '' == $rule['value']) {
			goto END;
		}

		$field = $rule['field'];
		$operator = $rule['operator'];
		$value = $rule['value'];

		if ('keyword' === $field) {
			$returnCond = csSYNOPhotoDB::GetKeywordCondition($value, $operator,
														   'photo' === $type ? array('name', 'title', 'description', 'label_name') : array('title', 'description', 'label_name'));
		} else if ('date' === $field) {
			if ('taken' === $operator) {
				$returnCond['cond'] = csSYNOPhotoDB::GetDateCondition($value, 'photo' === $type ? 'timetaken' : 'mdate');
			} else {
				$returnCond['cond'] = csSYNOPhotoDB::GetDateCondition($value, 'photo' === $type ? 'create_time' : 'date');
			}
		} else if ('people' === $field || 'geo' === $field || 'desc' === $field) {
			if ('people' !== $field || 'video' !== $type) {
				$returnCond = csSYNOPhotoDB::GetTagCondition($value, $operator, $field, $type);
			}
		}

	END:
		return $returnCond;
	}
}
?>
