<?php
require_once('label_util.php');
/*!
 * browsing operation
 */
class csSYNOPhotoBrowse {
	/*! reference to a self instance */
	private static $instance = null;

	/*!
	 * Get a exist instance
	 */
	static function GetBrowseInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	/*!
	 * Get ordered album list by configuration
	 *
	 * \return sorted album list array
	 */
	private function GetAlbumListByOrderConfig()
	{
		$list = json_decode(csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'order_list'), true);
		if (NULL == $list) {
			$list = array();
		}

		$result = array();
		$albums = array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']);

		/* make sure data type is string */
		foreach ($list as &$name) {
			settype($name, 'string');
		}
		foreach ($albums as &$name) {
			settype($name, 'string');
		}
		unset($name);

		foreach ($list as $item) {
			if (in_array($item, $albums, true)) {
				array_push($result, $item);
			}
		}
		foreach ($albums as $item) {
			if (!in_array($item, $list, true)) {
				array_push($result, $item);
			}
		}
		return $result;
	}
	/*!
	 * Get ordered uploadable album list by configuration
	 *
	 * \return sorted uploadable album list array
	 */
	private function GetUploadableAlbumListByOrderConfig()
	{
		$list = json_decode(csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'order_list'), true);
		if (NULL == $list) {
			$list = array();
		}
		$result = array();
		$albums = array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['uploadable_album']);

		/* make sure data type is string */
		foreach ($list as &$name) {
			settype($name, 'string');
		}
		foreach ($albums as &$name) {
			settype($name, 'string');
		}
		unset($name);

		foreach ($list as $item) {
			if (in_array($item, $albums, true)) {
				array_push($result, $item);
			}
		}
		foreach ($albums as $item) {
			if (!in_array($item, $list, true)) {
				array_push($result, $item);
			}
		}
		return $result;
	}

	private function SetSortTypeOrder($albumName, $sortType, $sortOrder)
	{
		switch ($sortType) {
		case 'name':
			$type = '0';
			break;
		case 'time':
			$type = '1';
			break;
		case 'create':
			$type = '2';
			break;
		default:
			$type = '-1';
			break;
		}
		switch ($sortOrder) {
		case 'desc':
			$order = '1';
			break;
		default:
			$order = '0';
			break;
		}
		if ($type == '-1') {
			$sortMethod = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumThumbSortType($albumName);
			if ($sortMethod === '' || $sortMethod['type'] == '-1') {
				csSYNOPhotoDB::GetDBInstance()->SetSessionSortMethod(csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'thumb_sort_type'),
																	 csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'thumb_sort_order'));
			} else {
				csSYNOPhotoDB::GetDBInstance()->SetSessionSortMethod($sortMethod['type'], $sortMethod['order']);
			}
		} else {
			csSYNOPhotoDB::GetDBInstance()->SetSessionSortMethod($type, $order);
		}
	}

	function GetItemListByPreference($albumName, $photoList, $videoList)
	{
		$sort = csSYNOPhotoAlbum::GetAlbumThumbSortType($albumName);
		$list = array();
		if (!empty($sort['list'])) {
			$list = $sort['list'];
		}

		$result = array();
		foreach($list as $item){
			if (in_array($item, $photoList, true) || in_array($item, $videoList, true)) {
				array_push($result, $item);
			}
		}

		foreach ($photoList as $item) {
			if (!in_array($item, $list, true)) {
				array_push($result, $item);
			}
		}

		foreach ($videoList as $item) {
			if (!in_array($item, $list, true)) {
				array_push($result, $item);
			}
		}
		return $result;
	}
	/*!
	 * Get content name list for a album
	 *
	 * \param $albumName album name
	 * \return array with NAME list for dir & photo
	 * \return array with PATH list for video
	 */
	function GetList($albumName)
	{
		$dirList = array();
		$photoList = array();
		$videoList = array();
		$itemList = array();
		$sortPhotoViedoTogether = false;
		if ('/' == $albumName) {
			$OrderType = csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'album_order_type');
			if ('1' != $OrderType) {
				$OrderTypeDesc = csSYNOPhotoDB::GetDBInstance()->GetConfig('album', 'album_order_type_is_desc');
				if ('1' == $OrderTypeDesc) {
					$albumList = array_reverse(array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']));
				} else {
					$albumList = array_keys($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']);
				}
			} else {
				$albumList = $this->GetAlbumListByOrderConfig();
			}
            if (false !== ($keyIndex = array_search('/', $albumList))) {
                unset($albumList[$keyIndex]);
            }
			$dirList = $albumList;
		} else {
			$photoList = csSYNOPhotoDB::GetDBInstance()->GetAlbumPhotoList($albumName);
			$videoList = csSYNOPhotoDB::GetDBInstance()->GetAlbumVideoList($albumName);
			$unsortedDirList = csSYNOPhotoMisc::GetSubDir($albumName, true);

			$videoNameList = array();
			$length = count($videoList);
			$i = 0;
			while($i < $length) {
				$videoNameList[] = basename($videoList[$i]);
				$i++;
			}
			if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_type'] == 'name') {
				$sortPhotoViedoTogether = true;
				$itemList = array_merge($photoList, $videoNameList);
				if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] == 'desc') {
					$dirList = array_reverse(array_keys($unsortedDirList));
					arsort($itemList);
				} else {
					$dirList = array_keys($unsortedDirList);
					asort($itemList);
				}
			} else {
				if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_order'] == 'desc') {
					arsort($unsortedDirList);
				} else {
					asort($unsortedDirList);
				}
				$dirList = array_keys($unsortedDirList);
			}

			if ($_SESSION[SYNOPHOTO_ADMIN_USER]['sort_by_preference']) {
				$sortPhotoViedoTogether = true;
				$itemList = $this->GetItemListByPreference($albumName, $photoList, $videoNameList);
			}

			if ($sortPhotoViedoTogether) {
				$list = array();
				foreach($dirList as $name) {
					$list[$name] = SYNOPHOTO_ITEM_TYPE_ALBUM;
				}
				foreach($itemList as $name){
					if (csSYNOPhotoMisc::IsPhotoFile($name)) {
						$list[$name] = SYNOPHOTO_ITEM_TYPE_PHOTO;
					} else {
						$name = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$albumName.'/'.$name;
						$list[$name] = SYNOPHOTO_ITEM_TYPE_VIDEO;
					}
				}
				return $list;
			}
		}

		$list = array();
		foreach($dirList as $name) {
			$list[$name] = SYNOPHOTO_ITEM_TYPE_ALBUM;
		}
		foreach($photoList as $name) {
			$list[$name] = SYNOPHOTO_ITEM_TYPE_PHOTO;
		}
		foreach($videoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		}
		return $list;
	}

	/*!
	 * get search token by ui search option
	 *
	 * \param $condition conditions for search
	 * \return search token
	 */
	function OptionToSearchToken($condition)
	{
		$photoCond = array();
		$MatchPattern = array('option_name' => 'name', 'option_title' => 'title', 'option_desc' => 'description');
		foreach ($MatchPattern as $key => $field) {
			if (isSet($condition[$key])) {
				$photoCond[$field] = $condition[$key];
			}
		}
		return csSYNOPhotoDB::GetDBInstance()->GetSearchToken($photoCond);
	}
	/*!
	 * Get search result list
	 *
	 * \param $condition conditions for search
	 * \return array with PATH list
	 */
	function GetSearchList($condition)
	{
		$albumCond = array();
		$MatchPattern = array('option_name' => 'sharename', 'option_title' => 'title', 'option_desc' => 'description');
		foreach ($MatchPattern as $key => $field) {
			if (isSet($condition[$key])) {
				$albumCond[$field] = array('op' => 'MIDDLE', 'value' => $condition[$key]);
			}
		}

		$searchToken = $this->OptionToSearchToken($condition);
		$photoList = $_SESSION[SYNOPHOTO_ADMIN_USER]['search_result'][$searchToken]['result'];
		$videoList = $_SESSION[SYNOPHOTO_ADMIN_USER]['search_result_video'][$searchToken]['result'];
		$dirList = csSYNOPhotoDB::GetDBInstance()->GetAlbums($albumCond, true);

		$list = array();
		foreach($dirList as $item) {
			$list[$item['sharename']] = SYNOPHOTO_ITEM_TYPE_ALBUM;
		}
		foreach($photoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_PHOTO;
		}
		foreach($videoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		}

		return $list;
	}
	/*!
	 * Get most recent item's path list
	 *
	 * \param $source source type of most recent item, 'photo' or 'video'
	 * \return array with PATH list
	 */
	function GetMostRecentList($source)
	{
		$photoList = array();
		$videoList = array();

		if ('photo' == $source) {
			$photoList = csSYNOPhotoDB::GetDBInstance()->GetMostRecentPhotoList();
		} else if ('video' == $source) {
			$videoList = csSYNOPhotoDB::GetDBInstance()->GetMostRecentVideoList();
		}


		$list = array();
		foreach($photoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_PHOTO;
		}
		foreach($videoList as $path) {
			$list[$path] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		}

		return $list;
	}
	/*!
	 * Get album thumb
	 *
	 * \param $albumName album name
	 * \return array with album thumb info
	 */
	private function GetAlbumThumb($albumName)
	{
		$item = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumInfo($albumName);
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;
		$covers = csSYNOPhotoAlbum::GetAlbumInstance()->GetAlbumCover($albumName);
		$item['cover'] = $covers['cover'];
		$item['bigCover'] = $covers['bigCover'];
		return $item;
	}
	/*!
	 * Get photo thumb
	 *
	 * \param $albumName album name
	 * \return array with photo thumb info
	 */
	private function GetPhotoThumb($photoPath)
	{
		$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($photoPath);
		$item = csSYNOPhotoThumb::GetThumbInstance()->GetThumbInfo($photoInfo);
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_PHOTO;
		return $item;
	}
		/*!
	 * Get video thumb
	 *
	 * \param $albumName album name
	 * \return array with photo thumb info
	 */
	private function GetVideoThumb($videoPath)
	{
		$videoInfo = csSYNOPhotoDB::GetDBInstance()->GetVideoInfo($videoPath);
		$item = csSYNOPhotoThumb::GetThumbInstance()->GetVideoThumbInfo($videoInfo);
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_VIDEO;
		return $item;
	}
	/*!
	 * Get album list by offset and length
	 *
	 * \param $offset # of albums to skip
	 * \param $length # of albums to list
	 * \param $isMostRecent if true plus most recent albums
	 * \return array with album list info
	 *	- albums: album list info
	 *		- array returned by csSYNOPhotoAlbum::GetAlbumInfo()
	 *		- cover: album cover info
	 *	- albumCount: # of the rest albums
	 */
	function GetAlbumList($offset, $length, $isMostRecent)
	{
		$albumList = array();
		$list = $this->GetList('/');

		if ($isMostRecent) {
			if (0 == $offset) {
				$mostRecentPhotos = $this->GetMostRecentAlbumThumb('photo');
				if ($mostRecentPhotos) {
					$albumList[] = $mostRecentPhotos;
				}
				$mostRecentVideos = $this->GetMostRecentAlbumThumb('video');
				if ($mostRecentVideos) {
					$albumList[] = $mostRecentVideos;
				}
			}
		}
		$seekOffset = 0;
		foreach($list as $name => $itemType) {
			if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
				if ($itemType == SYNOPHOTO_ITEM_TYPE_ALBUM) {
					$albumList[] = $this->GetAlbumThumb($name);
				}
			}
			$seekOffset++;
		}

		$result = array();
		$result['albums'] = $albumList;
		$result['albumCount'] = count($list);
		return $result;
	}

	/*!
	 * Get most recent album thumb
	 *
	 * \param $source most recent sorce. Photo or video.
	 * \return array with most recent album thumb info
	 *
	 */
	function GetMostRecentAlbumThumb($source)
	{
		$item = csSYNOPhotoAlbum::GetAlbumInstance()->GetMostRecentAlbumInfo($source);
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;

		$mostRecentList = $this->GetMostRecentList($source);

		$item['photos'] = count($mostRecentList);

		if (0 < $item['photos']) {
			// Set the first photo of most recent album as cover.
			$keys = array_keys($mostRecentList);
			$name = $keys[0];
			$itemType = $mostRecentList[$name];
			if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
				$thumb = $this->GetPhotoThumb($name);
			} else {
				$thumb = $this->GetVideoThumb($name);
			}

			$item['cover'] = $thumb['cover'];
			$item['bigCover'] = $thumb['bigCover'];
			return $item;
		} else {
			return null;
		}
	}

	/*!
	 * Get first level uploadable album list
	 *
	 * \return array with first level uploadable album list info
	 *	- albums: first layer uploadable album list info
	 *		- array returned by csSYNOPhotoAlbum::GetAlbumInfo()
	 *		- cover: album cover info
	 */
	function GetUploadableAlbumList()
	{
		$albumList = array();
		$subAlbumList = array();

		if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$isAdmin = true;
		} else {
			$isAdmin = false;
		}

		if ($isAdmin) {
			$rootList = $this->GetAlbumListByOrderConfig();
		} else {
			$rootList = $this->GetUploadableAlbumListByOrderConfig();
		}

		foreach ($rootList as $name) {
			$split = explode("/", $name);
			if (1 < count($split)) {
			/* Skip second level albums */
				continue;
			}
			$item = $this->GetAlbumThumb($name);
			$albumList[] = $item;
		}
		$result = array();
		$result['items'] = $albumList;
		return $result;
	}
	/*!
	 * Get thumb list by offset and length
	 *
	 * \param $albumName album name
	 * \param $offset # of photos to skip
	 * \param $length # of photos to list
	 * \return array with thumb list info
	 *	- items: array merged from GetDirThumbs() and GetPicThumbs()
	 *	- subAlbumCount: # of the subAlbums
	 *	- itemCount: # of the thumbs
	 */
	function GetThumbList($albumName, $offset, $length, $sort_type, $sort_order)
	{
		csSYNOPhotoDB::GetDBInstance()->PrepareAlbumPhotos($albumName, $offset, $length);
		$this->SetSortTypeOrder($albumName, $sort_type, $sort_order);
		$thumbList = array();
		$list = $this->GetList($albumName);
		$listCount = array_count_values($list);
		$albumCount = 0;
		if (isSet($listCount[SYNOPHOTO_ITEM_TYPE_ALBUM])) {
			$albumCount = $listCount[SYNOPHOTO_ITEM_TYPE_ALBUM];
		}

		$photoCount = 0;
		if (isSet($listCount[SYNOPHOTO_ITEM_TYPE_PHOTO])) {
			$photoCount = $listCount[SYNOPHOTO_ITEM_TYPE_PHOTO];
		}

		if ($offset + $length > $albumCount + $photoCount) {
			// need to query video data
			$videoOffset = 0;
			if ($offset > ($albumCount + $photoCount)) {
				$videoOffset = $offset - ($albumCount + $photoCount);
			}
			csSYNOPhotoDB::GetDBInstance()->PrepareAlbumVideos($albumName, $videoOffset, $length);
		}


		$seekOffset = 0;
		foreach($list as $name => $itemType) {
			if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
				if ($itemType == SYNOPHOTO_ITEM_TYPE_ALBUM) {
					$thumbList[] = $this->GetAlbumThumb($name);
				} else if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
					$photoPath = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$name}";
					$thumbList[] = $this->GetPhotoThumb($photoPath);
				} else {
					//$name will be path in video type condition
					$thumbList[] = $this->GetVideoThumb($name);
				}
			}
			$seekOffset++;
		}

		$result = array();
		$result['items'] = $thumbList;
		$result['itemCount'] = count($list);
		$result['subAlbumCount'] = $albumCount;
		$result['videoCount'] = $result['itemCount'] - $result['subAlbumCount'] - $photoCount;
		$result['totalVideoCount'] = csSYNOPhotoDB::GetDBInstance()->GetAlbumTotalVideoCount($albumName);
		return $result;
	}
	/*!
	 * Get GPS thumb list by offset and length
	 *
	 * \param $albumName album name
	 * \param $offset # of photos to skip
	 * \param $length # of photos to list
	 * \return array with gps thumb info list
	 *	- items: array with thumb info that included GPS info, photos or videos.
	 *	- itemCount: # of the photos
	 *	- videoCount: # of the videos
	 */
	function GetGPSThumbList($albumName, $offset, $length)
	{
		csSYNOPhotoDB::GetDBInstance()->PrepareAlbumPhotos($albumName, $offset, $length);

		$thumbList = array();
		$list = $this->GetList($albumName);
		$listCount = array_count_values($list);

		$photoCount = 0;
		if (isSet($listCount[SYNOPHOTO_ITEM_TYPE_PHOTO])) {
			$photoCount = $listCount[SYNOPHOTO_ITEM_TYPE_PHOTO];
		}

		if ($offset + $length > $photoCount) {
			// need to query video data
			$videoOffset = 0;
			if ($offset > ($photoCount)) {
				$videoOffset = $offset - ($photoCount);
			}
			csSYNOPhotoDB::GetDBInstance()->PrepareAlbumVideos($albumName, $videoOffset, $length);
		}

		foreach($list as $name => $itemType) {
			if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
				if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
					$thumbList[] = $this->GetPhotoThumb(SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$name}");
				} else {
					//$name will be path in video type condition
					$thumbList[] = $this->GetVideoThumb($name);
				}
			}
		}

		$result = array();
		$result['items'] = $thumbList; //Thumb list that carries gps info
		$result['itemCount'] = count($list); //All items in this album includes subalbum, photo and ideo
		$result['subAlbumCount'] = 0;
		$result['videoCount'] = $result['itemCount'] - $photoCount;
		return $result;
	}
	/*!
	 * Get thumb list from search result by offset and length
	 *
	 * \param $condition conditions for search
	 * \param $offset # of photos to skip
	 * \param $length # of photos to list
	 * \return array with thumb list info
	 *	- token: the cache token returned by csSYNOPhotoDB::GetSearchToken()
	 *	- items: result thumb list
	 *	- subAlbumCount: # of the sub albums
	 *	- itemCount: # of total items
	 */
	function GetSearchThumbList($condition, $offset, $length)
	{
		$searchToken = $this->OptionToSearchToken($condition);
		csSYNOPhotoDB::GetDBInstance()->PrepareSearchPhotos($searchToken, $offset, $length);

		$thumbList = array();
		$list = $this->GetSearchList($condition);

		$listCount = array_count_values($list);
		$albumCount = 0;
		if (isSet($listCount[SYNOPHOTO_ITEM_TYPE_ALBUM])) {
			$albumCount = $listCount[SYNOPHOTO_ITEM_TYPE_ALBUM];
		}

		$photoCount = 0;
		if (isSet($listCount[SYNOPHOTO_ITEM_TYPE_PHOTO])) {
			$photoCount = $listCount[SYNOPHOTO_ITEM_TYPE_PHOTO];
		}

		if ($offset + $length > $albumCount + $photoCount) {
			// need to query video data
			$videoOffset = 0;
			if ($offset > ($albumCount + $photoCount)) {
				$videoOffset = $offset - ($albumCount + $photoCount);
			}
			csSYNOPhotoDB::GetDBInstance()->PrepareSearchVideos($searchToken, $videoOffset, $length);
		}

		$seekOffset = 0;
		foreach($list as $name => $itemType) {
			if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
				if ($itemType == SYNOPHOTO_ITEM_TYPE_ALBUM) {
					$thumbList[] = $this->GetAlbumThumb($name);

				} else if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
					$thumbList[] = $this->GetPhotoThumb($name);
				} else {
					$thumbList[] = $this->GetVideoThumb($name);
				}
			}
			$seekOffset++;
		}

		$result = array();
		$result['token'] = $searchToken;
		$result['items'] = $thumbList;
		$result['itemCount'] = count($list);
		$result['subAlbumCount'] = $albumCount;
		$result['videoCount'] = $result['itemCount'] - $result['subAlbumCount'] - $photoCount;
		return $result;
	}
	/*!
	 * Get thumb list from most recent items by offset and length
	 *
	 * \param $source most recent items' source type, 'photo' or 'video'
	 * \param $offset # of photos to skip
	 * \param $length # of photos to list
	 * \return array with thumb list info
	 *	- items: result thumb list
	 *	- subAlbumCount: # of the sub albums
	 *	- itemCount: # of total items
	 */
	function GetMostRecentThumbList($source, $offset, $length)
	{
		//unset dbcacher, sothat photo/ video data will skip dbcached and be queried from DB directly
		// (dbcacher won't have most recent photo/ video data)
		if ('photo' == $source) {
			$_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_SESSION_ID] = array();

		} else if ('video' == $source) {
			$_SESSION[SYNOPHOTO_ADMIN_USER][DBCACHER_VIDEO_SESSION_ID] = array();

		}

		$thumbList = array();
		$list = $this->GetMostRecentList($source);

		$seekOffset = 0;
		foreach($list as $name => $itemType) {
			if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
				if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
					$thumbList[] = $this->GetPhotoThumb($name);
				} else {
					$thumbList[] = $this->GetVideoThumb($name);
				}
			}
			$seekOffset++;
		}

		$result = array();
		$result['items'] = $thumbList;
		$result['itemCount'] = count($list);
		$result['subAlbumCount'] = 0;
		$videoCount = 0;

		if ('video' == $source) {
			$videoCount = $result['itemCount'];
		}
		$result['videoCount'] = $videoCount;

		return $result;
	}

	private function GetLabelAlbumList($categoty, $tags)
	{
		$tagNameList = array();
		foreach ($tags as $tag) {
			$tagNameList[$tag['name']] = $tag['id'];
		}
		uksort($tagNameList, 'strnatcasecmp');
		return $tagNameList;
	}

	private function GetLabelAlbumThumbFirst($category, $tags)
	{
		$labelTag = $tags[$category];
		if (0 >= count($labelTag)) {
			return null;
		}
		$item = csSYNOPhotoAlbum::GetAlbumInstance()->GetLabelAlbumInfoFirst($category);
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;

		$tagNameList = $this->GetLabelAlbumList($category, $labelTag);

		$itemList = array();
		foreach ($tagNameList as $id) {
			$itemList = csSYNOPhotoDB::GetDBInstance()->GetItemListByLabel($id, $category);
			if (count($itemList) > 0) {
				break;
			}
		}

		if (empty($itemList)) {
			return null;
		}

		$keys = array_keys($itemList);
		$name = $keys[0];
		$itemType = $itemList[$name];
		if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
			$thumb = $this->GetPhotoThumb($name);
		} else {
			$thumb = $this->GetVideoThumb($name);
		}
		$item['cover'] = $thumb['cover'];
		$item['bigCover'] = $thumb['bigCover'];
		return $item;
	}

	private function GetLabelVirtualAlbumList()
	{
		$albumList = array();

		$hasPersonAlbum = ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'person_label_album'));
		$hasPlaceAlbum = ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'place_label_album'));
		$hasGeneralAlbum = ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'general_label_album'));

		if ($hasPersonAlbum || $hasPlaceAlbum || $hasGeneralAlbum) {
			$tags = SYNOPHOTO_LABEL_UTIL_GetAllLabel(true);
		}

		if ($hasPersonAlbum) {
			$album = $this->GetLabelAlbumThumbFirst(IDX_LABEL_ALBUM_PERSON, $tags);
			if ($album) {
				$albumList[] = $album;
			}
		}
		if ($hasPlaceAlbum) {
			$album = $this->GetLabelAlbumThumbFirst(IDX_LABEL_ALBUM_PLACE, $tags);
			if ($album) {
				$albumList[] = $album;
			}
		}
		if ($hasGeneralAlbum) {
			$album = $this->GetLabelAlbumThumbFirst(IDX_LABEL_ALBUM_GENERAL, $tags);
			if ($album) {
				$albumList[] = $album;
			}
		}
		return $albumList;
	}

	private function GetLabelAlbumThumb($category, $tagName, $id)
	{
		$item = csSYNOPhotoAlbum::GetAlbumInstance()->GetLabelAlbumInfo($category, $tagName, $id);
		$item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;
		$covers = csSYNOPhotoAlbum::GetAlbumInstance()->GetLabelAlbumCover($id);
		if (null == $covers && -1 == $id) {
			return false;
		}
		$item['bigCover'] = $covers['bigCover'];
		$item['cover'] = $covers['cover'];

		return $item;
	}

	function GetLabelVirtualAlbumItemList($category, $labelId, $page = 1, $length = 0, $isDisplayAll = false)
	{
		$dirList = array();
		$list = array();
		$thumbList = array();
		$photoCount = 0;
		$offset = ($isDisplayAll) ? 0 : ($page - 1) * $length;
		$seekOffset = 0;

		if (null === $labelId) {
			$tags = SYNOPHOTO_LABEL_UTIL_GetAllLabel(true);
			$dirList = $this->GetLabelAlbumList($category, $tags[$category]);
			$list = $dirList;
			$length = ($isDisplayAll) ? count($list) : $length;
			if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && $category == 0 && $offset == 0) {
				$toBeConfirmAlbum = $this->GetLabelAlbumThumb($category, 'photo_str_non_confirm_album', -1);
				if ($toBeConfirmAlbum) {
					$thumbList[] = $toBeConfirmAlbum;
				}
			}
			foreach($list as $name => $tagId) {
				if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
					$thumbList[] = $this->GetLabelAlbumThumb($category, $name, $tagId);
				}
				$seekOffset++;
			}
		} else {
			if (-1 == $labelId) {
				$list = csSYNOPhotoDB::GetDBInstance()->GetNonConfirmItemList();
			} else {
				$list = csSYNOPhotoDB::GetDBInstance()->GetItemListByLabel($labelId, $category);
			}
			$length = ($isDisplayAll) ? count($list) : $length;
			foreach($list as $path => $itemType) {
				if ($seekOffset >= $offset && $seekOffset < $offset + $length) {
					if ($itemType == SYNOPHOTO_ITEM_TYPE_PHOTO) {
						$item = $this->GetPhotoThumb($path);
						$photoCount++;
					} else {
						$item = $this->GetVideoThumb($path);
					}
					$thumbList[] = $item;
				}
				$seekOffset++;
			}
		}
		$result = array();
		$result['items'] = $thumbList;
		$result['itemCount'] = count($list);
		$result['subAlbumCount'] = count($dirList);
		$result['videoCount'] = $result['itemCount'] - $result['subAlbumCount'] - $photoCount;
		return $result;
	}

	/*!
	 * Get smart album
	 *
	 * \return array with smart album info
	 *
	 */
	private function GetSmartAlbum()
	{
		$returnAlbumList = array();
		if (!$smartAlbumList = json_decode(csSYNOSmartAlbum::ListSmartAlbum(), true)) {
			csSYNOPhotoMisc::Synophoto_Mobile_Log('Decode failed');
			goto Error;
		}

		if (!$smartAlbumList["success"]) {
			csSYNOPhotoMisc::Synophoto_Mobile_Log('list smart album failed');
			goto Error;
		}

		$smartAlbums = $smartAlbumList["data"]["albumList"];
		if (!$smartAlbums) {
			csSYNOPhotoMisc::Synophoto_Mobile_Log('no smart album data');
			goto Error;
		}

		foreach ($smartAlbums as $smartAlbum) {
			if (!strlen($smartAlbum["name"])) {
				continue;
			}

			$item['dir'] = bin2hex($smartAlbum["name"]);
			$item['name'] = $smartAlbum["name"];
			$item['title'] = $smartAlbum["name"];
			$item['desc'] = $smartAlbum["desc"];
			$item['isPublic'] = true;
			$item['hit'] = 0;
			$item['itemType'] = SYNOPHOTO_ITEM_TYPE_ALBUM;
			$item['dirName'] = '';
			$item['showTitle'] = htmlspecialchars($smartAlbum["name"]);
			$item['uploadable'] = false;
			$item['isSmartAlbum'] = true;

			if ($smartAlbum["cover"]) {
				if ('photo' === $smartAlbum["cover"]['type']) {
					$thumb = $this->GetPhotoThumb($smartAlbum["cover"]['path']);
				} else {
					$thumb = $this->GetVideoThumb($smartAlbum["cover"]['path']);
				}
				$item['cover'] = $thumb['cover'];
				$item['bigCover'] = $thumb['bigCover'];
			} else {
				$item['cover']['src'] = SYNOPHOTO_IMG_EMPTY;
				$item['bigCover']['src'] = SYNOPHOTO_IMG_EMPTY;
			}

			$returnAlbumList[] = $item;
		}

	Error:
		return $returnAlbumList;
	}

	/*!
	 * Get smart album photo list
	 *
	 * \return array with smart album photo list info
	 *
	 */
	function GetSmartAlbumItemList($smartAlbumName, $page = 1, $length = 0, $isDisplayAll = false)
	{
		$returnItemList = array();

		if ($isDisplayAll) {
			$offset = 0;
			$limit = 0;
		} else {
			$offset = ($page - 1) * $length;
			$limit = $length;
		}

		$data = array(
			"name" => $smartAlbumName,
			"offset" => $offset,
			"limit" => $limit
		);

		if (!$itemListJson = json_decode(csSYNOSmartAlbum::ListItem(json_encode($data)), true)) {
			csSYNOPhotoMisc::Synophoto_Mobile_Log('Decode photo list json failed');
			goto Error;
		}

		if (!$itemListJson["success"]) {
			csSYNOPhotoMisc::Synophoto_Mobile_Log('list photo in smart album failed');
			goto Error;
		}

		$items = $itemListJson["data"]["itemList"];
		if (!is_array($items)) {
			csSYNOPhotoMisc::Synophoto_Mobile_Log('no photo');
			goto Error;
		}

		$videoCount = 0;
		$thumbList = array();

		foreach($items as $item) {
			if ('photo' === $item['type']) {
				$thumb = $this->GetPhotoThumb($item["path"]);
			} else if ('video' === $item['type']) {
				$thumb = $this->GetVideoThumb($item["path"]);
			} else {
				continue;
			}
			$thumbList[] = $thumb;
			if ('video' === $item['type']) {
				$videoCount++;
			}
		}

		$returnItemList['items'] = $thumbList;
		$returnItemList['itemCount'] = $itemListJson["data"]["total"];
		$returnItemList['subAlbumCount'] = 0;
		$returnItemList['videoCount'] = $videoCount;
	Error:
		return $returnItemList;
	}

	private function GetMostRecentAlbums()
	{
		$albumList = array();
		$mostRecentPhotos = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentAlbumThumb('photo');
		if ($mostRecentPhotos) {
			$albumList[] = $mostRecentPhotos;
		}

		$mostRecentVideos = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentAlbumThumb('video');
		if ($mostRecentVideos) {
			$albumList[] = $mostRecentVideos;
		}
		return $albumList;
	}

	function GetVirtualAlbums($isShowMostRecentAlbum = false, $isShowLabelAlbum = false)
	{
		$albumList = array();

		if ($isShowMostRecentAlbum) {
			$mostRecentAlbums = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentAlbums();
			if ($mostRecentAlbums) {
				foreach($mostRecentAlbums as $value) {
					$albumList[] = $value;
				}
			}
		}

		if ($isShowLabelAlbum) {
			$virtualAlbums = csSYNOPhotoBrowse::GetBrowseInstance()->GetLabelVirtualAlbumList();
			if ($virtualAlbums) {
				foreach($virtualAlbums as $value) {
					$albumList[] = $value;
				}
			}	
		}

		$smartAlbumList = csSYNOPhotoBrowse::GetBrowseInstance()->GetSmartAlbum();
		if ($smartAlbumList) {
			foreach($smartAlbumList as $value) {
				$albumList[] = $value;
			}
		}
		return $albumList;
	}

	/*!
	 * Get comments for specified photo by page number
	 *
	 * \param $albumName album name
	 * \param $photoName photo file name
	 * \param $offset # of comments to skip
	 * \param $length # of comments to list
	 * \return array with comment list info
	 *	- comments: array with comment info
	 *		- name: commentator name
	 *		- email: commentator email
	 *		- comment: comment
	 *		- date: comment date
	 *	- commentsMore: # of the rest comments
	 */
	function GetCommentList($albumName, $photoName, $offset, $length)
	{
		$photoPath = SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/{$photoName}";
		$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($photoPath);
		$comments = csSYNOPhotoDB::GetDBInstance()->GetPhotoComments($photoInfo['id'], $offset, $length);
		$result['comments'] = array();
		foreach ($comments as $item) {
			$result['comments'][] = array('name' => $item['name'], 'email' => $item['email'], 'comment' => $item['comment'],
										  'date' => csSYNOPhotoMisc::GetReducedDate($item['date'])
										 );
		}
		$result['commentsMore'] = csSYNOPhotoDB::GetDBInstance()->GetNumberOfComments($photoInfo['id']) - $offset - count($result['comments']);
		return $result;
	}
	/*!
	 * Get all comments for specified photo
	 *
	 * \param $photoPath photo path
	 * \return array with comment list info
	 *	- comments: array with comment info
	 *		- name: commentator name
	 *		- email: commentator email
	 *		- comment: comment
	 *		- date: comment date
	 */
	function GetAllPhotoComments($photoPath)
	{
		$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($photoPath);
		$comments = csSYNOPhotoDB::GetDBInstance()->GetPhotoComments($photoInfo['id']);
		$result = array();
		foreach ($comments as $item) {
			$emailAddr = '';
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
				// only show e-mail addr when user is admin
				$emailAddr = $item['email'];
			}

			$result[] = array('name' => $item['name'], 'email' => $emailAddr, 'comment' => $item['comment'],
										  'date' => $item['date']
										 );
		}
		return $result;
	}

	/*!
	 * Get all comments for specified video
	 *
	 * \param $videoPath video path
	 * \return array with comment list info
	 *	- comments: array with comment info
	 *		- name: commentator name
	 *		- email: commentator email
	 *		- comment: comment
	 *		- date: comment date
	 */
	function GetAllVideoComments($videoPath)
	{
		$comments = csSYNOPhotoDB::GetDBInstance()->GetVideoComments($videoPath);
		$result = array();
		foreach ($comments as $item) {
			$emailAddr = '';
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
				// only show e-mail addr when user is admin
				$emailAddr = $item['email'];
			}
			$result[] = array('name' => $item['name'], 'email' => $emailAddr, 'comment' => $item['comment'],
										  'date' => $item['date']
										 );
		}
		return $result;
	}
	/*!
	 * Check if the photo or video file is commentable
	 *
	 * \param $filePath photo or video file path
	 * \return true or false
	 */
	function isFileCommentable($filePath)
	{
        $blAllowUserComment = $_SESSION[SYNOPHOTO_ADMIN_USER]['allow_user_comment'];
        $blAllowGuestComment = $_SESSION[SYNOPHOTO_ADMIN_USER]['allow_guest_comment'];

        if ($blAllowGuestComment) {
            return true;
        } elseif ($blAllowUserComment) {
            if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) || isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
                return true;
            }
        }
        return false;
	}
	/*!
	 * add new comment
	 *
	 * \param $filePath the path of the photo or video
	 * \param $itemType identify photo or video
	 * \param $name user name who adding the comment
	 * \param $email email address of whom adding the comment
	 * \param $comment the comment
	 * \return true for adding comment success
	 */
	function AddNewComment($filePath, $itemType, $name, $mail, $comment)
	{
		$result = false;
		if (SYNOPHOTO_ITEM_TYPE_PHOTO == $itemType) {
			$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($filePath);
			if (!empty($photoInfo)) {
				$result = csSYNOPhotoDB::GetDBInstance()->AddPhotoComment($photoInfo['id'], $name, $mail, $comment);
			}

		} else if (SYNOPHOTO_ITEM_TYPE_VIDEO == $itemType) {
			$videoInfo = csSYNOPhotoDB::GetDBInstance()->GetVideoInfo($filePath);
			if (!empty($videoInfo)) {
				$result = csSYNOPhotoDB::GetDBInstance()->AddVideoComment($videoInfo['path'], $name, $mail, $comment);
			}
		}

		return $result;
	}

	function DeleteOneItem($filePath, $itemType)
	{
		$result = false;
		if (SYNOPHOTO_ITEM_TYPE_PHOTO == $itemType) {
			$result = csSYNOPhotoDB::GetDBInstance()->DeletePhoto($filePath);
		} else if (SYNOPHOTO_ITEM_TYPE_VIDEO == $itemType) {
			$result = csSYNOPhotoDB::GetDBInstance()->DeleteVideo($filePath);
		}
		return $result;
	}

	function DeleteItems($albumlist, $photolist, $videolist)
	{
		$result = true;
		if (!empty($albumlist)) {
			$ret = $this->DeleteAlbums($albumlist);
			if (!$ret) {
				$result = $ret;
			}
		}
		if (!empty($photolist)) {
			$ret = $this->DeletePhotos($photolist);
			if (!$ret) {
				$result = $ret;
			}
		}
		if (!empty($videolist)) {
			$ret = $this->DeleteVideos($videolist);
			if (!$ret) {
				$result = $ret;
			}
		}
		return $result;
	}

	function DeleteAlbums($albumlist)
	{
		$result = true;
		$list = explode(',', $albumlist);
		foreach($list as $sharename) {
			$sharename = trim($sharename);
			if ('' != $sharename) {
				$sharename = @pack('H*', $sharename);
				$flag = csSYNOPhotoDB::GetDBInstance()->DeleteAlbum($sharename);
				if (!$flag) {
					$result = false;
				}
			}
		}
		return $result;
	}

	function DeletePhotos($photolist)
	{
		$result = true;
		$list = json_decode($photolist);
		foreach($list as $path) {
			$path = trim($path);
			if ('' != $path) {
				$flag = csSYNOPhotoDB::GetDBInstance()->DeletePhoto($path);
				if (!$flag) {
					$result = false;
				}
			}
		}
		return $result;
	}

	function DeleteVideos($videolist)
	{
		$result = true;
		$list = json_decode($videolist);
		foreach($list as $path) {
			$path = trim($path);
			if ('' != $path) {
				$flag = csSYNOPhotoDB::GetDBInstance()->DeleteVideo($path);
				if (!$flag) {
					$result = false;
				}
			}
		}
		return $result;
	}
}
?>
