<?php
// for debug
//error_reporting(E_ALL);

define('SYNO_CNF_FILE', '/etc/synoinfo.conf');
define('SYNO_DEF_CNF_FILE', '/etc.defaults/synoinfo.conf');
define('SYNO_DEF_VERSION_FILE', '/etc.defaults/VERSION');
define('SYNOPHOTO_ADMIN_PASS', 'hlinak3');
define('SYNO_USER_FILE', '/etc/synouser.conf');

define('SYNOPHOTO_MOBILE_ROOT', dirname(__FILE__).'/..');
define('SMARTY_DIR', SYNOPHOTO_MOBILE_ROOT . '/lib/');
define('SYNO_PKG_DIR', '/var/packages/PhotoStation');
define('SYNO_PKG_CNF_FILE', SYNO_PKG_DIR.'/etc/settings.conf');

define('SYNOPHOTO_ROOT', dirname(__FILE__).'/../..');
define('SYNOPHOTO_INCLUDE_DIR', SYNOPHOTO_ROOT.'/include');
define('SYNOPHOTO_EADIR', '@eaDir');
define('SYNOPHOTO_LANGS_DIR', SYNOPHOTO_ROOT.'/language');
define('SYNOPHOTO_INCLUDE_DB', SYNOPHOTO_INCLUDE_DIR.'/syno_db.php');

//Photo Station account system
define('SYNOPHOTO_INDEPENDENT_ACCOUNT', "0");
define('SYNOPHOTO_DSM_ACCOUNT', "1");

//album permission label
define('SYNOPHOTO_ALBUM_PUBLIC', 0);
define('SYNOPHOTO_ALBUM_PRIVATE', 1);
define('SYNOPHOTO_ALBUM_PASSWORD', 2);

//personal photo station
if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
	define('SYNOPHOTO_ADMIN_USER', substr(urldecode($matches[0]), 1));
	define('SYNOPHOTO_ADMIN_NAME', substr(urldecode($matches[0]), 2));
	define('SYNOPHOTO_URL_PREFIX', $matches[0]);
	define('SYNOPHOTO_SERVICE_DIR', '/var/services/homes/'.SYNOPHOTO_ADMIN_NAME.'/photo');
	define('SYNOPHOTO_SERVICE_REAL_DIR', @readlink('/var/services/homes').'/'.SYNOPHOTO_ADMIN_NAME.'/photo');
	define('SYNOPHOTO_SERVICE_REAL_DIR_PATH', '');
	define('SYNOPHOTO_SERVICE_REAL_DIR_PREFIX', @readlink('/var/services/homes').'/'.SYNOPHOTO_ADMIN_NAME.'/photo/');
	define('SYNO_PERSONAL_CNF_FILE', '/usr/syno/etc/preference/'.SYNOPHOTO_ADMIN_NAME.'/synoinfo.conf');
} else{//photo station
	define('SYNOPHOTO_ADMIN_USER', 'root');
	define('SYNOPHOTO_ADMIN_NAME', 'root');
	define('SYNOPHOTO_URL_PREFIX', '');
	define('SYNOPHOTO_SERVICE_DIR', '/var/services/photo');
	define('SYNOPHOTO_SERVICE_REAL_DIR', @readlink(SYNOPHOTO_SERVICE_DIR));
	define('SYNOPHOTO_SERVICE_REAL_DIR_PATH', @readlink(SYNOPHOTO_SERVICE_DIR).'/');
	define('SYNOPHOTO_SERVICE_REAL_DIR_PREFIX', '');
}

// defined constant string value used in uploader.php, need to sync with iPhone & android client code.
define('SYNOPHOTO_UPLOAD_CLIENT_IPHONE', 'iphone_app');
define('SYNOPHOTO_UPLOAD_CLIENT_ANDROID', 'android_app');
define('SYNOPHOTO_UPLOAD_FILE_TYPE_PHOTO', 'file_type_photo');
define('SYNOPHOTO_UPLOAD_FILE_TYPE_VIDEO', 'file_type_video');

define('SYNOPHOTO_IMAGES_DIR_FULL', SYNOPHOTO_ROOT . '/images');
define('SYNOPHOTO_MAPP_IMAGES_DIR_FULL', SYNOPHOTO_ROOT . '/mApp/img');
if ($_REQUEST['client'] == SYNOPHOTO_UPLOAD_CLIENT_IPHONE) {
	define('SYNOPHOTO_IMG_EMPTY', '/photo/mApp/img/empty_cover.png');
	define('SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY', '/photo/mApp/img/empty_big_cover.png');
	define('SYNOPHOTO_IMG_EMPTY_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/empty_75.png');
	define('SYNOPHOTO_IMG_EMPTY_FILE_PATH_HIGH_QUALITY', SYNOPHOTO_IMAGES_DIR_FULL . '/empty_bigCover.png');
	define('SYNOPHOTO_IMG_LOCKED', '/photo/images/locked_75.png');
	define('SYNOPHOTO_IMG_LOCKED_HIGH_QUALITY', '/photo/images/locked_bigCover.png');
	define('SYNOPHOTO_IMG_LOCKED_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/locked_75.png');
	define('SYNOPHOTO_IMG_LOCKED_FILE_PATH_HIGH_QUALITY', SYNOPHOTO_IMAGES_DIR_FULL . '/locked_bigCover.png');
	define('SYNOPHOTO_IMG_BROKEN', '/photo/images/broken_small.png');
	define('SYNOPHOTO_IMG_BROKEN_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/broken_small.png');
	define('SYNOPHOTO_IMG_BROKEN_BIG', '/photo/images/broken_big.png');
	define('SYNOPHOTO_IMG_BROKEN_BIG_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/broken_big.png');
} else {
	define('SYNOPHOTO_IMG_EMPTY', '/photo/mApp/img/120_empty_album.png');
	define('SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY', '/photo/mApp/img/148_empty_album.png');
	define('SYNOPHOTO_IMG_EMPTY_FILE_PATH', SYNOPHOTO_MAPP_IMAGES_DIR_FULL . '/120_empty_album.png');
	define('SYNOPHOTO_IMG_EMPTY_FILE_PATH_HIGH_QUALITY', SYNOPHOTO_MAPP_IMAGES_DIR_FULL . '/148_empty_album.png');
	define('SYNOPHOTO_IMG_LOCKED', '/photo/mApp/img/120_password.png');
	define('SYNOPHOTO_IMG_LOCKED_HIGH_QUALITY', '/photo/mApp/img/148_password.png');
	define('SYNOPHOTO_IMG_LOCKED_FILE_PATH', SYNOPHOTO_MAPP_IMAGES_DIR_FULL . '/120_password.png');
	define('SYNOPHOTO_IMG_LOCKED_FILE_PATH_HIGH_QUALITY', SYNOPHOTO_MAPP_IMAGES_DIR_FULL . '/148_password.png');
	define('SYNOPHOTO_IMG_BROKEN', '/photo/mApp/img/120_broken.png');
	define('SYNOPHOTO_IMG_BROKEN_FILE_PATH', SYNOPHOTO_MAPP_IMAGES_DIR_FULL . '/120_broken.png');
	define('SYNOPHOTO_IMG_BROKEN_BIG', '/photo/mApp/img/640_broken.png');
	define('SYNOPHOTO_IMG_BROKEN_BIG_FILE_PATH', SYNOPHOTO_MAPP_IMAGES_DIR_FULL . '/640_broken.png');
}
define('SYNOPHOTO_IMG_THUMB', '/photo/images/loading_small.png');
define('SYNOPHOTO_IMG_THUMB_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/loading_small.png');
define('SYNOPHOTO_IMG_THUMB_BIG', '/photo/images/loading_big.png');
define('SYNOPHOTO_IMG_THUMB_BIG_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/loading_big.png');
define('SYNOPHOTO_IMG_FULL_BIG', '/photo/images/full_big.jpg');
define('SYNOPHOTO_IMG_FULL_BIG_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/full_big.gif');
define('SYNOPHOTO_IMG_FULL', '/photo/images/full.gif');
define('SYNOPHOTO_IMG_FULL_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/full.gif');
define('SYNOPHOTO_IMG_MOVIE', '/photo/images/movie.png');
define('SYNOPHOTO_IMG_MOVIE_FILE_PATH', SYNOPHOTO_IMAGES_DIR_FULL . '/movie.png');
define('SYNOPHOTO_RSRV_DISK_SPACE', 104857600);	//100*1024*1024 bytes = 100M

define('SYNOPHOTO_THUMB_WIDTH', 71);
define('SYNOPHOTO_THUMB_HEIGHT', 71);
define('SYNOPHOTO_THUMBALBUM_WIDTH', 57);
define('SYNOPHOTO_THUMBALBUM_HEIGHT', 57);
define('SYNOPHOTO_THUMBSMALL_WIDTH', 120);
define('SYNOPHOTO_THUMBSMALL_HEIGHT', 120);
define('SYNOPHOTO_THUMBMEDIUM_WIDTH', 320);
define('SYNOPHOTO_THUMBMEDIUM_HEIGHT', 320);
define('SYNOPHOTO_THUMBBIG_WIDTH', 640);
define('SYNOPHOTO_THUMBBIG_HEIGHT', 640);
define('SYNOPHOTO_THUMBLARGE_WIDTH', 800);
define('SYNOPHOTO_THUMBLARGE_HEIGHT', 800);
define('SYNOPHOTO_THUMBXLARGE_WIDTH', 1280);
define('SYNOPHOTO_THUMBXLARGE_HEIGHT', 1280);

define('SYNOPHOTO_MAX_LOG_TO_KEEP', 1000);
define('SYNOPHOTO_REC_TO_DEL', 100);

define('ALBUMS_PER_LOAD', 12);
define('PHOTOS_PER_LOAD', 60);
define('COMMENTS_PER_LOAD', 10);
define('MOST_RECENT_MAX', 80);

//label album
define('IDX_LABEL_ALBUM_PERSON', 0);
define('IDX_LABEL_ALBUM_PLACE', 1);
define('IDX_LABEL_ALBUM_GENERAL', 2);

define('SYNO_EXIFTOOL_FILE', '/usr/syno/bin/exiv2');

define('SYNOPHOTO_THUMBSMALL', 0);
define('SYNOPHOTO_THUMBBIG', 1);
define('SYNOPHOTO_THUMBMEDIUM', 4);
define('SYNOPHOTO_THUMBLARGE', 5);
define('SYNOPHOTO_THUMBXLARGE', 12);

//item type definition, sync with mobile devide code
define('SYNOPHOTO_ITEM_TYPE_ALBUM', 0);
define('SYNOPHOTO_ITEM_TYPE_PHOTO', 1);
define('SYNOPHOTO_ITEM_TYPE_VIDEO', 2);

//facebook
define('SYNOPHOTO_FB_UTILS', SYNOPHOTO_ROOT.'/facebook/fbutils.php');
define('SYNOPHOTO_FB_SDK', SYNOPHOTO_ROOT.'/facebook/php-sdk/src/facebook.php');

define('SYNOPHOTO_FB_SYNCING_FILE', '/tmp/fbsyncing');

define('SYNOPHOTO_PACKAGE_INFO', '/var/packages/PhotoStation/INFO');

$SYNOPHOTO_ALLOW_PICT_NAMES_EXT = array(
	'jpg', 'jpeg', 'jpe', 'bmp', 'gif', 'png', 'tiff', 'tif',
	// Camera raw files
	"arw", "srf", "sr2", // Sony
	"dcr", "k25", "kdc", // Kodak
	"cr2","crw",// Canon
	"nef", // nikon
	"mrw", // Minolta
	"ptx", "pef",// Pentax
	"raf", // Fuji
	"3fr", // Hasselblad
	"erf", // (Epson)
	"mef", // (Mamiya)
	"mos", // (Leaf)
	"orf", // (Olympus),
	"rw2", // (Panasonic)
	"dng", // Adobe Digital Negative
	"x3f", // Sigma Raw Image
	"raw"  // Panasonic
);
$SYNOPHOTO_ALLOW_ORIG_NAMES_EXT = array('gif');

require_once('SYNOPhotoEA.php');
require_once('synophoto_mobile_csPhotoMisc.php');
require_once('synophoto_mobile_csPhotoDB.php');
require_once('synophoto_mobile_csPhotoAlbum.php');
require_once('synophoto_mobile_csPhotoThumb.php');
require_once('synophoto_mobile_csPhotoBrowse.php');
require_once('synophoto_mobile_csSmartAlbum.php');

/*!
 * Get translated localization string
 *
 * \param $string the string to be translated
 * \return the translated string or input string when no translated string found.
 */
function __($string)
{
	include(SYNOPHOTO_LANGS_DIR."/{$_SESSION[SYNOPHOTO_ADMIN_USER]['lang']}.php");
	$pattern = preg_replace('/[^0-9a-z]/i','_', $string);
	if (isSet($$pattern)) {
		return $$pattern;
	}
	$pattern = 'photo_mobile_'.preg_replace('/[^0-9a-z]/i','_', $string);
	if (isSet($$pattern)) {
		return $$pattern;
	}
	return $string;
}

function undoMagicQuotes(&$value)
{
	$value = is_array($value) ? array_map('undoMagicQuotes', $value) :
			 stripslashes($value);
	return $value;
}

function GetSessionIdentifier()
{
	$token = $_SERVER['REMOTE_ADDR'];
	if (isSet($_SERVER["HTTP_X_FORWARDED_FOR"])) {
		$token .= $_SERVER["HTTP_X_FORWARDED_FOR"];
	}
	return $token;
}

function RestoreSession()
{
	if (!isSet($_GET['SESSID'])) {
		return false;
	}

	$sessionDir = session_save_path();
	if (empty($sessionDir)) {
		$sessionDir = sys_get_temp_dir();
	}

	$sessionPath = $sessionDir . '/sess_' . $_GET['SESSID'];
	$serializedSession = @file_get_contents($sessionPath);
	if (empty($serializedSession)) {
		return false;
	}

	/* backup */
	$currIdentifier = $_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier'];
	$currSession = session_encode();
	/* restore */
	session_unset();
	if (session_decode($serializedSession)
		&& isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier'])
		&& $currIdentifier == $_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier']) {
		return true;
	}
	/* rollback */
	session_unset();
	session_decode($currSession);
	return false;
}

// set umask to 0
@umask(0);

session_start();
if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['forMobile'])) {
	session_unset();
}

$_SESSION[SYNOPHOTO_ADMIN_USER]['forMobile'] = true;
$_SESSION[SYNOPHOTO_ADMIN_USER]['security_identifier'] = GetSessionIdentifier();
if (isSet($_GET['SESSID'])) {
	RestoreSession();
	/* remove SESSION ID from url */
	$queryString = '?' . $_SERVER['QUERY_STRING'];
	$queryString = preg_replace("/[\?&]SESSID=[^&]+/", "", $queryString);
	header("Location: {$_SERVER['SCRIPT_NAME']}{$queryString}");
	exit;
}

$_SESSION[SYNOPHOTO_ADMIN_USER]['lang'] = csSYNOPhotoDB::GetDBInstance()->GetLanguage();
$_SESISON['hideSearch'] = ('on' != csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'hide_search'));

/* undo escape by magic_quotes */
if ((function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()) ||
	(ini_get('magic_quotes_sybase') && ('off' != strtolower(ini_get('magic_quotes_sybase')))) ) {
	undoMagicQuotes($_GET);
	undoMagicQuotes($_POST);
	undoMagicQuotes($_REQUEST);
	undoMagicQuotes($_COOKIE);
}

/* replace netbios name to server address */
if (false !== strpos($_SERVER['HTTP_HOST'], '_')) {
	header("Location: http://{$_SERVER['SERVER_ADDR']}{$_SERVER['REQUEST_URI']}");
	exit;
}

/* check logined user exist or not */
if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) && !csSYNOPhotoDB::GetDBInstance()->CheckUserExist($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
	header('Location: /photo/report.php?msgkey=photo_str_useracct_removed');
	exit;
}


/* user-agent pattern for browser didn't support css well */
$cssBreakUAPattern = '/(MSIE|IEMobile)/i';
/* pick a edition according to mobile device */
if (preg_match('/(iPhone|iPod|Android)/i', $_SERVER['HTTP_USER_AGENT']) ) {
	$_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser'] = 'iPhone';
} else if (preg_match($cssBreakUAPattern, $_SERVER['HTTP_USER_AGENT']) ) {
	$_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser'] = 'Old';
} else {
	$_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser'] = 'Mobile';
}

?>
