<?php
require_once('include/synophoto_mobile_conf.php');

$page = 1;
if (isSet($_GET['page']) && is_numeric($_GET['page'])) {
	$page = $_GET['page'];
}

if (isset($_GET['refresh']) && $page == 1) {
	// refresh the cache
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
}

$albumName = @pack('H*', $_GET['dir']);

$photosPerLoad = PHOTOS_PER_LOAD;
if (isSet($_GET['photosPerLoad']) && is_numeric($_GET['photosPerLoad'])) {
	$photosPerLoad = $_GET['photosPerLoad'];
}

$password = isSet($_GET['passwd'])?@pack('H*', $_GET['passwd']):"";
$albumAccessibleResult = csSYNOPhotoDB::GetDBInstance()->CheckAlbumAccessible($albumName, $password);

if (true === $albumAccessibleResult) {
	$sort_type = "";
	$sort_order = "";
	if (isSet($_GET['sort_type']) && isSet($_GET['sort_order'])) {
		$sort_type = $_GET['sort_type'];
		$sort_order = $_GET['sort_order'];
	}
	$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetThumbList($albumName, ($page - 1) * $photosPerLoad, $photosPerLoad, $sort_type, $sort_order);
} else {
    $errText = $albumAccessibleResult;
}

$guestLogin = true;
if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) || isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
	$guestLogin = false;
}

$photoList['isGuestLogin'] = $guestLogin;
$photoList['success'] = empty($errText)?true:$errText;

echo json_encode($photoList);

?>
