<?php
require_once('include/synophoto_mobile_conf.php');

if ('on' == csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'hide_search')) {
	header("Location: {SYNOPHOTO_URL_PREFIX}/photo/m");
	exit;
}

if (!isSet($_GET['search']) || empty($_GET['search']) ||
	(!isSet($_GET['option_name']) && !isSet($_GET['option_title']) && !isSet($_GET['option_desc'])) ) {
	header("Location: {SYNOPHOTO_URL_PREFIX}/photo/m/search.php");
	exit;
}

/* force search photos in this page. */
$matchPattern = array('option_name', 'option_title', 'option_desc');
$condition = array();
foreach($matchPattern as $field) {
	if (isSet($_GET[$field])) {
		$condition[$field] = $_GET['search'];
	}
}
csSYNOPhotoBrowse::GetBrowseInstance()->OptionToSearchToken($condition);

if ('iPhone' != $_SESSION[SYNOPHOTO_ADMIN_USER]['mobileUser']) {
	$page = 1;
	if (isSet($_GET['showSeq']) && is_numeric($_GET['showSeq'])) {
		$page = ceil($_GET['showSeq'] / PHOTOS_PER_LOAD);
	} else if (isSet($_GET['page']) && is_numeric($_GET['page'])) {
		$page = $_GET['page'];
	}

	$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetSearchThumbList($condition, ($page - 1) * PHOTOS_PER_LOAD, PHOTOS_PER_LOAD);

    $smarty->assign('page', $page);
	$smarty->assign('isMorePage', $photoList['photoMore']);
	$smarty->assign('photoList', $photoList);
}

$smarty->assign('toolbarTitle', __('photo_str_search_result'));
$smarty->assign('navPrevText', __('photo_str_search'));
$smarty->assign('navPrevLink', 'search.php');
$smarty->display('search_result.tpl');
?>
