<?php
$type = (array_key_exists('type', $_POST)) ? $_POST['type'] : null;
if(!$type)
	$type = (array_key_exists('type', $_GET)) ? $_GET['type'] : null ;
require_once('syno_conf.php');
require_once 'SYNOPhotoEA.php';
$cv = (array_key_exists('cv', $_GET)) ? $_GET['cv'] :0;
$changed = (array_key_exists('changed', $_GET)) ? $_GET['changed'] : null;
$action = (array_key_exists('action', $_POST)) ? $_POST['action'] : null;
$get_action = (array_key_exists('action', $_GET)) ? $_GET['action'] : null;
$value = (array_key_exists('value', $_POST)) ? $_POST['value'] : null ;
if ($action) {
	switch($action) {
		case 'v6_template':
			echo SYNOTHEME_SetTempTemplate($action,$value,$type);
			break;
		case 'v6_logo':
		case 'v6_show_bkg_img':
		case 'v6_bkg_color':
		case 'v6_font_color':
		case 'v6_hl_color':
		case 'v6_sec_color':
		case 'template':
		case 'transparent':
		case 'show_bkg_img':
		case 'bkg_color':
		case 'font_color':
			echo SYNOTHEME_SetTempConfig($action,$value,$type);
			break;
		case 'logo_name':
			echo SYNOTHEME_SetLogoName($action,$value,$type);
			break;
		case 'banner':
			echo SYNOTHEME_SetTempConfig($action,$value,$type);
			break;
		case 'init':
			echo SYNOTHENE_GetInitConfig($type);
			break;
		case 'save':
			echo SYNOTHENE_SaveConfig($type);
			break;
		case 'default':
			echo SYNOTHENE_LoadDefaultConfig($type);
			break;
		case 'photo':
			echo SYNOTHEME_Get_Images($action);
			break;
		case 'save_bkg_custom':
			SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_FILE, SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_FILE);
			SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_BIG_FILE, SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_BIG_FILE);
			echo SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_PREVIEW_FILE, SYNOTHEME_BKG_CUSTOM_TEMP_FILE);
			break;
		case 'cancel_bkg_custom':
			SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_FILE, SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_FILE);
			SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_BIG_FILE, SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_BIG_FILE);
			echo SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_TEMP_FILE, SYNOTHEME_BKG_CUSTOM_PREVIEW_FILE);
			break;
		case 'css_change':
			echo SYNOTHEME_WRITE_FILE($_POST['syno-css-edit'], SYNOTHEME_CSS_CUSTOM_EDIT_FILE);
			break;
		case 'css_save':
			echo SYNOTHEME_COPY_FILE(SYNOTHEME_CSS_CUSTOM_EDIT_FILE, SYNOTHEME_CSS_CUSTOM_FILE);
			break;
		case 'css_cancel':
			echo SYNOTHEME_COPY_FILE(SYNOTHEME_CSS_CUSTOM_FILE, SYNOTHEME_CSS_CUSTOM_EDIT_FILE);
			break;
		case 'pattern':
			echo SYNOBLOG_IMG_GetAlbumPattern();
			break;
		default:
			echo SYNOTHEME_ACTION_ERROR();
			break;
	}
}

if ($get_action) {
	switch ($get_action) {
		case 'logo':
			SYNOTHEME_GET_LOGO_PIC((1 > $cv) ? 'theme_swp':'theme', $type);
			break;
		case 'banner':
			SYNOTHEME_GET_BANNER_PIC((1 > $cv) ? 'theme_swp':'theme', $type);
			break;
		case 'preview_bkg_custom':
			if (1 < $cv && $_GET['big']) {
				SYNOTHEME_READ_PIC(SYNOTHEME_BKG_CUSTOM_THUMB_BIG_FILE, false);
			} else if (1 < $cv){
				SYNOTHEME_READ_PIC(SYNOTHEME_BKG_CUSTOM_THUMB_FILE, false);
			} else if ($_GET['big']){
				SYNOTHEME_READ_PIC(SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_BIG_FILE, false);
			} else {
				SYNOTHEME_READ_PIC(SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_FILE, false);
			}
			break;
		case 'preview_bkg_none':
			SYNOTHEME_READ_PIC(SYNOTHEME_SPACER_FILE, TRUE);
			break;
		case 'bkg':
			SYNOTHEME_GET_BKG_PIC((1 > $cv) ? 'theme_swp':'theme',$type);
			break;
		case 'personal_img':
			SYNOTHEME_READ_PIC(SYNOTHEME_PERSONAL_IMG_FILE);
			break;
	}
}

function SYNOTHEME_WRITE_FILE ($context, $filename)
{
	$result = array();
	$result['success'] = TRUE;
	if ($fp = @fopen($filename,'w')) {
		fwrite($fp,$context);
		fclose($fp);
	} else {
		$result['success'] = FALSE;
		$result['message'] = __(photo_str_open_error) . ': ' .$filename;
	}
	return json_encode($result);
}

function SYNOTHEME_COPY_FILE($source, $dest)
{
	$result =array();
	$result['success'] = TRUE;
	if (!file_exists($source) || FALSE == @copy($source, $dest)) {
		$result['success'] = FALSE;
		$result['message'] = 'Copy Error source:'.$source.' dest:'.$dest;
	}
	return json_encode($result);
}

function SYNOTHEME_FRESH_FILE($filename)
{
	if(null == $fp = fopen($filename, 'w')) {
		return false;
	}

	fwrite($fp, '');
	fclose($fp);
	return true;
}

/* sql function*/
function SYNOTHEME_SetTempConfig($key, $value, $type)
{
	 return csSYNOPhotoMisc::UpdateConfigDB('theme_swp',  $key, $value, $type . '_config');
}
function SYNOTHEME_SetTempTemplate($key,$value,$type)
{
	 global $SYNOTHEME_CONFIG;
	 csSYNOPhotoMisc::UpdateConfigDB('theme_swp',  $key, $value, $type . '_config');
	 $config = array();
	 foreach ($SYNOTHEME_CONFIG[$type][$value] as $k => $v) {
		 csSYNOPhotoMisc::UpdateConfigDB('theme_swp',  $k, $v, $type . '_config');
		 $config[$k] = $v;
	 }
	 $config['result'] = SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_FILE, SYNOTHEME_BKG_CUSTOM_TEMP_FILE);
	 if(false == SYNOTHEME_FRESH_FILE(SYNOTHEME_CSS_CUSTOM_EDIT_FILE)) {
	     $config['result'] = false;
	 }
	 return json_encode($config);
}

function SYNOTHEME_SetLogoName($key, $value, $type)
{
	 return csSYNOPhotoMisc::UpdateConfigDB('theme',  $key, $value, $type . '_config');
}

function SYNOTHENE_GetInitConfig($type)
{
	if (!is_dir(SYNOTHEME_DIR) && !mkdir(SYNOTHEME_DIR)) {
		return FALSE;
	}
	$img_width = 0;
	$img_height = 0;
	global $SYNOTHEME_CONFIG;
	$CONFIG_DEFAULT = $SYNOTHEME_CONFIG[$type]["White"];

	$config = array();
	$show_bkg_img_key = 'photo' === $type ? 'v6_show_bkg_img' : 'show_bkg_img';

	foreach ($CONFIG_DEFAULT as $key => $value) {
		if (null == $tmp_value = csSYNOPhotoMisc::GetConfigDB('theme', $key, $type.'_config')) {
			$tmp_value = $value;
		}

		if ($show_bkg_img_key == $key) {
			$config['show_bkg'] = $tmp_value;

			if (1 == $tmp_value) {
				$tmp_value = SYNOTHEME_REQUEST_FILE . '?type=' . $type . '&action=bkg&cv=' . rand();
				list($img_width, $img_height, $img_type, $img_attr) =
					file_exists(SYNOTHEME_BKG_SYNO_FILE) ? @getimagesize(SYNOTHEME_BKG_SYNO_FILE) : array(0,0,0,0);

			}

			if (2 == $tmp_value) {
				$tmp_value = SYNOTHEME_REQUEST_FILE . '?type=' . $type . '&action=preview_bkg_custom&cv='.rand();
				list($img_width, $img_height, $img_type, $img_attr) =
					file_exists(SYNOTHEME_BKG_CUSTOM_FILE) ? @getimagesize(SYNOTHEME_BKG_CUSTOM_FILE) : array(0,0,0,0);
				SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_THUMB_FILE, SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_FILE);
				SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_THUMB_BIG_FILE, SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_BIG_FILE);
				SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_FILE, SYNOTHEME_BKG_CUSTOM_TEMP_FILE);
				SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_THUMB_FILE, SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_FILE);
				SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_THUMB_BIG_FILE, SYNOTHEME_BKG_CUSTOM_PREVIEW_THUMB_BIG_FILE);
				SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_FILE, SYNOTHEME_BKG_CUSTOM_PREVIEW_FILE);
			}

			if (4 == $tmp_value) {
				$tmp_value = SYNOTHEME_REQUEST_FILE . '?type=' . $type . '&action=bkg&cv=' . rand();
				list($img_width, $img_height, $img_type, $img_attr) =
					file_exists(SYNOTHEME_BKG_PS_FILE) ? @getimagesize(SYNOTHEME_BKG_PS_FILE) : array(0,0,0,0);
			}
		}

		$config[$key] = $tmp_value;
		// backup into swp
		csSYNOPhotoMisc::UpdateConfigDB('theme_swp',  $key, $tmp_value, $type . '_config');
	}
	$config['logo_name'] = csSYNOPhotoMisc::GetConfigDB('theme', 'logo_name', $type.'_config');
	$config['bkg_width'] = $img_width ? $img_width : 0;
	$config['bkg_height'] = $img_height ? $img_height : 0;
	$config['custom_css'] = file_exists(SYNOTHEME_CSS_CUSTOM_FILE) ? file_get_contents(SYNOTHEME_CSS_CUSTOM_FILE) : '';

	if ($type == 'blog') {
		$config['banner_name'] = csSYNOPhotoMisc::GetConfigDB('theme', 'banner_name', 'blog_config');
		if (null == $config['banner_name']) {
			$config['banner_name'] = '';
		}
		if (file_exists(SYNOTHEME_BANNER_CUSTOM_FILE)) {
			SYNOTHEME_COPY_FILE(SYNOTHEME_BANNER_CUSTOM_FILE, SYNOTHEME_BANNER_CUSTOM_PREVIEW_FILE);
		}
	}

	if (file_exists(SYNOTHEME_LOGO_CUSTOM_FILE)) {
		SYNOTHEME_COPY_FILE(SYNOTHEME_LOGO_CUSTOM_FILE, SYNOTHEME_LOGO_CUSTOM_PREVIEW_FILE);
	}

	return json_encode($config);
}

function isLargeImage ($path, $checkSize = 1920)
{
	$imgInfo = @getimagesize($path);
	return $checkSize < min($imgInfo[0], $imgInfo[1]) && !strstr($imgInfo['mime'],'gif');
}

function SYNOTHENE_SaveConfig($type)
{
	global $SYNOTHEME_CONFIG;
	$CONFIG_DEFAULT = $SYNOTHEME_CONFIG[$type]["White"];

	$result['success'] = TRUE;
	$prefix = 'photo' === $type ? 'v6_' : '';
	foreach ($CONFIG_DEFAULT as $key => $value) {
		$tmp_value = csSYNOPhotoMisc::GetConfigDB('theme_swp', $key, $type.'_config');

		if ($prefix.'show_bkg_img' == $key && $tmp_value != '0' && $tmp_value != '3') {
			if (strstr($tmp_value, 'action=bkg'))continue;

			$url = $tmp_value;
			if (strstr($tmp_value, 'custom')) {
				$tmp_value = '2';
			} else if (strstr($tmp_value, '/photo/images/01.jpg')) {
				$tmp_value = '3';
			} else if (strncmp($url, "photo_",5) == 0) {
				$tmp_value = '4';
			} else {
				$tmp_value = '1';
			}

			// photos
			if ($tmp_value == '1') {
				$result['success'] = SYNOTHEME_LoadImage($url, SYNOTHEME_BKG_SYNO_FILE, $result);
			}
		}
		// my photos
		if ($prefix.'show_bkg_img' == $key && $tmp_value == '2' && @file_exists(SYNOTHEME_BKG_CUSTOM_TEMP_FILE)) {
			if (isLargeImage(SYNOTHEME_BKG_CUSTOM_TEMP_FILE)) {
				$result = csSYNOPhotoMisc::ResizePhoto(SYNOTHEME_BKG_CUSTOM_TEMP_FILE, SYNOTHEME_BKG_CUSTOM_FILE);
				$result = SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_FILE, SYNOTHEME_BKG_CUSTOM_TEMP_FILE);
			} else {
				$result = SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_TEMP_FILE, SYNOTHEME_BKG_CUSTOM_FILE);
			}
			SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_BIG_FILE, SYNOTHEME_BKG_CUSTOM_THUMB_BIG_FILE);
			$result = SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_FILE, SYNOTHEME_BKG_CUSTOM_THUMB_FILE);
		} else if ($prefix.'show_bkg_img' == $key && $tmp_value == '4' && @file_exists(SYNOTHEME_BKG_PS_PREVIEW_FILE)) {
			if (isLargeImage(SYNOTHEME_BKG_PS_PREVIEW_FILE)) {
				$result = csSYNOPhotoMisc::ResizePhoto(SYNOTHEME_BKG_PS_PREVIEW_FILE, SYNOTHEME_BKG_PS_FILE);
			} else {
				$result = SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_PS_PREVIEW_FILE, SYNOTHEME_BKG_PS_FILE);
			}
		}

		if ($prefix.'logo' == $key && $tmp_value == '2' && @file_exists(SYNOTHEME_LOGO_CUSTOM_PREVIEW_FILE)) {
			$imageInfo = @getImageSize($dest);
			if ( 'photo' === $type && 200 < min($imageInfo[0], $imageInfo[1]) && !strstr($imageInfo['mime'], 'gif')) {
				$result = csSYNOPhotoMisc::ResizePhoto(SYNOTHEME_LOGO_CUSTOM_PREVIEW_FILE, SYNOTHEME_LOGO_CUSTOM_FILE, 200);
			} else {
				$result = SYNOTHEME_COPY_FILE(SYNOTHEME_LOGO_CUSTOM_PREVIEW_FILE, SYNOTHEME_LOGO_CUSTOM_FILE);
			}
		}

		if ('banner' == $key && $tmp_value == '2' && @file_exists(SYNOTHEME_BANNER_CUSTOM_PREVIEW_FILE)) {
			$result = SYNOTHEME_COPY_FILE(SYNOTHEME_BANNER_CUSTOM_PREVIEW_FILE, SYNOTHEME_BANNER_CUSTOM_FILE);
		}

		if (null == $tmp_value) {
			csSYNOPhotoMisc::UpdateConfigDB('theme_swp',  $key, $value, $type .'_config');
			$tmp_value = $value;
		}
		// save from swp
		csSYNOPhotoMisc::UpdateConfigDB('theme',  $key, $tmp_value, $type .'_config');
	}

	SYNOTHEME_COPY_FILE(SYNOTHEME_CSS_CUSTOM_EDIT_FILE, SYNOTHEME_CSS_CUSTOM_FILE);
	if (isSet($_POST['banner_name'])) {
		csSYNOPhotoMisc::UpdateConfigDB('theme',  'banner_name', $_POST['banner_name'], $type .'_config');
	}
	if (isSet($_POST['logo_name'])) {
		csSYNOPhotoMisc::UpdateConfigDB('theme',  'logo_name', $_POST['logo_name'], $type .'_config');
	}

	return json_encode($result);
}

function SYNOTHENE_LoadDefaultConfig($type)
{
	global $SYNOTHEME_CONFIG;

	if ('photo' == $type) {
		$template = csSYNOPhotoMisc::GetConfigDB('theme', 'v6_template', $type . '_config');
		$CONFIG_DEFAULT = $SYNOTHEME_CONFIG[$type][$template];
	} else {
		$CONFIG_DEFAULT = $SYNOTHEME_CONFIG[$type]["White"];
	}
	$config = array();
	foreach ($CONFIG_DEFAULT as $key => $value) {
		csSYNOPhotoMisc::UpdateConfigDB('theme_swp',  $key, $value, $type . '_config');
		$config[$key] = $value;
	}
	$config['result'] = SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_FILE, SYNOTHEME_BKG_CUSTOM_TEMP_FILE);
	if(false == SYNOTHEME_FRESH_FILE(SYNOTHEME_CSS_CUSTOM_EDIT_FILE)) {
		$config['result'] = false;
	}
	return json_encode($config);
}


function SYNOTHEME_Get_Images($action)
{
	// Submit those variables to the server
	$post_data = array(
		'action' => $action
	);

	// Send a request to synology.com
	$result = SYNOTHEME_POST_REQUEST(SYNOTHEME_SERVER_SITE . '/synobkg.php', $post_data);
	if ($result['status'] == 'ok'){
		$jsonArray = json_decode( $result['content'], true);
		$images = $jsonArray['images'];
		foreach ($images as $index => $image) {
			$images[$index]['name'] = SYNOTHEME_SERVER_SITE . '/bg_thumb/'. $image['name'];
			$images[$index]['type'] = 'img-'.$action.'-view';
		}
		$jsonArray['images'] = $images;
		return json_encode($jsonArray);

	}
	else {
		$jsonArray['images'] = array();
		return json_encode($jsonArray);
	}
}

function SYNOTHEME_LoadImage($source, $save_to, &$result)
{

	$isPattern = preg_match('/\/images\/Pattern.*png/', $source, $matches);
	if ($isPattern) {
		$source = SYNOPHOTO_ROOT . $matches[0];
	} else {
		$source = preg_replace('/bg_thumb/', 'bg', $source) ;
	}

	if (!strstr($source, 'http') && !file_exists($source)) {
		$result['message'] = __(photo_str_open_error) . ': ' . $source;
		return FALSE;
	}

	if (($hostfile = @fopen($source, 'r')) == NULL) {
		$result['message'] = __(photo_str_open_error) . ': ' . $source;
		return FALSE;
	}
	if (($fh = @fopen( $save_to, 'w')) == NULL) {
		$result['message'] = __(photo_str_open_error) . ': ' . $save_to;
		return FALSE;
	}
	while (!feof($hostfile)) {
		$output = fread($hostfile, 8192);
		fwrite($fh, $output);
	}

	fclose($hostfile);
	fclose($fh);

	return TRUE;
}




function SYNOTHEME_POST_REQUEST($url, $data, $referer='')
{

		// Convert the data array into URL Parameters like a=b&foo=bar etc.
		$data = http_build_query($data);

		// parse the given URL
		$url = parse_url($url);

		if ($url['scheme'] != 'http') {
			die('Error: Only HTTP request are supported !');
		}

		// extract host and path:
		$host = $url['host'];
		$path = $url['path'];

		// open a socket connection on port 80 - timeout: 30 sec
		$fp = @pfsockopen($host, 80, $errno, $errstr, 5);
		if ($fp) {
			// send the request headers:
			fputs($fp, "POST $path HTTP/1.1\r\n");
			fputs($fp, "Host: $host\r\n");

			if ($referer != '') {
				fputs($fp, "Referer: $referer\r\n");
			}

			fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n");
			fputs($fp, "Content-length: ". strlen($data) ."\r\n");
			fputs($fp, "Connection: close\r\n\r\n");
			fputs($fp, $data);

			$result = '';
			while(!feof($fp)) {
				// receive the results of the request
				$result .= fgets($fp, 128);
			}
		} else {
			return array(
				'status' => 'err',
				'error' => "$errstr ($errno)"
			);
		}

		// close the socket connection:
		fclose($fp);

		// split the result header from the content
		$result = explode("\r\n\r\n", $result, 2);
		$header = isset($result[0]) ? $result[0] : '';
		$content = isset($result[1]) ? $result[1] : '';

		// return as structured array:
		return array(
			'status' => 'ok',
			'header' => $header,
			'content' => $content
		);
}


/* Read image file transfer to html link tag */

function SYNOTHEME_GET_LOGO_PIC($mode,$type)
{
	$prefix = 'photo' === $type ? 'v6_' : '';
	if (null == $logo =  csSYNOPhotoMisc::GetConfigDB($mode, $prefix.'logo', $type . '_config')) {
		$logo = '1';
	}

	//1. /usr/syno/synoman/phpsrc/photo/images/White/ps5_logo.png
	//2. /var/services/blog/blog_customer_logo.png
	//3. /usr/syno/synoman/phpsrc/photo/images/spacer.png
	if ( $logo == '1') {
		$template =  csSYNOPhotoMisc::GetConfigDB($mode, $prefix.'template', $type . '_config');
		$template = $template ? $template : 'White';

		if ($type === 'photo') {
		    $logo_file = SYNOPHOTO_ROOT . '/photo_new/images/' . $template.'/logo_ps6.png';
		} else {
		    $logo_file = SYNOPHOTO_ROOT . '/images/' . $template.'/ps_logo.png';
		}
	}else if ($logo == '0') {
		$logo_file = SYNOTHEME_SPACER_FILE;
	} else if ($mode == 'theme'){
		$logo_file = SYNOTHEME_LOGO_CUSTOM_FILE;
	} else if ($mode == 'theme_swp'){
		$logo_file = SYNOTHEME_LOGO_CUSTOM_PREVIEW_FILE;
	}
	SYNOTHEME_READ_PIC($logo_file, FALSE);

}

function SYNOTHEME_GET_BANNER_PIC($mode,$type)
{
	if ($mode == 'theme'){
		$banner_file = SYNOTHEME_BANNER_CUSTOM_FILE;
	} else if ($mode == 'theme_swp'){
		$banner_file = SYNOTHEME_BANNER_CUSTOM_PREVIEW_FILE;
	}

	SYNOTHEME_READ_PIC($banner_file, FALSE);
}

function SYNOTHEME_GET_BKG_PIC($mode, $type)
{
	$show_bkg_img_key = 'photo' === $type ? 'v6_show_bkg_img' : 'show_bkg_img';
	if (null == $show_bkg_img =  csSYNOPhotoMisc::GetConfigDB($mode, $show_bkg_img_key, $type . '_config')) {
		csSYNOPhotoMisc::UpdateConfigDB('theme', $show_bkg_img_key, '3', $type . '_config');
		$show_bkg_img = '3';
	}

	if (strstr($show_bkg_img, 'action=bkg')){
		$show_bkg_img =  csSYNOPhotoMisc::GetConfigDB('theme', $show_bkg_img_key, $type . '_config');
	}

	if ('1' == $show_bkg_img) {
		SYNOTHEME_READ_PIC(SYNOTHEME_BKG_SYNO_FILE);
	} else if ('4' == $show_bkg_img) {
		SYNOTHEME_READ_PIC(SYNOTHEME_BKG_PS_FILE);
	} else if ('3' == $show_bkg_img) {
		SYNOTHEME_READ_PIC(SYNOTHEME_BKG_DEFAULT_FILE);
	} else if ('2' == $show_bkg_img) {
		// Fixed bug #27044 Rename SYNOTHEME_BKG_CUSTOM_FILE between DSM 3.2 beta and DSM 3.2 release
		if (!file_exists(SYNOTHEME_BKG_CUSTOM_FILE) && file_exists(preg_replace('/jpg/', 'png', SYNOTHEME_BKG_CUSTOM_FILE))) {
			@rename(preg_replace('/jpg/', 'png', SYNOTHEME_BKG_CUSTOM_FILE), SYNOTHEME_BKG_CUSTOM_FILE);
			@rename(preg_replace('/\.jpg\./', '.png.', SYNOTHEME_BKG_CUSTOM_THUMB_FILE), SYNOTHEME_BKG_CUSTOM_THUMB_FILE);
			SYNOTHEME_COPY_FILE(SYNOTHEME_BKG_CUSTOM_THUMB_FILE, SYNOTHEME_BKG_CUSTOM_TEMP_THUMB_BIG_FILE);
		}// End
		SYNOTHEME_READ_PIC(SYNOTHEME_BKG_CUSTOM_FILE);
	} else if ('0' == $show_bkg_img) {
		SYNOTHEME_READ_PIC(SYNOTHEME_SPACER_FILE, false);
	} else if (strstr($show_bkg_img, 'preview_bkg_custom')) {
		SYNOTHEME_READ_PIC(SYNOTHEME_BKG_CUSTOM_PREVIEW_FILE, false);
	} else if (strstr($show_bkg_img, 'preview_bkg_none')) {
		SYNOTHEME_READ_PIC(SYNOTHEME_SPACER_FILE, false);
	} else if (strstr($show_bkg_img, 'Pattern')) {
		SYNOTHEME_READ_PIC(SYNOPHOTO_ROOT . preg_replace('/.*\/photo/','',$show_bkg_img), false);
	} else if (strstr($show_bkg_img, 'http')) {
		SYNOTHEME_READ_PIC(preg_replace('/bg_thumb/', 'bg', $show_bkg_img), false);
	} else if (strstr($show_bkg_img, '/photo/images/01.jpg')) {
		SYNOTHEME_READ_PIC(SYNOTHEME_BKG_DEFAULT_FILE);
	} else if (strncmp($show_bkg_img, 'photo_', 5) == 0) {
		SYNOTHEME_READ_PIC(SYNOTHEME_BKG_PS_PREVIEW_FILE);
	}
}


function SYNOTHEME_READ_PIC($filename, $useCache = TRUE)
{
	if (!strstr($filename, 'http') && !file_exists($filename)) {
		$filename = SYNOTHEME_SPACER_FILE;
	}

	if(!@fopen($filename,'r')) {
		$filename = SYNOTHEME_SPACER_FILE;
	}

	if (null != $header = SYNOTHEME_GET_HEADER_PIC_Get_Mime_Type($filename)) {
		$signature = SYNOTHEME_MISC_CreateSig($filename);
		@header("Content-type: ".$header);
		@header("Content-Disposition: inline; filename=".addslashes('synotheme.php'));

		if ($useCache)	{
			@header("Cache-Control: max-age=".(3600*24*7));
		} else {
			@header("Pragma: no-cache");
			@header("Expires: -1");
			@readfile($filename);
			return;
		}
		if($signature) {

			SYNOTHEME_MISC_CheckSigExit($signature);
			@header("ETag: ".$signature[0]);
			@header("Last-Modified: ".$signature[1]);
		}

		@readfile($filename);
	}
}


function SYNOTHEME_GET_HEADER_PIC_Get_Mime_Type($filename)
{
	$path_parts = pathinfo($filename);
	$extension = strtolower($path_parts['extension']);

	$file_types  = array(
		'jpg'   =>  'image/jpeg',
		'jpeg'  =>  'image/jpeg',
		'bmp'   =>  'image/bmp',
		'gif'   =>  'image/gif',
		'png'   =>  'image/png'
	);

	if(array_key_exists($extension, $file_types)) {
		return $file_types[$extension];
	} else {
		return null;
	}
}
function SYNOTHEME_MISC_CreateSig($path)
{
	$filest = @stat($path);
	$etag = "";
	if($filest != FALSE) {
		$etag = md5($path.$filest[1].$filest[9]);
		$lastmod = gmdate('D, d M Y H:i:s', $filest[9]) . ' GMT';
		return array($etag, $lastmod);
	}
	else {
		return FALSE;
	}
}

function SYNOTHEME_MISC_CheckSigExit($signature)
{
	$etag = $signature[0];
	$lastmod = $signature[1];
	$headers = apache_request_headers();
	$token = $headers['If-None-Match'];
	if($token && ($token == $etag)) {
		@header("HTTP/1.1 304 Not Modified");
		exit;
	}
	if(isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])) {
		$ims = preg_replace('/;.*$/', '', $_SERVER['HTTP_IF_MODIFIED_SINCE'] );
		if($ims == $lastmod) {
			@header("HTTP/1.1 304 Not Modified");
			exit;
		}
	}
}
/* Read image functions end */

function SYNOTHEME_ACTION_ERROR()
{
	$result['success'] = false;
	$result['message'] = 'Action command error.';
	return json_encode($result);
}

function SYNOBLOG_IMG_GetAlbumPattern()
{
	if (!$dir_handle = opendir('../images/Pattern')){
		$files['sucess'] = false;
		return json_encode($files);
	}

	$files = array();
	$i = 0;
	while ($file = readdir($dir_handle)) {
		$extension = strtolower(substr(strrchr($file, '.'), 1));
		if ($extension == "png" || $extension == "jpg" ) {
			$files['images'][$i]['name'] = SYNOPHOTO_URL_PREFIX . '/photo/images/Pattern/' . $file;
			$files['images'][$i]['id'] = $i;
			$files['images'][$i]['type'] = 'img-pattern-view';
			$i++;
		}
	}
	closedir($dir_handle);
	return json_encode($files);
}

?>
