<?php
/*!
 * album list operation
 */
class csSYNOPhotoAlbum {
	/*! reference to db handler */
	private $_dbh;
	private $escapeStr = '';
	/*! reference to a self instance */
	private static $instance = null;
	/*! convert type condition to query video_convert table */
	private static $video_convert_type_condition;
	/*!
	/*!
	 * Constructor
	 */
	function __construct()
	{
		$this->_dbh = csSYNOPhotoDB::GetDBInstance()->_dbh;
		$this->escapeStr = csSYNOPhotoDB::GetDBInstance()->escapeStr;

		if (isSet($_REQUEST['client']) && $_REQUEST['client'] == SYNOPHOTO_UPLOAD_CLIENT_IPHONE) {
			$this->video_convert_type_condition =' AND path in (SELECT video_path FROM video_convert WHERE convert_type=\'MOBILE_COMMON\' OR convert_type=\'IPHONE\') ';
		} else if (isSet($_REQUEST['client']) && $_REQUEST['client'] == SYNOPHOTO_UPLOAD_CLIENT_ANDROID) {
			$this->video_convert_type_condition =' AND path in (SELECT video_path FROM video_convert WHERE convert_type=\'MOBILE_COMMON\' OR convert_type=\'ANDROID_UPLOAD\') ';
		}
	}
	/*!
	 * Get a exist instance
	 */
	static function GetAlbumInstance()
	{
		if (null === self::$instance) {
			self::$instance = new self;
		}
		return self::$instance;
	}
	/*!
	 * Get the user-defined album cover for the sub-dir $albumName
	 *
	 * \param $albumName the sub-dir album name
	 * \return cover file path
	 */
	private function GetSubAlbumCover($albumName)
	{
		$result = '';

		$fullDirPath = sprintf("%s/%s", SYNOPHOTO_SERVICE_DIR, $albumName);
		if (false === SYNOPhotoEA::checkFilePath($fullDirPath, SYNOPhotoEA::FILE_ALBUM_COVER, $coverFile)) {
			return '';
		}
		if (false === ($result = @file_get_contents($coverFile))) {
			return '';
		}

		$cover_path = trim(SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}/".$result);

		if (!@is_file($cover_path)) {
			return '';
		}

		if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches)){
			$cover_path = "{$albumName}/".$result;
		}
		$row = array();
		if (csSYNOPhotoMisc::IsPhotoFile($cover_path)) {
			$query = "SELECT path,resolutionx,resolutiony,version FROM photo_image WHERE path= ?";
			$sqlParam = array($cover_path);
			$dbPhotoResult = $this->_dbh->prepare($query);
			$tt = $dbPhotoResult->execute($sqlParam);
			if($row = $dbPhotoResult->fetch()) {
				$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			}
		} else {
			$query = "SELECT path,resolutionx,resolutiony FROM video WHERE path=?";
			$sqlParam = array($cover_path);
			$dbPhotoResult = $this->_dbh->prepare($query);
			$dbPhotoResult->execute($sqlParam);
			if($row = $dbPhotoResult->fetch()) {
				$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			}
		}
		return $row;
	}
	/*!
	 * pick the latest upload image in the album as cover
	 *
	 * \param $albumName the album name
	 * \return cover file path
	 */
	private function GetAlbumCoverLatestUpload($albumName)
	{
		$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$queryAll = "SELECT path,resolutionx,resolutiony,version FROM photo_image WHERE path LIKE ? {$this->escapeStr} ORDER BY create_time DESC LIMIT 1";
		$queryVideoAll = "SELECT path,resolutionx,resolutiony FROM video WHERE path LIKE ? {$this->escapeStr} ".$this->video_convert_type_condition.' ORDER BY date DESC LIMIT 1';
		$sqlParam = array("{$albumRealPath}/%", "{$albumRealPath}/%/%");
		$result = '';

		$latestFile = csSYNOPhotoMisc::GetSubDirFile($albumName);
		if (!empty($latestFile)) {
			return $latestFile;
		}

		/* no photo or video in the album*/
		/* search each sub-dir for top album */
		if (false === strpos($albumName, '/')) {
			$unsortedDirList = csSYNOPhotoMisc::GetSubDir($albumName, true);
			$dirList = array_keys($unsortedDirList);
			foreach ($dirList as $album) {
				if (!csSYNOPhotoMisc::CheckAlbumAccessible($album)) {
					continue;
				}
				$result = $this->GetAlbumCoverLatestUpload($album);
				if (!empty($result)) {
					break;
				}
			}
			return $result;
		}

		/* pick one photo in the album and its sub-dir */
		$dbPhotoResult = $this->_dbh->prepare($queryAll);
		$dbPhotoResult->execute(array($sqlParam[0]));
		if($row = $dbPhotoResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			return $row;
		}

		$dbVideoResult = $this->_dbh->prepare($queryVideoAll);
		$dbVideoResult->execute(array($sqlParam[0]));
		if($row = $dbVideoResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
		}
		return $row;
	}

	/*!
	 * Get cover for album $albumName
	 *
	 * \param $albumName the album name
	 * \return array with cover info
	 *	- src: cover file path
	 *	- width: cover width
	 *	- height: cover height
	 */
	function GetAlbumCover($albumName)
	{
		$album = csSYNOPhotoDB::GetDBInstance()->GetAlbum($albumName);
		/* get user-defined cover */
		$coverFile = $this->GetSubAlbumCover($albumName);

		if (!empty($coverFile)) {
			$filePath = csSYNOPhotoMisc::GetThumbPathFromFullPath($coverFile['path'], SYNOPHOTO_THUMBMEDIUM, false);
			$isPhotoFileWithThumb = csSYNOPhotoMisc::IsPhotoFileWithThumb($coverFile['path']);
			if (!$isPhotoFileWithThumb) {
				$filePath = $coverFile['path'];
			}
			if (!@file_exists($filePath) || !csSYNOPhotoMisc::CheckPathAccessible($coverFile['path'])) {
				$coverFile = '';
			}
		}

		/* use latest upload photo as cover */
		if (empty($coverFile)) {
			$coverFile = $this->GetAlbumCoverLatestUpload($albumName);
		}

		/* use empty image */
		$result['bigCover'] = array();
		$result['cover'] = array();
		if (isSet($album) && $album['password'] != $_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName]) {
            $result['coverPath'] = '';
			$result['bigCover']['src'] = SYNOPHOTO_IMG_PASSWORD;
			$imageInfoCover = @getImageSize(SYNOPHOTO_IMG_PASSWORD_FILE_PATH);
			$result['bigCover']['width'] = $imageInfoCover[0];
			$result['bigCover']['height'] = $imageInfoCover[1];
			$result['cover']['src'] = SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY;
			$result['cover']['width'] = $imageInfoCover[0];
			$result['cover']['height'] = $imageInfoCover[1];
			$result['xLargeThumb']['src'] = SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY;
			$result['xLargeThumb']['width'] = $imageInfoCover[0];
			$result['xLargeThumb']['height'] = $imageInfoCover[1];
		} else if (empty($coverFile)) {
            $result['coverPath'] = '';
			$result['bigCover']['src'] = SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY;
			$imageInfoCover = @getImageSize(SYNOPHOTO_IMG_EMPTY_FILE_PATH_HIGH_QUALITY);
			$result['bigCover']['width'] = $imageInfoCover[0];
			$result['bigCover']['height'] = $imageInfoCover[1];
			$result['cover']['src'] = SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY;
			$result['cover']['width'] = $imageInfoCover[0];
			$result['cover']['height'] = $imageInfoCover[1];
			$result['xLargeThumb']['src'] = SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY;
			$result['xLargeThumb']['width'] = $imageInfoCover[0];
			$result['xLargeThumb']['height'] = $imageInfoCover[1];
		} else if (is_array($coverFile) && isSet($coverFile['version'])) {
			// thumb is from photo file
            $result['coverPath'] = $coverFile['path'];
			$result['bigCover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBMEDIUM, $coverFile['resolutionx'], $coverFile['resolutiony'], $coverFile['version']);
			$result['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBSMALL, $coverFile['resolutionx'], $coverFile['resolutiony'], $coverFile['version']);
			$result['xLargeThumb'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBXLARGE, $coverFile['resolutionx'], $coverFile['resolutiony'], $coverFile['version']);
		} else if (is_array($coverFile) && !isSet($coverFile['version'])) {
			// thumb is from video file
            $result['coverPath'] = $coverFile['path'];
			$result['bigCover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBMEDIUM, $coverFile['resolutionx'], $coverFile['resolutiony']);
			$result['cover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBSMALL, $coverFile['resolutionx'], $coverFile['resolutiony']);
			$result['xLargeThumb'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBXLARGE, $coverFile['resolutionx'], $coverFile['resolutiony'], $coverFile['version']);
		}else {
            $result['coverPath'] = $coverFile['path'];
			$result['bigCover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile, SYNOPHOTO_THUMBMEDIUM, 0, 0, -1);
			$result['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile, SYNOPHOTO_THUMBSMALL, 0, 0, -1);
			$result['xLargeThumb'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile, SYNOPHOTO_THUMBXLARGE, 0, 0, -1);
		}
        
		return $result;
	}

	/*!
	 * Get # of photos in the album after layer 2
	 * Do not need to check priviledge of user when getting number of photos of albums after layer 2.
	 * \param $albumName the album name
	 * \return the # of photos and videos
	 */
	function GetNumberOfPhotosAtAlbumsAfterLayer2($albumName)
	{
		$sqlParam = array();
		$sqlParamCount = 0;
		$sqlParam1Index = ++$sqlParamCount;
		$query = 'SELECT count(*) FROM photo_image WHERE (path LIKE ?)';
		$queryVideo = 'SELECT count(*) FROM video WHERE ((path LIKE ?)';

		$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR."/{$albumName}");
		$sqlParam[] = "{$albumRealPath}/%";

		$dbResult = $this->_dbh->prepare($query);
		$dbResult->execute($sqlParam);

		$dbVideoResult = $this->_dbh->prepare($queryVideo.' )'.$this->video_convert_type_condition);
		$dbVideoResult->execute($sqlParam);

		$row = $dbResult->fetch();
		$photoCount = $row[0];
		$row = $dbVideoResult->fetch();
		$videoCount = $row[0];

		return $photoCount + $videoCount;
	}
	/*!
	 * Get # of photos in the album
	 *
	 * \param $albumName the album name
	 * \param $isIncludeSubDir the # of photos include all sub-dir or not
	 * \return the # of photos and videos
	 */
	function GetNumberOfPhotos($albumName, $isIncludeSubDir)
	{
		$result = array(true => false, false => false);
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['photoNum_cache'][$albumName])) {
			$counted = $_SESSION[SYNOPHOTO_ADMIN_USER]['photoNum_cache'][$albumName];
			$result[true] = isSet($counted[true]) ? $counted[true] : false;
			$result[false] = isSet($counted[false]) ? $counted[false] : false;
		}
		if (false !== $result[$isIncludeSubDir]) {
			return $result[$isIncludeSubDir];
		}

		// count for photo & video
		$sqlParam = array();
		$sqlParamCount = 0;
		$sqlParam1Index = ++$sqlParamCount;
		$sqlParam2Index = ++$sqlParamCount;
		$query = "SELECT count(*) FROM photo_image WHERE (path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr})";
		$queryVideo = "SELECT count(*) FROM video WHERE ((path LIKE ? {$this->escapeStr} AND path NOT LIKE ? {$this->escapeStr})";
		$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$albumName}");
		$sqlParam[] = "{$albumRealPath}/%";
		$sqlParam[] = "{$albumRealPath}/%/%";
		if (!$isIncludeSubDir) {
			/* # of photos in the album */
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);
			$dbVideoResult = $this->_dbh->prepare($queryVideo.' )'.$this->video_convert_type_condition);
			$dbVideoResult->execute($sqlParam);
		} else {
			/* # of photos in all albums in the album */
			$condition = array('sharename' => array('op' => 'PREFIX', 'value' => $albumName.'/'));
			$albums = csSYNOPhotoDB::GetDBInstance()->GetAlbums($condition);
			foreach ($albums as $item) {
				$sqlParamIndex = ++$sqlParamCount;
				$itemRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
				$query .= " OR path LIKE ? {$this->escapeStr}";
				$queryVideo.= " OR path LIKE ? {$this->escapeStr}";
				$sqlParam[] = "{$itemRealPath}/%";
			}
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);

			$dbVideoResult = $this->_dbh->prepare($queryVideo.' )'.$this->video_convert_type_condition);
			$dbVideoResult->execute($sqlParam);
		}
		$row = $dbResult->fetch();
		$photoCount = $row[0];
		$row = $dbVideoResult->fetch();
		$videoCount = $row[0];

		$result[$isIncludeSubDir] = $photoCount + $videoCount;
		$_SESSION[SYNOPHOTO_ADMIN_USER]['photoNum_cache'][$albumName] = $result;
		return $result[$isIncludeSubDir];
	}
	/*!
	 * Check if album is uploadable by current login user
	 *
	 * \param $albumName album name
	 * \return true if the album is uploadable for the user
	 */
	function IsAlbumUploadable($albumName)
	{
		if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			return true;
		}

		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
			return false;
		}

		$sharename = $albumName;
		if (strstr($sharename, '/')) {
			$arr = explode('/', $sharename);
			$sharename = $arr[0] . '/' . $arr[1];
		}
		return isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['uploadable_album'][$sharename]);
	}

	/*!
	 * Get album information
	 *
	 * \param $albumName album name
	 * \return array with album info
	 *	- name: folder name
	 *	- title: user-defined title
	 *	- description: user-defined description
	 *	- hits: album hits
	 *	- showTitle: title or name when title is empty
	 *	- photos: # of photos in all alubms in the album
	 *	- link: link to browse the album
	 */
	function GetAlbumInfo($albumName)
	{
		$item = csSYNOPhotoDB::GetDBInstance()->GetAlbum($albumName);
		$result['name'] = $item['sharename'];
		$result['title'] = $item['title'];
		$result['desc'] = $item['description'];
		$result['isPublic'] = $item['public'];
		$result['hit'] = $item['hits'];
		$result['photos'] = 0;//for DSM bug#21213
		$tok = explode('/', $albumName);
		$result['dirName'] = $tok[count($tok) - 1];
		$result['showTitle'] = htmlspecialchars(empty($result['title']) ? $result['dirName'] : $result['title'], ENT_QUOTES);
		$result['dir'] = bin2hex($albumName);
		if (isSet($item) && $item['password'] != $_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName]) {
			$result['url'] = "javascript:onEnterPassword('".$result['dir']."');";
		} else {
			$result['url'] = 'photo_thumb.php?dir='.$result['dir'];
		}
		if ($item['password'] !='') {
			$result['needPassword'] = true;
		}
		$result['uploadable'] = $this->IsAlbumUploadable($albumName);

		return $result;
	}
	/*!
	 * Get mos recentalbum information
	 *
	 * \param $source most recent source. Photo or video.
	 * \return array with album info
	 *	- name: folder name
	 *	- title: user-defined title
	 *	- description: user-defined description
	 *	- hits: album hits
	 *	- showTitle: title or name when title is empty
	 *	- photos: # of photos in all alubms in the album
	 *	- link: link to browse the album
	 */
	function GetMostRecentAlbumInfo($source, $isRecentComment = false)
	{
		if ('photo' == $source) {
			if (!$isRecentComment) {
				$title = __(photo_str_recent_photo);
				$result['url'] = 'photo_thumb.php?virtual_album=0';
				$result['dir'] = 'v0';
			} else {
				$title = __(photo_str_recent_commented_photo);
				$result['url'] = 'photo_thumb.php?virtual_album=2';
				$result['dir'] = 'v2';
			}
		} else {
			if (!$isRecentComment) {
				$title = __(photo_str_recent_video);
				$result['url'] = 'photo_thumb.php?virtual_album=1';
				$result['dir'] = 'v1';
			} else {
				$title = __(photo_str_recent_commented_video);
				$result['url'] = 'photo_thumb.php?virtual_album=3';
				$result['dir'] = 'v3';
			}
		}
		$result['name'] = '';
		$result['title'] = $title;
		$result['desc'] = '';
		$result['isPublic'] = TRUE;
		$result['hit'] = 0;
		$result['dirName'] = '';

		$result['showTitle'] = $title;
		$result['uploadable'] = FALSE;
		$result['isVirtual'] = true;

		return $result;
	}

	function GetLabelAlbumInfoFirst($category)
	{
		switch ($category) {
			case 0:
				$title = __('photo_str_person_label');
				$result['url'] = 'photo_thumb.php?virtual_album=4';
				$result['dir'] = 'v4';
				break;
			case 1:
				$title = __('photo_str_place_label');
				$result['url'] = 'photo_thumb.php?virtual_album=5';
				$result['dir'] = 'v5';
				break;
			case 2:
				$title = __('photo_str_general_label');
				$result['url'] = 'photo_thumb.php?virtual_album=6';
				$result['dir'] = 'v6';
				break;
		}
		$result['name'] = '';
		$result['title'] = $title;
		$result['desc'] = '';
		$result['isPublic'] = TRUE;
		$result['hit'] = 0;
		$result['dirName'] = '';

		$result['showTitle'] = $title;
		$result['uploadable'] = FALSE;
		$result['isVirtual'] = true;
		$result['isLabelVirtual'] = true;

		return $result;
	}

	function GetLabelAlbumInfo($category, $tagName, $id)
	{
		$title = $tagName;
		$result['url'] = 'photo_thumb.php?virtual_album='.($category + 4).'&id='.$id;
		$result['dir'] = $id;
		$result['name'] = '';
		$result['title'] = $title;
		$result['desc'] = '';
		$result['isPublic'] = TRUE;
		$result['hit'] = 0;
		$result['dirName'] = '';

		$result['showTitle'] = htmlspecialchars($title, ENT_QUOTES);
		$result['uploadable'] = FALSE;
		$result['isVirtual'] = true;
		$result['isLabelVirtual'] = true;

		return $result;
	}

	function GetLabelAlbumCoverFromDB($id)
	{
		$sqlParam = array();
		if (-1 == $id) {
			$photoQuery = "SELECT path, resolutionx, resolutiony, version FROM photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id WHERE photo_image_label.status='f' ORDER BY photo_image.create_time DESC LIMIT 1";
			$dbPhotoResult = $this->_dbh->prepare($photoQuery);
			$tt = $dbPhotoResult->execute($sqlParam);
			if($row = $dbPhotoResult->fetch()) {
				$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
				return $row;
			}
			return null;
		}

		$photoQuery = "SELECT path, resolutionx, resolutiony, version FROM photo_image_label LEFT JOIN photo_image ON photo_image_label.image_id=photo_image.id WHERE photo_image_label.label_id=? AND photo_image_label.status='t'";
		$videoQuery = "SELECT path, resolutionx, resolutiony FROM photo_video_label LEFT JOIN video ON photo_video_label.video_path=video.path WHERE photo_video_label.label_id=? ";

		$sqlParam[] = $id;
		if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$albumCondition = csSYNOPhotoMisc::GetAccessibleAlbumQueryCondition();
			if(count($albumCondition['albumCond']) > 0) {
				$photoQuery .= " AND (".implode(' OR ', $albumCondition['albumCond']).' )';
				$videoQuery .= ' AND ('.implode(' OR ', $albumCondition['albumCond']).' )';
				$sqlParam = array_merge($sqlParam, $albumCondition['sqlParam']);
			} else {
				return null;
			}
		}

		$photoQuery .= " ORDER BY photo_image.create_time DESC LIMIT 1";
		$videoQuery .= " ORDER BY video.date DESC LIMIT 1";

		$dbPhotoResult = $this->_dbh->prepare($photoQuery);
		$tt = $dbPhotoResult->execute($sqlParam);
		if($row = $dbPhotoResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			return $row;
		}

		$dbPhotoResult = $this->_dbh->prepare($videoQuery);
		$tt = $dbPhotoResult->execute($sqlParam);
		if($row = $dbPhotoResult->fetch()) {
			$row['path'] = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
			return $row;
		}
		return null;
	}

	function GetLabelAlbumCover($id)
	{
		$coverFile = $this->GetLabelAlbumCoverFromDB($id);
		$result = null;
		if (-1 == $id && empty($coverFile)) {
            $result['coverPath'] = '';
			return $result;
		} else if (empty($coverFile)) {
            $result['coverPath'] = '';
			$result['bigCover']['src'] = SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY;
			$imageInfoCover = @getImageSize(SYNOPHOTO_IMG_EMPTY_FILE_PATH_HIGH_QUALITY);
			$result['bigCover']['width'] = $imageInfoCover[0];
			$result['bigCover']['height'] = $imageInfoCover[1];
			$result['cover']['src'] = SYNOPHOTO_IMG_EMPTY_HIGH_QUALITY;
			$result['cover']['width'] = $imageInfoCover[0];
			$result['cover']['height'] = $imageInfoCover[1];
		} else if (is_array($coverFile) && isSet($coverFile['version'])) {
			// thumb is from photo file
            $result['coverPath'] = $coverFile['path'];
			$result['bigCover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBMEDIUM, $coverFile['resolutionx'], $coverFile['resolutiony'], $coverFile['version']);
			$result['cover'] = csSYNOPhotoMisc::GetThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBSMALL, $coverFile['resolutionx'], $coverFile['resolutiony'], $coverFile['version']);
		} else if (is_array($coverFile) && !isSet($coverFile['version'])) {
			// thumb is from video file
            $result['coverPath'] = $coverFile['path'];
			$result['bigCover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBMEDIUM, $coverFile['resolutionx'], $coverFile['resolutiony']);
			$result['cover'] = csSYNOPhotoMisc::GetVideoThumbInfoFromFullPath($coverFile['path'], SYNOPHOTO_THUMBSMALL, $coverFile['resolutionx'], $coverFile['resolutiony']);
		}

		return $result;
	}
	/*!
	 * add album hit times
	 *
	 * \param $albumName album name
	 */
	function AddHitTimes($albumName)
	{
		/* hit one time for each session */
		if (!in_array($albumName, $_SESSION[SYNOPHOTO_ADMIN_USER]['accessed_albums'], true)) {
			array_push($_SESSION[SYNOPHOTO_ADMIN_USER]['accessed_albums'], $albumName);
			$query = "UPDATE photo_share SET hits=hits+1 WHERE sharename=?";
			$sqlParam = array($albumName);
			$dbResult = $this->_dbh->prepare($query);
			$dbResult->execute($sqlParam);
			$albumInfo = csSYNOPhotoDB::GetDBInstance()->GetAlbum($albumName);
			if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']) && ('f' == $albumInfo['public'] || false == $albumInfo['public'])) {
				$msg = "{$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']} accessed photo album [".htmlspecialchars($albumName).']';
				csSYNOPhotoDB::GetDBInstance()->AddPhotoLog($msg, 1, $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']);
			}
		}
	}
	/*!
	 * edit album's property
	 *
	 * \param $shareName album share name
	 * \param $title album's new title
	 * \param $description album's new description
	 * \param $public album's new is public property. 't' for true, 'f' for false
	 */
	function EditAlbumProperty($shareName, $title, $description)
	{
		$result = csSYNOPhotoDB::GetDBInstance()->UpdateAlbumProperty($shareName, $title, $description);
		// flush the cache since album property has been changed
		csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
		return $result;
	}

	/*!
	 * get link to the picture on photo station
	 *
	 * \param $path file path
	 */
	function GetAlbumUrlLink($path)
	{
		$pos = strrpos($path, '/');
		$dir = substr($path, 0, $pos);
		$dir = substr($dir, strlen(SYNOPHOTO_SERVICE_REAL_DIR.'/'));

		$result = SYNOPHOTO_URL_PREFIX.'/photo/photo_one.php?';
		$result = $result.'name='.bin2hex(basename($path)).'&dir='.bin2hex($dir);
		return $result;
	}

	function GetAlbumThumbSortType($albumName)
	{
		$result = '';

		if ('/' === $albumName) {
			$fullDirPath = SYNOPHOTO_SERVICE_REAL_DIR;
			$sortFile = $fullDirPath . '/' . SYNOPhotoEA::SYNO_EA_DIR . '/' . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_ALBUM_SORT);
		} else {
			$fullDirPath = sprintf("%s/%s", SYNOPHOTO_SERVICE_REAL_DIR, $albumName);
			if (false === SYNOPhotoEA::checkFilePath($fullDirPath, SYNOPhotoEA::FILE_ALBUM_SORT, $sortFile)) {
				return '';
			}
		}
		if (false === ($result = @file_get_contents($sortFile))) {
			return '';
		}

		$result = json_decode($result, true);
		if (empty($result)) {
			return '';
		}
		return $result;
	}

	function SaveAlbumThumbSortType($albumName, $data, $forcedOverrideList = false)
	{
		$result = '';
		if ('/' === $albumName) {
			$fullDirPath = SYNOPHOTO_SERVICE_REAL_DIR;
		} else {
			$fullDirPath = sprintf("%s/%s", SYNOPHOTO_SERVICE_REAL_DIR, $albumName);
		}

		$newData = $this->GetAlbumThumbSortType($albumName);
		if (isSet($data['type'])) {
			$newData['type'] = $data['type'];
		}
		if (isSet($data['order'])) {
			$newData['order'] = $data['order'];
		}
		if (isSet($data['list']) && !empty($data['list'])) {
			$newData['list'] = $data['list'];
		} else if ($forcedOverrideList) {
			$newData['list'] = array();
		}

		if (SYNOPHOTO_SERVICE_REAL_DIR === $fullDirPath) {
			@mkdir(SYNOPHOTO_SERVICE_REAL_DIR . '/' . SYNOPhotoEA::SYNO_EA_DIR, 0777);
			$sortFile = SYNOPHOTO_SERVICE_REAL_DIR . '/' . SYNOPhotoEA::SYNO_EA_DIR . '/' . SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_ALBUM_SORT);
		} else {
			SYNOPhotoEA::createEADir($fullDirPath, $eaDir);
			$sortFile = SYNOPhotoEA::getFilePath($fullDirPath, SYNOPhotoEA::FILE_ALBUM_SORT);
		}
		file_put_contents($sortFile, json_encode($newData));
	}
}
?>
