<?php
require_once(dirname(__FILE__).'/../syno_conf.php');

if (isSet($type) && $type !== 'blog') {
	if (preg_match('/^(add_album)$/', $_POST['action'])) {
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
			csSYNOPhotoMisc::CheckUserTimeOut();
		} else {
			csSYNOPhotoMisc::CheckAdminTimeOut();
		}
	} else {
		csSYNOPhotoMisc::CheckAdminTimeOut();
	}
}

if(isset($_POST['node'])) {//get album tree data
	echo SYNOPHOTO_ADMIN_GetAlbumTreeData();
	exit;
}

if($_POST['action'] == 'get_album_data') {
	echo SYNOPHOTO_ADMIN_GetAlbumData($_POST['sharename']);
} else if($_POST['action'] == 'update_album') {
	echo SYNOPHOTO_ADMIN_UpdateAlbum($_POST['sharename']);
} else if($_POST['action'] == 'add_album') {
	echo SYNOPHOTO_ADMIN_AddAlbum($_POST['sharename']);
} else if($_POST['action'] == 'add_smart_album') {
	echo SYNOPHOTO_ADMIN_AddSmartAlbum();
} else if ($_POST['action'] == 'load_smart_album_config') {
	echo SYNOPHOTO_ADMIN_LoadSmartAlbumConfig();
} else if($_POST['action'] == 'edit_smart_album') {
	echo SYNOPHOTO_ADMIN_EditSmartAlbum();
} else if($_POST['action'] == 'delete_smart_album') {
	echo SYNOPHOTO_ADMIN_DeleteSmartAlbum();
} elseif($_POST['action'] == 'delete_album'){
	echo SYNOPHOTO_ADMIN_DeleteAlbums();
} elseif($_POST['action'] == 'move_album'){
	echo SYNOPHOTO_ADMIN_MoveAlbums();
} elseif($_POST['action'] == 'delete_items'){
	echo SYNOPHOTO_ADMIN_DeleteItems();
} elseif($_POST['action'] == 'move_items'){
	echo SYNOPHOTO_ADMIN_MoveItems();
} elseif($_POST['action'] == 'copy_items'){
	echo SYNOPHOTO_ADMIN_CopyItems();
} elseif($_POST['action'] == 'copy_to_blog'){
	echo SYNOPHOTO_ADMIN_BlogImageCopy();
} elseif($_POST['action'] == 'delete_one'){
	$is_photo = ($_POST['type'] == 'image')? 1:0;
	$result['success'] = SYNOPHOTO_ADMIN_DeleteItemById($_POST['id'], $is_photo);
	$result['del_labels'] = SYNOPHOTO_LABEL_UTIL_Check_Photo_Label();
	echo json_encode($result);
}

function SYNOPHOTO_ADMIN_GetAlbumData($sharename)
{
	$result['success'] = false;
	if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		return json_encode($result);
	}
	if ('' === $sharename) {
		$sharename = '/';
	}
	$query = "Select * from photo_share where  sharename = '" .PHOTO_DB_EscapeParam($sharename). "'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if (!$row = PHOTO_DB_FetchRow($db_result)) {
		$result['data']['message'] = 'SQL Error';
		return json_encode($result);
	}

	$result['data']['title'] = $row['title'];
	$result['data']['description'] = $row['description'];
	$result['data']['allow_comment'] = PHOTO_DB_IsTrue($row['comment']);

	$result['data']['password'] = '';
	$result['data']['confirm_passwd'] = '';
	if ('' != $row['password']) { // is password
		$result['data']['privilege'] = 2;
		$result['data']['password'] = '12345678';
		$result['data']['confirm_passwd'] = '87654321';
	} else if (PHOTO_DB_ConvertBool($row['public']) == 't') { // is_public
		$result['data']['privilege'] = 0;
	} else {
		$result['data']['privilege'] = 1;
	}

	$result['data']['thumb_sort_type'] == -1;
	$result['data']['thumb_sort_order'] == 0;
	$result['hasSortPreference'] = false;
	$sortData = csSYNOPhotoAlbum::GetAlbumThumbSortType($sharename);
	if ($sortData !== '') {
		if (isSet($sortData['type'])) {
			$result['data']['thumb_sort_type'] = $sortData['type'];
		}
		if (isSet($sortData['order'])) {
			$result['data']['thumb_sort_order'] = $sortData['order'];
		}
		if (isSet($sortData['list']) && !empty($sortData['list'])) {
			$result['hasSortPreference'] = true;
		}
	}

	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_UpdateAlbum($sharename)
{
	$result['success'] = false;
	if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		return json_encode($result);
	}
	if ('' === $sharename) {
		$sharename = '/';
	}
	$query = "Select * from photo_share where sharename = ?";
	$sqlParam = array($sharename);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if ($row = PHOTO_DB_FetchRow($db_result)) {
		$shareid = $row['shareid'];
		$isPublic = ('t' == PHOTO_DB_ConvertBool($row['public']));
	} else {
		return json_encode($result);
	}

	$query = "Update photo_share set ";
	$query = $query."title = '".PHOTO_DB_EscapeParam(stripcslashes($_POST['title']))."', ";
	$query = $query."description = '".PHOTO_DB_EscapeParam(stripcslashes($_POST['description']))."', ";

	/* 0 for public, 1 for private, 2 for password */
	switch ($_POST['privilege']) {
		case 0:
			/* clear access right table if album is public */
			$query = $query."public = 't', password = '',";
			$query_access = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where shareid = ".$shareid;
			$db_result_access = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_access);

			/* add/delete self upload right */
			SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $_POST['add_upload_users'], PHOTO_UPLOAD_RIGHT_TABLE);
			SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $_POST['delete_upload_users'], PHOTO_UPLOAD_RIGHT_TABLE);
			/* add/delete self manage right */
			SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $_POST['add_manage_users'], PHOTO_MANAGE_RIGHT_TABLE);
			SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $_POST['delete_manage_users'], PHOTO_MANAGE_RIGHT_TABLE);
			/* add child browse, upload, manage rights for manager */
			SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $_POST['add_manage_users'], PHOTO_MANAGE_RIGHT_TABLE);
			SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $_POST['add_manage_users'], PHOTO_UPLOAD_RIGHT_TABLE);
			SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $_POST['add_manage_users'], PHOTO_ACCESS_RIGHT_TABLE);
			/* delete parent's manage right */
			SYNOPHOTO_ADMIN_DeleteParentRightBySharename($sharename, $_POST['delete_manage_users'], PHOTO_MANAGE_RIGHT_TABLE);
			break;
		case 1:
			$query = $query."public = 'f', password = '',";
			$add_access_users = SYNOPHOTO_ADMIN_PrivateAdjust($isPublic, $shareid);
			/* if public -> private, delete from auto, no need to update DB */
			$delete_access_users = $isPuiblic ? '' : $_POST['delete_access_users'];

			/* add/delete self browse right */
			SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $add_access_users, PHOTO_ACCESS_RIGHT_TABLE);
			SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $delete_access_users, PHOTO_ACCESS_RIGHT_TABLE);
			/* add/delete self upload right */
			SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $_POST['add_upload_users'], PHOTO_UPLOAD_RIGHT_TABLE);
			SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $_POST['delete_upload_users'], PHOTO_UPLOAD_RIGHT_TABLE);
			/* add/delete self manage right */
			SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $_POST['add_manage_users'], PHOTO_MANAGE_RIGHT_TABLE);
			SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $_POST['delete_manage_users'], PHOTO_MANAGE_RIGHT_TABLE);
			/* add child browse, upload, manage rights for manager */
			SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $_POST['add_manage_users'], PHOTO_MANAGE_RIGHT_TABLE);
			SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $_POST['add_manage_users'], PHOTO_UPLOAD_RIGHT_TABLE);
			SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $_POST['add_manage_users'], PHOTO_ACCESS_RIGHT_TABLE);
			/* delete parent's manage right */
			SYNOPHOTO_ADMIN_DeleteParentRightBySharename($sharename, $_POST['delete_manage_users'], PHOTO_MANAGE_RIGHT_TABLE);
			/* delete child's browse right */
			SYNOPHOTO_ADMIN_DeleteChildRightBySharename($sharename, $_POST['delete_access_users'], PHOTO_ACCESS_RIGHT_TABLE);
			break;
		case 2:
			$passwordStripe = SYNOPHOTO_ADMIN_CheckPasswordModify();
			$query = $query."public = 'f'," . $passwordStripe;
			/* remove all permissions if album is password */
			$query_access = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where shareid = ".$shareid;
			$db_result_access = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_access);
			$query_access = "Delete from " . PHOTO_UPLOAD_RIGHT_TABLE . " where shareid = ".$shareid;
			$db_result_access = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_access);
			$query_access = "Delete from " . PHOTO_MANAGE_RIGHT_TABLE . " where shareid = ".$shareid;
			$db_result_access = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_access);
			break;
	}

	if($_POST['allow_comment'] == 'on') {
		$query = $query."comment = 't' ";
	} else {
		$query = $query."comment = 'f' ";
	}

	if (isset($_POST['redirect_to_new']) && 'on' == $_POST['redirect_to_new']) {
		$result['url'] = SYNOPHOTO_URL_PREFIX.'/photo/photo_thumb.php?dir='.bin2hex($sharename);
	}

	$query = $query."where sharename = '".PHOTO_DB_EscapeParam($sharename)."'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	//sort
	$data = array();
	if (isSet($_POST['thumb_sort_type'])) {
		$data['type'] = $_POST['thumb_sort_type'];
	}
	if (isSet($_POST['thumb_sort_order'])) {
		$data['order'] = $_POST['thumb_sort_order'];
	}
	csSYNOPhotoAlbum::GetAlbumInstance()->SaveAlbumThumbSortType($sharename, $data);

	$result['title'] = htmlspecialchars(stripcslashes($_POST['title']), ENT_QUOTES);
	$result['description'] = htmlspecialchars(stripcslashes($_POST['description']), ENT_QUOTES);
	$result['sharename'] = $sharename;
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_CheckPasswordModify()
{
	if ('12345678' == $_POST['password'] && '87654321' == $_POST['confirm_passwd']) {
		return '';
	}
	return " password ='". md5($_POST['password']) ."', ";
}

function SYNOPHOTO_ADMIN_PrivateAdjust($isPublic, $shareid)
{
	if ($isPublic || '' == $_POST['add_access_users']) {
		return $_POST['add_access_users'];
	}

	$arr = explode(",", $_POST['add_access_users']);
	$add_users_arr = array();
	foreach ($arr as $userid) {
		$query = "Select * from " . PHOTO_ACCESS_RIGHT_TABLE . " where userid =".$userid." and shareid =".$shareid;
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		if (null == $row = PHOTO_DB_FetchRow($db_result)) {
			$add_users_arr[] = $userid;
		}
	}
	return join(",", $add_users_arr);
}


function SYNOPHOTO_ADMIN_AddAlbum ($parentAlbumName = '')
{
	$result['success'] = false;

	if ('' === $parentAlbumName) {
	   if (!csSYNOPhotoMisc::CheckAlbumUploadable('/')) {
	       return json_encode($result);
	   }
	} else if (!csSynoPhotoMisc::CheckAlbumUploadable($parentAlbumName)) {
		return json_encode($result);
	}

	$album_data = array();

	$album_name = stripcslashes($_POST['album_name']);
	$album_data['sharename'] = ($parentAlbumName == '') ? $album_name : $parentAlbumName.'/'.$album_name;
	$album_data['title'] = stripcslashes($_POST['title']);
	$album_data['description'] = stripcslashes($_POST['description']);
	$album_data['public'] = (isset($_POST['privilege']) &&  0 == $_POST['privilege']) ? 't' : 'f';
	$album_data['comment'] = (isset($_POST['allow_comment']) && 'on' == $_POST['allow_comment']) ? 't' : 'f';
	$album_data['is_subdir'] = ($parentAlbumName == '') ? 'f' : 't';
	$album_data['password'] = ( isset($_POST['password']) ) ? md5($_POST['password']) : '';

	$path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$album_data['sharename'];

	$ret = SYNOPHOTO_ADMIN_AddAlbumToDB($album_data, $path);
	if ('album existed' === $ret) {
		$result['success'] = 'album existed';
		$result['msg'] = __(photo_str_man_album_existed);
		return json_encode($result);
	} else {
		$result['sharename'] = $album_data['sharename'];
		$port = ($_SERVER['SERVER_PORT'] == 80)? '' : ":{$_SERVER['SERVER_PORT']}";
	}

	if (isset($_POST['redirect_to_new']) && 'on' == $_POST['redirect_to_new']) {
		$result['url'] = SYNOPHOTO_URL_PREFIX.'/photo/photo_thumb.php?dir='.bin2hex($album_data['sharename']);
	}

	//sort
	$data = array();
	if (isSet($_POST['thumb_sort_type'])) {
		$data['type'] = $_POST['thumb_sort_type'];
	}
	if (isSet($_POST['thumb_sort_order'])) {
		$data['order'] = $_POST['thumb_sort_order'];
	}
	csSYNOPhotoAlbum::GetAlbumInstance()->SaveAlbumThumbSortType($album_data['sharename'], $data);

	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_AddAlbumToDB($data = array(), $path, $forceInheritPrivilege=false)
{
	$sharename = PHOTO_DB_EscapeParam($data['sharename']);
	$title = PHOTO_DB_EscapeParam($data['title']);
	$desc  = PHOTO_DB_EscapeParam($data['description']);
	$password = PHOTO_DB_EscapeParam($data['password']);


	if(file_exists($path)) {
		$result = 'album existed';
		return $result;
	}

	$oldumask = umask(0);
	if(!($ret = @mkdir($path, 0777, true))) {
		return false;
	}
	umask($oldumask);

	$new_id = 0;

	$query = 'Select max(shareid) from photo_share';
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if($row = PHOTO_DB_FetchRow($db_result)) {
	    $new_id = $row[0]+1;
	} else {
	    return false;
	}

	$query = 'Insert into photo_share (shareid, sharename, title, description, public, comment, is_subdir, password) '
	    ."values ($new_id, '$sharename', '$title', '$desc', '{$data['public']}', '{$data['comment']}', '{$data['is_subdir']}', '$password')";
	if (false === ($db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query))) {
	    return false;
	}
	// If regualr user create second level album, we should do inheritAlbumPrivilege.
	if ($forceInheritPrivilege === true || 1 == csSYNOPhotoMisc::GetUserType()) {
	    $str = substr($data['sharename'], 0, strrpos($data['sharename'], '/'));
	    /* if add album in root, check the privilege of '/' */
	    if (false == $str) {
		    $str = '/';
	    }
	    $query = "SELECT shareid FROM photo_share WHERE sharename='".PHOTO_DB_EscapeParam($str)."'";
	    $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	    if($row = PHOTO_DB_FetchRow($db_result)) {
		$parentid = $row['shareid'];
	    }
	    csSYNOPhotoDB::GetDBInstance()->inheritAlbumPrivilege($parentid, $new_id);
	}

	@exec("/usr/syno/bin/synophotoio -a ".escapeshellarg($path));
	@exec("/usr/syno/bin/synoindex -a ".escapeshellarg($path));
	return $new_id;
}

function SYNOPHOTO_ADMIN_AddSmartAlbum()
{
	$returnJson = array(
		"success" => false
	);

	if (!isset($_POST['data'])) {
		csSYNOPhotoMisc::Synophoto_Log('post data NOT isset');
		return json_encode($returnJson);
	}

	$returnJson = SmartAlbum::AddSmartAlbum($_POST['data']);

	return $returnJson;
}

function SYNOPHOTO_ADMIN_LoadSmartAlbumConfig()
{
	$returnJson = array(
		"success" => false
	);

	if (!isset($_POST['data'])) {
		csSYNOPhotoMisc::Synophoto_Log('post data NOT isset');
		return json_encode($returnJson);
	}

	$returnJson = SmartAlbum::LoadSmartAlbumConfig($_POST['data']);

	return $returnJson;
}

function SYNOPHOTO_ADMIN_EditSmartAlbum()
{
	$returnJson = array(
		"success" => false
	);

	if (!isset($_POST['data'])) {
		csSYNOPhotoMisc::Synophoto_Log('post data NOT isset');
		return json_encode($returnJson);
	}

	$returnJson = SmartAlbum::EditSmartAlbum($_POST['data']);

	return $returnJson;
}

function SYNOPHOTO_ADMIN_DeleteSmartAlbum()
{
	$returnJson = array(
		"success" => false
	);

	if (!isset($_POST['data'])) {
		csSYNOPhotoMisc::Synophoto_Log('post data NOT isset');
		return json_encode($returnJson);
	}

	$returnJson = SmartAlbum::DeleteSmartAlbum($_POST['data']);

	return $returnJson;
}

function SYNOPHOTO_ADMIN_DeleteAlbums()
{
	$result['success'] = false;

	if (!isset($_POST['album_list'])) {
		return json_encode($result);
	}
	$list = explode(',', $_POST['album_list']);

	foreach($list as $sharename){
		$sharename = trim($sharename);
		if ('' != $sharename) {
			$sharename = @pack('H*', $sharename);
			SYNOPHOTO_ADMIN_DeleteOneAlbum($sharename);
		}
	}
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	SYNOPHOTO_LABEL_UTIL_Check_Photo_Label();

	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_DeleteOneAlbum($sharename)
{
	//get shareid
	$shareid = -1;
	$query = "SELECT shareid FROM photo_share WHERE sharename ='".PHOTO_DB_EscapeParam($sharename)."'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$shareid = $row['shareid'];
	}

	$path  = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$sharename;
	$real_path  = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$sharename;

	$escape = PHOTO_DB_GetEscape();
	//delete from photo_share, directory
	$query = 'DELETE FROM photo_share WHERE sharename LIKE ? '.$escape." OR sharename='".PHOTO_DB_EscapeParam($sharename)."'";
	$sqlParamName = array(PHOTO_DB_EscapForLike($sharename).'/%');
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParamName);

	$query = 'DELETE FROM ' . PHOTO_ACCESS_RIGHT_TABLE . ' WHERE shareid='.$shareid;
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$query = 'DELETE FROM ' . PHOTO_UPLOAD_RIGHT_TABLE . ' WHERE shareid='.$shareid;
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	//delete photo, we need photo id to delete photo comment
	$query = 'SELECT id FROM photo_image WHERE path LIKE ? '.$escape;
	$sqlParamPath = array(PHOTO_DB_EscapForLike($path).'/%');
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParamPath);
	$in_condi = '(';
	$count =0;
	while($row = PHOTO_DB_FetchRow($db_result)){
		$in_condi .= $row['id'].',';
		$count++;
	}
	$in_condi = substr($in_condi, 0, -1).')';
	if ($count == 0) {
		$in_condi = '()';
	}

	//delete comment
	$query = 'DELETE From photo_comment WHERE photo_id IN '.$in_condi;
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	//delete photo
	$query = 'DELETE FROM photo_image WHERE path LIKE ?'.$escape;
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParamPath);

	//delete video
	$query = 'DELETE FROM video WHERE path LIKE ?'.$escape;
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParamPath);

	$query = 'DELETE FROM video_convert WHERE video_path LIKE ?'.$escape;
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParamPath);

	$query = 'DELETE FROM video_comment WHERE path LIKE ?'.$escape;
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParamPath);

	$query = 'DELETE FROM video_desc WHERE path LIKE ?'.$escape;
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParamPath);

	$query = 'DELETE FROM photo_video_label WHERE video_path LIKE ?'.$escape;
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParamPath);

	if (file_exists($real_path)) {
		@exec("/usr/syno/bin/synophotoio -D ".escapeshellarg($real_path));
		@exec("/usr/syno/bin/synoindex -D ".escapeshellarg($real_path));
	}
}

function SYNOPHOTO_ADMIN_GetAlbumTreeData()
{
	$path = $_POST['node'];
	if($path == "source") {
		$query = "Select sharename from photo_share where is_subdir = 'f' AND sharename <> '/' order by sharename";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		$i = 0;
		while(($row = PHOTO_DB_FetchRow($db_result))) {
			if (!csSYNOPhotoMisc::CheckAlbumAccessible($row[0])) {
				continue;
			}
			$result[$i]['text'] = htmlspecialchars($row[0], ENT_QUOTES);
			$result[$i]['id'] = bin2hex($row[0]);
			$result[$i]['cls'] = 'root';
			$i++;
		}
	} else {
		$path = @pack('H*', $path);
		$currpath = getcwd();
		$temp_path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$path;

		if(!is_dir($temp_path) ||
		   0 !== strncmp (realpath($temp_path), SYNOPHOTO_SERVICE_REAL_DIR, strlen(SYNOPHOTO_SERVICE_REAL_DIR))) {
			return NULL;
		}
		$result = array();

		@chdir($temp_path);
		foreach (glob('{,.}*', GLOB_BRACE | GLOB_ONLYDIR) as $fullfile) {
			$thefile = array();

			$pos = strrpos($fullfile, "/");

			// skip photo in remote mount (cifs) or read-only mount (iso9660)
			if (csSYNOPhotoMisc::isSkipPhotoDev($temp_path.'/'.$fullfile, $_SESSION[SYNOPHOTO_ADMIN_USER]['mount_dev_list'])
				|| !csSYNOPhotoMisc::IsUtf8($fullfile)) {
				continue;
			}

			if ($pos != false || $fullfile == "@eaDir" || $fullfile == '.' || $fullfile == '..') {
				continue;
			}

			if (!csSYNOPhotoMisc::CheckAlbumAccessible($path."/".$fullfile)) {
				continue;
			}

			$thefile['text'] = htmlspecialchars($fullfile, ENT_QUOTES);
			$thefile['id'] = bin2hex($path."/".$fullfile);
			$thefile['cls'] = 'root';
			$result[] = $thefile;
		}
		@chdir($currpath);
	}
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_MoveAlbums()
{
	$result['success'] = false;
	/* block users when they have no manage permission in destination dir */
	if ('source' === $_POST['destination']) {
		if (!csSYNOPhotoMisc::CheckAlbumManageable('/')) {
			return json_encode($result);
		}
	} else if (!csSYNOPhotoMisc::CheckAlbumManageable(@pack('H*', $_POST['destination']))) {
		return json_encode($result);
	}
	if (!isSet($_POST['album_list']) || !isSet($_POST['destination']) || !isSet($_POST['write_strategy'])) {
		return json_encode($result);
	}

	$destShareData = array();
	$destShareData['shareid'] = -1;
	$destShareData['sharename'] = '';
	$is_overWrite = $_POST['write_strategy'];
	$list = explode(',', $_POST['album_list']);

	/* prepare album info for destination dir */
	if ($_POST['destination'] == 'source') {
		$query = "SELECT shareid, sharename, public, password FROM photo_share WHERE sharename='/'";
	} else {
		$dest_sharename = @pack('H*', $_POST['destination']);//parent name
		$destShareData['sharename'] = $dest_sharename;
		$query = "SELECT shareid, sharename, public, password FROM photo_share WHERE sharename='".PHOTO_DB_EscapeParam($dest_sharename)."'";
	}
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$destShareData['shareid'] = $row['shareid'];
		$destShareData['public'] = PHOTO_DB_ConvertBool($row['public']);
		$destShareData['password'] = $row['password'];
		$destShareData['comment'] = $row['comment'];
	}

	set_time_limit(0);
	foreach($list as $sharename){
		$sharename = trim($sharename);
		$sharename = @pack('H*', $sharename);
		SYNOPHOTO_ADMIN_MoveOneAlbum($destShareData, $sharename, $is_overWrite);
	}

	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_MoveOneAlbum($destShareData, $sharename, $is_overWrite)
{
	$shareid = -1;
	$public = 'f';
	//get shareid if in 1st or 2nd level
	$query = "SELECT shareid, public FROM photo_share WHERE sharename ='".PHOTO_DB_EscapeParam($sharename)."'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$shareid = $row[0];
		$public = PHOTO_DB_ConvertBool($row[1]);
	}

	if (!empty($destShareData['sharename'])) {
		$final_path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$destShareData['sharename'].'/'.basename($sharename);
		$final_sharename = $destShareData['sharename'].'/'.basename($sharename);
	} else {//move to first level
		$final_path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.basename($sharename);
		$final_sharename = basename($sharename);
	}

	//album exist
	if(file_exists($final_path)) {
		if(!$is_overWrite) {
			return true;
		}
		if (is_dir($final_path)) {
			SYNOPHOTO_ADMIN_DeleteOneAlbum($final_sharename);
		} else {
			SYNOPHOTO_ADMIN_DeleteItemByPath($final_path, SYNOPHOTO_ADMIN_IsPhotoFile($final_path));
		}
	}
	SYNOPHOTO_ADMIN_MoveAlbumInDB($destShareData, $sharename, $shareid, $public);
}

function SYNOPHOTO_ADMIN_MoveAlbumInDB($destShareData, $sharename, $shareid, $public)
{
	$escape = PHOTO_DB_GetEscape();
	$password = '';
	$ori_parent = substr($sharename, 0, strlen($sharename) - strlen(basename($sharename)));
	//get self and subdir in photo share
	$query = 'SELECT sharename, shareid, password, public, comment ' .
	         "FROM photo_share WHERE sharename LIKE ? $escape" .
			 " OR sharename='" . PHOTO_DB_EscapeParam($sharename) . "'";
	$dbParam = array(PHOTO_DB_EscapForLike($sharename).'/%');

	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $dbParam);
	while($row = PHOTO_DB_FetchRow($db_result)) {
		/* dir name for move */
		$movedir = substr($row['sharename'], strlen($ori_parent));
		/* final dir */
		$new_name = empty($destShareData['sharename']) ? $movedir : $destShareData['sharename'] . "/" . $movedir;
		$is_subdir = (!empty($destShareData['sharename']) ? 't' : (($row['sharename'] == $sharename) ? 'f' : 't'));
		$password = $row['password'];
		$query = "UPDATE photo_share SET sharename = '" . PHOTO_DB_EscapeParam($new_name) . "', is_subdir = '" . $is_subdir . "', cover = '' WHERE sharename='" . PHOTO_DB_EscapeParam($row['sharename'])."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		$type_ori = PHOTO_DB_ConvertBool($row['public']);
		$type_des = $destShareData['public'];
		$level_ori = count(explode('/', $row['sharename']));
		$level_aft = count(explode('/', $new_name));
		if ($level_ori <= 2 && $level_aft > 2) {
			/* delete all user permission, inherits parent's album type */
			$query = 'DELETE FROM ' . PHOTO_ACCESS_RIGHT_TABLE . ' WHERE shareid='.$row['shareid'];
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$query = 'DELETE FROM ' . PHOTO_UPLOAD_RIGHT_TABLE . ' WHERE shareid='.$row['shareid'];
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$query = 'DELETE FROM ' . PHOTO_MANAGE_RIGHT_TABLE . ' WHERE shareid='.$row['shareid'];
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$query = "UPDATE photo_share SET public = '" . $type_des . "', password = '" . $destShareData['password'] . "', comment = '" . $destShareData['comment'] . "' WHERE sharename = '" . $new_name . "'";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		} else if ($level_ori > 2 && $level_aft <= 2) {
			/* inherits parent's album type and user permission */
			$query = "UPDATE photo_share SET public = '" . $type_des . "', password = '" . $destShareData['password'] . "', comment = '" . $destShareData['comment'] . "' WHERE sharename = '" . $new_name . "'";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			/* if parent is pwd, it should inherit parent's parent */
			if ('' !== $destShareData['password']) {
				$query = "SELECT shareid FROM photo_share WHERE sharename='/'";
				$db_res = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
				$row1 = PHOTO_DB_FetchRow($db_res);
				csSYNOPhotoDB::GetDBInstance()->inheritAlbumPrivilege($row1['shareid'], $row['shareid']);
			} else {
				csSYNOPhotoDB::GetDBInstance()->inheritAlbumPrivilege($destShareData['shareid'], $row['shareid']);
			}
		} else if ($level_ori <= 2 && $level_aft <= 2) {
			if ($type_des == 'f' && $destShareData['password'] === '' && $type_ori == 'f' && $row['password'] === '') {
				$query = 'DELETE FROM ' . PHOTO_ACCESS_RIGHT_TABLE . ' WHERE shareid='.$row['shareid'];
				PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
				$query = 'DELETE FROM ' . PHOTO_UPLOAD_RIGHT_TABLE . ' WHERE shareid='.$row['shareid'];
				PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
				$query = 'DELETE FROM ' . PHOTO_MANAGE_RIGHT_TABLE . ' WHERE shareid='.$row['shareid'];
				PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
				csSYNOPhotoDB::GetDBInstance()->inheritAlbumPrivilege($destShareData['shareid'], $row['shareid']);
			} else if ($row['password'] === '') {
				/* update manage permission */
				$query = "SELECT userid FROM " . PHOTO_MANAGE_RIGHT_TABLE . " WHERE shareid IN (SELECT shareid FROM photo_share WHERE sharename='/' OR sharename = '" . $destShareData['sharename'] . "')";
				$db_res = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
				while ($row1 = PHOTO_DB_FetchRow($db_res)) {
					if ($type_ori !== 't') {
						SYNOPHOTO_ADMIN_AddAccessRightByShareid($row['shareid'], $row1['userid'], PHOTO_ACCESS_RIGHT_TABLE);
					}
					SYNOPHOTO_ADMIN_AddAccessRightByShareid($row['shareid'], $row1['userid'], PHOTO_UPLOAD_RIGHT_TABLE);
					SYNOPHOTO_ADMIN_AddAccessRightByShareid($row['shareid'], $row1['userid'], PHOTO_MANAGE_RIGHT_TABLE);
				}
			}
			// set comment as parent
			$query = "UPDATE photo_share SET comment = '" . $destShareData['comment'] . "' WHERE sharename = '" . $new_name . "'";
		} else if ($level_ori > 2 && $level_aft > 2) {
			/* inherit album type only */
			$query = "UPDATE photo_share SET public = '" . $type_des . "', password = '" . $destShareData['password'] . "', comment = '" . $destShareData['comment'] . "' WHERE sharename = '" . $new_name . "'";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		}
	}

	$ori_path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$sharename;
	$final_path = (empty($destShareData['sharename'])) ? SYNOPHOTO_SERVICE_REAL_DIR.'/'.basename($sharename) : SYNOPHOTO_SERVICE_REAL_DIR.'/'.$destShareData['sharename'].'/'.basename($sharename);
	if (file_exists($ori_path)) {
		@exec("/usr/syno/bin/synophotoio -b -m ".escapeshellarg($final_path)." ".escapeshellarg($ori_path));
		@exec("/usr/syno/bin/synoindex -p PhotoStation -N ".escapeshellarg($final_path)." ".escapeshellarg($ori_path));
		@exec("/usr/syno/bin/synomkthumb -a ".escapeshellarg('R:'.$final_path));
	}
	SYNOPHOTO_ADMIN_MoveAlbumPhoto($destShareData['sharename'], $sharename);
	SYNOPHOTO_ADMIN_MoveAlbumVideo($destShareData['sharename'], $sharename);
}

function SYNOPHOTO_ADMIN_InsertPhotoShare($sharename)
{
	$new_id = 0;
	$query = 'Select max(shareid) from photo_share';
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$new_id = $row[0]+1;
	}

	$is_subdir = (false === strstr($sharename, '/')) ? 'f' : 't';
	$public = 'f';
	if (preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches) &&
		'yes' === $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['percfg']['albumdefpublic']){
		$public = 't';
	} else if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['albumdefpublic']) &&
		'yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['albumdefpublic']) {
		$public = 't';
	}
	$query = 'Insert into photo_share (shareid, sharename, title, description, public, is_subdir) '
			."values ($new_id, '$sharename', '', '', '$public', '$is_subdir')";
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	return $new_id;
}

function SYNOPHOTO_ADMIN_MoveAlbumPhoto($parentname, $sharename)
{
	$ori_parent = substr($sharename, 0, strlen($sharename) - strlen(basename($sharename)));
	$escape = PHOTO_DB_GetEscape();
	$path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$sharename;
	$query = "SELECT path FROM photo_image WHERE path LIKE ? $escape";
	$sqlParamPath = array(PHOTO_DB_EscapForLike($path).'/%');
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParamPath);
	while($row = PHOTO_DB_FetchRow($db_result)) {
		$photo_path = $row[0];
		$movefile = substr($row[0], strlen(SYNOPHOTO_SERVICE_REAL_DIR_PATH.$ori_parent));
		$new_path = (empty($parentname)) ? SYNOPHOTO_SERVICE_REAL_DIR_PATH.$movefile : SYNOPHOTO_SERVICE_REAL_DIR_PATH.$parentname.'/'.$movefile;
		$query = "UPDATE photo_image SET path='".PHOTO_DB_EscapeParam($new_path)."' WHERE path='".PHOTO_DB_EscapeParam($photo_path)."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		//echo "photo: $photo_path => $new_path \n";
	}
}

function SYNOPHOTO_ADMIN_MoveAlbumVideo($parentname, $sharename)
{
	$ori_parent = substr($sharename, 0, strlen($sharename) - strlen(basename($sharename)));
	$escape = PHOTO_DB_GetEscape();
	$path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$sharename;
	$query = "SELECT path FROM video WHERE path LIKE ? $escape";
	$sqlParamPath = array(PHOTO_DB_EscapForLike($path).'/%');
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParamPath);
	$rows = PHOTO_DB_FetchAll($db_result);
	$db_result = null;
	foreach($rows as $row) {
		$video_path = $row[0];
		$movefile = substr($row[0], strlen(SYNOPHOTO_SERVICE_REAL_DIR_PATH.$ori_parent));
		$new_path = (empty($parentname)) ? SYNOPHOTO_SERVICE_REAL_DIR_PATH.$movefile : SYNOPHOTO_SERVICE_REAL_DIR_PATH.$parentname.'/'.$movefile;
		$real_new_path = (empty($parentname))? SYNOPHOTO_SERVICE_REAL_DIR.'/'.$movefile : SYNOPHOTO_SERVICE_REAL_DIR.$parentname.'/'.$movefile;
		$query = "UPDATE video SET path='".PHOTO_DB_EscapeParam($new_path)."' WHERE path='".PHOTO_DB_EscapeParam($video_path)."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		//update video_convert for PPS (PS's video_convert will be updated on cascade directly)
		$query = "UPDATE video_convert SET video_path='".PHOTO_DB_EscapeParam($new_path)."' WHERE video_path='".PHOTO_DB_EscapeParam($video_path)."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$query = "SELECT convert_file_path FROM video_convert WHERE video_path='".PHOTO_DB_EscapeParam($new_path)."'";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$convert_rows = PHOTO_DB_FetchAll($db_result);
		$db_result = null;
		foreach ($convert_rows as $convert_row) {
			$query = "UPDATE video_convert ".
				"SET convert_file_path='".PHOTO_DB_EscapeParam(SYNOPhotoEA::getEADirPath($new_path)."/".pathinfo($convert_row['convert_file_path'], PATHINFO_BASENAME))."' ".
				"WHERE convert_file_path = '".PHOTO_DB_EscapeParam($convert_row['convert_file_path'])."'";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		}
		$query = "UPDATE video_desc SET path='".PHOTO_DB_EscapeParam($new_path)."' WHERE path='".PHOTO_DB_EscapeParam($video_path)."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$query = "UPDATE video_comment SET path='".PHOTO_DB_EscapeParam($new_path)."' WHERE path='".PHOTO_DB_EscapeParam($video_path)."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$query = "UPDATE photo_video_label SET video_path='".PHOTO_DB_EscapeParam($new_path)."' WHERE video_path='".PHOTO_DB_EscapeParam($video_path)."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		@exec("/usr/syno/bin/synomkflv -a ".escapeshellarg($real_new_path));
	}
}

function SYNOPHOTO_ADMIN_CopyItems()
{
	set_time_limit(0);
	$dest_sharename = @pack('H*', $_POST['destination']);//parent name
	$is_overWrite = $_POST['write_strategy'];

	if (isset($_POST['photo_list']) && $_POST['photo_list'] != '') {
		$list = explode(',', $_POST['photo_list']);
		foreach($list as $id){
			SYNOPHOTO_ADMIN_CopyOnePhoto($dest_sharename, $id, $is_overWrite);
		}
		$real_dest_path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$dest_sharename;
		@exec("/usr/syno/bin/synomkthumb -a ".escapeshellarg($real_dest_path));
	}

	if (isset($_POST['video_list']) && $_POST['video_list'] != '') {
		$list = explode(',', $_POST['video_list']);
		foreach($list as $id){
			SYNOPHOTO_ADMIN_CopyOneVideo($dest_sharename, $id, $is_overWrite);
		}
	}
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_CopyOnePhoto($parentname, $photoid, $is_overWrite, $new_name='')
{
	$query = "SELECT * FROM photo_image WHERE id=?";
	$sqlParam = array($photoid);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$photo_name = ($new_name !== '') ? $new_name : basename($row['path']);
		$albumPrefix = '';
		if ('' !== $parentname) {
			$albumPrefix = $parentname . '/';
		}
		$new_path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$albumPrefix.$photo_name;
		$final_path = SYNOPHOTO_SERVICE_REAL_DIR."/".$albumPrefix.$photo_name;
		if ($new_path == $row['path']) {
			return;
		}

		//check file exist
		if(file_exists($final_path)) {
			if (!$is_overWrite) {
				return;
			}
			$labels = SYNOPHOTO_LABEL_UTIL_GetPhotoLabels($photoid);
			if(is_file($final_path)) {
				SYNOPHOTO_ADMIN_DeleteItemByPath($final_path, 1);
			}else{
				$sharename = $albumPrefix.basename($photo_name);
				SYNOPHOTO_ADMIN_DeleteOneAlbum($sharename);
			}
		} else {
			$labels = SYNOPHOTO_LABEL_UTIL_GetPhotoLabels($photoid);
		}

		$labels = SYNOPHOTO_LABEL_UTIL_FlattenLabels($labels);

		$real_ori_path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
		$info = pathinfo($new_path);
		$name = PHOTO_DB_EscapeParam($info['basename']);
		$title = PHOTO_DB_EscapeParam($info['filename']);
		$description = PHOTO_DB_EscapeParam($row['description']);
		$query = "Insert into photo_image (path, name, title, album, size, resolutionx, resolutiony, camera_make,
			camera_model, exposure, aperture, iso, timetaken, updated, version, create_time, description, gps) values ('"
			.PHOTO_DB_EscapeParam($new_path)."', '".$name."', '".$title."','".basename($parentname)."',
			{$row['size']}, {$row['resolutionx']}, {$row['resolutiony']}, '{$row['camera_make']}',
			'{$row['camera_model']}', '{$row['exposure']}', '{$row['aperture']}', {$row['iso']},
			'{$row['timetaken']}', '{$row['updated']}', {$row['version']}, '{$row['create_time']}',
			'{$description}', '{$row['gps']}');";

		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], "SELECT id from photo_image where path='".PHOTO_DB_EscapeParam($new_path)."';");
		if ($row = PHOTO_DB_FetchRow($db_result)) {
			$query = "INSERT INTO photo_image_label (image_id, label_id, info_new, status) values(?, ?, ?, ?);";
			foreach ($labels as $label) {
				$sqlParam = array($row['id'], $label['label_id'], $label['info'], PHOTO_DB_ConvertBool($label['status']));
				PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
			}
		}
		@exec("/usr/syno/bin/synophotoio -c -m ".escapeshellarg($final_path)." ".escapeshellarg($real_ori_path));
		@exec("/usr/syno/bin/synoindex -p PhotoStation -a ".escapeshellarg($final_path));
	}
}

function SYNOPHOTO_ADMIN_CopyOneVideo($parentname, $videoid, $is_overWrite, $new_name='')
{
	$query = "SELECT * FROM video WHERE id=?";
	$sqlParam = array($videoid);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$video_name = ($new_name !== '') ? $new_name : basename($row['path']);
		$albumPrefix = '';
		if ('' !== $parentname) {
			$albumPrefix = $parentname . '/';
		}
		$new_path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$albumPrefix.$video_name;
		$final_path = SYNOPHOTO_SERVICE_REAL_DIR."/".$albumPrefix.$video_name;
		if ($new_path == $row['path']) {
			return;
		}

		$orig_path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
		//check file exist
		if(file_exists($final_path)) {
			if (!$is_overWrite) {
				return;
			}
			$labels = SYNOPHOTO_LABEL_UTIL_GetVideoLabels($orig_path);
			if (is_file($final_path)) {
				SYNOPHOTO_ADMIN_DeleteItemByPath($final_path, 0);
			} else {
				$sharename = $albumPrefix.basename($photo_name);
				SYNOPHOTO_ADMIN_DeleteOneAlbum($sharename);
			}
		} else {
			$labels = SYNOPHOTO_LABEL_UTIL_GetVideoLabels($orig_path);
		}
		$labels = SYNOPHOTO_LABEL_UTIL_FlattenLabels($labels);

		$real_ori_path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row['path'];
		$info = pathinfo($new_path);
		$path = PHOTO_DB_EscapeParam($new_path);
		$album = PHOTO_DB_EscapeParam(basename($parentname));

		$query = "INSERT INTO video (path, title, filesize, album, container_type, video_codec, frame_bitrate, frame_rate_num, frame_rate_den, video_bitrate,
			video_profile, video_level, resolutionX, resolutionY, audio_codec, audio_bitrate, frequency, channel, duration, date, mdate, gps) values (
			'$path', '{$info['filename']}', {$row['filesize']}, '$album', '{$row['container_type']}', '{$row['video_codec']}',
			{$row['frame_bitrate']}, {$row['frame_rate_num']}, {$row['frame_rate_den']}, {$row['video_bitrate']}, {$row['video_profile']}, {$row['video_level']},
			{$row['resolutionx']}, {$row['resolutiony']}, '{$row['audio_codec']}', {$row['audio_bitrate']}, {$row['frequency']}, {$row['channel']},
			{$row['duration']}, '{$row['date']}', '{$row['mdate']}', '{$row['gps']}');";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		$query = "INSERT INTO photo_video_label (video_path, label_id, info, status) values(?, ?, ?, ?);";
		foreach ($labels as $label) {
			$sqlParam = array($path, $label['label_id'], $label['info'], PHOTO_DB_ConvertBool($label['status']));
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		}

		$query = "SELECT * FROM video_convert WHERE video_path='".PHOTO_DB_EscapeParam($row['path'])."';";
		$db_result1 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		while ($row1 = PHOTO_DB_FetchRow($db_result1)) {
			$info1 = pathinfo($new_path);
			$convert_file_path = $info1['dirname'].'/'.SYNOPHOTO_EADIR.'/'.$info1['basename'].'/'.basename($row1['convert_file_path']);
			$convert_file_path = PHOTO_DB_EscapeParam($convert_file_path);
			$query1 = "INSERT INTO video_convert (video_path, convert_file_path, resolutionx, resolutiony, container_type,
				video_bitrate, vcodec, video_profile, video_level, acodec, audio_bitrate, audio_frequency, audio_channel, convert_type) values(
				'$path', '{$convert_file_path}', {$row1['resolutionx']}, {$row1['resolutiony']}, '{$row1['container_type']}',
				{$row1['video_bitrate']}, '{$row1['vcodec']}', {$row1['video_profile']}, {$row1['video_level']},
				'{$row1['acodec']}', {$row1['audio_bitrate']}, {$row1['audio_frequency']}, {$row1['audio_channel']}, '{$row['convert_type']}');";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query1);
		}

		$query = "SELECT * FROM video_desc WHERE path='".PHOTO_DB_EscapeParam($row['path'])."';";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		if ($row = PHOTO_DB_FetchRow($db_result)) {
			$query = "INSERT INTO video_desc (path, title, description) values(?, ?, ?);";
			$sqlParam = array($path, $row['title'], $row['description']);
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		}

		@exec("/usr/syno/bin/synophotoio -c -m ".escapeshellarg($final_path)." ".escapeshellarg($real_ori_path));
		@exec("/usr/syno/bin/synoindex -p PhotoStation -a ".escapeshellarg($final_path));
		@exec("/usr/syno/bin/synomkflv -a ".escapeshellarg($final_path));
	}
}

function SYNOPHOTO_ADMIN_MoveItems()
{
	set_time_limit(0);
	$is_overWrite = $_POST['write_strategy'];
	$destShareData = array();
	$destShareData['shareid'] = -1;
	$destShareData['sharename'] = '';

	if ($_POST['destination'] == 'source') {
		$query = "SELECT shareid, sharename, public, password FROM photo_share WHERE sharename='/'";
		$sqlParam = array();
	} else {
		$destShareData['sharename'] = @pack('H*', $_POST['destination']);//parent name
		$query = "SELECT shareid, sharename, public, password FROM photo_share WHERE sharename=?";
		$sqlParam = array($destShareData['sharename']);
	}
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$destShareData['shareid'] = $row['shareid'];
		$destShareData['public'] = PHOTO_DB_ConvertBool($row['public']);
		$destShareData['password'] = $row['password'];
	}

	if (isset($_POST['album_list']) && $_POST['album_list'] != '') {
		$list = explode(',', $_POST['album_list']);
		foreach($list as $sharename){
			$sharename = @pack('H*', $sharename);
			SYNOPHOTO_ADMIN_MoveOneAlbum($destShareData, $sharename, $is_overWrite);
		}
	}

	if (isset($_POST['photo_list']) && $_POST['photo_list'] != '') {
		$list = explode(',', $_POST['photo_list']);
		foreach($list as $id){
			SYNOPHOTO_ADMIN_MoveOnePhoto($destShareData['sharename'], $id, $is_overWrite);
		}
		$real_dest_path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$destShareData['sharename'];
		@exec("/usr/syno/bin/synomkthumb -a ".escapeshellarg($real_dest_path));
	}

	if (isset($_POST['video_list']) && $_POST['video_list'] != '') {
		$list = explode(',', $_POST['video_list']);
		foreach($list as $id){
			SYNOPHOTO_ADMIN_MoveOneVideo($destShareData['sharename'], $id, $is_overWrite);
		}
	}
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_MoveOnePhoto($parentname, $photoid, $is_overWrite)
{
	$query = "SELECT path FROM photo_image WHERE id=?";
	$sqlParam = array($photoid);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$photo_name = basename($row[0]);
		$albumPrefix = '';
		if ('' !== $parentname) {
			$albumPrefix = $parentname . '/';
		}
		$new_path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$albumPrefix.$photo_name;
		$final_path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$albumPrefix.basename($photo_name);
		if ($new_path == $row[0]) {
			return;
		}

		//check file exist
		if(file_exists($final_path)) {
			if (!$is_overWrite) {
				return;
			}
			if(is_file($final_path)) {
				SYNOPHOTO_ADMIN_DeleteItemByPath($final_path, 1);
			}else{
				$sharename = $albumPrefix.basename($photo_name);
				SYNOPHOTO_ADMIN_DeleteOneAlbum($sharename);
			}
		}
		$real_ori_path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
		$real_new_path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$albumPrefix.$photo_name;
		//echo "$real_ori_path => $real_new_path";

		@exec("/usr/syno/bin/synophotoio -b -m ".escapeshellarg($real_new_path)." ".escapeshellarg($real_ori_path));
		@exec("/usr/syno/bin/synoindex -p PhotoStation -N ".escapeshellarg($real_new_path)." ".escapeshellarg($real_ori_path));

		$query = "UPDATE photo_image SET path='".PHOTO_DB_EscapeParam($new_path)."' WHERE id=?";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	}
}

function SYNOPHOTO_ADMIN_MoveOneVideo($parentname, $videoid, $is_overWrite)
{
	$query = "SELECT path FROM video WHERE id=?";
	$sqlParam = array($videoid);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$video_name = basename($row[0]);
		$albumPrefix = '';
		if ('' !== $parentname) {
			$albumPrefix = $parentname . '/';
		}
		$new_path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$albumPrefix.$video_name;
		$final_path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$albumPrefix.basename($video_name);
		if ($new_path == $row[0]) {
			return;
		}
		//check file exist
		if(file_exists($final_path)) {
			if (!$is_overWrite) {
				return;
			}
			if (is_file($final_path)) {
				SYNOPHOTO_ADMIN_DeleteItemByPath($final_path, 0);
			} else {
				$sharename = $albumPrefix.basename($photo_name);
				SYNOPHOTO_ADMIN_DeleteOneAlbum($sharename);
			}
		}

		$real_ori_path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];
		$real_new_path = SYNOPHOTO_SERVICE_REAL_DIR.'/'.$albumPrefix.$video_name;

		$query = "UPDATE video SET path='".PHOTO_DB_EscapeParam($new_path)."' WHERE id=?";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		$query = "UPDATE video_convert SET video_path='".PHOTO_DB_EscapeParam($new_path)."' WHERE video_path='".PHOTO_DB_EscapeParam($row[0])."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$query = "UPDATE video_comment SET path='".PHOTO_DB_EscapeParam($new_path)."' WHERE path='".PHOTO_DB_EscapeParam($row[0])."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$query = "UPDATE video_desc SET path='".PHOTO_DB_EscapeParam($new_path)."' WHERE path='".PHOTO_DB_EscapeParam($row[0])."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$query = "UPDATE photo_video_label SET video_path='".PHOTO_DB_EscapeParam($new_path)."' WHERE video_path='".PHOTO_DB_EscapeParam($row[0])."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

		SYNOPHOTO_UPDATE_VIDEO_CONVERT_PATH($new_path);

		@exec("/usr/syno/bin/synophotoio -b -m ".escapeshellarg($real_new_path)." ".escapeshellarg($real_ori_path));
		@exec("/usr/syno/bin/synomkflv -a ".escapeshellarg($real_new_path));
	}
}

function SYNOPHOTO_UPDATE_VIDEO_CONVERT_PATH($path)
{
	$query = "SELECT * FROM video_convert WHERE video_path='" . PHOTO_DB_EscapeParam($path) . "';";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	while ($row = PHOTO_DB_FetchRow($db_result)) {
		$info = pathinfo($path);
		$convert_file_path = $info['dirname'] . '/' . SYNOPHOTO_EADIR . '/' . $info['basename'] . '/' . basename($row['convert_file_path']);
		$convert_file_path = PHOTO_DB_EscapeParam($convert_file_path);

		$query = "UPDATE video_convert SET convert_file_path='" . $convert_file_path .
				"' WHERE video_path='" . PHOTO_DB_EscapeParam($path) . "' AND convert_file_path='" . $row['convert_file_path'] . "'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	}
}

function SYNOPHOTO_ADMIN_DeleteItems()
{
	if (isset($_POST['album_list']) && $_POST['album_list'] != '') {
		$list = explode(',', $_POST['album_list']);
		foreach($list as $sharename){
			$sharename = @pack('H*', $sharename);
			SYNOPHOTO_ADMIN_DeleteOneAlbum($sharename);
		}
	}

	if (isset($_POST['photo_list']) && $_POST['photo_list'] != '') {
		$list = explode(',', $_POST['photo_list']);
		foreach($list as $id){
			SYNOPHOTO_ADMIN_DeleteItemById($id, 1);
		}
	}

	if (isset($_POST['video_list']) && $_POST['video_list'] != '') {
		$list = explode(',', $_POST['video_list']);
		foreach($list as $id){
			SYNOPHOTO_ADMIN_DeleteItemById($id, 0);
		}
	}
	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	SYNOPHOTO_LABEL_UTIL_Check_Photo_Label();

	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_DeleteItemById($id, $is_photo)
{
	if ($is_photo) {
		$query = 'SELECT path FROM photo_image WHERE id=?';
		$sqlParam = array($id);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		if ($row = PHOTO_DB_FetchRow($db_result)) {
			$real_path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];

			$query = "DELETE FROM photo_image WHERE id=?";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
			$query ="DELETE FROM photo_comment WHERE photo_id=?";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

			@exec("/usr/syno/bin/synophotoio -d ".escapeshellarg($real_path));
			@exec("/usr/syno/bin/synoindex -p PhotoStation -d ".escapeshellarg($real_path));
		}
	}else{
		$query = "SELECT path FROM video WHERE id=?";
		$sqlParam = array($id);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		if($row = PHOTO_DB_FetchRow($db_result)) {

			$real_path = SYNOPHOTO_SERVICE_REAL_DIR_PREFIX.$row[0];

			$query = "DELETE FROM video WHERE id=?";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
			$query = "DELETE FROM video_convert WHERE video_path='".PHOTO_DB_EscapeParam($row[0])."'";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$query = "DELETE FROM video_comment WHERE path='".PHOTO_DB_EscapeParam($row[0])."'";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$query = "DELETE FROM video_desc WHERE path='".PHOTO_DB_EscapeParam($row[0])."'";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$query = "DELETE FROM photo_video_label WHERE video_path='".PHOTO_DB_EscapeParam($row[0])."'";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

			@exec("/usr/syno/bin/synophotoio -d ".escapeshellarg($real_path));
		}
	}
	return true;
}

//full path , 0/1
function SYNOPHOTO_ADMIN_DeleteItemByPath($path, $is_photo)
{
	$dbPath = substr($path, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
	if ($is_photo) {
		//get photo id for delete comment
		$query = "SELECT id FROM photo_image WHERE path='".PHOTO_DB_EscapeParam($dbPath)."'";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		if ($row = PHOTO_DB_FetchRow($db_result)) {
			$query = "DELETE FROM photo_image WHERE path='".PHOTO_DB_EscapeParam($dbPath)."'";
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$query ="DELETE FROM photo_comment WHERE photo_id=".$row[0];
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		}
		@exec("/usr/syno/bin/synophotoio -d ".escapeshellarg($path));
		@exec("/usr/syno/bin/synoindex -d ".escapeshellarg($path));
	}else{
		$query = "DELETE FROM video WHERE path='".PHOTO_DB_EscapeParam($dbPath)."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$query = "DELETE FROM video_convert WHERE video_path='".PHOTO_DB_EscapeParam($dbPath)."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$query = "DELETE FROM video_comment WHERE path='".PHOTO_DB_EscapeParam($dbPath)."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$query = "DELETE FROM video_desc WHERE path='".PHOTO_DB_EscapeParam($dbPath)."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$query = "DELETE FROM photo_video_label WHERE video_path='".PHOTO_DB_EscapeParam($dbPath)."'";
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		@exec("/usr/syno/bin/synophotoio -d ".escapeshellarg($path));
	}

	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_IsPhotoFile($path)
{
	global $SYNOPHOTO_ALLOW_PICT_NAMES_EXT;

	$path = strtolower($path);
	$path_parts = pathinfo($path);
	$extension = $path_parts['extension'];
	if(in_array($extension, $SYNOPHOTO_ALLOW_PICT_NAMES_EXT)) {
		return true;
	} else {
		return false;
	}
}

function SYNOPHOTO_ADMIN_DeleteAccessRightByShareid($shareid, $delete_users, $table)
{
	if ($shareid == null || $shareid == "" ||
		$delete_users == null || $delete_users == "") {
		return;
	}

//	$query = "Delete from " . PHOTO_ACCESS_RIGHT_TABLE . " where userid in (".$delete_users.") and shareid =".$shareid;
	$query = "Delete from " . $table . " where userid in ($delete_users) and shareid =?";
	$sqlParam = array($shareid);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
}

function SYNOPHOTO_ADMIN_AddAccessRightByShareid($shareid, $accessible_users, $table)
{
	if($shareid == null || $shareid == "" ||
		$accessible_users == null || $accessible_users == "") {
		return;
	}

	$arr = explode(",", $accessible_users);
	foreach ($arr as $tok) {
		if($tok == "") {
			continue;
		}
		$date = date('Y-m-d H:i:s');
		$query = "Insert into " . $table . " (userid, shareid, create_time) ";
		$query = $query."Values (?, ?, ?)";
		$sqlParam = array($tok, $shareid, $date);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	}
}

function SYNOPHOTO_ADMIN_AddChildRightBySharename($sharename, $users, $table) {
	if($sharename == null || $sharename == "" ||
	    $users == null || $users == "") {
		return;
	}
	if ("/" === $sharename) {
		$query = "SELECT shareid FROM photo_share WHERE sharename <> '/' AND sharename NOT LIKE '%/%/%'";
	} else {
		$query = "SELECT shareid FROM photo_share WHERE sharename LIKE '" . PHOTO_DB_EscapeParam($sharename) . "/%'";
		$query .= " AND sharename NOT LIKE '" . PHOTO_DB_EscapeParam($sharename) . "/%/%'";
	}
	if ($table === PHOTO_ACCESS_RIGHT_TABLE) {
		$query .= " AND public='f'";
	}
	$query .= " AND password=''";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	while ($row = PHOTO_DB_FetchRow($db_result)) {
		$shareid = $row['shareid'];
		$arr = explode(",", $users);
		foreach ($arr as $tok) {
			if($tok == "") {
				continue;
			}
			$date = date('Y-m-d H:i:s');
			$query = "Insert into " . $table . " (userid, shareid, create_time) ";
			$query = $query."Values (?, ?, ?)";
			$sqlParam = array($tok, $shareid, $date);
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		}
	}
}
function SYNOPHOTO_ADMIN_DeleteChildRightBySharename($sharename, $users, $table)
{
	if($sharename == null || $sharename == "" ||
		$users == null || $users == "") {
		return;
	}
	$escape = PHOTO_DB_GetEscape();
	$query = "SELECT shareid FROM photo_share WHERE sharename LIKE '" . PHOTO_DB_EscapeParam($sharename) . "/%'";
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	while ($row = PHOTO_DB_FetchRow($db_result)) {
		$shareid = $row['shareid'];
		$arr = explode(",", $users);
		foreach ($arr as $tok) {
			if($tok == "") {
				continue;
			}
			$query = "DELETE FROM " . $table . " WHERE userid=" . $tok . " AND shareid=" . $shareid;
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		}
	}
}

function SYNOPHOTO_ADMIN_DeleteParentRightBySharename($sharename, $users, $table)
{
	if($sharename == null || $sharename == "" ||
		$users == null || $users == "") {
		return;
	}
	if ('/' === $sharename || '' === $sharename) {
		return;
	}
	$parentName = substr($sharename, 0, strrpos($sharename, '/'));
	if ('' === $parentName) {
		$parentName = '/';
	}
	$escape = PHOTO_DB_GetEscape();
	$query = "SELECT shareid FROM photo_share WHERE sharename='" . $parentName . "'";
	PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if ($row = PHOTO_DB_FetchRow($db_result)) {
		$shareid = $row['shareid'];
		$arr = explode(",", $users);
		foreach ($arr as $tok) {
			if($tok == "") {
				continue;
			}
			$query = "DELETE FROM " . $table . " WHERE userid=" . $tok . " AND shareid=" . $shareid;
			PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		}
	}
	SYNOPHOTO_ADMIN_DeleteParentRightBySharename($parentName, $users, $table);
}
function SYNOPHOTO_ADMIN_BlogImageCopy()
{
	$result['success'] = false;
	if (!isSet($_POST['id']) || !isSet($_POST['isForVideo'])) {
		return json_encode($result);
	}
	$id = $_POST['id'];
	if ($_POST['isForVideo'] != 1) {
		$query = "SELECT path, resolutionx, resolutiony, version FROM photo_image where id=?";
	} else {
		$query = "SELECT path FROM video where id=?";
	}
	$sqlParam = array($id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if(($row = PHOTO_DB_FetchRow($db_result)) == false) {
		return json_encode($result);
	}
	$real_path = SYNOPHOTO_SERVICE_REAL_DIR_PATH.$row['path'];
	$name = basename($real_path);
	if (false === ($newPath = SYNOPHOTO_ADMIN_CheckBlogImageDir($name))) {
		return json_encode($result);
	}

	$dbPath = substr($newPath, strlen(SYNOPHOTO_SERVICE_REAL_DIR_PREFIX));
	if ($_POST['isForVideo'] != 1) {
		SYNOPHOTO_ADMIN_CopyOnePhoto(SYNOBLOG_IMAGE_DIR, $id, false, basename($newPath));
		$thumb = csSYNOPhotoMisc::GetThumbInfoFromFullPath($newPath, SYNOPHOTO_THUMBMEDIUM, $row['resolutionx'], $row['resolutiony'], $row['version']);
		$src = $thumb['src'];
		$query = "SELECT id FROM photo_image where path='".PHOTO_DB_EscapeParam($dbPath)."'";
	} else {
		SYNOPHOTO_ADMIN_CopyOneVideo(SYNOBLOG_IMAGE_DIR, $id, false, basename($newPath));
		$src = SYNOPHOTO_URL_PREFIX."/blog/include/v&dir=".csSYNOPhotoMisc::UrlEncode(csSYNOPhotoMisc::UrlEncode(SYNOBLOG_IMAGE_DIR))."&file=".csSYNOPhotoMisc::UrlEncode(csSYNOPhotoMisc::UrlEncode(basename($newPath)));
		$query = "SELECT id FROM video where path='".PHOTO_DB_EscapeParam($dbPath)."'";
	}
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$row1 = PHOTO_DB_FetchRow($db_result);

	$result['data']['id'] = $row1['id'];
	$result['data']['src'] = $src;
	$result['success'] = true;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_CheckBlogImageDir($name)
{
	$blog_dir = SYNOPHOTO_SERVICE_REAL_DIR."/".SYNOBLOG_IMAGE_DIR;
	if (!is_dir($blog_dir)) {
		$album_data = array();
		$album_data['sharename'] = SYNOBLOG_IMAGE_DIR;
		$album_data['title'] = '';
		$album_data['description'] = '';
		$album_data['public'] = 'f';
		$album_data['comment'] = 'f';
		$album_data['is_subdir'] = 'f';
		$album_data['password'] = '';
		$ret = SYNOPHOTO_ADMIN_AddAlbumToDB($album_data, $blog_dir);
	}
	$new_name = date("Y-m-d").'-'.$name;
	$count=1;
	while (file_exists($blog_dir.'/'.$new_name)) {
		$path_parts = pathinfo($new_name);
		$new_name = $path_parts['filename'].'-'.$count.'.'.$path_parts['extension'];
		$count++;
	}
	return $blog_dir.'/'.$new_name;
}

?>
