<?php
require_once(dirname(__FILE__).'/../syno_conf.php');

if($_POST['action'] == 'get_all_labels') {
    echo SYNOBLOG_LABEL_GetLabelComboData($_POST['id']);
} else if($_POST['action'] == "get_article_label" && isset($_POST['article_id'])) {
    echo SYNOBLOG_LABEL_GetArticleRawLabel($_POST['article_id']);
} else if($_POST['action'] == "get_invalid_labels") {
    echo SYNOBLOG_LABEL_GetInvalidLabels();
}

function SYNOBLOG_LABEL_GetLabelComboData($article_id)
{
	$labels = array();
	if ($article_id != -1) {
		$labels = SYNOBLOG_LABEL_GetArticleLabel($article_id);
    }
	$all_labels = SYNOBLOG_LABEL_GetAllLabel();
	$result['all_labels'] = array();
	$result['all_labels'][] = SYNOBLOG_LABEL_GetComboItem(-1, '- - - - - '.__(photo_str_article_edit_label_apply), 'none', 'label-item-gray');

	foreach ($all_labels as $row){
		if ('no_label' == $row['label_name']) {
			continue;
		}
		$already_use = false;
		foreach($labels as $label) {
			if ($label['label_id'] == $row['label_id']) {
				$already_use = true;
				break;
			}
		}
		if (!$already_use) {
			$result['all_labels'][] = SYNOBLOG_LABEL_GetComboItem($row['label_id'], $row['label_name'], 'add', '');
		}
    }
	$result['all_labels'][] = SYNOBLOG_LABEL_GetComboItem(-2, '- - - - - '.__(photo_str_article_edit_label_add_new), 'new', 'label-item-new');
	$result['all_labels'][] = SYNOBLOG_LABEL_GetComboItem(-3, '- - - - - '.__(photo_str_article_edit_label_delete), 'none', 'label-item-gray');
	if (!empty($labels)) {
		foreach($labels as $label) {
			$result['all_labels'][] = SYNOBLOG_LABEL_GetComboItem($label['label_id'], $label['label_name'], 'remove', '');
		}
	}
	return json_encode($result);
}

function SYNOBLOG_LABEL_GetAllLabel()
{
	$query = 'Select * from blog_label order by label_name;';
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$labels = array();
	while(($row = PHOTO_DB_FetchRow($db_result))){
		if ('no_label' == $row['label_name']) {
			continue;
		}
		$labels[] = $row;
	}
	return $labels;
}

function SYNOBLOG_LABEL_GetComboItem($id, $name, $action, $cls)
{
	$label['id'] = $id;
	$label['name'] = $name;
	$label['action'] = $action;
	$label['cls'] = $cls;
	return $label;
}

function SYNOBLOG_LABEL_GetArticleRawLabel($article_id)
{
	global $blog_str_article_label_none;

    $query = "Select label_name from blog_article_label where article_id = ".$article_id." order by label_name;";
    $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

    while(($row = PHOTO_DB_FetchRow($db_result))) {
        if($row[0] == "no_label") {
            continue;
        }
        $result[] = $row[0];
    }

	return json_encode($result);
}

function SYNOBLOG_LABEL_GetArticleLabel($article_id)
{
    $query = "Select * from blog_article_label where article_id = ".$article_id." order by label_name;";
    $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
    $row = PHOTO_DB_FetchRow($db_result);

	$labels = array();
	while($row) {
		if ($row['label_name'] == 'no_label') {
			return array();
		}
		$labels[] = $row;
		$row = PHOTO_DB_FetchRow($db_result);
	}
	return $labels;
}

function SYNOBLOG_LABEL_DeleteArticleLabel($article_id)
{
    $query = "Select * from blog_article_label where article_id = ".$article_id;
    $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

    while(($row = PHOTO_DB_FetchRow($db_result))) {
        $query = "Select * from blog_label where label_id = ".$row[1].";";
        $db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
        $row_2 = PHOTO_DB_FetchRow($db_result_2);
		$article_count = $row_2[2] - 1;

        $query = "Update blog_label set article_count = ".$article_count." where label_id = ".$row[1].";";
        $db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
    }

    $query = "Delete from blog_article_label where article_id = ".$article_id;
    $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

    SYNOBLOG_LABEL_CleanLabel();
}

function SYNOBLOG_LABEL_CleanLabel()
{
    $query = "Select label_id from blog_label where label_name != 'no_label' and article_count = 0;";
    $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

    while(($row = PHOTO_DB_FetchRow($db_result))) {
        $query = "Delete from blog_label where label_id = ".$row[0];
        $db_result_2 = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
    }
}

function SYNOBLOG_LABEL_AddArticleLabel($article_id, $labels)
{
	$count = 0;
	$array = explode(', ', $labels);
	foreach ($array as $tok) {
		if (trim($tok) == '') {
			continue;
		}
		SYNOBLOG_LABEL_AddLabelArticleCount($article_id, PHOTO_DB_EscapeParam($tok));
		$count++;
	}
	if ($count == 0) {
		SYNOBLOG_LABEL_AddLabelArticleCount($article_id, "no_label");
	}
}

function SYNOBLOG_LABEL_AddLabelArticleCount($article_id, $label_name) {
    $query = "Select * from blog_label where label_name = '".$label_name."';";
    $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
    $row = PHOTO_DB_FetchRow($db_result);

    if($row != null) {
        $article_count = $row[2] + 1;
		$label_id = $row[0];

        $query = "Update blog_label set article_count = ".$article_count." where label_name = '".$label_name."';";
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
    } else {
        $query = "Insert Into blog_label (label_name, article_count) Values ('".$label_name."', 1)";
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

        $query = "Select label_id from blog_label where label_name = '".$label_name."';";
        $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
        $row = PHOTO_DB_FetchRow($db_result);
        $label_id = $row[0];
    }

    $query = "Insert Into blog_article_label (label_id, label_name, article_id) Values (".$label_id.", '".$label_name."', ".$article_id.")";
    $db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
}

function SYNOBLOG_LABEL_GetInvalidLabels()
{
    $result[0] = "";
    $result[1] = "no_label";
    $result[2] = "synology_add_new_label";

    $i = 3;
    $currpath = getcwd();
    chdir(SYNOPHOTO_LANGS_DIR);

    foreach (glob("*.php") as $fullfile) {
        $lang_file = fopen($fullfile, 'r');
        while (!feof($lang_file)) {
            $line = fgets($lang_file, 4096);
            if(strstr($line, '$photo_str_no_label') != null) {
                $conf = explode('"', $line);
                if (strlen($conf[1]) > 0) {
                    $result[$i] = $conf[1];
                    $i++;
                    break;
                }
            }
        }
        fclose($lang_file);
    }
    chdir($currpath);

	$all_labels = SYNOBLOG_LABEL_GetAllLabel();
	foreach($all_labels as $label){
		$result[] = $label['label_name'];
	}
    return json_encode($result);
}
?>
