<?php
require_once(dirname(__FILE__).'/../syno_conf.php');
require_once(SYNOBLOG_INCLUDE_LABEL);
require_once(SYNOBLOG_INCLUDE_COMMENT);
require_once(SYNOBLOG_INCLUDE_AUTOSAVE);
require_once(SYNOPHOTO_INCLUDE_ALBUM_UTIL);

header('Content-type:text/html; charset=utf-8');

if(isset($_POST['list_type'])) {
	echo SYNOBLOG_ARTICLE_GetListsContent($_POST['list_type'], $_POST['value']);
}

$action = (array_key_exists('action', $_POST)) ? $_POST['action'] : null ;
switch ($action)
{
case 'show_abstract':
	echo SYNOBLOG_ARTICLE_GetAbstracts($_POST['page']);
	break;
case 'show_article':
	echo SYNOBLOG_ARTICLE_GetArticle($_POST['id'], stripslashes($_POST['input_key']));
	break;
case 'save_article':
	echo SYNOBLOG_ARTICLE_SaveArticle();
	break;
case 'delete_article':
	SYNOBLOG_ARTICLE_DeleteArticle($_POST['article_id']);
	echo '1';
	break;
case "get_article_raw":
	if(isset($_POST['article_id'])) {
		echo SYNOBLOG_ARTICLE_GetArticleRawData($_POST['article_id']);
	}
	break;
case 'delete_allautosave':
	echo SYNOBLOG_ARTICLE_DeleteAllAutosave();
	break;
case 'get_autosave_interval':
	echo csSYNOPhotoMisc::GetConfigDB('main', 'autosave_interval');
	break;
case "getDaysWithBlogArticle":
	echo SYNOBLOG_ARTICLE_GetDaysWithBlogArticle($_POST['firstDay'], $_POST['lastDay']);
	break;
case 'setStickyArticle':
	if (csSYNOPhotoMisc::GetConfigDB('main', 'sticky_article') == $_POST['config_value']) {
		echo csSYNOPhotoMisc::UpdateConfigDB($_POST['module_name'], $_POST['config_key'], '', $_POST['table']);
	} else {
		echo csSYNOPhotoMisc::UpdateConfigDB($_POST['module_name'], $_POST['config_key'], $_POST['config_value'], $_POST['table']);
	}
	break;
}

function SYNOBLOG_ARTICLE_GetArticleRawData($article_id)
{
	$result = array();
	$query = 'Select * from blog_article where article_id = ?;';
	$sqlParam = array($article_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	$row = PHOTO_DB_FetchRow($db_result);
	if($row != null) {
		$date = explode(" ", $row['date']);
		$result['data']['date'] = $date[0];
		$result['data']['time'] = $date[1];
		$result['data']['title'] = $row['title'];
		$result['data']['abstract_content'] = $row['abstract'] == null ? '' : $row['abstract'];
		$result['data']['content'] = $row['content'];
		$result['data']['viewing_privilege'] = intval($row['viewing_privilege']);
		$result['data']['access_key'] = $row['access_key'];
		$result['data']['access_key_hint'] = $row['access_key_hint'];
		$result['data']['allow_comment'] = PHOTO_DB_ConvertBool($row['allow_comment']);
		$result['data']['show_abstract'] = PHOTO_DB_ConvertBool($row['show_abstract']);
		$result['data']['draft'] = $row['draft'];

		if($row['draft'] == -1) {
			$result['data']['autosave_target'] = SYNOBLOG_AUTOSAVE_GetAutosaveTarget($article_id);
		}
	}
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOBLOG_ARTICLE_GetStickyArticle($sticky_article_id)
{
	$article = null;
	if($sticky_article_id == null || $sticky_article_id == '') {
		return $article;
	}
	if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		$query = 'Select * from blog_article where article_id = ? and draft = 0';
	} else if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
		$query = 'Select * from blog_article where article_id = ? and draft = 0 and viewing_privilege != '.SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN;
	} else {
		$query = 'Select * from blog_article where article_id = ? and draft = 0 and viewing_privilege != '.SYNOBLOG_ARTICLE_PRIVILEGE_USER.' and viewing_privilege != '.SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN;
	}
	$sqlParam = array($sticky_article_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if(($row = PHOTO_DB_FetchRow($db_result))) {
		$article = SYNOBLOG_ARTICLE_PrepareArticleData($row, true);
	}
	return $article;
}
function SYNOBLOG_ARTICLE_GetAbstractList($page)
{
	$abstract_num = csSYNOPhotoMisc::GetConfigDB('main', 'article_num');
	$article_num = $abstract_num;
	if($page == null || $page == '' || $page <= 0) {
		$page = 1;
	}
	$offset = ($page-1) * $abstract_num;
	//get sticky article
	$sticky_article_id = csSYNOPhotoMisc::GetConfigDB('main', 'sticky_article');
	if ($sticky_article_id != null && $sticky_article_id != '') {
		$sticky_article = SYNOBLOG_ARTICLE_GetStickyArticle($sticky_article_id);
	}
	$condition = '';
	if ($sticky_article) {
		$condition = ' and article_id <> '.$sticky_article_id.' ';
		if($page == 1) {
			$article_list[] = $sticky_article;
			$article_num = $abstract_num - 1;
		} else {
			$offset = $offset -1;
		}
	}
	//get other articles
	if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		$query = 'Select * from blog_article where draft = 0 '.$condition.'order by date desc limit '.$article_num.' offset '.$offset;
	} else if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
		$query = 'Select * from blog_article where draft = 0 '.$condition.'and viewing_privilege != '.SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN.' order by date desc limit '.$article_num.' offset '.$offset;
	} else {
		$query = 'Select * from blog_article where draft = 0 '.$condition.'and viewing_privilege != '.SYNOBLOG_ARTICLE_PRIVILEGE_USER.' and viewing_privilege != '.SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN.' order by date desc limit '.$article_num.' offset '.$offset;
	}
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	while ($row = PHOTO_DB_FetchRow($db_result)) {
		$article_list[] = SYNOBLOG_ARTICLE_PrepareArticleData($row, false, false);
	}
	$total_article = SYNOBLOG_ARTICLE_GetTotalArticleCount();
	$page_list = SYNOBLOG_ARTICLE_GetPageIndex($page, $abstract_num, $total_article);

	$articles['article_list'] = $article_list;
	$articles['page_list'] = $page_list;
	$articles['total_page'] = ceil($total_article/$abstract_num);
	return $articles;
}
function SYNOBLOG_ARTICLE_PrepareArticleData($row, $isSticky = false, $isWhole = false)
{
	$article['id']= $row['article_id'];
	$article['date'] = htmlspecialchars($row['date']);
	$article['title'] = htmlspecialchars($row['title']);
	$article['author'] = $row['author'];
	$article['shareParams'] = "{from:'blog',id:". $article['id'].",title:'". $article['title'] . "',type}";
	$article['allow_comment'] = $row['allow_comment'] == 't' || $row['allow_comment'] === true;

	$sticky_article_id = csSYNOPhotoMisc::GetConfigDB('main', 'sticky_article');
	if ($sticky_article_id == $article['id']) {
		$isSticky = true;
	}

	if ('' == $row['title']) {
		$article['title'] = "..... (".__(article_no_title).")";
	}
	$article['type'] ='';
	if(1 == $row['draft']) {//draft
		$article['type'] = __(blog_article_draft);
	} else if (-1 == $row['draft']) {//autosave
		$article['type'] = __(autosave_article);
	} else if ($isSticky) {
		$article['type'] = __(blog_sticky_article);
		$article['isSticky'] = true;
	}

	$article['hint'] = $row['access_key_hint'];
	if($row['viewing_privilege'] == 3 && !$isWhole) {// Need Passwd
		$article['content'] .= "<img src='".SYNOBLOG_IMAGES_PROTECTED_ICON."'>&nbsp;";
		$article['content'] .= __(photo_article_need_passwd);
	} else {
		// Abstract Or Content
		if(PHOTO_DB_ConvertBool($row['show_abstract']) == 'f' || $isWhole) {
			$article['content'] = $row['content'];
		} else {
			$article['is_abstract'] = true;
			$article['content'] = $row['abstract'] == null ? '' : $row['abstract'];
		}
	}
	$article['info']['author'] = __(blog_article_author).''.$row['author'];
	$article['info']['commentCount'] = SYNOBLOG_COMMENT_GetArticleCommentCount($row['article_id']).' '.__(photo_str_comment);
	$article['info']['hitCount'] = $row['hits'].' '.__(photo_str_hits);

	if ($isWhole) {
		$article['labels'] = SYNOBLOG_LABEL_GetArticleLabel($row['article_id']);
		$article['comments'] = SYNOBLOG_COMMENT_GetArticleComment($row['article_id']);
	}
	return $article;
}

function SYNOBLOG_ARTICLE_GetPageIndex($current_page, $num, $total_article)
{
	$section_size = 5;
	$offset = floor($section_size/2);
	$total_page = ceil($total_article/$num);
	$start = $current_page - $offset;
	$end = $current_page + $offset;
	$next_section = $current_page + $section_size;
	$prev_section = $current_page - $section_size;

	if ($start <= 0) {
		$start = 1;
		$end = min($section_size, $total_page);
	}
	if ($end > $total_page) {
		$end = $total_page;
		$start = max($total_page - $section_size + 1, 1);
	}
	$index_list = array();
	if ($next_section > $total_page) {
		$next_section = $total_page;
	}
	if ($prev_section < 1) {
		$prev_section = 1;
	}
	if ($start > 1) {
		$index = null;
		$index['text'] = '...';
		$index['index'] = $prev_section;
		$index_list[] = $index;
	}
	for($i = $start; $i <=$end; $i++) {
		$index = null;
		$index['text'] = $i;
		$index['index'] = $i;
		if ($i == $current_page) {
			$index['class'] = 'current-page';
		}
		else{
			$index['class'] = 'normal-page';
		}
		$index_list[] = $index;
	}
	if ($end < $total_page) {
		$index = null;
		$index['text'] = '...';
		$index['index'] = $next_section;
		$index_list[] = $index;
	}
	return $index_list;
}

function SYNOBLOG_ARTICLE_GetLists($list_type, $value)
{
	$result = null;
	$sqlParam = array();
	if ('draft' ==$list_type) {
		$title = __(blog_str_list_draft);
		$query = 'Select * from blog_article where draft = 1 order by date desc;';
	} else {
		$title = __(blog_str_list_autosave);
		$query = 'Select * from blog_article where draft = -1 order by date desc;';
	}
	if($list_type == 'label') {
		if(null != $value && '' != $value) {
			$query_label = 'Select * from blog_article_label where label_id = '.$value.';';
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query_label);
			$id_list = '';
			$label_name = '';
			while(($row = PHOTO_DB_FetchRow($db_result))) {
				$id_list = $id_list.$row['article_id'].', ';
				if('' == $label_name) {
					$label_name = $row['label_name'];
				}
			}
			if('' != $id_list) {
				if('no_label' == $label_name) {
					$title = __(blog_str_list_no_label);
				} else {
					$title = htmlspecialchars(str_replace('{0}', ' '.$label_name.' ', __(blog_str_list_label)), ENT_QUOTES);
				}
				$id_list = substr($id_list, 0, strlen($id_list)-2);
				if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
					$query = 'Select * from blog_article where article_id in ('.$id_list.') and draft = 0 order by date desc;';
				} else if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
					$query = 'Select * from blog_article where article_id in ('.$id_list.') and draft = 0 and viewing_privilege != '.SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN.' order by date desc;';
				} else {
					$query = 'Select * from blog_article where article_id in ('.$id_list.') and draft = 0 and viewing_privilege != '.SYNOBLOG_ARTICLE_PRIVILEGE_USER.' and viewing_privilege != '.SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN.' order by date desc;';
				}
			}
		}
	} else if('date' == $list_type) {
		$escape = PHOTO_DB_GetEscape();
		$title = __($blog_str_list_date);
		$title = str_replace("{0}", $value , $title);
		$sqlParam = array(PHOTO_DB_EscapForLike($value).'%');
		if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$query = "Select * from blog_article where draft = 0 and cast(date as text) like ? $escape order by date desc;";
		} else if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
			$query = "Select * from blog_article where cast(date as text) like ? $escape and draft = 0 and viewing_privilege != ".SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN.' order by date desc;';
		} else {
			$query = "Select * from blog_article where cast(date as text) like ? $escape and draft = 0 and viewing_privilege != ".SYNOBLOG_ARTICLE_PRIVILEGE_USER.' and viewing_privilege != '.SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN.' order by date desc;';
		}
	}
	if($query) {
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		$result['title'] = $title;
		$result['type'] = $list_type;
		$article_list = array();
		while($row = PHOTO_DB_FetchRow($db_result)) {
			$article_list[] = SYNOBLOG_ARTICLE_PrepareArticleData($row);
		}
		$result['list'] = $article_list;
	}
	return $result;
}

function SYNOBLOG_ARTICLE_GetAbstracts($page)
{
	global $smarty;
	$articles = SYNOBLOG_ARTICLE_GetAbstractList($page);
	$smarty->assign('STR_READ_ALL', __(blog_article_read_all));
	$smarty->assign('articleList', $articles['article_list']);
	$smarty->assign('pageIndex', $articles['page_list']);
	$smarty->assign('TOTALPAGE', $articles['total_page']);
	$smarty->assign('IS_DISABLE_SHARE', (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'disable_share') == 'on') ? true : false);
	return $smarty->Fetch('blog/article.tpl');
}

function SYNOBLOG_ARTICLE_GetArticle($article_id, $input_key)
{
	global $smarty;

	$query = "Select * from blog_article where article_id = ?;";
	$sqlParam = array($article_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	if($row = PHOTO_DB_FetchRow($db_result)) {
		$pass = SYNOBLOG_ARTICLE_CheckReadingPrivilege($row[11], $row[6], $input_key, $row[7], $article_id);
		switch($pass) {
		case -1://no privilege
			return SYNOBLOG_ARTICLE_GetErrorContent(__(article_permission_denied));
			break;
		case 0://need input key
			return SYNOBLOG_ARTICLE_GetProtectArticleContent($row);
			break;
		case 1:
			return SYNOBLOG_ARTICLE_GetWholeArticleContent($row);
			break;
		}
	} else {
		return SYNOBLOG_ARTICLE_GetErrorContent(__(article_not_exist));
	}
}

function SYNOBLOG_ARTICLE_GetWholeArticleContent($row)
{
	global $smarty;

	$row['hits'] = $row['hits'] + 1;
	SYNOBLOG_ARTICLE_UpdateArticleHits($row['article_id'], $row['hits']);
	$smarty->assign('STR_LABEL', __(photo_str_label_cloud_title));
	$smarty->assign('STR_POST_COMMENT', __(photo_str_comment_add));
	$list[]= SYNOBLOG_ARTICLE_PrepareArticleData($row, false, true);
	if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		$smarty->assign('STR_SET_STICKY', __(sticky_article_set));
		$smarty->assign('STR_CANCEL_STICKY', __(photo_str_sticky_article_cancel));
		$smarty->assign('STR_EDIT', __(photo_str_updateuser));
		$smarty->assign('STR_FROM', __(photo_str_comment_from));
		$smarty->assign('STR_EMAIL', __(photo_str_comment_email));
		$smarty->assign('STR_DELETE', __(photo_str_deleteuser));
	}
	$smarty->assign('IS_DISABLE_SHARE', (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'disable_share') == 'on') ? true : false);
	$smarty->assign('articleList', $list);
	return $smarty->Fetch('blog/article.tpl');
}

function SYNOBLOG_ARTICLE_GetProtectArticleContent($row)
{
	global $smarty;
	$smarty->assign('PROTECT_IMG', SYNOBLOG_IMAGES_PROTECTED_ICON);
	$smarty->assign('STR_NEED_PASSWD', __(photo_article_need_passwd));
	$smarty->assign('STR_ENTER_PASSWD', __(plz_enter_reading_passwd));
	$smarty->assign('STR_SUBMIT', __(photo_str_submit));
	$smarty->assign('STR_PASSWD_HINT', __(passwd_hint));
	$list[]= SYNOBLOG_ARTICLE_PrepareArticleData($row, false, false);
	$smarty->assign('articleList', $list);
	return $smarty->Fetch('blog/article.tpl');
}

function SYNOBLOG_ARTICLE_GetErrorContent($error_msg, $img = SYNOBLOG_IMAGES_ERROR_ICON)
{
	global $smarty;
	$smarty->assign('ERROR_IMG', $img);
	$smarty->assign('STR_NO_PRIVILEGE', $error_msg);
	$list[]= array($error_msg);//give an array to let smarty print one basic article layout
	$smarty->assign('articleList', $list);
	return $smarty->Fetch('blog/article.tpl');
}

function SYNOBLOG_ARTICLE_GetListsContent($list_type, $value)
{
	global $smarty;

	if('draft' == $list_type || 'autosave' == $list_type) {
		if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			return SYNOBLOG_ARTICLE_GetErrorContent(__(article_permission_denied));
		}
	}
	$smarty->assign('STR_AUTHOR', __(blog_article_author));
	$list[] = SYNOBLOG_ARTICLE_GetLists($list_type, $value);
	if ('autosave' == $list_type && count($list[0]['list']) > 0) {
		$smarty->assign('STR_DELETE', __(blog_str_delete_all_autosave));
	}
	$smarty->assign('articleList', $list);
	return $smarty->Fetch('blog/article.tpl');
}

function SYNOBLOG_ARTICLE_GetTotalArticleCount()
{
	$total_article = 0;
	if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		$query = "Select count(article_id) from blog_article where draft = 0;";
	} else if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
		$query = "Select count(article_id) from blog_article where draft = 0 and viewing_privilege != ".SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN;
	} else {
		$query = "Select count(article_id) from blog_article where draft = 0 and viewing_privilege != ".SYNOBLOG_ARTICLE_PRIVILEGE_USER." and viewing_privilege != ".SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN;
	}
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	if ($row = PHOTO_DB_FetchRow($db_result)){
		$total_article = $row[0];
	}
	return $total_article;
}

function SYNOBLOG_ARTICLE_UpdateArticleHits($article_id, $hits)
{
	$query = 'Update blog_article set hits = '.$hits.' where article_id = '.$article_id.';';
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
}

function SYNOBLOG_ARTICLE_CheckReadingPrivilege($isDraft, $privilege, $input_key, $accees_key, $article_id)
{
	$result = -1;
	if($isDraft == 1) {
		if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			$result = 1;
		} else {
			$result = -1;
		}
	} else {
		switch((string)$privilege) {
		case SYNOBLOG_ARTICLE_PRIVILEGE_PASSWD:
			if($input_key == $accees_key || isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) ||
			   $_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_article'][$article_id]) {
				$result = 1;
				$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_article'][$article_id] = true;
			} else {
				$result = 0;
			}
			break;
		case SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN:
			if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
				$result = 1;
			}
			break;
		case SYNOBLOG_ARTICLE_PRIVILEGE_USER:
			if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) || isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
				$result = 1;
			}
			break;
		case SYNOBLOG_ARTICLE_PRIVILEGE_PUBLIC:
			$result = 1;
			break;
		}
	}
	return $result;
}

function SYNOBLOG_ARTICLE_DeleteAllAutosave() {
	if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		return 0;
	}

	$query = 'Select article_id from blog_article where draft = -1';
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	while(($row = PHOTO_DB_FetchRow($db_result))) {
		SYNOBLOG_ARTICLE_DeleteArticle($row[0]);
	}

	$query = 'Delete from blog_article_autosave';
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);

	return 1;
}

function SYNOBLOG_ARTICLE_DeleteArticle($article_id)
{
	if(!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		return 0;
	}

	SYNOBLOG_COMMENT_DeleteComment_ByArticleID($article_id);
	SYNOBLOG_LABEL_DeleteArticleLabel($article_id);

	$query = "Delete from blog_article where article_id = ?";
	$sqlParam = array($article_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	$query = "Select autosave_id from blog_article_autosave where article_id = ?";

	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
	while(($row = PHOTO_DB_FetchRow($db_result))) {
		SYNOBLOG_ARTICLE_DeleteArticle($row[0]);
	}
}

function SYNOBLOG_ARTICLE_SaveArticle()
{
	csSYNOPhotoMisc::CheckAdminTimeOut();
	$article_id = $_POST['article_id'];
	$_POST['show_abstract'] = ($_POST['show_abstract'] == 'on' || $_POST['show_abstract']== 'true') ? 't':'f';
	$_POST['allow_comment'] = ($_POST['allow_comment'] == 'on' || $_POST['allow_comment']== 'true') ? 't':'f';

	if($_POST['isdraft'] == -1) {//autosave
		if($_POST['autosave_id'] == -1) {//new one
			$article_id = SYNOBLOG_ARTICLE_SaveArticle_New();
			SYNOBLOG_AUTOSAVE_AddAutosave($article_id, $_POST['article_id']);
		} else {
			$article_id = $_POST['autosave_id'];
			SYNOBLOG_ARTICLE_SaveArticle_Update($article_id);
		}
	} else {
		if($article_id == -1) {
			$article_id = SYNOBLOG_ARTICLE_SaveArticle_New();
		} else {
			SYNOBLOG_ARTICLE_SaveArticle_Update($article_id);
		}

		if($_POST['autosave_id'] == -1) {
		} else {
			SYNOBLOG_ARTICLE_DeleteArticle($_POST['autosave_id']);
			SYNOBLOG_AUTOSAVE_DeleteAutosaveByAutosaveId($_POST['autosave_id']);
		}
	}

	SYNOBLOG_LABEL_DeleteArticleLabel($article_id);
	SYNOBLOG_LABEL_AddArticleLabel($article_id, $_POST['label']);

	if (isSet($_POST['photo_list']) || isSet($_POST['video_list'])) {
		SYNOPHOTO_ADMIN_DeleteItems();
	}

	$result['success'] = TRUE;
	$result['article_id'] = $article_id;
	echo json_encode($result);
}

function SYNOBLOG_ARTICLE_SaveArticle_New()
{
	if($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'] != '') {
		$author = $_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'];
	} else {
		$author = 'admin';
	}
	$date = $_POST['date']." ".date('H:i:s');
	$query = "Insert Into blog_article (author, date, title, abstract, content, viewing_privilege, ";
	$query = $query."access_key, access_key_hint, allow_comment, draft, show_abstract) ";
	$query = $query."Values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
	$sqlParam = array($author, $date, $_POST['title'], $_POST['abstract_content'], $_POST['article_content'],
				$_POST['viewing_privilege'], $_POST['access_key'], $_POST['access_key_hint'],
				$_POST['allow_comment'], $_POST['isdraft'], $_POST['show_abstract']);

	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	$query = "Select article_id from blog_article where date = '".$date."';";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$row = PHOTO_DB_FetchRow($db_result);

	return $row['article_id'];
}

function SYNOBLOG_ARTICLE_SaveArticle_Update($article_id)
{
	$query = 'Update blog_article set ';

	$time = date('H:i:s');
	if($_POST['isdraft'] == 0 && $_POST['time'] != null && $_POST['time'] != "") {
		$time = $_POST['time'];
	}

	$date = $_POST['date']." ".$time;
	$query = $query."date = ?, ";
	$query = $query."title = ?, ";
	$query = $query."abstract = ?, ";
	$query = $query."content = ?, ";
	$query = $query."viewing_privilege = ?, ";
	$query = $query."access_key = ?, ";
	$query = $query."access_key_hint = ?, ";
	$query = $query."allow_comment = ?, ";
	$query = $query."draft = ?, ";
	$query = $query."show_abstract = ? ";
	$query = $query."where article_id = ?;";
	$sqlParam = array($date, $_POST['title'], $_POST['abstract_content'], $_POST['article_content'],
				$_POST['viewing_privilege'], $_POST['access_key'], $_POST['access_key_hint'],
				$_POST['allow_comment'], $_POST['isdraft'], $_POST['show_abstract'], $article_id);
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
}

function SYNOBLOG_ARTICLE_GetAutosaveInterval()
{
	$query = "Select config_value from blog_config where module_name = 'main' and config_key = 'autosave_interval'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$row = PHOTO_DB_FetchRow($db_result);
	return $row[0];
}

function SYNOBLOG_ARTICLE_GetDaysWithBlogArticle($firstDay, $lastDay)
{
	$firstDay = $firstDay.' 00:00:00';
	$lastDay = $lastDay.' 00:00:00';
	$sqlParam = array($firstDay, $lastDay);
	if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		$query = "Select date from blog_article where draft = 0 and date BETWEEN ? and ?";
	} else if(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user'])) {
		$query = "Select date from blog_article where draft = 0 and viewing_privilege != ".SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN." and date BETWEEN ? and ?";
	} else {
		$query = "Select date from blog_article where draft = 0 and viewing_privilege != ".SYNOBLOG_ARTICLE_PRIVILEGE_USER." and viewing_privilege != ".SYNOBLOG_ARTICLE_PRIVILEGE_ADMIN." and date BETWEEN ? and ?";
	}
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

	$i = 0;
	while(($row = PHOTO_DB_FetchRow($db_result))) {
		$result[$i]['y'] = substr($row[0], 0, 4);
		$result[$i]['m'] = substr($row[0], 5, 2);
		$result[$i]['d'] = substr($row[0], 8, 2);
		$i++;
	}
	return json_encode($result);
}
?>
