<?php
require_once("include/syno_conf.php");

$DSM_VERSION = csSYNOPhotoMisc::GetDsmVersion();
$PACKAGE_VERSION = csSYNOPhotoMisc::GetPackageVersion();
$LANGUAGE = $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];
$DEBUG = isset($_GET['jsDebug']);
$PAGE_TITLE = "Photo Station 6";
$blDemoMode = 'false';
$isDemoMode = csSYNOPhotoMisc::GetConfigFile(SYNO_CNF_FILE, 'enable_demomode');
if ('yes' === $isDemoMode['enable_demomode']) {
    $blDemoMode = 'true';
}
?>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">

	<!-- javascript -->
	<script type="text/javascript" src="scripts/uistrings.php?v=<?php echo $DSM_VERSION ?>&ln=<?php echo $LANGUAGE ?>"></script>
	<script type="text/javascript" src="photo_new/ext-3/adapter/ext/ext-base.js?v=<?php echo $PACKAGE_VERSION ?>"></script>
	<script type="text/javascript" src="photo_new/ext-3/ext-all.js?v=<?=$PACKAGE_VERSION?>"></script>
	<script type="text/javascript" src="photo_new/ext-3/ux/ux-all.js?v=<?php echo $PACKAGE_VERSION ?>"></script>
	<script type="text/javascript" src="../photo/include/client_string.php?v=<?php echo $PACKAGE_VERSION ?>&ln=<?php echo $LANGUAGE ?>"></script>
	<script type="text/javascript" src="photo_new/flexcroll/flexcroll.js?v=<?php echo $PACKAGE_VERSION ?>"></script>
	<script type="text/javascript" src="tinymce/jscripts/tiny_mce/tiny_mce.js?v=<?php echo $PACKAGE_VERSION ?>"></script>
    <script>
            var gIsDemoMode = false;
            if ("true" === ("<?php echo $blDemoMode;?>")) {
                gIsDemoMode = true;
            }
    </script>
	<?php
	if ($DEBUG === true) {
	    $jsFiles = array(
		'javascripts/utils.js', 'photo_new/js/BaseWindow.js', 'photo_new/js/Debug.js', 'photo_new/js/MessageBox.js',
		'javascripts/blog/synoblog.js', 'javascripts/blog/template_module.js',
		'photo_new/js/util.js', 'photo_new/js/admin/CommonFormPanel.js', 'photo_new/js/admin/account_panel.js', 'photo_new/js/admin/blog_panel.js',
		'photo_new/js/admin/center_panel.js', 'photo_new/js/admin/dialog_album_privilege.js',
		'photo_new/js/admin/dialog_blog_banner_content.js', 'photo_new/js/admin/dialog_group.js', 'photo_new/js/admin/dialog_label_manage.js',
		'photo_new/js/admin/dialog_layout_module.js', 'photo_new/js/admin/dialog_privilege.js', 'photo_new/js/admin/dialog_user.js', 'photo_new/js/admin/general_panel.js',
		'photo_new/js/admin/group_panel.js', 'photo_new/js/admin/left_panel.js', 'photo_new/js/admin/log_panel.js', 'photo_new/js/admin/main.js',
		'photo_new/js/admin/photo_panel.js', 'photo_new/js/admin/treegrid.js', 'photo_new/js/admin/user_panel.js'
	    );
	} else {
		$jsFiles = array('photo_new/syno_photo_setting.js');
	}
	printf("\t<script type=\"text/javascript\">debugMode = " . ($DEBUG ? 'true' : 'false') . ";</script>\n");

	foreach ($jsFiles as $item) {
		printf(
			"\t<script type=\"text/javascript\" src=\"%s?v=%s%s\"></script>\n",
			$item, $PACKAGE_VERSION, ($DEBUG === true) ? '&_dc='.time() : ''
		);
	}
	?>
	<!-- for blog setting --> 
	<?php
		$blogJS = glob("blog/modules/*.js");
		foreach ($blogJS as $file) {
		    print "\t<script type=text/javascript src=$file?v=$PACKAGE_VERSION ></script>\n";
		}
	?>

	<!-- style sheet -->
	<link rel="stylesheet" type="text/css" href="photo_new/ext-3/resources/css/ext-all.css?v=<?php echo $PACKAGE_VERSION ?>" />
	<link rel="stylesheet" type="text/css" href="photo_new/ext-3/resources/css/xtheme-gray-syno.css?v=<?php echo $PACKAGE_VERSION ?>" />
	<link rel="stylesheet" type="text/css" href="photo_new/ext-3/ux/ux-all.css?v=<?php echo $PACKAGE_VERSION ?>" />
	<link rel="stylesheet" type="text/css" href="css/flexcrollstyles.css?v=<?php echo $PACKAGE_VERSION ?>" />
	<link rel="stylesheet" type="text/css" href="photo_new/css/style.css?v=<?php echo $PACKAGE_VERSION ?>">
	<link rel="stylesheet" type="text/css" href="css/treegrid.css?v=<?=$PACKAGE_VERSION?>" />

	<link rel="shortcut icon" href="favicon.ico">

	<title><?php echo $PAGE_TITLE ?></title>
</head>
<body>
	<iframe id="login_iframe" name="login_iframe" width="0" height="0" frameborder="0"></iframe>
	<form id="login_form" class="login_form" method="POST" action="webapi/auth.php" target="login_iframe" style="filter: Alpha(opacity=0); opacity: 0;">
		<input type="text" id="login_api" name="api" class="sbox-text login-input" />
		<input type="text" id="login_method" name="method" class="sbox-text login-input" />
		<input type="text" id="login_version" name="version" class="sbox-text login-input" />
		<input type="text" id="login_username" name="username" class="sbox-text login-input" />
		<input type="password" id="login_password" name="password" class="sbox-text login-input"/>
		<input type="submit" style="display: none;">
	</form>
	<form id="history-form" class="x-hidden">
		<input type="hidden" id="x-history-field" />
		<iframe id="x-history-frame"></iframe>
	</form>
</body>
</html>
