<?php
require_once("../include/syno_conf.php");

if (preg_match('/^(get_setting|set_setting|delete_fb_token|get_fb_setting)$/', $_POST['action'])) {
	csSYNOPhotoMisc::CheckAdminTimeOut();
}

switch ($_POST['action']) {
case "get_setting":
	echo SYNOPHOTO_ADMIN_GetGeneralSettings();
	break;
case "set_setting":
	echo SYNOPHOTO_ADMIN_SetGeneralSettings();
	break;
case "get_fb_setting":
	echo SYNOPHOTO_ADMIN_GetFbSettings();
	break;
case "delete_fb_token":
	echo SYNOPHOTO_ADMIN_DeleteFbToken();
	break;
}

function SYNOPHOTO_ADMIN_GetPackageConfig($key, &$value)
{
	if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg'][$key])) {
		return false;
	}

	$value = $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg'][$key];

	return true;
}

function SYNOPHOTO_ADMIN_GetGeneralSettings()
{
	csSYNOPhotoMisc::CheckAdminTimeOut();

    // socail network
    $social = SocialNetwork::ReadList();
    if (is_array($social)) {
        foreach ($social as $item) {
            if ('Facebook' === $item['name']) {
                $result['data']['social_facebook'] = (true === $item['enable']) ? 'on' : 'off';
            }
            if ('Twitter' === $item['name']) {
                $result['data']['social_twitter'] = (true === $item['enable']) ? 'on' : 'off';
            }
            if ('Plurk' === $item['name']) {
                $result['data']['social_plurk'] = (true === $item['enable']) ? 'on' : 'off';
            }
            if ('Google+' === $item['name']) {
                $result['data']['social_googlep'] = (true === $item['enable']) ? 'on' : 'off';
            }
            if ('Weibo' === $item['name']) {
                $result['data']['social_weibo'] = (true === $item['enable']) ? 'on' : 'off';
            }
            if ('QQ' === $item['name']) {
                $result['data']['social_qq'] = (true === $item['enable']) ? 'on' : 'off';
            }
        }
    }


	$result['data']['lang_setting'] = csSYNOPhotoMisc::GetConfigDB("global", "lang_setting", "photo_config");
	if($result['data']['lang_setting'] == null || $result['data']['lang_setting'] == "") {
		$result['data']['lang_setting'] = "0";
	}
	$result['data']['account_system'] = csSYNOPhotoMisc::GetConfigDB("global", "account_system", "photo_config");
	if($result['data']['account_system'] == null || $result['data']['account_system'] == "") {
		$result['data']['account_system'] = "0";
	}

	$result['isHomeServiceEnable'] = false;
	if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['userHomeEnable'])&&
		 'yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['userHomeEnable']) {
		$result['isHomeServiceEnable'] = true;
	}

	$result['data']['enable_personal_photo'] = 'off';
	if ($result['isHomeServiceEnable'] && isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runpersonalphotostation']) &&
		'yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['runpersonalphotostation']) {
		$result['data']['enable_personal_photo'] = 'on';
	}

	$result['data']['def_album_public'] = 'off';
	if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['albumdefpublic']) &&
		'yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['albumdefpublic']) {
		$result['data']['def_album_public'] = 'on';
	}

	$pkgConfig = SYNOPHOTO_ADMIN_GET_PKG_CONF();
	$result['data']['hide_dsm_icon'] = 'off';
	if(isSet($pkgConfig['.url']['SYNO.SDS.PhotoStation']['allUsers'])) {
		$result['data']['hide_dsm_icon'] = $pkgConfig['.url']['SYNO.SDS.PhotoStation']['allUsers'] ? 'off':'on';
	}

	//external port
	$result['data']['external_dns_or_ip'] = '';
	if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_host_ip'])) {
		$result['data']['external_dns_or_ip'] = $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_host_ip'];
	}
	$result['data']['external_port_photo_http'] = '';
	if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_port_photo_http'])) {
		$result['data']['external_port_photo_http'] = $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_port_photo_http'];
	}
	$result['data']['external_port_photo_https'] = '';
	if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_port_photo_https'])) {
		$result['data']['external_port_photo_https'] = $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['pkgCfg']['external_port_photo_https'];
	}

	//social network
	$result['data']['share_upload_orig'] = 'off';
	if (csSYNOPhotoMisc::GetConfigDB("photo", "share_upload_orig", "photo_config") == 'on') {
		$result['data']['share_upload_orig'] = 'on';
	}
	$result['data']['enable_share'] = "on";
	if(csSYNOPhotoMisc::GetConfigDB("photo", "disable_share", "photo_config") == "on") {
		$result['data']['enable_share'] = "off";
	}
	$result['data']['allow_guest_fb_upload'] = csSYNOPhotoMisc::GetConfigDB("photo", "allow_guest_fb_upload", "photo_config");
	if($result['data']['allow_guest_fb_upload'] == null || $result['data']['allow_guest_fb_upload'] == "") {
		$result['data']['allow_guest_fb_upload'] = "off";
	}

	//impressum
	$result['data']['impressum_text'] = '';
	$impressumTemp = csSYNOPhotoMisc::GetConfigDB("photo", "impressum_text", "photo_config");
	if (null !== $impressumTemp) {
		$result['data']['impressum_text'] = $impressumTemp;
	}
	$result['data']['impressum_link'] = '';
	$impressumTemp = csSYNOPhotoMisc::GetConfigDB("photo", "impressum_link", "photo_config");
	if (null !== $impressumTemp) {
		$result['data']['impressum_link'] = $impressumTemp;
	}

	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_SetGeneralSettings()
{
	if ('yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['enable_demomode']) {
		return json_encode(array(
			'success' => false,
			'error' => __(photo_str_error_demo)
		));
	}

	csSYNOPhotoMisc::UpdateConfigDB("global", "lang_setting", $_POST['lang_setting'], "photo_config");
	if ('root' == SYNOPHOTO_ADMIN_USER) {
		csSYNOPhotoMisc::UpdateConfigDB("global", "account_system", $_POST['account_system'], "photo_config");
	}

	$newRunPPS = $_POST['enable_personal_photo']==='on'? 'yes':'no';
	csSYNOPhotoMisc::SetConfigFile(SYNO_PKG_CNF_FILE, 'runpersonalphotostation', $newRunPPS);

	$oldRunPPS = 'no';
	SYNOPHOTO_ADMIN_GetPackageConfig('runpersonalphotostation', $oldRunPPS);
	if ($newRunPPS === 'yes' && $oldRunPPS === 'no') {
		// signal synoindexd to reload package index config for Personal Photo Station
		@exec("/usr/syno/bin/synophoto_dsm_user --hupsynoindexd");
	}

	csSYNOPhotoMisc::SetConfigFile(SYNO_PKG_CNF_FILE, 'albumdefpublic', $_POST['def_album_public']==='on'? 'yes':'no');
	csSYNOPhotoMisc::SetConfigFile(SYNO_PKG_CNF_FILE, 'photo_hide_icon', $_POST['hide_dsm_icon']==='on'? 'yes':'no');

	$pkgConfig = SYNOPHOTO_ADMIN_GET_PKG_CONF();
	$pkgConfig['.url']['SYNO.SDS.PhotoStation']['allUsers'] = $_POST['hide_dsm_icon'] === 'on' ? false:true;
	$confFile = SYNO_PKG_DIR.'/target/ui/config';
	file_put_contents($confFile, json_encode($pkgConfig));

	csSYNOPhotoMisc::SetConfigFile(SYNO_PKG_CNF_FILE, 'external_host_ip', $_POST['external_dns_or_ip']);
	csSYNOPhotoMisc::SetConfigFile(SYNO_PKG_CNF_FILE, 'external_port_photo_http', $_POST['external_port_photo_http']);
	csSYNOPhotoMisc::SetConfigFile(SYNO_PKG_CNF_FILE, 'external_port_photo_https', $_POST['external_port_photo_https']);

	csSYNOPhotoMisc::UpdateConfigDB("photo", "allow_guest_fb_upload", $_POST['allow_guest_fb_upload'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "share_upload_orig", $_POST['share_upload_orig'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "disable_share", $_POST['enable_share'] == "on"? "off":"on", "photo_config");
	SYNOPHOTO_ADMIN_SetAllowFbRegularSync('on' == $_POST['allow_fb_regular_sync']);

	csSYNOPhotoMisc::UpdateConfigDB("photo", "impressum_text", $_POST['impressum_text'], "photo_config");
	csSYNOPhotoMisc::UpdateConfigDB("photo", "impressum_link", $_POST['impressum_link'], "photo_config");

    // social network
    $social = array();
    unset($item);
    $item['name'] = 'Facebook';
    $item['enable'] = ('on' === $_POST['social_facebook']) ? true : false;
    array_push($social, $item);
    unset($item);
    $item['name'] = 'Twitter';
    $item['enable'] = ('on' === $_POST['social_twitter']) ? true : false;
    array_push($social, $item);
    unset($item);
    $item['name'] = 'Plurk';
    $item['enable'] = ('on' === $_POST['social_plurk']) ? true : false;
    array_push($social, $item);
    unset($item);
    $item['name'] = 'Google+';
    $item['enable'] = ('on' === $_POST['social_googlep']) ? true : false;
    array_push($social, $item);
    unset($item);
    $item['name'] = 'Weibo';
    $item['enable'] = ('on' === $_POST['social_weibo']) ? true : false;
    array_push($social, $item);
    unset($item);
    $item['name'] = 'QQ';
    $item['enable'] = ('on' === $_POST['social_qq']) ? true : false;
    array_push($social, $item);
    SocialNetwork::SaveList($social);


	csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);
	csSYNOPhotoDB::GetDBInstance()->SetSessionSystemConfigsFromFile();
	return SYNOPHOTO_ADMIN_GetGeneralSettings();
}

function SYNOPHOTO_ADMIN_GET_PKG_CONF()
{
	$confFile = SYNO_PKG_DIR.'/target/ui/config';
	if (!@file_exists($confFile)
			|| false === ($result = @file_get_contents($confFile))) {
			return null;
		}
		$result = json_decode($result, true);
		if (empty($result)) {
			return null;
		}
		return $result;
}

function SYNOPHOTO_ADMIN_GetFbSettings()
{
	$fb_utils = csSYNOPhotoMisc::CheckFbTokenValid();

	$result['data']['fb_status_descr'] = $fb_utils ? $fb_utils->user_name.' '. __(photo_fb_auth_ok) : __(photo_fb_auth_not_yet);
	$result['data']['fb_auth_status'] = $fb_utils ? true : false;

	$result['data']['fb_allow_regular_sync'] = false;
	if ($fb_utils && @file_exists(SYNOPHOTO_FB_REGULAR_SYNC_CONF)) {
		$conf_arr = json_decode(file_get_contents(SYNOPHOTO_FB_REGULAR_SYNC_CONF));
		if(in_array(SYNOPHOTO_ADMIN_NAME, $conf_arr)) {
			$result['data']['fb_allow_regular_sync'] = true;
		}
	} else {
		SYNOPHOTO_ADMIN_SetAllowFbRegularSync(false);
	}
	$result['success'] = TRUE;
	return json_encode($result);
}

function SYNOPHOTO_ADMIN_SetAllowFbRegularSync($enable)
{
	if (!@file_exists(SYNOPHOTO_FB_REGULAR_SYNC_CONF)) {
		if ($enable) {
			$conf_arr = array();
			$conf_arr[] = SYNOPHOTO_ADMIN_NAME;
			if (null != ($handle = @fopen(SYNOPHOTO_FB_REGULAR_SYNC_CONF, 'w'))) {
				fwrite($handle, json_encode($conf_arr));
				fclose($handle);
			}
			$commend = "/usr/syno/bin/synophoto_sns_utils --regular_fbsync add";
			@exec($commend." > /dev/null 2>&1");
		}
		return;
	}

	$conf_arr = json_decode(file_get_contents(SYNOPHOTO_FB_REGULAR_SYNC_CONF));
	if ($enable) {
		if (in_array(SYNOPHOTO_ADMIN_NAME, $conf_arr)) {
			return;
		}
		$conf_arr[] = SYNOPHOTO_ADMIN_NAME;
		if (null != ($handle = @fopen(SYNOPHOTO_FB_REGULAR_SYNC_CONF, 'w'))) {
			fwrite($handle, json_encode($conf_arr));
			fclose($handle);
		}
	} else {
		$new_arr = array();
		for ($i = 0; $i < count($conf_arr); $i++) {
			if (SYNOPHOTO_ADMIN_NAME != $conf_arr[$i]) {
				$new_arr[] = $conf_arr[$i];
			}
		}
		if (0 == count($new_arr)) {
			@unlink(SYNOPHOTO_FB_REGULAR_SYNC_CONF);
			$commend = "/usr/syno/bin/synophoto_sns_utils --regular_fbsync remove";
			@exec($commend." > /dev/null 2>&1");
			return;
		}
		if (null != ($handle = @fopen(SYNOPHOTO_FB_REGULAR_SYNC_CONF, 'w'))) {
			fwrite($handle, json_encode($new_arr));
			fclose($handle);
		}
	}
}

function SYNOPHOTO_ADMIN_DeleteFbToken()
{
	$query = "delete from photo_config where config_key = 'fb_token'";
	$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
	$result['success'] = TRUE;
	return json_encode($result);
}
?>
