<?php
// Change the header chache-control to "must-revalidate" before session_start
session_cache_limiter("must-revalidate");

require_once("../include/syno_conf.php");

csSYNOPhotoMisc::CheckAdminTimeOut();

if ($_POST['action'] == "get_backup_status") {
	echo SYNOPHOTO_BACKUP_GetBackupStatus();
} else if ($_GET['action'] == "backup") {
	SYNOPHOTO_BACKUP_WriteStatus("start");
	SYNOPHOTO_BACKUP_DoBackup();
} else if ($_POST['action'] == "add_pps_log") {
	echo SYNOPHOTO_BACKUP_AddPPSLog();
} else if ($_POST['type'] == "restore") {
	SYNOPHOTO_BACKUP_WriteStatus("start");
	echo SYNOPHOTO_BACKUP_DoRestore($_POST['is_overwrite'] == "yes"?"-o":"");
}

function SYNOPHOTO_BACKUP_GetBackupStatus()
{
	$status = '';
	if (file_exists(SYNOPHOTO_BACKUP_PROGRESS_FILE.".".$_POST['prog_id'])) {
		$status = csSYNOPhotoMisc::GetConfigFile(SYNOPHOTO_BACKUP_PROGRESS_FILE.".".$_POST['prog_id'], 'status');
		$status = $status['status'];
	}

	if ($status == "finish" || $status == "error") {
		unlink(SYNOPHOTO_BACKUP_PROGRESS_FILE.".".$_POST['prog_id']);
	}

	$result['success'] = $status;
	return json_encode($result);
}

function SYNOPHOTO_BACKUP_DoBackup()
{
	$pid_file = SYNOPHOTO_BACKUP_PID_FILE;
	$tmp_dir = SYNOPHOTO_BACKUP_PHP_TMP_DIR;
	$param_user = '';
	if ('root' != SYNOPHOTO_ADMIN_USER) {
		$pid_file = SYNOPHOTO_BACKUP_PID_FILE.'.'.SYNOPHOTO_ADMIN_NAME;
		$tmp_dir = SYNOPHOTO_BACKUP_PHP_TMP_DIR.'/'.SYNOPHOTO_ADMIN_NAME.'/';
		$param_user = '-u '.escapeshellarg(SYNOPHOTO_ADMIN_NAME);
	}

	if (file_exists($pid_file)) {
		SYNOPHOTO_BACKUP_WriteStatus("wait");
		return;
	}

	if (!file_exists($tmp_dir)) {
		mkdir($tmp_dir, 0777, true);
	}

	//generate dump file
	if (SYNOPHOTO_BACKUP_GenerateDumpFile($tmp_dir, $param_user) === false) {
		SYNOPHOTO_BACKUP_WriteStatus("error");
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog('System failed to backup blog data.', 'f', 'admin');
	} else {
		if (file_exists($tmp_dir.SYNOPHOTO_BACKUP_FINAL_FILE)) {
			SYNOPHOTO_BACKUP_WriteStatus("finish");
			header("Content-Type: application/xxx");
			header("Content-Disposition: inline; filename=\"".SYNOPHOTO_BACKUP_FINAL_FILE."\"");
			readfile($tmp_dir.SYNOPHOTO_BACKUP_FINAL_FILE);
			unlink($tmp_dir.SYNOPHOTO_BACKUP_FINAL_FILE);
			unlink($tmp_dir.SYNOPHOTO_BACKUP_DUMP_FILE);
			unlink($tmp_dir.SYNOPHOTO_BACKUP_TIME_FILE);
			csSYNOPhotoDB::GetDBInstance()->AddPhotoLog('System successfully backup blog data.', 't', 'admin');
		}
	}

	if ('root' != SYNOPHOTO_ADMIN_USER) {
		@rmdir($tmp_dir);
	}
}

function SYNOPHOTO_BACKUP_GenerateDumpFile($tmp_dir, $param_user)
{
	$commend = "/usr/syno/bin/synoblog_backup -b ".escapeshellarg($tmp_dir).' '.$param_user;
	@system($commend, $retval);
	if ($retval != 0) {
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog("commend failed", 'f', 'admin');
		return false;
	}
	if (file_exists($tmp_dir.SYNOPHOTO_BACKUP_DUMP_FILE)) {
		$time = date('y-m-d H:i');
		$version = csSYNOPhotoMisc::GetConfigFile(SYNO_DEF_VERSION_FILE, 'buildnumber');
		$version = $version['buildnumber'];
		$type = ('root' == SYNOPHOTO_ADMIN_USER)? 'ps':'pps';
		$handle = @fopen($tmp_dir.SYNOPHOTO_BACKUP_TIME_FILE, "w");
		@fwrite($handle, 'backuptime="'.$time."\"\n".
						 'version="'.$version."\"\n".
						 'type="'.$type."\"\n".
						 'schema_version="'.SYNOPHOTO_BACKUP_SCHEMA_VERSION."\"\n");
		fclose($handle);
		$final_file = escapeshellarg($tmp_dir.SYNOPHOTO_BACKUP_FINAL_FILE);
		$commend = "/usr/syno/bin/tar -zcvf $final_file ".SYNOPHOTO_BACKUP_DUMP_FILE.' '.SYNOPHOTO_BACKUP_TIME_FILE.' -C '.escapeshellarg($tmp_dir)." > /dev/null 2>&1";
		@system($commend, $retval);
		if ($retval != 0) {
			csSYNOPhotoDB::GetDBInstance()->AddPhotoLog("fail ".$commend, 'f', 'admin');
			return false;
		}
		return true;
	}
}

function SYNOPHOTO_BACKUP_DoRestore($overwrite_para)
{
	$pid_file = SYNOPHOTO_BACKUP_PID_FILE;
	$tmp_dir = SYNOPHOTO_BACKUP_PHP_TMP_DIR;
	$param_user = '';
	if ('root' != SYNOPHOTO_ADMIN_USER) {
		$pid_file = SYNOPHOTO_BACKUP_PID_FILE.'.'.SYNOPHOTO_ADMIN_NAME;
		$tmp_dir = SYNOPHOTO_BACKUP_PHP_TMP_DIR.'/'.SYNOPHOTO_ADMIN_NAME.'/';
		$param_user = '-u '.escapeshellarg(SYNOPHOTO_ADMIN_NAME);
	}

	if (file_exists($pid_file)) {
		$result['success'] = 'another_proccessing';
		return json_encode($result);
	}

	$fsize = $_FILES["file"]["size"];

	if ($fsize > disk_free_space(SYNOPHOTO_BACKUP_PHP_TMP_DIR)) {
		$result['success'] = 'disk_free_space_error';
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog('System failed to restore blog data.', 'f', 'admin');
		return json_encode($result);
	}

	$tar_file = $tmp_dir.SYNOPHOTO_BACKUP_FINAL_FILE;
	if (!file_exists($tmp_dir)) {
		@mkdir($tmp_dir, 0777, true);
	}

	rename($_FILES['file']['tmp_name'], $tar_file);

	if (!SYNOPHOTO_BACKUP_CheckUploadFile($tmp_dir)){
		$result['success'] = 'invalid_file';
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog('System failed to restore blog data.', 'f', 'admin');
		unlink($tmp_dir.SYNOPHOTO_BACKUP_FINAL_FILE);
		unlink($tmp_dir.SYNOPHOTO_BACKUP_DUMP_FILE);
		unlink($tmp_dir.SYNOPHOTO_BACKUP_TIME_FILE);
		return json_encode($result);
	}

	$command = "/usr/syno/bin/synoblog_backup -r ".escapeshellarg($tmp_dir).' '.$param_user.' '.$overwrite_para;
	@system($command, $retval);
	if ($retval != 0) {
		$result['success'] = 'restore_blog_failed';
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog('System failed to restore blog data.', 'f', 'admin');
	} else {
		$result['success'] = 'restore_blog';
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog('System successfully restored blog data.', 't', 'admin');
	}

	SYNOPHOTO_BACKUP_WriteStatus("finish");

	unlink($tmp_dir.SYNOPHOTO_BACKUP_FINAL_FILE);
	unlink($tmp_dir.SYNOPHOTO_BACKUP_DUMP_FILE);
	unlink($tmp_dir.SYNOPHOTO_BACKUP_TIME_FILE);

	if ('root' != SYNOPHOTO_ADMIN_USER) {
		@rmdir($tmp_dir);
	}
	return json_encode($result);
}

function SYNOPHOTO_BACKUP_WriteStatus($status)
{
	if ($_POST['prog_id'] != null && $_POST['prog_id'] != "") {
		$prog_id = $_POST['prog_id'];
	} else {
		$prog_id = $_GET['prog_id'];
	}
	$handle = @fopen(SYNOPHOTO_BACKUP_PROGRESS_FILE.".".$prog_id, "w");
	@fwrite($handle, "status=\"".$status."\"\n");
	fclose($handle);
}

function SYNOPHOTO_BACKUP_CheckUploadFile($tmp_dir)
{
	$tar_file = $tmp_dir.SYNOPHOTO_BACKUP_FINAL_FILE;
	$dump_file = $tmp_dir.SYNOPHOTO_BACKUP_DUMP_FILE;
	$time_file = $tmp_dir.SYNOPHOTO_BACKUP_TIME_FILE;
	$current_type = preg_match('/\/~[^\/]+/', $_SERVER['REQUEST_URI'], $matches) ? 'pps' : 'ps';

	$commend = "/usr/syno/bin/tar -zxvf ".escapeshellarg($tar_file)." -C ".escapeshellarg($tmp_dir)." > /dev/null 2>&1";
	@system($commend, $retval);
	if (false === $retval || !file_exists($dump_file) || !file_exists($time_file)) {
		return false;
	}

	$conf = csSYNOPhotoMisc::GetConfigFile($time_file, 'type|schema_version');
	$type = $conf['type'];
	$schema_version = $conf['schema_version'];

	//before pps, we do not record these information in time file
	if (!isSet($conf['schema_version'])) {
		$schema_version = '1.0';
	}
	if (!isSet($conf['type'])) {
		$type = 'ps';
	}

	if ($type != $current_type || $schema_version != SYNOPHOTO_BACKUP_SCHEMA_VERSION) {
		return false;
	}

	return true;
}

function SYNOPHOTO_BACKUP_AddPPSLog()
{
	$result['success'] = false;
	if (!isSet($_POST['success'])) {
		return json_encode($result);
	}

	if ($_POST['success'] === 'true') {
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog('System successfully restored blog data.', 't', 'admin');
	} else {
		csSYNOPhotoDB::GetDBInstance()->AddPhotoLog('System failed to restore blog data.', 'f', 'admin');
	}

	$result['success'] = true;
	return json_encode($result);
}

?>
