<?php
require_once("include/syno_conf.php");

$DSM_VERSION = csSYNOPhotoMisc::GetDsmVersion();
$PACKAGE_VERSION = csSYNOPhotoMisc::GetPackageVersion();
$LANGUAGE = $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];
$DEBUG = isset($_GET['jsDebug']);
$PAGE_TITLE = "Photo Station 6";
?>
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">

	<!-- javascript -->
	<script type="text/javascript" src="scripts/uistrings.php?v=<?php echo $DSM_VERSION ?>&ln=<?php echo $LANGUAGE ?>"></script>
	<script type="text/javascript" src="scripts/prototype-1.6.1/prototype.js?v=<?=$DSM_VERSION?>"></script>
	<script type="text/javascript" src="photo_new/ext-3/adapter/ext/ext-base.js?v=<?php echo $PACKAGE_VERSION ?>"></script>
	<script type="text/javascript" src="photo_new/ext-3/ext-all.js?v=<?php echo $PACKAGE_VERSION ?>"></script>
	<script type="text/javascript" src="photo_new/ext-3/ux/ux-all.js?v=<?php echo $PACKAGE_VERSION ?>"></script>
	<script type="text/javascript" src="../photo/include/client_string.php?v=<?php echo $PACKAGE_VERSION ?>&ln=<?php echo $LANGUAGE ?>"></script>
	<?php
	if ($DEBUG === true) {
	    $jsFiles = array('tinymce/plugins/compat3x/tiny_mce_popup.js','photo_new/js/BaseWindow.js','photo_new/js/util.js',
		'photo_new/js/about_me_file_chooser.js', 'photo_new/js/file_selector.js');
	} else {
		$jsFiles = array('photo_new/syno_file_chooser.js');
	}
	printf("\t<script type=\"text/javascript\">debugMode = " . ($DEBUG ? 'true' : 'false') . ";</script>\n");

	foreach ($jsFiles as $item) {
		printf(
			"\t<script type=\"text/javascript\" src=\"%s?v=%s%s\"></script>\n",
			$item, $PACKAGE_VERSION, ($DEBUG === true) ? '&_dc='.time() : ''
		);
	}
	?>

	<!-- style sheet -->
	<link rel="stylesheet" type="text/css" href="photo_new/ext-3/resources/css/ext-all.css?v=<?php echo $PACKAGE_VERSION ?>" />
	<link rel="stylesheet" type="text/css" href="photo_new/ext-3/resources/css/xtheme-gray-syno.css?v=<?php echo $PACKAGE_VERSION ?>" />
	<link rel="stylesheet" type="text/css" href="photo_new/ext-3/ux/ux-all.css?v=<?php echo $PACKAGE_VERSION ?>" />
	<link rel="stylesheet" type="text/css" href="photo_new/css/style.css?v=<?php echo $PACKAGE_VERSION ?>">
	<link rel="stylesheet" type="text/css" href="./photo_new/css/imageChooser.css?v=<?php echo $PACKAGE_VERSION ?>">

	<link rel="shortcut icon" href="favicon.ico">

	<title><?php echo $PAGE_TITLE ?></title>
</head>
<body>
<script type=text/javascript>
Ext.onReady(function() {
    var res = tinyMCEPopup.getWindowArg("type");
    var FileChooserDialog = new PhotoStation.AboutMeFileChooser({type:res});
    FileChooserDialog.show();
});
</script>
</body>
</html>
