<?php

require_once("../include/syno_conf.php");
require_once("util.php");

define('CLIENT_ID', '4201062284');

$error = array(
	'error' => 'Unknown error.',
	'error_code' => '0000',
	'error_source' => 'local'
);

//get access token from weibo
if (isset($_GET['access_token'])) {
	SYNOPHOTO_WEIBO_GetAccessToken();
}

switch ($_POST['action']) {
case 'upload':
	echo SYNOPHOTO_WEIBO_Upload();
	break;
case 'upload_new':
	echo SYNOPHOTO_WEIBO_Upload_new();
	break;
default:
	FillErrorMessage('Invalid POST action', '0001', 'local');
	ResponseErrorJson();
}

function SYNOPHOTO_WEIBO_GetAccessToken()
{
	if (!isset($_GET['access_token']) || !isset($_GET['expires_in']) || !isset($_GET['uid'])) {
		FillErrorMessage('No GET access_token, expire_in, or uid', '0002', 'local');
		SYNOPHOTO_UTIL_ResponseErrorHtml();
	}

	$accessToken = $_GET['access_token'];
	$expire = $_GET['expires_in'];
	$uid = $_GET['uid'];

	if (false === ($userInfo = GetUserInfo($accessToken, CLIENT_ID, $uid))) {
		SYNOPHOTO_UTIL_ResponseErrorHtml();
	}

	echo GetCallbackHtmlTemplate('_onWeiboLogin', $accessToken, $userInfo['name'], $userInfo['profile_image_url'], $uid, $expire);
	exit;
}

function SYNOPHOTO_WEIBO_Upload()
{
	if (!isset($_POST['token']) || !isset($_POST['path']) || !isset($_POST['message'])) {
		FillErrorMessage('no token, path, or message.', '0003', 'local');
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	$image = csSYNOPhotoMisc::GetThumbPathFromFullPath($_POST['path'], SYNOPHOTO_THUMBXLARGE, false);
	if (!file_exists($image)) {
		$image = $_POST['path'];// upload original file
	}

	$params = array(
		'status' => $_POST['message'],
		'pic' => '@'.$image
	);

	$oAuth = new SaeTOAuthV2(CLIENT_ID, $_POST['token']);

	$reponse = $oAuth->post('statuses/upload', $params, true);

	if (false === $reponse || null === $reponse || !is_array($reponse)) {
		FillErrorMessage('Response is not a json.', '2000', 'Weibo: '.$reponse);
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	if (isset($reponse['error']) && isset($reponse['error_code'])) {
		FillErrorMessage($reponse['error'], $reponse['error_code'], 'Weibo: '.$reponse['request']);
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	$returnJson = array(
		'success' => true
	);

	echo json_encode($returnJson);
}

function SYNOPHOTO_WEIBO_Upload_new()
{
	if (!isset($_POST['token']) || !isset($_POST['id']) || !isset($_POST['message'])) {
		FillErrorMessage('no token, path, or message.', '0003', 'local');
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	$idarr = split('_', $_POST['id']);
	$path = @pack('H*', $idarr[1]) . "/" . @pack('H*', $idarr[2]);
	$image = csSYNOPhotoMisc::GetThumbPathFromFullPath(realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $path), SYNOPHOTO_THUMBXLARGE, false);
	if (!file_exists($image)) {
		$image = realpath(SYNOPHOTO_SERVICE_REAL_DIR . "/" . $_POST['path']);// upload original file
	}

	$params = array(
		'status' => $_POST['message'],
		'pic' => '@'.$image
	);

	$oAuth = new SaeTOAuthV2(CLIENT_ID, $_POST['token']);

	$reponse = $oAuth->post('statuses/upload', $params, true);

	if (false === $reponse || null === $reponse || !is_array($reponse)) {
		FillErrorMessage('Response is not a json.', '2000', 'Weibo: '.$reponse);
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	if (isset($reponse['error']) && isset($reponse['error_code'])) {
		FillErrorMessage($reponse['error'], $reponse['error_code'], 'Weibo: '.$reponse['request']);
		SYNOPHOTO_UTIL_ResponseErrorJson();
	}

	$returnJson = array(
		'success' => true
	);

	echo json_encode($returnJson);
}

function GetUserInfo($token, $appid, $uid)
{
	$getUserInfoAPI = 'https://api.weibo.com/2/users/show.json';

	$url = $getUserInfoAPI.'?access_token='.$token.'&uid='.$uid;

	if (false === ($userInfoResult = CurlRequest($url))) {
		return false;
	}

	if (false === ($userInfoJson = json_decode($userInfoResult, true))) {
		FillErrorMessage('Decode user info json failed', '1000', 'local');
		return false;
	}

	if (isset($userInfoJson['error']) && isset($userInfoJson['error_code'])) {
		FillErrorMessage($userInfoJson['error'], $userInfoJson['error_code'], 'Weibo: '.$userInfoJson['request']);
		return false;
	}

	if (!isset($userInfoJson['name']) || !isset($userInfoJson['profile_image_url'])) {
		FillErrorMessage('No required fields in user info json.', '1001', 'local');
		return false;
	}

	return $userInfoJson;
}

/**
 * sL OAuth ???(OAuth2)
 *
 * ???ja?ҷL?񥭥x?G{@link http://open.weibo.com/wiki/Oauth2}
 *
 * @package sae
 * @author Elmer Zhang
 * @version 1.0
 */
class SaeTOAuthV2 {
	/**
	 * @ignore
	 */
	public $client_id;
	/**
	 * @ignore
	 */
	//public $client_secret;
	/**
	 * @ignore
	 */
	public $access_token;
	/**
	 * @ignore
	 */
	public $refresh_token;
	/**
	 * Contains the last HTTP status code returned. 
	 *
	 * @ignore
	 */
	public $http_code;
	/**
	 * Contains the last API call.
	 *
	 * @ignore
	 */
	public $url;
	/**
	 * Set up the API root URL.
	 *
	 * @ignore
	 */
	public $host = "https://api.weibo.com/2/";
	/**
	 * Set timeout default.
	 *
	 * @ignore
	 */
	public $timeout = 30;
	/**
	 * Set connect timeout.
	 *
	 * @ignore
	 */
	public $connecttimeout = 30;
	/**
	 * Verify SSL Cert.
	 *
	 * @ignore
	 */
	public $ssl_verifypeer = FALSE;
	/**
	 * Respons format.
	 *
	 * @ignore
	 */
	public $format = 'json';
	/**
	 * Decode returned json data.
	 *
	 * @ignore
	 */
	public $decode_json = TRUE;
	/**
	 * Contains the last HTTP headers returned.
	 *
	 * @ignore
	 */
	public $http_info;
	/**
	 * Set the useragnet.
	 *
	 * @ignore
	 */
	public $useragent = 'Sae T OAuth2 v0.1';

	/**
	 * print the debug info
	 *
	 * @ignore
	 */
	public $debug = FALSE;

	/**
	 * boundary of multipart
	 * @ignore
	 */
	public static $boundary = '';

	/**
	 * Set API URLS
	 */
	/**
	 * @ignore
	 */
	//function accessTokenURL()  { return 'https://api.weibo.com/oauth2/access_token'; }
	/**
	 * @ignore
	 */
	//function authorizeURL()    { return 'https://api.weibo.com/oauth2/authorize'; }

	/**
	 * construct WeiboOAuth object
	 */
	function __construct($client_id, /*$client_secret,*/ $access_token = NULL, $refresh_token = NULL) {
		$this->client_id = $client_id;
		//$this->client_secret = $client_secret;
		$this->access_token = $access_token;
		$this->refresh_token = $refresh_token;
	}

	/**
	 * authorizef
	 *
	 * ??APIG{@link http://open.weibo.com/wiki/Oauth2/authorize Oauth2/authorize}
	 *
	 * @param string $url ?Z^?a},~?λO^?a}@P,??λݭn?canvas pagea}
	 * @param string $response_type ȥ]A code Mtoken q??code
	 * @param string $state Τ_O?DM^???Cb^??,?bQuery Parameter^????
	 * @param string $display ??? i?S?: 
	 *  - default		q???		
	 *  - mobile		html5		
	 *  - popup			???		
	 *  - wap1.2		wap1.2?		
	 *  - wap2.0		wap2.0?		
	 *  - js			js-sdk ? ??O?A^?G?js-sdk^?		
	 *  - apponweibo	???,??Τ?display??,}Bresponse_type?token?,q?ϥΧdisplay.?Z?^access_tokenAuO?Xjss??Τج[
	 * @return array
	 */
	/*function getAuthorizeURL( $url, $response_type = 'code', $state = NULL, $display = NULL ) {
		$params = array();
		$params['client_id'] = $this->client_id;
		$params['redirect_uri'] = $url;
		$params['response_type'] = $response_type;
		$params['state'] = $state;
		$params['display'] = $display;
		return $this->authorizeURL() . "?" . http_build_query($params);
	}*/

	/**
	 * access_tokenf
	 *
	 * ??APIG{@link http://open.weibo.com/wiki/OAuth2/access_token OAuth2/access_token}
	 *
	 * @param string $type ?D?,iH?:code, password, token
	 * @param array $keys L??G
	 *  - ?$type?code?G array('code'=>..., 'redirect_uri'=>...)
	 *  - ?$type?password?G array('username'=>..., 'password'=>...)
	 *  - ?$type?token?G array('refresh_token'=>...)
	 * @return array
	 */
	/*function getAccessToken( $type = 'code', $keys ) {
		$params = array();
		$params['client_id'] = $this->client_id;
		$params['client_secret'] = $this->client_secret;
		if ( $type === 'token' ) {
			$params['grant_type'] = 'refresh_token';
			$params['refresh_token'] = $keys['refresh_token'];
		} elseif ( $type === 'code' ) {
			$params['grant_type'] = 'authorization_code';
			$params['code'] = $keys['code'];
			$params['redirect_uri'] = $keys['redirect_uri'];
		} elseif ( $type === 'password' ) {
			$params['grant_type'] = 'password';
			$params['username'] = $keys['username'];
			$params['password'] = $keys['password'];
		} else {
			throw new OAuthException("wrong auth type");
		}

		$response = $this->oAuthRequest($this->accessTokenURL(), 'POST', $params);
		$token = json_decode($response, true);
		if ( is_array($token) && !isset($token['error']) ) {
			$this->access_token = $token['access_token'];
			$this->refresh_token = $token['refresh_token'];
		} else {
			throw new OAuthException("get access token failed." . $token['error']);
		}
		return $token;
	}*/

	/**
	 * ѪR signed_request
	 *
	 * @param string $signed_request ?ήج[b[?iframe??q?VCanvas URL post??signed_request
	 *
	 * @return array
	 */
	/*function parseSignedRequest($signed_request) {
		list($encoded_sig, $payload) = explode('.', $signed_request, 2); 
		$sig = self::base64decode($encoded_sig) ;
		$data = json_decode(self::base64decode($payload), true);
		if (strtoupper($data['algorithm']) !== 'HMAC-SHA256') return '-1';
		$expected_sig = hash_hmac('sha256', $payload, $this->client_secret, true);
		return ($sig !== $expected_sig)? '-2':$data;
	}*/

	/**
	 * @ignore
	 */
	/*function base64decode($str) {
		return base64_decode(strtr($str.str_repeat('=', (4 - strlen($str) % 4)), '-_', '+/'));
	}*/

	/**
	 * ?jssdk?HAΤ_MjssdkPBn?
	 *
	 * @return array \^array('access_token'=>'value', 'refresh_token'=>'value'); ?^false
	 */
	/*function getTokenFromJSSDK() {
		$key = "weibojs_" . $this->client_id;
		if ( isset($_COOKIE[$key]) && $cookie = $_COOKIE[$key] ) {
			parse_str($cookie, $token);
			if ( isset($token['access_token']) && isset($token['refresh_token']) ) {
				$this->access_token = $token['access_token'];
				$this->refresh_token = $token['refresh_token'];
				return $token;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}*/

	/**
	 * ????access_tokenMrefresh_token
	 * `Τ_?SessionCookie?tokenAγq?Session/CookieO_stokenP?n???C
	 *
	 * @param array $arr saccess_tokenMsecret_token??
	 * @return array \^array('access_token'=>'value', 'refresh_token'=>'value'); ?^false
	 */
	/*function getTokenFromArray( $arr ) {
		if (isset($arr['access_token']) && $arr['access_token']) {
			$token = array();
			$this->access_token = $token['access_token'] = $arr['access_token'];
			if (isset($arr['refresh_token']) && $arr['refresh_token']) {
				$this->refresh_token = $token['refresh_token'] = $arr['refresh_token'];
			}

			return $token;
		} else {
			return false;
		}
	}*/

	/**
	 * GET wrappwer for oAuthRequest.
	 *
	 * @return mixed
	 */
	function get($url, $parameters = array()) {
		$response = $this->oAuthRequest($url, 'GET', $parameters);
		if ($this->format === 'json' && $this->decode_json) {
			return json_decode($response, true);
		}
		return $response;
	}

	/**
	 * POST wreapper for oAuthRequest.
	 *
	 * @return mixed
	 */
	function post($url, $parameters = array(), $multi = false) {
		$response = $this->oAuthRequest($url, 'POST', $parameters, $multi );
		if ($this->format === 'json' && $this->decode_json) {
			return json_decode($response, true);
		}
		return $response;
	}

	/**
	 * DELTE wrapper for oAuthReqeust.
	 *
	 * @return mixed
	 */
	function delete($url, $parameters = array()) {
		$response = $this->oAuthRequest($url, 'DELETE', $parameters);
		if ($this->format === 'json' && $this->decode_json) {
			return json_decode($response, true);
		}
		return $response;
	}

	/**
	 * Format and sign an OAuth / API request
	 *
	 * @return string
	 * @ignore
	 */
	function oAuthRequest($url, $method, $parameters, $multi = false) {

		if (strrpos($url, 'http://') !== 0 && strrpos($url, 'https://') !== 0) {
			$url = "{$this->host}{$url}.{$this->format}";
		}

		switch ($method) {
			case 'GET':
				$url = $url . '?' . http_build_query($parameters);
				return $this->http($url, 'GET');
			default:
				$headers = array();
				if (!$multi && (is_array($parameters) || is_object($parameters)) ) {
					$body = http_build_query($parameters);
				} else {
					$body = self::build_http_query_multi($parameters);
					$headers[] = "Content-Type: multipart/form-data; boundary=" . self::$boundary;
				}
				return $this->http($url, $method, $body, $headers);
		}
	}

	/**
	 * Make an HTTP request
	 *
	 * @return string API results
	 * @ignore
	 */
	function http($url, $method, $postfields = NULL, $headers = array()) {
		$this->http_info = array();
		$ci = curl_init();
		/* Curl settings */
		curl_setopt($ci, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
		curl_setopt($ci, CURLOPT_USERAGENT, $this->useragent);
		curl_setopt($ci, CURLOPT_CONNECTTIMEOUT, $this->connecttimeout);
		curl_setopt($ci, CURLOPT_TIMEOUT, $this->timeout);
		curl_setopt($ci, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ci, CURLOPT_ENCODING, "");
		curl_setopt($ci, CURLOPT_SSL_VERIFYPEER, $this->ssl_verifypeer);
		curl_setopt($ci, CURLOPT_HEADERFUNCTION, array($this, 'getHeader'));
		curl_setopt($ci, CURLOPT_HEADER, FALSE);

		switch ($method) {
			case 'POST':
				curl_setopt($ci, CURLOPT_POST, TRUE);
				if (!empty($postfields)) {
					curl_setopt($ci, CURLOPT_POSTFIELDS, $postfields);
					$this->postdata = $postfields;
				}
				break;
			case 'DELETE':
				curl_setopt($ci, CURLOPT_CUSTOMREQUEST, 'DELETE');
				if (!empty($postfields)) {
					$url = "{$url}?{$postfields}";
				}
		}

		if ( isset($this->access_token) && $this->access_token )
			$headers[] = "Authorization: OAuth2 ".$this->access_token;

		$headers[] = "API-RemoteIP: " . $_SERVER['REMOTE_ADDR'];
		curl_setopt($ci, CURLOPT_URL, $url );
		curl_setopt($ci, CURLOPT_HTTPHEADER, $headers );
		curl_setopt($ci, CURLINFO_HEADER_OUT, TRUE );

		$response = curl_exec($ci);
		$this->http_code = curl_getinfo($ci, CURLINFO_HTTP_CODE);
		$this->http_info = array_merge($this->http_info, curl_getinfo($ci));
		$this->url = $url;

		if ($this->debug) {
			echo "=====post data======\r\n";
			var_dump($postfields);

			echo '=====info====='."\r\n";
			print_r( curl_getinfo($ci) );

			echo '=====$response====='."\r\n";
			print_r( $response );
		}
		curl_close ($ci);
		return $response;
	}

	/**
	 * Get the header info to store.
	 *
	 * @return int
	 * @ignore
	 */
	function getHeader($ch, $header) {
		$i = strpos($header, ':');
		if (!empty($i)) {
			$key = str_replace('-', '_', strtolower(substr($header, 0, $i)));
			$value = trim(substr($header, $i + 2));
			$this->http_header[$key] = $value;
		}
		return strlen($header);
	}

	/**
	 * @ignore
	 */
	public static function build_http_query_multi($params) {
		if (!$params) return '';

		uksort($params, 'strcmp');

		$pairs = array();

		self::$boundary = $boundary = uniqid('------------------');
		$MPboundary = '--'.$boundary;
		$endMPboundary = $MPboundary. '--';
		$multipartbody = '';

		foreach ($params as $parameter => $value) {

			if( in_array($parameter, array('pic', 'image')) && $value{0} == '@' ) {
				$url = ltrim( $value, '@' );
				$content = file_get_contents( $url );
				$array = explode( '?', basename( $url ) );
				$filename = $array[0];

				$multipartbody .= $MPboundary . "\r\n";
				$multipartbody .= 'Content-Disposition: form-data; name="' . $parameter . '"; filename="' . $filename . '"'. "\r\n";
				$multipartbody .= "Content-Type: image/unknown\r\n\r\n";
				$multipartbody .= $content. "\r\n";
			} else {
				$multipartbody .= $MPboundary . "\r\n";
				$multipartbody .= 'content-disposition: form-data; name="' . $parameter . "\"\r\n\r\n";
				$multipartbody .= $value."\r\n";
			}

		}

		$multipartbody .= $endMPboundary;
		return $multipartbody;
	}
}

?>
