<?php

require_once("../include/syno_conf.php");

if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
	echo json_encode(array('success' => false));
	exit;
}

switch ($_POST['action']) {
	case 'load':
		SYNOPHOTO_SOCIAL_NETWORK_LoadList();
		break;
	case 'apply':
		SYNOPHOTO_SOCIAL_NETWORK_ApplyList();
		break;
	default:
		echo json_encode(array('success' => false));
		break;
}

function SYNOPHOTO_SOCIAL_NETWORK_LoadList()
{
	$returnData = array(
		'data' => SocialNetwork::ReadList(),
		'success' => true
	);

END:
	echo json_encode($returnData);
}

function SYNOPHOTO_SOCIAL_NETWORK_ApplyList()
{
	$returnData = array(
		'success' => false
	);

	if ('yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['enable_demomode']) {
		$returnData['error'] = __(photo_str_error_demo);
		goto END;
	}

	if (false === ($providerList = json_decode($_POST['data'], true)) || empty($providerList)) {
		goto END;
	}

	$origProviderList = SocialNetwork::ReadList();

	foreach ($providerList as $provider) {
		if (!isset($provider['name']) || !isset($provider['enable'])) {
			continue;
		}

		foreach ($origProviderList as &$origProvider) {
			if ($origProvider['name'] === $provider['name']) {
				$origProvider['enable'] = (bool)$provider['enable'];
				break;
			}
		}
	}

	if (false === SocialNetwork::SaveList($origProviderList)) {
		goto END;
	}

	$returnData['success'] = true;
END:
	echo json_encode($returnData);
}

?>
