#!/bin/sh
# Copyright (c) 2003-2012 Synology Inc. All rights reserved.

SQLITE="/usr/syno/bin/sqlite3"
UPGRADE_DIR="/var/packages/PhotoStation/target/photo_scripts/sql/pps_upgrade"
UPGRADE_SCRIPT="006_pps_create_photo_image_gps_column.sql"

echo "Update photo_image table to test column gps existence"
SQL="update photo_image set gps = '' where id = 0"
db=$1
$SQLITE "$db" "$SQL" >/dev/null 2>&1
Ret=$?
if [ $Ret = 1 ]; then
	Script="$UPGRADE_DIR/$UPGRADE_SCRIPT"

	$SQLITE "$db" < $Script
	if [ $? != 0 ]; then
		echo "Failed to upgrade photo database"
		exit 2
	else
		username=$(echo $db | sed 's/^.*homes\///g')
                username=$(echo $username | sed "s/\/.*$//g")
		/usr/syno/bin/synoindex -R user:"$username"
	fi
fi
