#!/bin/sh
# Copyright (c) 2000-2008 Synology Inc. All rights reserved.
Upgrade=0


echo "Update photo log table where log id = 0 to test db existence"
su -l admin -c "/usr/syno/pgsql/bin/psql photo -c \"update photo_log set success = false where logid = 0\""
Ret=$?
if [ $Ret = 2 ]; then
   su -l admin -c "/usr/syno/pgsql/bin/createdb photo"
   if [ $? != 0 ]; then
      echo "Failed to create database"
      exit
   fi
   Ret=1
fi
      
if [ $Ret = 1 ]; then      
   /usr/syno/pgsql/bin/psql photo -U admin -f /var/packages/PhotoStation/target/photo_scripts/sql/photo.pgsql
   if [ $? != 0 ]; then
      echo "Failed to create tables in photo database"
      exit
   fi
   /usr/syno/bin/synoindex -R photo
fi
           
if [ -f "/tmp/photo.pgdump" ]; then
   su -l admin -c "/usr/syno/pgsql/bin/psql photo < /tmp/photo.pgdump"
   if [ $? != 0 ]; then
      echo "Failed to restore photo database"
      exit
   fi

   rm /tmp/photo.pgdump
   if [ $? != 0 ]; then
      echo "Failed to remove photo database backup"
      exit
   fi
fi

echo "Update blog_config table in photo db where config_id = 0 to test blog tables existence"
su -l admin -c "/usr/syno/pgsql/bin/psql photo -c \"update blog_config set config_value = '' where config_id = 0\""
Ret=$?
echo  $Ret     
if [ $Ret = 1 ]; then
   Script="/var/packages/PhotoStation/target/photo_scripts/sql/blog.pgsql"
   su -l admin -c "/usr/syno/pgsql/bin/psql photo < $Script"
   if [ $? != 0 ]; then
      echo "Failed to create blog tables"
      exit
   fi
fi
