#!/bin/sh
# Copyright (c) 2000-2008 Synology Inc. All rights reserved.

FIND="/usr/bin/find"
HOME_PHOTO_DIR="/var/services/homes/*/photo"
DB_FILE=".SYNOPPSDB"
SQL_DIR='/var/packages/PhotoStation/target/photo_scripts/sql'
UPGRADE_DIR="$SQL_DIR/upgrade"
PPS_UPGRADE_DIR="$SQL_DIR/pps_upgrade"

files=`ls $SQL_DIR/*.sh`
for ThisArg in $files;
do
   $ThisArg
done

files=`$FIND $UPGRADE_DIR -name "*.sh" | sort`
for ThisArg in $files;
do
   $ThisArg
done

PPS_DB_FILES=`$FIND $HOME_PHOTO_DIR/$DB_FILE` >/dev/null 2>&1

files=`$FIND $PPS_UPGRADE_DIR -name "*.sh" | sort`
for ThisArg in $files;
do
	$FIND $HOME_PHOTO_DIR/$DB_FILE | while read db
	do
		NeedPPSReindex=0
		$ThisArg  "$db"
		Ret=$?
		if [ $Ret = 1 ]; then
			NeedPPSReindex=1
		fi
		if [ $NeedPPSReindex = 1 ]; then
			user=`echo $db | awk -F '/' '{print $5}'`
			/usr/syno/bin/synoindex -R user:$user
		fi
	done
done

