#!/bin/sh
# Copyright (c) 2000-2011 Synology Inc. All rights reserved.

HOME_PHOTO_DIR="/var/services/photo/"
EADIR="@eaDir"
FB_SYNC_CONF_FILE="SYNOPHOTO_ALBUM.fbsync"
FB_SYNC_CONF_FILE_DEPRECATED="SYNOPHOTO:ALBUM.fbsync"
PHOTO_PKG_PATH='/var/packages/PhotoStation/target/photo'
targetConfPath=""
OLDIFS=$IFS
IFS="
"

echo "Get fb token from databse"
token=$(su admin -c "/usr/syno/pgsql/bin/psql photo -tc \"select config_value from photo_config where config_key='fb_token'\"")

token=$(echo $token | sed "s/^ //g")
if [ "$token" = "" ]; then
    exit
fi

echo "Get uploading setting from databse"
useOrig=$(su admin -c "/usr/syno/pgsql/bin/psql photo -tc \"select config_value from photo_config where config_key='share_upload_orig'\"")
useOrig=$(echo $useOrig | sed "s/^ //g")
origSetting=""
if [ "$useOrig" = "on" ]; then
	origSetting="-o"
fi
echo $origSetting

echo "Get photo shares from databse"
names=$(su admin -c "/usr/syno/pgsql/bin/psql photo -tc \"select sharename from photo_share\"")

for n in $names;
do
    n=$(echo $n | sed "s/^ //g")
    sub_folder=$(echo $n | sed "s/^.*\///g")
    if [ $sub_folder = $n ]; then
        targetConfPath="${HOME_PHOTO_DIR}${EADIR}/${n}/${FB_SYNC_CONF_FILE}"
		if [ ! -f "$targetConfPath" ]; then
			targetConfPath="${HOME_PHOTO_DIR}${EADIR}/${n}/${FB_SYNC_CONF_FILE_DEPRECATED}"
		fi
    else
        parent_folder=$(echo $n | sed "s/\/.*$//g")
        targetConfPath="${HOME_PHOTO_DIR}${parent_folder}/${EADIR}/${sub_folder}/${FB_SYNC_CONF_FILE}"
		if [ ! -f "$targetConfPath" ]; then
			targetConfPath="${HOME_PHOTO_DIR}${parent_folder}/${EADIR}/${sub_folder}/${FB_SYNC_CONF_FILE_DEPRECATED}"
		fi
    fi

    if [ -f "$targetConfPath" ]; then
        echo "Syncing album: $n"
        /usr/bin/php -n -d extension_dir=/lib/php/extensions -d extension=syno_compiler.so -d extension=curl.so $PHOTO_PKG_PATH/facebook/fbsync.php $origSetting -t "$token" -c "$targetConfPath" "${HOME_PHOTO_DIR}/${n}" 
    fi
done

IFS=$OLDIFS # restore the field separator
