<?php

define('SYNO_PHOTO_LEGACY_KEY_PARAM', 'legacy_key');
define('SYNO_PHOTO_MERGED_KEY', 'geo_tag_merged');
define('SYNO_PHOTO_DSM_USER_PROG', '/usr/syno/bin/synophoto_dsm_user');
define('SYNO_EXIFTOOL_FILE', '/usr/syno/bin/exiv2');

/* get old merged key in config file */
$options = getopt("", array(SYNO_PHOTO_LEGACY_KEY_PARAM.':'));
$oldMergedKey = ('yes' === $options[SYNO_PHOTO_LEGACY_KEY_PARAM]);


/* list dsm users */
$dsmUserList = getDSMUserList();
$usernameList = array_merge(array(''), $dsmUserList);

foreach ($usernameList as $username) {
	$user = $username;
	$dbh = getDatabaseHandler();
	$escapeStr = getEscapeString();

	//no database, skip
	if (!$dbh) {
		continue;
	}

	if ($oldMergedKey) {
		setMergedKeyToDB();
		continue;
	}

	$newMergedKey = getMergedKeyFromDB();
	if ($newMergedKey) {
		continue;
	}

	//fetch original geo tag list
	$photoTagList = getAllPhotoGeoTagFromDB();
	$videoTagList = getAllVideoGeoTagFromDB();

	//change geo tag to genaral tag
	$geoTagList = getAllGeoTagFromDB();
	convertGeotagToDescTag();

	//merge geo tag for one photo/video
	mergeOriginalGeotag($photoTagList, $videoTagList);
	upgradeSmartAlbumCondition($user);

	setMergedKeyToDB();
}

function upgradeSmartAlbumCondition($user) {
	global $geoTagList;

	$smartAlbumList = readSmartAlbumFile();
	if (!$smartAlbumList) {
		return;
	}

	foreach($smartAlbumList['smart_albums'] as $smartName => $smartAlbum) {
		$geoRule = array();
		$descRule = array();
		$newRules = array();
		$idx = 0;
		foreach($smartAlbum['rule_sets'][0] as $rule) {
			if ('geo' == $rule['field']) {
				$geoRule = $rule;
			} else if ('desc' == $rule['field']) {
				$descRule = $rule;
			} else {
				$newRules[] = $rule;
			}
			$idx ++;
		}
		if (empty($geoRule)) {
			continue;
		}
		$newDescRule = combineGeoDescRule($geoRule, $descRule);
		$newRules[] = $newDescRule;
		$smartAlbumList['smart_albums'][$smartName]['rule_sets'][0] = $newRules;
	}
	writeSmartAlbumFile($smartAlbumList);
}

function combineGeoDescRule($geoRule, $descRule)
{
	$geoTagIdList = explode(',', $geoRule['value']);
	if (empty($descRule)) {
		$descRule['field'] = 'desc';
		$descRule['operator'] = $geoRule['operator'];
		$descRule['value'] = '';
		$descTagIdList = array();
	} else {
		$descTagIdList = explode(',', $descRule['value']);
	}

	foreach($geoTagIdList as $tagId) {
		if (false !== ($descId = findDescTagId($tagId))) {
			$descTagIdList[] = $descId;
		}
	}

	$descRule['value'] = implode(',', array_unique($descTagIdList));
	return $descRule;
}

function findDescTagId($tagId)
{
	global $geoTagList;
	$tagName = '';

	foreach($geoTagList as $tag) {
		if ($tagId == $tag['id']) {
			$tagName = $tag['name'];
			break;
		}
	}
	if (!empty($tagName) && false !== ($row = selectTag($tagName, 2))) {
		return $row['id'];
	}
	return false;
}

function convertGeotagToDescTag() {
	global $geoTagList;

	foreach($geoTagList as $geoTag) {
		if (false !== ($descTag = selectTag($geoTag['name'], 2))) {
			//deac is already exist, change geotag id to desctag id
			changePhotoTagId($geoTag['id'], $descTag['id']);
			//delete geotag
			deleteTag($geoTag['id']);
		} else {
			//change geo tag type
			changeGeoTagTypeToDesc($geoTag['id']);
		}
	}
}

function getAllGeoTagFromDB()
{
	global $dbh, $escapeStr;
	$tagList = array();
	$sqlParam = array();

	$sql = 'SELECT * FROM photo_label WHERE category = 1';
	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);

	$tagList = $dbResult->fetchAll(PDO::FETCH_ASSOC);

	return $tagList;
}

function getAllPhotoGeoTagFromDB() {
	global $dbh, $escapeStr;
	$photoList = array();
	$sqlParam = array();

	$sql = "SELECT image_id, label_id, photo_label.name FROM photo_image_label INNER JOIN photo_label ON label_id=photo_label.id WHERE category = 1";
	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);

	$photoList = $dbResult->fetchAll(PDO::FETCH_ASSOC | PDO::FETCH_GROUP);
	return $photoList;
}

function getAllVideoGeoTagFromDB() {
	global $dbh, $escapeStr;
	$videoList = array();
	$sqlParam = array();

	$sql = "SELECT video_path, label_id, photo_label.name FROM photo_video_label INNER JOIN photo_label ON label_id=photo_label.id WHERE category = 1";
	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);

	$videoList = $dbResult->fetchAll(PDO::FETCH_ASSOC | PDO::FETCH_GROUP);
	return $videoList;
}

function mergeOriginalGeotag($photoTagList, $videoTagList)
{
	global $dbh, $escapeStr;

	foreach($photoTagList as $photoId => $tagArr) {
		$tagNameArr = array();
		foreach($tagArr as $tag) {
			$tagNameArr[] = $tag['name'];
		}
		saveAsNewGeotag($photoId, implode(', ', $tagNameArr), true);
		updateMetaData($photoId);
	}

	foreach($videoTagList as $videoPath => $tagArr) {
		$tagNameArr = array();
		foreach($tagArr as $tag) {
			$tagNameArr[] = $tag['name'];
		}
		saveAsNewGeotag($videoPath, implode(', ', $tagNameArr), false);
	}
}

function saveAsNewGeotag($photoId, $tagName, $isPhoto)
{
	$sqlParam = array();
	$id = -1;
	if (false !== ($row = selectTag($tagName, 1))) {
		$id = $row['id'];
	} else {
		if (false === ($id = addNewTag($tagName))) {
			return;
		}
	}
	if ($isPhoto) {
		addPhotoTag($photoId, $id);
	} else {
		addVideoTag($photoId, $id);
	}
}

function updateMetaData($photoId)
{
	global $dbh, $escapeStr;
	global $user;

	//1. query file path from DB
	$query = 'SELECT path FROM photo_image WHERE id = ?';
	$sqlParam = array($photoId);
	$dbResult = $dbh->prepare($query);
	$dbResult->execute($sqlParam);
	if (false === ($row = $dbResult->fetch())) {
		return false;
	}
	if (strlen($user)) {
		$path = "/var/services/homes/{$user}/photo/".$row['path'];
	} else {
		$path = $row['path'];
	}

	//2. remove existed metadata
	$cmd = sprintf('%s -M "del %s" %s', SYNO_EXIFTOOL_FILE, "Iptc.Application2.Keywords", escapeshellarg($path));
	@exec($cmd);
	$cmd = sprintf('%s -M "del %s" %s', SYNO_EXIFTOOL_FILE, "Xmp.dc.subject", escapeshellarg($path));
	@exec($cmd);

	//3. query new metadata value from DB
	$query = 'SELECT A.id, B.name FROM photo_image_label A, photo_label B '.
		'WHERE A.image_id = ? AND B.id = A.label_id AND B.category = ? ';
	$sqlParam = array($photoId, 2);
	$dbResult = $dbh->prepare($query);
	$dbResult->execute($sqlParam);
	if (false === $dbResult) {
		return false;
	}

	//4. write metadata to file
	$count = 1;
	while ($row = $dbResult->fetch()) {
		$cmd = sprintf('%s -M "add %s %s" %s', SYNO_EXIFTOOL_FILE,
					   "Iptc.Application2.Keywords String", str_replace('"', '\"', $row['name']), escapeshellarg($path));
		@exec($cmd);
		if (1 === $count) {
			$cmd = sprintf('%s -M "set %s %s" %s', SYNO_EXIFTOOL_FILE, "Xmp.dc.subject", "''", escapeshellarg($path));
			@exec($cmd);
		}
		$cmd = sprintf('%s -M "set %s[%d] %s" %s', SYNO_EXIFTOOL_FILE,
					   "Xmp.dc.subject", $count++, str_replace('"', '\"', $row['name']), escapeshellarg($path));
		@exec($cmd);
	}

	//update mtime of all thumbnails for prevent from re-making thumbnail
	$cmd = sprintf('/usr/syno/bin/synophoto_dsm_user --updatethumbnailmtime %s', escapeshellarg($path));
	@exec($cmd);
}

function addNewTag($tagName) {
	global $dbh, $escapeStr, $user;

	$sqlParam = array();

	if ($user !== '') {
		//personal tag id will not auto increase, get max id first
		$id = getTagMaxId() + 1;
		$sqlParam[] = $id;
		$sql = "INSERT INTO photo_label (id, name, category) VALUES (?, ?, ?)";
	} else {
		$sql = "INSERT INTO photo_label (name, category) VALUES (?, ?)";
	}

	$sqlParam[] = $tagName;
	$sqlParam[] = 1;
	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);

	if (false !== ($row = selectTag($tagName, 1))) {
		return $row[id];
	}
	return false;
}

function getTagMaxId() {
	global $dbh, $escapeStr;

	$sqlParam = array();
	$sql = "SELECT MAX(id) FROM photo_label;";
	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);

	if (false !== ($row = $dbResult->fetch())) {
		return $row[0];
	}
	return 0;
}

function addPhotoTag($photoId, $tagId) {
	global $dbh, $escapeStr;

	$sqlParam = array();
	$sqlParam[] = $photoId;
	$sqlParam[] = $tagId;

	$sql = "INSERT INTO photo_image_label (image_id, label_id, info) VALUES (?, ?, '')";
	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);
}

function addVideoTag($videoPath, $tagId) {
	global $dbh, $escapeStr;

	$sqlParam = array();
	$sqlParam[] = $videoPath;
	$sqlParam[] = $tagId;

	$sql = "INSERT INTO photo_video_label (video_path, label_id, info) VALUES (?, ?, '')";
	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);
}

function selectTag($name, $type) {
	global $dbh, $escapeStr;

	$sqlParam = array();
	//test tag exist
	$sql = "SELECT * FROM photo_label WHERE name=? AND category=?";
	$sqlParam[] = $name;
	$sqlParam[] = $type;

	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);
	if (false !== ($row = $dbResult->fetch(PDO::FETCH_ASSOC))) {
		return $row;
	}
	return false;
}

function deleteTag($tagId) {
	global $dbh, $escapeStr;

	$sqlParam = array();
	$sqlParam[] = $tagId;

	$sql = "DELETE FROM photo_label WHERE id=?";
	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);
}

function changeGeoTagTypeToDesc($tagId) {
	global $dbh, $escapeStr;

	$sqlParam = array();
	$sqlParam[] = $tagId;

	$sql = "UPDATE photo_label SET category=2, info='' WHERE id=?";
	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);
}

function changePhotoTagId($geoTagId, $descTagId) {
	global $dbh, $escapeStr;

	$sqlParam = array();
	$sqlParam[] = $descTagId;
	$sqlParam[] = $geoTagId;
	$sqlParam[] = $descTagId;

	$sql = "UPDATE photo_image_label SET label_id=? WHERE label_id=? AND image_id NOT IN (SELECT image_id FROM photo_image_label WHERE label_id=?)";
	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);

	$sql = "UPDATE photo_video_label SET label_id=? WHERE label_id=? AND video_path NOT IN (SELECT video_path FROM photo_video_label where label_id=?)";
	$dbResult = $dbh->prepare($sql);
	$dbResult->execute($sqlParam);
}

function readSmartAlbumFile()
{
    global $user;
    if (strlen($user)){
        $smartAlbumFile = "/var/services/homes/{$user}/photo/@eaDir/smart_album.json";
    } else {
        $smartAlbumFile = "/var/services/photo/@eaDir/smart_album.json";
    }

    //test whether smart album file config exist or not
    if (!@file_exists($smartAlbumFile)) {
        return null;
    }

    //get contents from smart album config file
    if (!$smartAlbumJsonStr = @file_get_contents($smartAlbumFile)) {
        return null;
    }

    //parse contents
    if (!$smartAlbumList = json_decode($smartAlbumJsonStr, true)) {
        return null;
    }

    return $smartAlbumList;
}

function writeSmartAlbumFile($smartAlbumList)
{
    global $user;
    if (strlen($user)){
        $smartAlbumFile = "/var/services/homes/{$user}/photo/@eaDir/smart_album.json";
    } else {
        $smartAlbumFile = "/var/services/photo/@eaDir/smart_album.json";
    }

    //encode smart album list to json string
    if (!$smartAlbumListJsonStr = json_encode($smartAlbumList)) {
        return false;
	}

    //beautify json string
    $smartAlbumListJsonStr = indentJson($smartAlbumListJsonStr);

    //create @eaDir
    if(!@file_exists($eaDir)) {
        @mkdir($eaDir);
    }

    //put contents to smart album config file
    if (!@file_put_contents($smartAlbumFile, $smartAlbumListJsonStr)) {
        return false;
    }

    chmod($smartAlbumFile, 0666);

    return true;
}

function indentJson($json)
{
    if (!json_decode($json)) {
        return $json;
	}

    $result = '';
    $pos = 0;
    $strLen = strlen($json);
    $indentStr = "\t";
    $newLine = "\n";
    $prevChar = '';
    $outOfQuotes = true;

    for($i = 0; $i <= $strLen; $i++) {
        // Grab the next character in the string
        $char = substr($json, $i, 1);

        // Are we inside a quoted string?
        if($char == '"' && $prevChar != '\\') {
            $outOfQuotes = !$outOfQuotes;
        }
        // If this character is the end of an element,
        // output a new line and indent the next line
        else if(($char == '}' || $char == ']') && $outOfQuotes) {
            $result .= $newLine;
            $pos --;
            for ($j=0; $j<$pos; $j++) {
                $result .= $indentStr;
            }
        }
        // Add the character to the result string
        $result .= $char;

        // If the last character was the beginning of an element,
        // output a new line and indent the next line
        if (($char == ',' || $char == '{' || $char == '[') && $outOfQuotes) {
            $result .= $newLine;
            if ($char == '{' || $char == '[') {
                $pos ++;
            }
            for ($j = 0; $j < $pos; $j++) {
                $result .= $indentStr;
            }
        }
        $prevChar = $char;
    }

    return $result;
}

function getDSMUserList()
{
	@exec(SYNO_PHOTO_DSM_USER_PROG." --enum", $dsmUserCount);
	@exec(SYNO_PHOTO_DSM_USER_PROG." --enum 0 ".intval($dsmUserCount[0]), $dsmUserList);
	$list = array();

	foreach($dsmUserList as &$dsmUser) {
		$dsmUser = explode(',', $dsmUser);
		if (count($dsmUser) != 6) {
			continue;
		}
		$list[] = $dsmUser[1];
	}
	return $list;
}

function getDatabaseHandler()
{
	global $user;

	$dbh = null;

	if (strlen($user)){
		$user_photo_db = "/var/services/homes/$user/photo/.SYNOPPSDB";

		if(!file_exists($user_photo_db)){
			return $dbh;
		}

		try {
			$dbh = new PDO("sqlite:{$user_photo_db}");
			$dbh->exec('PRAGMA case_sensitive_like=1');
			$dbh->exec('PRAGMA foreign_keys=ON');
		} catch (PDOException $e) {
			die($e->getMessage());
		}
	} else {
		try {
			$dbh = new PDO('pgsql:dbname=photo', 'admin', '', array(PDO::ATTR_PERSISTENT => false, PDO::ATTR_EMULATE_PREPARES => true));
		} catch (PDOException $e) {
			die($e->getMessage());
		}
	}

	return $dbh;
}

function getEscapeString()
{
	global $user;

	return strlen($user) ? "ESCAPE '\'" : "";
}

function setMergedKeyToDB()
{
	global $dbh, $escapeStr;

	$sqlCond = "SELECT * FROM photo_config WHERE module_name = 'photo' AND config_key = '".SYNO_PHOTO_MERGED_KEY."'";
	$sqlParam = array();

	$dbResult = $dbh->prepare($sqlCond);
	$dbResult->execute($sqlParam);

	if (false !== ($row = $dbResult->fetch())) {
		$id = $row['config_id'];
		$sqlCond = "UPDATE photo_config SET config_value = 'on' WHERE config_id = ".$row['config_id'];
	} else {
		$sqlCond = "INSERT INTO photo_config (module_name, config_key, config_value) VALUES ('photo', '".SYNO_PHOTO_MERGED_KEY."', 'on')";
	}

	$dbResult = $dbh->prepare($sqlCond);
	$dbResult->execute($sqlParam);
}

function getMergedKeyFromDB()
{
	global $dbh, $escapeStr;

	$sqlCond = "SELECT * FROM photo_config WHERE module_name = 'photo' AND config_key = '".SYNO_PHOTO_MERGED_KEY."'";
	$sqlParam = array();

	$dbResult = $dbh->prepare($sqlCond);
	$dbResult->execute($sqlParam);

	$ret = false;
	if (false !== ($row = $dbResult->fetch())) {
		if ('on' === $row['config_value']) {
			$ret = true;
		}
	}

	return $ret;
}
?>
