<?php
	$cmdOpts = getopt('t:f:');
	if ($cmdOpts === false || empty($cmdOpts['t']) || empty($cmdOpts['f'])) {
		exit(-1);
	}

	$path = $cmdOpts['f'];
	$tag = $cmdOpts['t'];

	if ('GPSLatitude' != $tag && 'GPSLongitude' != $tag){
		exit(-1);
	}

	$exif = @exif_read_data($path, 'GPS', true);
	if (!$exif || !$exif["GPS"][$tag]) {
		exit(-1);
	}

	$deg = SYNOPHOTO_GPS_UTIL_GetURational($exif["GPS"][$tag][0]);
	$min = SYNOPHOTO_GPS_UTIL_GetURational($exif["GPS"][$tag][1]);
	$sec = SYNOPHOTO_GPS_UTIL_GetURational($exif["GPS"][$tag][2]);

	echo intval($deg).'deg '.intval($min)."' ".$sec.'"';
	exit(0);

function SYNOPHOTO_GPS_UTIL_GetURational($str)
{
	$info = array();
	$info[] = $str;
	if (!is_string($str)) {
		return $str;
	}
	list($dividend, $divider) = @explode('/', $str);
	if (!$divider) {
		return 0;
	}
	$dividend = sprintf('%u', $dividend);
	$divider = sprintf('%u', $divider);
	return $dividend / $divider;
}
?>
