<?PHP

require_once('group.inc.php');

class GroupAPI extends WebAPI
{
	function __construct()
	{
		parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
	}

	protected function Process()
	{
		/* if not admin, returns directly */
		csSYNOPhotoMisc::CheckSessionTimeOut();

		if (!strcasecmp($this->method, "list")) {
			$this->ListGroup();
		}
		if (!strcasecmp($this->method, "get")) {
			$this->GetGroup();
		}
		if (!strcasecmp($this->method, "getmember")) {
			$this->GetGroupMember();
		}
		if (!strcasecmp($this->method, "create")) {
			$this->CreateGroup();
		}
		if (!strcasecmp($this->method, "delete")) {
			$this->DeleteGroup();
		}
		if (!strcasecmp($this->method, "editmember")) {
			$this->EditMember();
		}
		if (!strcasecmp($this->method, "edit")) {
			$this->EditGroup();
		}
	}

	private function ListGroup()
	{
		$ret = false;
		$resp = array();

		/* set params */
		$offset = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 15;
		$search = isset($_REQUEST['query']) ? $_REQUEST['query'] : '';

		$groups = $this->GetAllGroups($offset, $limit, $search);

		$resp['totalCount'] = $groups['totalCount'];
		$resp['groups'] = $groups['all_groups'];
		$this->SetResponse($resp);

		$ret = true;
	End:
		return $ret;

	}

	private function GetGroup()
	{
		$ret = false;
		$resp = array();

		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}
		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		/* set params */
		$id = $_REQUEST['id'];

		$query = "SELECT * FROM photo_group WHERE groupid = ?";
		$sqlParam = array($id);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

		if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}
		$resp['groupid'] = $row['groupid'];
		$resp['groupname'] = $row['groupname'];
		$resp['description'] = $row['description'];

		$this->SetResponse($resp);

		$ret = true;
	End:
		return $ret;
	}

	private function GetGroupMember()
	{
		$ret = false;
		$resp = array();

		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}
		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		/* set params */
		$id = $_REQUEST['id'];
		$start = isset($_REQUEST['offset']) ? $_REQUEST['offset'] : 0;
		$limit = isset($_REQUEST['limit']) ? $_REQUEST['limit'] : 15;

		$query = "SELECT A.userid, A.username, A.description, B.groupid FROM photo_user A LEFT JOIN photo_user_group B ON A.userid = B.userid AND B.groupid = ? LIMIT ? OFFSET ?";
		$sqlParam = array($id, $limit, $start);
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

		$resp['users'] = array();
		while($row = PHOTO_DB_FetchRow($db_result)) {
			$item = array();
			$item['id'] = $row['userid'];
			$item['username'] = $row['username'];
			$item['description'] = $row['description'];
			$item['add'] = $id == $row['groupid'];
			$resp['users'][] = $item;
		}

		$query = "SELECT count(*) FROM photo_user";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$row = PHOTO_DB_FetchRow($db_result);

		$resp['totalCount'] = $row[0];
		$this->SetResponse($resp);

		$ret = true;
	End:
		return $ret;
	}

	private function CreateGroup()
	{
		$ret = false;
		$resp = array();

		if (!isset($_REQUEST['groupname'])) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		/* set params */
		$groupname = $_REQUEST['groupname'];
		$description = isset($_REQUEST['description']) ? $_REQUEST['description'] : '';

		$query = "SELECT MAX(groupid) FROM photo_group";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$max_gid = PHOTO_DB_FetchRow($db_result);
		$new_gid = $max_gid[0] + 1;
		$query = "INSERT INTO photo_group (groupid, groupname, description) VALUES (?, ?, ?)";
		$sqlParam = array($new_gid, $groupname, $description);
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

		$resp['id'] = $new_gid;
		$this->SetResponse($resp);

		$ret = true;
	End:
		return $ret;
	}

	private function EditMember()
	{
		$ret = false;
		$resp = array();

		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		/* set params */
		$gid = $_REQUEST['id'];
		$addList = isset($_REQUEST['group_user_add']) ? $_REQUEST['group_user_add'] : '';
		$deleteList = isset($_REQUEST['group_user_delete']) ? $_REQUEST['group_user_delete'] : '';

		$this->DeleteUserFromGroup($gid, $deleteList);
		$this->AddUserToGroup($gid, $addList);

		$this->SetResponse($resp);

		$ret = true;
	End:
		return $ret;
	}

	private function DeleteUserFromGroup($gid, $users)
	{
		if ($gid == null || $gid == "" || $users == null || $users == "") {
			return;
		}

		$ids = explode(',', $users);
		foreach ($ids as $id) {
			if ('' === $id) {
				continue;
			}
			$query = "DELETE FROM photo_user_group WHERE userid = ? AND groupid = ?";
			$sqlParam = array($id, $gid);
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		}
	}

	private function AddUserToGroup($gid, $users)
	{
		if ($gid == null || $gid == "" || $users == null || $users == "") {
			return;
		}

		$ids = explode(',', $users);
		foreach ($ids as $id) {
			if ('' === $id) {
				continue;
			}
			$query = "SELECT MAX(id) FROM photo_user_group";
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
			$max_id = PHOTO_DB_FetchRow($db_result);
			$new_id = $max_id[0] + 1;
			$query = "INSERT INTO photo_user_group (id, userid, groupid) VALUES (?, ?, ?)";
			$sqlParam = array($new_id, $id, $gid);
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		}
	}

	private function EditGroup()
	{
		$ret = false;
		$resp = array();

		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		/* set params */
		$id = $_REQUEST['id'];
		$description = isset($_REQUEST['description']) ? $_REQUEST['description'] : null;

		if (isset($_REQUEST['description'])) {
			$query = "UPDATE photo_group set description = ? where groupid = ?";
			$sqlParam = array($description, $id);
			$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);
		}

		$this->SetResponse($resp);

		$ret = true;
	End:
		return $ret;
	}

	private function DeleteGroup() {
		$ret = false;
		$resp = array();

		if (!isset($_REQUEST['id'])) {
			$this->SetError(PHOTOSTATION_PERMISSION_BAD_PARAMS);
			goto End;
		}

		/* set params */
		$gid = $_REQUEST['id'];

		$query = "DELETE FROM photo_group WHERE groupid = ?";
		$sqlParam = array($gid);
		PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam);

		$this->SetResponse($resp);

		$ret = true;
	End:
		return $ret;
	}

	private function GetAllGroups($start, $limit, $search)
	{
		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account']) {
			return $this->GetAllDSMGroup($start, $limit, $search);
		}

		$i = 0;
		$query = "SELECT * FROM photo_group WHERE groupname LIKE '%" . PHOTO_DB_EscapeParam($search) . "%' ORDER BY groupname ASC LIMIT $limit OFFSET $start";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		while ($row = PHOTO_DB_FetchRow($db_result)) {
			$result['all_groups'][$i]['groupid'] = $row['groupid'];
			$result['all_groups'][$i]['groupname'] = $row['groupname'];
			$result['all_groups'][$i]['description'] = $row['description'];
			$i ++;
		}
		$query = "SELECT count(*) FROM photo_group WHERE groupname LIKE '%" . PHOTO_DB_EscapeParam($search) . "%' ";
		$db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query);
		$row = PHOTO_DB_FetchRow($db_result);
		$result['totalCount'] = $row[0];
		return $result;
	}

	private function GetAllDSMGroup($start, $limit, $query = '')
	{
		$command = "/usr/syno/bin/synophoto_dsm_user --group " . escapeshellarg($query);
		@exec($command, $pListGroupCount, $retval);
		if (0 > $retval) {
			$result['totalCount'] = 0;
			return $result;
		}
		$result['totalCount'] = $pListGroupCount[0];

		$command = "/usr/syno/bin/synophoto_dsm_user --group " . escapeshellarg($start) . " " . escapeshellarg($limit) . " ASC:" . escapeshellarg($query);
		@exec($command, $pListGroupName, $retval);

		if (0 !== $retval) {
			$result['totalCount'] = 0;
			return $result;
		}

		$i = 0;
		$result['all_groups'] = array();
		foreach ($pListGroupName as $group_str) {
			$group_info = split(',', $group_str);
			$result['all_groups'][$i]['groupid'] = $group_info[0];
			$result['all_groups'][$i]['groupname'] = $group_info[1];
			$result['all_groups'][$i]['description'] = htmlspecialchars($group_info[2], ENT_QUOTES);
			$result['all_groups'][$i]['disable'] = 'true' === $group_info[3] ? 't' : 'f';
			$i ++;
		}

		return $result;
	}
}

$api = new GroupAPI();
$api->Run();
