<?php

require_once('cover.inc.php');

class CoverAPI extends WebAPI {
    function __construct()
    {
        parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
    }

    protected function Process()
    {
        csSYNOPhotoMisc::CheckSessionTimeOut(true);

        if (!strcasecmp($this->method, "set")) {
            $this->SetCover();
        }
    }

    /**
     *  @params - $id like: photo_dir_name, video_dir_name
     */
    private function GetItemInfo($id)
    {
        $arr = explode('_', $id);
        if (3 !== count($arr)) {
            return false;
        }
        if (!in_array($arr[0], array('photo', 'video'))) {
            return false;
        }
        // get id
        $dirName = @pack('H*', $arr[1]);
        $fileName = @pack('H*', $arr[2]);
        $filePath = $dirName.'/'.$fileName;
        $realPath = realpath(SYNOPHOTO_SERVICE_REAL_DIR.'/'.$filePath);
        if (0 !== strncmp($realPath, SYNOPHOTO_SERVICE_REAL_DIR."/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
            return false;
        }
        $table = ('photo' === $arr[0]) ? 'photo_image' : 'video';
        if ('root' === SYNOPHOTO_ADMIN_USER) {
            $row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('id', $table, 'path', $realPath);
        } else {
            $row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('id', $table, 'path', $filePath);
        }
        $data['id'] = $row['id'];
        $data['path'] = $realPath;
        $data['sharePath'] = $filePath;
        $data['isPhoto'] = ('photo' === $arr[0]) ? true : false;

        return $data;
    }

    private function GetParams_Set()
    {
        if (!isset($_REQUEST['id']) || !isset($_REQUEST['item_id'])) {
            return false;
        }
        // get album id
        $arr = explode('album_', $_REQUEST['id']);
        if (2 !== count($arr)) {
            return false;
        }
        // check album exist
        $shareName = @pack('H*', $arr[1]);
        $params['album_sharePath'] = $shareName;

        $albumFullPath = realpath(SYNOPHOTO_SERVICE_REAL_DIR."/".$shareName);
        if (0 !== strncmp($albumFullPath, SYNOPHOTO_SERVICE_REAL_DIR."/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
            return false;
        }
        $params['album_path'] = $albumFullPath;

        // get photo, video id
        if (false === ($data = $this->GetItemInfo($_REQUEST['item_id']))) {
            return false;
        }
        $params['id'] = $data['id'];
        $params['path'] = $data['path'];
        $params['sharePath'] = $data['sharePath'];
        $params['isPhoto'] = $data['isPhoto'];

        return $params;
    }

    private function SetAblumCover($albumPath, $coverPath)
    {
        $albumFullPath = realpath(SYNOPHOTO_SERVICE_REAL_DIR."/".$albumPath);
        if (0 !== strncmp($albumFullPath, SYNOPHOTO_SERVICE_REAL_DIR."/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
            return false;
        }

        $eaDir = dirname($albumFullPath)."/".SYNOPHOTO_EADIR;
        if(!@file_exists($eaDir)) {
            @mkdir($eaDir);
            @chmod($eaDir, 0777);
        }
        $coverDir = $eaDir.'/'.basename($albumPath);
        if(!@file_exists($coverDir)) {
            @mkdir($coverDir);
            @chmod($coverDir, 0777);
        }
        $coverFile = $coverDir.'/'.SYNOPhotoEA::getFilename(SYNOPhotoEA::FILE_ALBUM_COVER);
        $coverValue =  substr($coverPath, (strlen($albumPath) + 1));

        if (false === ($handle = fopen($coverFile, "w+"))) {
            return false;
        }
        if ($handle) {
            if (false === fwrite($handle, $coverValue)) {
                return false;
            }
            fclose($handle);
    		@chmod($coverFile, 0777);
        }
        return true;
    }

    private function SetCover()
    {
        csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

        if (false === ($params = $this->GetParams_Set())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // check album exist
        $row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('count(shareid)', 'photo_share', 'sharename', $params['album_sharePath']);
        if (1 !== (int)$row[0]) {
            $this->SetError(PHOTOSTATION_COVER_ALBUM_NOT_EXIST);
            goto End;
        }

        // check photo/video exist
        $table = $params['isPhoto'] ? 'photo_image' : 'video';
        $row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('count(id)', $table, 'path', ('root' === SYNOPHOTO_ADMIN_USER) ? $params['path'] : $params['sharePath']);
        if (1 !== (int)$row[0]) {
            $this->SetError(PHOTOSTATION_COVER_PHOTO_VIDEO_NOT_EXIST);
            goto End;
        }

        // check photo/video in album
        $ret = strpos($params['path'], $params['album_path']);
        if (false === $ret || 0 !== $ret) {
            $this->SetError(PHOTOSTATION_COVER_PHOTO_VIDEO_NOT_IN_ALBUM);
            goto End;
        }

        // check album maganeable
        if (false === csSynoPhotoMisc::CheckAlbumManageable($params['album_sharePath'])) {
            $this->SetError(PHOTOSTATION_COVER_ACCESS_DENY);
            goto End;
        }

        // set album cover
        if (false === $this->SetAblumCover($params['album_sharePath'], $params['sharePath'])) {
            $this->SetError(PHOTOSTATION_COVER_SET_FAIL);
            goto End;
        }

    End:
        return;
    }
}

$api = new CoverAPI();
$api->Run();

?>
