<?php
require_once('comment.inc.php');
require_once('albumutil.php');

class CommentAPI extends WebAPI {
    function __construct()
    {
        parent::__construct(SZ_WEBAPI_API_DESCRIPTION_PATH);
    }

    protected function Process()
    {
        if (!strcasecmp($this->method, "list")) {
            $this->CommentList();
        } elseif (!strcasecmp($this->method, "create")) {
            $this->Create();
        } elseif (!strcasecmp($this->method, "delete")) {
            $this->Delete();
        }
    }

    /**
     *  @params - $id like: photo_dir_name, video_dir_name
     */
    private function GetItemInfo($id)
    {
        $arr = explode('_', $id);
        if (3 !== count($arr)) {
            return false;
        }
        if (!in_array($arr[0], array('photo', 'video'))) {
            return false;
        }
        // get id
        $dirName = @pack('H*', $arr[1]);
        $fileName = @pack('H*', $arr[2]);
        $filePath = $dirName.'/'.$fileName;
        $realPath = realpath(SYNOPHOTO_SERVICE_REAL_DIR.'/'.$filePath);
        if (0 !== strncmp($realPath, SYNOPHOTO_SERVICE_REAL_DIR."/", strlen(SYNOPHOTO_SERVICE_REAL_DIR) + 1)) {
            return false;
        }
        $table = ('photo' === $arr[0]) ? 'photo_image' : 'video';
        if ('root' === SYNOPHOTO_ADMIN_USER) {
            $row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('id', $table, 'path', $realPath);
        } else {
            $row = csSYNOPhotoDB::GetDBInstance()->GetFieldByKeyValue('id', $table, 'path', $filePath);
        }
        $data['id'] = $row['id'];
        $data['path'] = $realPath;
        $data['sharePath'] = $filePath;
        $data['isPhoto'] = ('photo' === $arr[0]) ? true : false;
        return $data;
    }

    private function GetParams_Create()
    {
        if (!isset($_REQUEST['id']) || !isset($_REQUEST['name']) || !isset($_REQUEST['comment'])) {
            return false;
        }
        if ('' === trim($_REQUEST['name']) || '' === trim($_REQUEST['comment'])) {
            return false;
        }
        // get photo, video id
        if (false === ($data = $this->GetItemInfo($_REQUEST['id']))) {
            return false;
        }
        $params['id'] = $data['id'];
        $params['path'] = $data['path'];
        $params['sharePath'] = $data['sharePath'];
        $params['isPhoto'] = $data['isPhoto'];

        if (!empty($_REQUEST['email'])) {
            if (false === filter_var($_REQUEST['email'], FILTER_VALIDATE_EMAIL)) {
                return false;
            }
        }
        $params['email'] = $_REQUEST['email'];
        $params['name'] = $_REQUEST['name'];
        $params['comment'] = $_REQUEST['comment'];
        $userType = csSYNOPhotoMisc::GetUserType();
        $params['userType'] = $userType;
        $params['validate_number'] = $_REQUEST['validate_number'];
        return $params;
    }

    private function GetParams_Delete()
    {
        if (!isset($_REQUEST['id']) || !isset($_REQUEST['comment_id'])) {
            return false;
        }
        // get photo, video id
        if (false === ($data = $this->GetItemInfo($_REQUEST['id']))) {
            return false;
        }
        $params['id'] = $data['id'];
        $params['path'] = $data['path'];
        $params['sharePath'] = $data['sharePath'];
        $params['isPhoto'] = $data['isPhoto'];

        // get comment id
        $params['comment_id'] = array();
        $arr = explode(',', $_REQUEST['comment_id']);
        foreach ($arr as $comment_id) {
            $split = explode('comment_', $comment_id);
            if (2 !== count($split)) {
                return false;
            }
            array_push($params['comment_id'], $split[1]);
        }
        return $params;
    }

    private function GetParams_List()
    {
        if (!isset($_REQUEST['id'])) {
            return false;
        }
        if (false === ($data = $this->GetItemInfo($_REQUEST['id']))) {
            return false;
        }
        $params['id'] = $data['id'];
        $params['path'] = $data['path'];
        $params['sharePath'] = $data['sharePath'];
        $params['isPhoto'] = $data['isPhoto'];
        return $params;
    }

    private function GetCommentID($photoID, $videoPath, $name, $email, $comment, $isPhoto)
    {
        if (true === $isPhoto) {
            $query = "SELECT id FROM photo_comment WHERE photo_id=? AND name=? AND email=? AND comment=? ORDER BY id DESC LIMIT 1";
            $sqlParam = array($photoID, $name, $email, $comment);
        } else {
            $query = "SELECT id FROM video_comment WHERE path=? AND name=? AND email=? AND comment=? ORDER BY id DESC LIMIT 1";
            $sqlParam = array($videoPath, $name, $email, $comment);
        }

        if (false === ($db_result = PHOTO_DB_Query($GLOBALS['dbconn_photo'], $query, $sqlParam))) {
            return false;
        }
        if (false === ($row = PHOTO_DB_FetchRow($db_result))) {
            return false;
        }
        return $row['id'];
    }

    private function IsAlbumCommentalb($sharePath) {
        $arr = explode('/', $sharePath);
		$level1ShareName = $arr[0];
        return isset($_SESSION[SYNOPHOTO_ADMIN_USER]['commentable_album'][$level1ShareName]);
    }

    private function FormComment($data)
    {
        $comments = array();
        foreach ($data as $item) {
            $comment['id'] = 'comment_'.$item['id'];
            $comment['name'] = $item['name'];
            $comment['email'] = $item['email'];
            $comment['comment'] = $item['comment'];
            $comment['date'] = $item['date'];
            array_push($comments, $comment);
        }
        return $comments;
    }

    private function CommentList()
    {
        if (false === ($params = $this->GetParams_List())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        // database query
        if (true === $params['isPhoto']) {
            $result = csSYNOPhotoDB::GetDBInstance()->GetPhotoComments($params['id']);
        } else {
            $result = csSYNOPhotoDB::GetDBInstance()->GetVideoComments($params['path']);
        }
        $comments = $this->FormComment($result);
        
        $resp['comments'] = $comments;
        $this->SetResponse($resp);
    End:
        return;
    }

    private function Delete()
    {
        csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

        csSYNOPhotoMisc::CheckSessionTimeOut(true);

        if (false === ($params = $this->GetParams_Delete())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }
        // check album maganeable
        if (false === csSynoPhotoMisc::CheckAlbumManageable(dirname($params['sharePath']))) {
            $this->SetError(PHOTOSTATION_COMMENT_ACCESS_DENY);
            goto End;
        }
        // database query
        if (true === $params['isPhoto']) {
            foreach ($params['comment_id'] as $comment_id) {
                csSYNOPhotoDB::GetDBInstance()->DeleteComment(1, $comment_id);
            }
        } else {
            foreach ($params['comment_id'] as $comment_id) {
                csSYNOPhotoDB::GetDBInstance()->DeleteComment(2, $comment_id);
            }
        }
    End:
        return;
    }

    private function Create()
    {
        csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

        if (false === ($params = $this->GetParams_Create())) {
            $this->SetError(WEBAPI_ERR_BAD_REQUEST);
            goto End;
        }

        // check album is commentable
        if (false === AlbumAPIUtil::IsAlbumCommentalbGlobal(true)) {
            $this->SetError(PHOTOSTATION_COMMENT_ACCESS_DENY);
            goto End;
        }

        // check validate number. guest must have correct validate number
        if (0 === $params['userType']) {
            if (null === $params['validate_number']) {
                $this->SetError(PHOTOSTATION_COMMENT_VALIDATE_FAIL);
                goto End;
            }

            $validateCount = strlen($params['validate_number']);
            if (4 === $validateCount) {
                if ((string)$params['validate_number'] !== (string)$_SESSION[SYNOPHOTO_ADMIN_USER]['post_key_photo']) {
                    $this->SetError(PHOTOSTATION_COMMENT_VALIDATE_FAIL);
                    goto End;
                }
            } elseif (12 === $validateCount) { // for DS photo+
                $phppath = '/var/packages/PhotoStation/target/photo_scripts/gen_comment_validate_string.php';
                $cmd = "/usr/syno/bin/php -n -d extension_dir=/lib/php/extensions -d extension=syno_compiler.so {$phppath} ".escapeshellarg($params['email']).' '.escapeshellarg($params['comment']);
                @exec($cmd, $signature, $ret);
                if (0 !== $ret) {
                    $this->SetError(PHOTOSTATION_COMMENT_VALIDATE_FAIL);
                    goto End;
                }
                if ($signature[0] !== (string)$params['validate_number']) {
                    $this->SetError(PHOTOSTATION_COMMENT_VALIDATE_FAIL);
                    goto End;
                }
            } else {
                $this->SetError(PHOTOSTATION_COMMENT_VALIDATE_FAIL);
                goto End;
            }
        }

        // database query
        if (false === csSYNOPhotoBrowse::GetBrowseInstance()->AddNewComment($params['path'], ($params['isPhoto']) ? SYNOPHOTO_ITEM_TYPE_PHOTO : SYNOPHOTO_ITEM_TYPE_VIDEO,
                                                              $params['name'], $params['email'], $params['comment'])) {
                $this->SetError(PHOTOSTATION_COMMENT_CREATE_FAIL);
                goto End;
        }

        // get inserted comment id
        $insertedID = $this->GetCommentID($params['id'], $params['path'], $params['name'], $params['email'], $params['comment'], $params['isPhoto']);

        $resp['id'] = 'comment_'.$insertedID;
        $this->SetResponse($resp);
    End:
        return;
    }
}

$api = new CommentAPI();
$api->Run();
?>


