<?php
$type = (array_key_exists('type', $_GET)) ? $_GET['type'] : null;
require_once('./include/syno_conf.php');

if (2 != csSYNOPhotoMisc::GetUserType() || null == $type || ($type != 'photo' && $type != 'blog')) {
	header('Location: '.SYNOPHOTO_URL_PREFIX .'/photo');
	exit;
}

$dsmVersion = csSYNOPhotoMisc::GetDsmVersion();
$packageVersion = csSYNOPhotoMisc::GetPackageVersion();
$smarty->assign('DSM_VERSION', '?v='.$dsmVersion);
$smarty->assign('PACKAGE_VERSION', '?v='.$packageVersion);

$lang = $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];
$smarty->assign('LAN_PARAM', "ln=$lang");


csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

if ('blog' == $type) {
	$pre_page_tail = '#TabBlog';
} else if ('photo' == $type) {
	$pre_page_tail = '#TabPhoto';
}
if (!isset($_SERVER['HTTP_REFERER'])) {
	$pre_page = SYNOPHOTO_URL_PREFIX . '/' .$type . '/';
} else if (strstr($_SERVER['HTTP_REFERER'], 'admin')) {
	$pre_page = $_SERVER['HTTP_REFERER'] . $pre_page_tail;
} else {
	$pre_page = $_SERVER['HTTP_REFERER'];
}

$jsGlobalVars = 'var gIsDemoMode=false';
if ('yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['enable_demomode']) {
	$jsGlobalVars .= 'gIsDemoMode = true;';
}

$logoName = htmlspecialchars(csSYNOPhotoMisc::GetConfigDB('theme', 'logo_name', $type.'_config'), ENT_QUOTES);
$bannerName = htmlspecialchars(csSYNOPhotoMisc::GetConfigDB('theme', 'banner_name', $type.'_config'), ENT_QUOTES);
$def['photo_theme_myLogImag'] = $logoName;
$def['photo_theme_myBannerImage'] = $bannerName;
$def['SYNOTHEME_REQUEST_FILE'] = SYNOTHEME_REQUEST_FILE;
$def['SYNOTHEME_SPACER_FILE'] = SYNOTHEME_SPACER_URL;
$def['SYNOTHEME_BKG_DEFAULT_THUMB_FILE'] = SYNOTHEME_BKG_DEFAULT_THUMB_FILE_URL;
$def['PREVIEW_URL'] = SYNOPHOTO_URL_PREFIX . '/' .$type . '/';
$def['PREPAGE_URL'] = $pre_page;
$def['TYPE'] = $type;

if (file_exists(SYNOTHEME_BANNER_CUSTOM_FILE)) {
	$imageInfo = @getImageSize(SYNOTHEME_BANNER_CUSTOM_FILE);
	$def['blog_banner_height'] = $imageInfo[1];
}

$smarty->assign('JS_GLOBAL_VARS', $jsGlobalVars);
$smarty->assign('SYNOTHEME_REQUEST_FILE',SYNOTHEME_REQUEST_FILE);
$smarty->assign('DEF',$def);
$smarty->assign('PAGE_TITLE', __(photo_management_title));
$smarty->display('theme_index.htm');



?>
