<?php
require_once("include/syno_conf.php");

// redirect old link to new photo station
if (isset($_GET['dir'])) {
	$albums = split('/', @pack('H*', $_GET['dir']));
	$token = 'Albums';
	$fullpath = '';
	foreach ($albums as $name) {
		$album = bin2hex($name);
		$fullpath .= $album;
		$token .= '/album_' . $fullpath;
		$fullpath .= '2f';
	}

	header("Location: index.php#$token");

} else if (isset($_GET['smart_album'])) {
	$token = 'SmartAlbums/smart_' . $_GET['smart_album'];

	header("Location: index.php#$token");

} else if (isset($_GET['virtual_album'])) {
	$token = 'SmartAlbums';
	switch($_GET['virtual_album']) {
		case 4:
			$token .= '/defaultsmart_People';
			if (isset($_GET['id']) && -1 == $_GET['id']) {
				$token .= '/defaultsmart_Unconfirm';
			}
			break;
		case 5:
			$token .= '/defaultsmart_Location';
			break;
		case 6:
			$token .= '/defaultsmart_General';
			break;
	}

	if (isset($_GET['id']) && $_GET['id'] > 0) {
		$token = $token . "/tag_" . $_GET['id'];
	}

	header("Location: index.php#$token");

} else {
	header("Location: index.php");
}

csSYNOPhotoDB::GetDBInstance()->SetSessionCache(true);

function IsLabelManageAction($manage)
{
	$ret = false;

	switch ($manage) {
		case 10:
		case 11:
		case 12:
		case 13:
			$ret = true;
			break;
		default:
			break;
	}

	return $ret;
}

function GetManageActionStr($manage)
{
	$key = 'photo_str_copy';

	switch ($manage) {
		case 0:
			$key = 'photo_str_man_album_move';
			break;
		case 1:
			$key = 'photo_str_deleteuser';
			break;
		case 2:
			$key = 'photo_str_upload_to_fb';
			break;
		case 3:
			$key = 'photo_str_upload_to_picasa';
			break;
		case 4:
			$key = 'photo_str_copy';
			break;
		case 10:
			$key = 'photo_str_album_add_gps_label';
			break;
		case 11:
			$key = 'photo_str_album_add_general_label';
			break;
		case 12:
			$key = 'photo_str_album_delete_gps_label';
			break;
		case 13:
			$key = 'photo_str_album_delete_general_label';
			break;
		default:
			break;
	}

	return __($key);
}

if (isSet($_GET['dir'])) {
	if ("" == $_GET['dir']) {
		if (!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
			header("Location: index.php");
		}
	} else {
		csSYNOPhotoMisc::CheckAlbumAccessible($albumName = @pack('H*', $_GET['dir']), 1);
	}
}
$currentUrl = csSYNOPhotoMisc::GetServerHost();
$currentUrl .= SYNOPHOTO_URL_PREFIX.'/photo/photo_thumb.php?dir='.$_GET['dir'];
$rssLink = 'rss.php';
$rssForCoolris = $rssLink.'?for_cooliris=true';

$title =  csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'photo_page_title');
if($title == NULL || $title == "") {
	$title = __(photo_str_ap_name);
}

$gpsData = SYNOPHOTO_GPS_UTIL_GetGPSDefLatLng();
$jsGlobalVars .= "g_gps_def=".json_encode($gpsData).";";

$thumbSize = SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE;//must assign before get thumb data
$jsGlobalVars .= "var gLayoutType=0;";
$jsGlobalVars .= "var gSocialNetworkList = ".json_encode(SocialNetwork::ReadList()).";";
if (!empty($_COOKIE['ys-layout_type'])) {
	$layoutTypeData = explode(':', $_COOKIE['ys-layout_type']);
	$layoutType = (int)$layoutTypeData[1];
} else{
	$layoutType = csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'thumbnail_layout_type');
}
$_SESSION[SYNOPHOTO_ADMIN_USER]['layout_type'] = $layoutType;

$thumbPerLoad = csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'thumbnail_per_page');
if (!$thumbPerLoad) {
	$thumbPerLoad = 40;
}

$page = 1;
if (isSet($_GET['page']) && is_numeric($_GET['page'])) {
	$page = $_GET['page'];
}


if (isSet($_GET['virtual_album'])) {//virtual album
	$virtualType = $_GET['virtual_album'];
	$isDisplayAll = false;
	if (isSet($_GET['display']) && $_GET['display'] == 'all') {
		$isDisplayAll = true;
	}
	$rssLink = 'rss.php?virtual_album='.$virtualType;
	if ($virtualType >=4 && $virtualType <= 6) {
		$labelId = null;
		$label = null;
		if (isSet($_GET['id'])) {
			$labelId = intval($_GET['id']);
			if (-1 !== $labelId && false === ($label = SYNOPHOTO_LABEL_UTIL_GetLabelById($labelId))) {
				header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/index.php");
				exit;
			}
			$rssLink = 'rss.php?virtual_album='.$virtualType.'&id='.$labelId;
		}
	}

	switch ($virtualType) {
	case 0:
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentThumbList('photo', false, false, 0, 0);
		break;
	case 1:
		if ($isDisplayAll) {
			$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentThumbList('video', false, false, 0, 0);
		} else {
			$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentVideoThumbList($page, $thumbPerLoad);
		}
		break;
	case 2:
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentThumbList('photo', true, false, 0, 0);
		break;
	case 3:
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetMostRecentThumbList('video', true, false, 0, 0);
		break;
	case 4:
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetLabelAlbumThumbList($page, $thumbPerLoad, 0, $labelId, $isDisplayAll);
		break;
	case 5:
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetLabelAlbumThumbList($page, $thumbPerLoad, 1, $labelId, $isDisplayAll);
		break;
	case 6:
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetLabelAlbumThumbList($page, $thumbPerLoad, 2, $labelId, $isDisplayAll);
		break;
	}

	$title = csSYNOPhotoMisc::getVirtualAlbumText($_GET['virtual_album']).' - '.$title;

	$pathLinkArray = csSYNOPhotoBrowse::GetBrowseInstance()->GetPathLinkArray('', $virtualType, false, ($labelId === -1) ? -1 : $label);
	$jsGlobalVars .= 'var gIsVirtual = true;var gIsAdmin=false;var gManageMode=null;var g_is_for_search=false;
		var gDisplayAll=false; var gDisableRightButton=false;var gCurrentPage=null; var gIsSmartAlbum = false;';

	$smarty->assign('IS_VIRTUAL', true);
	$rssForCooliris = $rssLink.'&for_cooliris=true';
	if (($virtualType == 1 && csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'recent_video_num') == "all")
		|| $virtualType >= 4) {

		$pageUrl = 'photo_thumb.php?virtual_album='.$virtualType;
		if ($label) {
			$pageUrl .= '&id='.$label['id'];
		}
		$smarty->assign('PAGE_URL', $pageUrl);
		if ($isDisplayAll) {
			$jsGlobalVars .= 'gDisplayAll=true;';
			$smarty->assign('IS_DISPLAY_ALL', true);
		} else {
			$totalPage = ceil($photoList['itemCount']/$thumbPerLoad);
			$smarty->assign('PAGE_INDEX', $photoList['pageIndex']);
			$smarty->assign('TOTALPAGE', $totalPage);
			$jsGlobalVars .= 'gCurrentPage='.$page.';';
			$jsGlobalVars .= 'gTotalPage='.$totalPage.';';
		}
	}
} else if (isSet($_GET['smart_album'])) {//smart album
	$smartAlbumName = $_GET['smart_album'];
	$title = htmlspecialchars(@pack('H*', $smartAlbumName)).' - '.$title;

	$isDisplayAll = false;
	if (isSet($_GET['display']) && $_GET['display'] == 'all') {
		$isDisplayAll = true;
	}

	$rssLink = 'rss.php?smart_album='.$_GET['smart_album'];
	$rssForCooliris = $rssLink.'&for_cooliris=true';

	$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetSmartAlbumItemList(@pack('H*', $smartAlbumName), $page, $thumbPerLoad, $isDisplayAll);

	$smarty->assign('PAGE_URL', 'photo_thumb.php?smart_album='.$smartAlbumName);
	$smarty->assign('IS_VIRTUAL', true);
	$smarty->assign('IS_SMARTALBUM', true);
	$smarty->assign('STR_EDIT_SMARTALBUM', __(photo_str_smart_album_title_edit));
	$smarty->assign('STR_DELETE_SMARTALBUM', __(photo_str_delete_current_album));

	$pathLinkArray = csSYNOPhotoBrowse::GetBrowseInstance()->GetPathLinkArray(@pack('H*', $smartAlbumName), -1, false, null, true);

	$jsGlobalVars .=
		'var gIsVirtual = true; var gIsAdmin = false; var gManageMode = null; var g_is_for_search = false;
		var gDisplayAll = false; var gDisableRightButton = false; var gCurrentPage = null; var gDisableShare = false;
		var gIsSmartAlbum = true; var gSmartAlbumName = '.json_encode(@pack('H*', $smartAlbumName)).';';

	if (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'disable_share') == 'on') {
		$jsGlobalVars .= 'gDisableShare = true;';
	}

	if ($isDisplayAll) {
		$jsGlobalVars .= 'gDisplayAll=true;';
		$smarty->assign('IS_DISPLAY_ALL', true);
	} else {
		$totalPage = ceil($photoList['itemCount'] / $thumbPerLoad);
		$smarty->assign('PAGE_INDEX', $photoList['pageIndex']);
		$smarty->assign('TOTALPAGE', $totalPage);
		$jsGlobalVars .= 'gCurrentPage = '.$page.';';
		$jsGlobalVars .= 'gTotalPage = '.$totalPage.';';
	}
} else if (isSet($_GET['search'])) {//search result
	if (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'hide_search') == 'on') {
		header("Location: index.php");
		exit;
	}

	//prepare query condition
	$matchPattern = array('dir', 'k', 'k_op', 'd', 'd_op', 'pt', 'pt_op', 'gt', 'gt_op', 'dt', 'dt_op');
	$condition = array();
	foreach($matchPattern as $field) {
		if (isSet($_GET[$field])) {
			$condition[$field] = $_GET[$field];
		}
	}

	//trim page, prepare url only query string
	$arr = explode("&", $_SERVER['QUERY_STRING']);
	$queryArr = array();
	foreach($arr as $item){
		if (substr($item, 0, 4) != 'page') {
			$queryArr[] = $item;
		}
	}

	$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetSearchThumbList($condition, ($page - 1) *SEARCH_RESULT_PER_LOAD, SEARCH_RESULT_PER_LOAD);

	$pathLinkArray = csSYNOPhotoBrowse::GetBrowseInstance()->GetPathLinkArray('');
	$jsGlobalVars .=
		"var gIsVirtual = false;var gIsAdmin=false;var gManageMode=null;var g_is_for_search=true;
		var gIsAllowDownload=false;var gDisplayAll=false; var gDisableRightButton=false;
		var gAlbumNameHex='".$_GET['dir']."'; var gIsSmartAlbum = false;";

	$jsGlobalVars .= "var searchTerm='';";
	if (isset($_GET['k'])) {
		$jsGlobalVars .= "var searchTerm=".json_encode($_GET['k']).";";
	}

	if (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'allow_album_download') == 'on') {
		$jsGlobalVars .= 'gIsAllowDownload=true;';
		$smarty->assign('ALLOW_DOWNLOAD', true);
	}

	if (isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) && !isset($_GET['dir'])) {
		$smarty->assign('STR_SAVE_AS_SMARTALBUM', __(photo_str_smart_album_title_save_as));
	}

	$totalPage = ceil($photoList['itemCount']/SEARCH_RESULT_PER_LOAD);
	$smarty->assign('PAGE_INDEX', $photoList['pageIndex']);
	$smarty->assign('PAGE_URL', 'photo_thumb.php?'.implode('&', $queryArr));
	$smarty->assign('TOTALPAGE', $totalPage);
	$jsGlobalVars .= 'var gCurrentPage='.$page.';';
	$jsGlobalVars .= 'var gTotalPage='.$totalPage.';';
	$smarty->assign('IS_SEARCH', true);
	$smarty->assign('STR_NO_RESULT', __(photo_str_no_search_result));
	$title = __(photo_str_search_result).' - '.$title;

} else {// normal
	$isDisplayAll = false;
	if (isSet($_GET['display']) && $_GET['display'] == 'all') {
		$isDisplayAll = true;
	}

	$manage = null;
	if (isSet($_GET['man']) && is_numeric($_GET['man'])) {
		$manage = $_GET['man'];
	}
	$manageable = false;
	if (csSYNOPhotoMisc::CheckAlbumManageable($albumName)) {
		$smarty->assign('IS_MANAGER', true);
		$jsGlobalVars .= 'gIsManager = true;';
		$jsGlobalVars .= "gSession='".session_id()."';";
		$manageable = true;
	} else {
		$jsGlobalVars .= 'gIsManager = false;';
	}

	if (!empty($_COOKIE['ys-thumb_size'])) {
		$sizeData = explode(':', $_COOKIE['ys-thumb_size']);
		$thumbSize = (int)$sizeData[1];
	} else {
		$thumbSize = csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'default_thumbnail_size_simple');
		if (1 == $_SESSION[SYNOPHOTO_ADMIN_USER]['layout_type']) {
			$thumbSize = csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'default_thumbnail_size');
		}

		if (empty($thumbSize)) {
			$thumbSize = SYNOPHOTO_DEFAULT_THUMBSMALL_SIZE;
		}
	}

	$albumName = @pack('H*', $_GET['dir']);
	$smarty->assign('ALBUM_NAME', $albumName);
	csSYNOPhotoAlbum::GetAlbumInstance()->AddHitTimes($albumName);
	$tok = explode('/', $albumName);
	$isThird = false;
	if (count($tok) > 2) {
		$isThird = true;
	}

	if ("" == $albumName) {
		$albumInfo = csSYNOPhotoBrowse::GetBrowseInstance()->GetUncategorizedPhotosAlbumThumb();
	} else {
		$albumInfo = csSYNOPhotoBrowse::GetBrowseInstance()->GetAlbumThumb($albumName);
	}

	$albumTitle = ($albumInfo['title'] == '') ? htmlspecialchars($albumInfo['dirName'], ENT_QUOTES) : htmlspecialchars($albumInfo['title'], ENT_QUOTES);

	if ($albumInfo['desc'] === '' && ($manageable || isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']))) {
		$albumDesc = __(photo_str_add_description);
		$smarty->assign('ADD_DESC_CLASS', 'empty-desc');
	} else {
		$albumDesc = htmlspecialchars($albumInfo['desc'], ENT_QUOTES);
		$smarty->assign('ADD_DESC_CLASS', '');
	}

	csSYNOPhotoBrowse::GetBrowseInstance()->SetSortTypeOrder($albumName);

	$manageActionStr = '';
	if ($isThird) {
		$jsGlobalVars .="var gIsThird=true; ";
	} else {
		$jsGlobalVars .="var gIsThird=false; ";
	}
	if (csSYNOPhotoMisc::isSetToSyncWithFb($albumName)) {
		$jsGlobalVars .="var gSetToSyncWithFb=true; ";
	} else {
		$jsGlobalVars .="var gSetToSyncWithFb=false; ";
	}
	if (csSYNOPhotoMisc::isSyncingWithFb($albumName)) {
		$jsGlobalVars .="gIsSyncingWithFb=true; ";
	} else {
		$jsGlobalVars .="var gIsSyncingWithFb=false; ";
	}
	$jsGlobalVars .="var gAlbumNameHex='".$_GET['dir']."'; ";
	$jsGlobalVars .="var gAlbumName=".json_encode($albumName)."; ";
	$jsGlobalVars .="var gDirName=".json_encode($tok[count($tok)-1])."; ";
	$jsGlobalVars .= "var gManageMode=null; var gIsAdmin=false; var gIsAllowDownload=false; var gIsAllowVideoDownload=false;var g_is_for_search=false;";
	$jsGlobalVars .= 'var gCurrentPage=null;var gDisplayAll=false;var gDisplayAll=false;var gHasFbToken=false;var gAllowGuestFbUpload=false;var gDisableShare=false;var gDisableRightButton=false;';
	$jsGlobalVars .= 'var gIsSmartAlbum = false;';

	if ('on' == csSYNOPhotoMisc::GetConfigDB("photo", "allow_guest_fb_upload", "photo_config")) {
		$jsGlobalVars .= 'gAllowGuestFbUpload=true;';
	}
	//0:move 1:delete 2:fb 3:picasa 4:copy
	// 10: add gps label, 11: add general label
	// 12: delete gps label, 13: delete gps label
	if ($manage !== null &&
		((($manage == 0 || $manage == 1 || $manage == 4 || IsLabelManageAction($manage)) && ($manageable || isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']))) ||
		 ($manage == 2 || $manage == 3))
		) {
		if ("" == $albumName) {
			$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetUncategorizedThumbList(($page - 1) * $thumbPerLoad, $thumbPerLoad, $thumbSize);
		} else {
			$removeAlbum = false;
			$removeVideo = false;
			if ($manage == 2 || $manage == 3 || $manage == 4 || IsLabelManageAction($manage)) {
				$removeAlbum = true;
				if ($manage == 2 || $manage == 3) {
					$removeVideo = true;
				}
			}
			$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetThumbList($albumName, ($page - 1) * $thumbPerLoad, $thumbPerLoad, $thumbSize, $removeAlbum, $removeVideo);
		}
		$totalPage = ceil($photoList['itemCount']/$thumbPerLoad);
		$smarty->assign('PAGE_INDEX', $photoList['pageIndex']);
		$smarty->assign('TOTALPAGE', $totalPage);
		$smarty->assign('PAGE_URL', 'photo_thumb.php?dir='.bin2hex($albumName).'&man='.$manage);
		$jsGlobalVars .= 'gCurrentPage='.$page.';';
		$jsGlobalVars .= 'gTotalPage='.$totalPage.';';
		$jsGlobalVars .= 'gManageMode='.$manage.";\n";
		$manageActionStr = GetManageActionStr($manage);
		$jsGlobalVars .= 'var gSelectList="";';
		if (isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['select_list'])) {
			$jsGlobalVars .= 'gSelectList="'.$_SESSION[SYNOPHOTO_ADMIN_USER]['select_list'].'";';
		}
	} else if ($isDisplayAll && isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user'])) {
		$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetThumbListAll($albumName, null, false, false, $thumbSize);
		$jsGlobalVars .= 'gDisplayAll=true;';
		$smarty->assign('IS_DISPLAY_ALL', true);
		$smarty->assign('PAGE_URL', 'photo_thumb.php?dir='.bin2hex($albumName));
	} else {
		if ("" == $albumName) {
			$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetUncategorizedThumbList(($page - 1) * $thumbPerLoad, $thumbPerLoad, $thumbSize);
		} else {
			$photoList = csSYNOPhotoBrowse::GetBrowseInstance()->GetThumbList($albumName, ($page - 1) * $thumbPerLoad, $thumbPerLoad, $thumbSize);
		}
		$totalPage = ceil($photoList['itemCount']/$thumbPerLoad);
		$smarty->assign('PAGE_INDEX', $photoList['pageIndex']);
		$smarty->assign('PAGE_URL', 'photo_thumb.php?dir='.bin2hex($albumName));
		$smarty->assign('TOTALPAGE', $totalPage);
		$jsGlobalVars .= 'gCurrentPage='.$page.';';
		$jsGlobalVars .= 'gTotalPage='.$totalPage.';';
	}

	$jsGlobalVars .="var gPhotoCount=".($photoList['itemCount'] - $photoList['videoCount'] - $photoList['subAlbumCount'])."; ";
	$jsGlobalVars .="var gItemCount=".$photoList['itemCount']."; ";

	$jsGlobalVars .= 'var gIsVirtual = false;var gUploadable=false; var gAllowCopyFromDs=false;';

	if (csSYNOPhotoMisc::CheckAlbumUploadable($albumName)) {
		$smarty->assign('IS_UPLOADABLE', true);
		$jsGlobalVars .= 'gUploadable = true;';
		$jsGlobalVars .= "gSession='".session_id()."';";
		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['use_dsm_account'] ||
			(isset($_SESSION[SYNOPHOTO_ADMIN_USER]['admin_syno_user']) &&
			!isset($_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']))) {
			$jsGlobalVars .= 'gAllowCopyFromDs = true;';
		}
	}
	if (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'allow_album_download') == 'on') {
		$jsGlobalVars .= 'gIsAllowDownload=true;';
	}
	$linkPathClass = 'info-link-with-search';
	if (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'hide_search') == 'on') {
		$smarty->assign('IS_HIDE_SEARCH', true);
		$linkPathClass = '';
	}
	if ('' != $albumName) {
		$pathLinkArray = csSYNOPhotoBrowse::GetBrowseInstance()->GetPathLinkArray($albumName);
	} else {
		$pathLinkArray = csSYNOPhotoBrowse::GetBrowseInstance()->GetPathLinkArray($albumName, -1, true);
	}
	$rssLink = 'rss.php?dir='.$_GET['dir'];
	$rssForCooliris = $rssLink.'&for_cooliris=true';

	$coverFile = $albumInfo['cover'];
	$style = csSYNOPhotoMisc::GetOverFitCenterStyle($coverFile, 54, 54);
	$smarty->assign('COVER_SRC', $coverFile['src']);
	$smarty->assign('COVER_STYLE', $style);

	if (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'disable_share') == 'on') {
		$jsGlobalVars .= 'gDisableShare = true;';
	}

	$title = $albumInfo['showTitle'].' - '.$title;
	$smarty->assign('Hit_COUNT', $albumInfo['hit']);
} //end of normal

if (1 == $layoutType) {
	$jsGlobalVars .= "gLayoutType=1;";
	$smarty->assign('LAYOUT_TYPE', 1);
	$smarty->assign('DETAIL_ALBUM_CLASS', 'detail-album-info');
	$smarty->assign('DETAIL_PHOTOMAIN_CLASS', 'photo-main-detail');
}

$jsGlobalVars .= 'var gIsDemoMode = false;';
if ('yes' == $_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['cfg']['enable_demomode']) {
	$jsGlobalVars .= 'gIsDemoMode = true;';
	$isDemoMode = true;
}

if (csSYNOPhotoDB::GetDBInstance()->GetConfig('photo', 'disable_right_button') == 'on') {
	$jsGlobalVars .= 'gDisableRightButton = true;';
}

$userType = csSYNOPhotoMisc::GetUserType();
$jsGlobalVars .= "var gUserType=$userType;";

if(2 == $userType) {
	$smarty->assign('IS_ADMIN', true);
	$jsGlobalVars .= 'gIsAdmin=true;';

	$token = csSYNOPhotoMisc::GetConfigDB("photo", "fb_token", "photo_config" );
	if (null != $token && "" != $token) {
		$jsGlobalVars .= "gHasFbToken=true;";
	}
} else if(1 == $userType) {
	$jsGlobalVars .= "gCurrentUsername='".$_SESSION[SYNOPHOTO_ADMIN_USER]['reg_syno_user']."';";
}

$dsmVersion = csSYNOPhotoMisc::GetDsmVersion();
$packageVersion = csSYNOPhotoMisc::GetPackageVersion();
$smarty->assign('DSM_VERSION', '?v='.$dsmVersion);
$smarty->assign('PACKAGE_VERSION', '?v='.$packageVersion);

$lang = $_SESSION[SYNOPHOTO_ADMIN_USER]['lang'];
$smarty->assign('LAN_PARAM', "ln=$lang");

$jsGlobalVars .= "gCurrentSize=".$thumbSize.';';

$previewDataList = csSYNOPhotoBrowse::GetBrowseInstance()->prepareThumbListForPreview($photoList['items']);

$show_bkg_img = $_SESSION[SYNOPHOTO_ADMIN_USER]['photo_config']['theme']['show_bkg_img'];
if ($show_bkg_img && '1' == $show_bkg_img && file_exists(SYNOTHEME_BKG_SYNO_FILE)) {
	$smarty->assign('BKG_CHANGE',  @filemtime(SYNOTHEME_BKG_SYNO_FILE));
} else if ($show_bkg_img && '2' == $show_bkg_img && file_exists(SYNOTHEME_BKG_CUSTOM_FILE)) {
	$smarty->assign('BKG_CHANGE',  @filemtime(SYNOTHEME_BKG_CUSTOM_FILE));
} else if ($show_bkg_img && '3' == $show_bkg_img) {
	$smarty->assign('BKG_CHANGE',  '0');
} else {
	$smarty->assign('BKG_CHANGE',  rand());
}

$thumbSizeArr = csSYNOPhotoBrowse::GetBrowseInstance()->getThumbSizeArray($thumbSize, $layoutType);
if ($thumbSize < 136) {
	$smarty->assign('TITLE_DISPLAY_CLASS', 'display-none');
} else {
	$smarty->assign('TITLE_DISPLAY_CLASS', '');
}

$jsGlobalVars .= 'var unique="'.$_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['defCfg']['unique'].'";';
$jsGlobalVars .="var gPathLink=".json_encode($pathLinkArray)."; ";

$smarty->assign('PHOTO_META_DESC', __(photo_str_meta_desc));
$smarty->assign('PHOTO_META_KEYWORD', __(photo_str_meta_keyword));
$smarty->assign('PHOTO_STATION_TITLE', $title);
$smarty->assign('IS_THUMB_PAGE', true);
$smarty->assign('THUMB_CLS', 'album-thumb');

$smarty->assign('WELCOME_TITLE', csSYNOPhotoMisc::GetWelcomeText());
$smarty->assign('HEADER_LINK_ARRAY', csSYNOPhotoMisc::GetTopHeaderLinkArray());

$smarty->assign('PATH_LINK_ARRAY', $pathLinkArray);
$smarty->assign('PATH_LINK_LENGTH_CLASS', $linkPathClass);
$smarty->assign('ALBUM_DESC', $albumDesc);

$smarty->assign('STR_ADD', __(photo_str_add));
$smarty->assign('STR_MANAGEMENT', __(photo_str_man_manage));
$smarty->assign('STR_SELECT_ALL', __(photo_str_select_all));
$smarty->assign('STR_SELECT_PAGE_ALL', __(photo_str_select_page_all));
$smarty->assign('STR_SLIDESHOW', __(photo_str_slideshow));
$smarty->assign('STR_MAP', __(photo_str_map));
$smarty->assign('STR_SHARE', __(photo_str_share));
$smarty->assign('STR_MORE', __(photo_str_more));
$smarty->assign('STR_ACTION', $manageActionStr);
$smarty->assign('STR_MAN_MODE', $manage);
$smarty->assign('STR_CANCEL', __(photo_str_btnCancel));
$smarty->assign('STR_ALBUMS', __(photo_str_albums));
$smarty->assign('STR_ITEMS', __(photo_str_items));
$smarty->assign('STR_SEARCH_RESULT', __(photo_str_search_result));
$smarty->assign('STR_ALBUM', __(photo_str_photoalbum));
$smarty->assign('STR_PHOTO', __(photo_str_photo));
$smarty->assign('STR_VIDEO', __(photo_str_search_result_video));
$smarty->assign('STR_DOWNLOAD', __(photo_str_btnDownload));
$smarty->assign('STR_FILENAME', __(photo_str_sort_type_filename));
$smarty->assign('STR_ADD_TITLE', __(photo_str_add_title));
$smarty->assign('STR_HITS', __(photo_str_hits));
//quick menu string
$smarty->assign('STR_ROTATE_90', __(photo_str_rotate_90));
$smarty->assign('STR_ROTATE_270', __(photo_str_rotate_270));
$smarty->assign('STR_SET_COVER', __(photo_str_setcover));
if (!$isDemoMode) {
	$smarty->assign('STR_DELETE', __(photo_str_deleteuser));
} else {
	$smarty->assign('STR_DELETE', __(photo_str_error_demo));
}

$smarty->assign('STR_NO_ITEM', __(photo_str_no_item));
$smarty->assign('ITEM_COUNT', $photoList['itemCount']);
$smarty->assign('SUBALBUM_COUNT', $photoList['subAlbumCount']);
$smarty->assign('VIEDO_COUNT', $photoList['videoCount']);
$smarty->assign('PHOTO_COUNT', $photoList['itemCount'] - $photoList['videoCount'] - $photoList['subAlbumCount']);
$smarty->assign('ALBUMS', $photoList['items']);
$smarty->assign('DIR', $_GET['dir']);
$smarty->assign('JS_GLOBAL_VARS', $jsGlobalVars);
$smarty->assign('SCRIPT_PREVIEW_DATA', $previewDataList);

$smarty->assign('STR_DISPLAY_ALL', __(photo_str_display_all));
$smarty->assign('STR_DISPLAY_PAGE', __(photo_str_display_page));
$smarty->assign('SYNOTHEME_REQUEST_FILE', SYNOTHEME_REQUEST_FILE);
$smarty->assign('RSS_URL', $rssLink);
$smarty->assign('RSS_COOLIRIS', $rssForCooliris);

$smarty->assign('ITEM_WIDTH', $thumbSizeArr['itemWidth']);
$smarty->assign('ITEM_HEIGHT', $thumbSizeArr['itemHeight']);
$smarty->assign('ALBUM_SIZE', $thumbSizeArr['albumSize']);
$smarty->assign('ALBUM_LEFT_SIZE', $thumbSizeArr['albumLeft']);
$smarty->assign('ALBUM_RIGHT_HEIGHT', $thumbSizeArr['albumRightHeight']);
$smarty->assign('PHOTO_SIZE', $thumbSizeArr['photoSize']);
$smarty->assign('THUMB_SIZE', $thumbSize);
$smarty->assign('VIDEO_ICON_LEFT', $thumbSizeArr['viedoIconLeft']);
$smarty->assign('CURRENT_TITLE', $albumTitle ? $albumTitle : $_SERVER['SERVER_NAME']);
$smarty->assign('CURRENT_DESC', strcmp(__(photo_str_add_description), $albumDesc) ? $albumDesc : '');
$smarty->assign('CURRENT_IMAGE_URL', $albumInfo['cover']['src'] ? csSYNOPhotoMisc::GetServerHost().$albumInfo['cover']['src'] : "");
$smarty->assign('CURRENT_URL', $currentUrl);

$smarty->display('photo/photo_thumb.tpl');

?>
