<?php
/*!
 * static misc function
 */
class csSYNOPhotoMisc {
	/*!
	 * check the prefix of files in eaDir is old or not
	 */
	static function IsOldEAFilePrefix() {
		if ($_SESSION[SYNOPHOTO_ADMIN_USER]['system_config']['dsmCfg']['buildnumber'] >= SYNOPhotoEA::OLD_EADIR_PREFIX_DSM_VERSION) {
			return false;
		}
		return true;
	}
	/*!
	 * check the $path is a allowed photo file or not
	 *
	 * \param $path file path
	 * \return true or false
	 */
	static function IsPhotoFile($path)
	{
		global $SYNOPHOTO_ALLOW_PICT_NAMES_EXT;

		$path = strtolower($path);
		$ext = substr(strrchr($path, '.'), 1);
		if (in_array($ext, $SYNOPHOTO_ALLOW_PICT_NAMES_EXT)) {
			return true;
		}
		return false;
	}
	/*!
	 * check the photo file $path should have thumb file or not
	 *
	 * \param $path photo file path
	 * \return true or false
	 */
	static function IsPhotoFileWithThumb($path)
	{
		global $SYNOPHOTO_ALLOW_ORIG_NAMES_EXT;

		$path = strtolower($path);
		$ext = substr(strrchr($path, '.'), 1);
		if (!in_array($ext, $SYNOPHOTO_ALLOW_ORIG_NAMES_EXT)) {
			return true;
		}
		return false;
	}
	/*!
	 * check the disk space is empty enough or not
	 *
	 * \return true or false
	 */
	static function DiskSpaceCheck()
	{
		if (SYNOPHOTO_RSRV_DISK_SPACE < diskfreespace(SYNOPHOTO_SERVICE_DIR)) {
			return true;
		}
		return false;
	}
	/*!
	 * Get accessible sub-dir list
	 *
	 * \param $albumName album name
	 * \param $isNeedCtime returned list need include create time or not
	 * \return array with sub-dir list
	 */
	static function GetSubDir($albumName, $isNeedCtime)
	{
		$list = array();
		$currPath = getcwd();
		@chdir(SYNOPHOTO_SERVICE_DIR . "/{$albumName}");

		foreach (glob('{,.}*', GLOB_BRACE | GLOB_ONLYDIR) as $dir) {
			// skip photo in remote mount (cifs) or read-only mount (iso9660)
			if (csSYNOPhotoMisc::IsSkipPhotoPath(SYNOPHOTO_SERVICE_DIR.'/'.$albumName.'/'.$dir)) {
				continue;
			}
			if ($dir != SYNOPHOTO_EADIR && $dir != '.' && $dir != '..') {
				if (false === strpos($albumName, '/') &&
					!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir']["{$albumName}/{$dir}"])) {
					continue;
				}
				$list["{$albumName}/{$dir}"] = $isNeedCtime ? filectime($dir) : 0;
			}
		}

		@chdir($currPath);
		return $list;
	}
	/*!
	 * check the album is thumbing or not
	 *
	 * \param $dir the album name
	 * \return true or false
	 */
	static function ThumbingCheck($dir='')
	{
		$isThumbing = false;
		$lockPath = "{$dir}/".SYNOPHOTO_EADIR;

		if (($fp = @fopen($lockPath, 'r'))>0) {
			if (flock($fp, LOCK_EX | LOCK_NB)) {
				flock($fp, LOCK_UN);
			} else {
				$isThumbing = true;
			}
			fclose($fp);
		}
		return $isThumbing;
	}
	/*!
	 * Get thumb file path by photo file path
	 *
	 * \param $path photo file path
	 * \param $isBigThumb return big thumb or not
	 * \param $isFail return thumb for failed thumb or not
	 * \return the thumb file path
	 */
	static function GetThumbPathFromFullPath($path, $thumbType, $isFail)
	{
		if ($isFail) {
			$thumbName = SYNOPHOTO_THUMBSMALL != $thumbType ? SYNOPhotoEA::FILE_THUMB_B_FAIL : SYNOPhotoEA::FILE_THUMB_S_FAIL;
		} else {
			switch ($thumbType) {
				case SYNOPHOTO_THUMBSMALL:
					$thumbName = SYNOPhotoEA::FILE_THUMB_S;
					break;
				case SYNOPHOTO_THUMBMEDIUM:
					$thumbName = SYNOPhotoEA::FILE_THUMB_M;
					break;
				case SYNOPHOTO_THUMBBIG:
					$thumbName = SYNOPhotoEA::FILE_THUMB_B;
					break;
				case SYNOPHOTO_THUMBLARGE:
					$thumbName = SYNOPhotoEA::FILE_THUMB_L;
					break;
				default:
					$thumbName = SYNOPhotoEA::FILE_THUMB_XL;
					break;
			}
		}
		SYNOPhotoEA::checkFilePath($path, $thumbName, $thumbPath);
		return $thumbPath;
	}
	/*!
	 * Get alternative thumb type during thumb generating
	 */
	static function GetAlternativeThumbType($thumbType)
	{
		$type = $thumbType;

		switch($thumbType) {
			case SYNOPHOTO_THUMBSMALL:
			case SYNOPHOTO_THUMBMEDIUM:
				$type = SYNOPHOTO_THUMBMEDIUM;
				break;
			case SYNOPHOTO_THUMBBIG:
			case SYNOPHOTO_THUMBLARGE:
			case SYNOPHOTO_THUMBXLARGE:
			default:
				$type = SYNOPHOTO_THUMBXLARGE;
		}

		return $type;
	}
	/*!
	 * Get thumb info by photo file path
	 *
	 * \param $path photo file path
	 * \param $thumbType return large thumb, big thumb or small thumb
	 * \param $width photo width
	 * \param $height photo height
	 * \param $version photo orientation
	 * \return array with thumb info
	 *	- src: link to the thumb file
	 *	- width: thumb width
	 *	- height: thumb height
	 */
	static function GetThumbInfoFromFullPath($path, $thumbType, $width, $height, $version)
	{
		if (!csSYNOPhotoMisc::IsPhotoFile($path)) {
			return array();
		}

		$isPhotoFileWithThumb = self::IsPhotoFileWithThumb($path);
		$fileName = basename($path);
		$dir = (false !== strpos($path, SYNOPHOTO_SERVICE_DIR)) ? SYNOPHOTO_SERVICE_DIR.'/' : SYNOPHOTO_SERVICE_REAL_DIR.'/';
		$dir = substr($path, strlen($dir), strlen($path) - strlen($dir) - strlen($fileName) - 1);

		$thumbFile = '';
		$failFile  = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, $thumbType, true);
		if ($isPhotoFileWithThumb) {
			$thumbFile = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, $thumbType, false);
			if (!@file_exists($thumbFile)) {
				$thumbType = csSYNOPhotoMisc::GetAlternativeThumbType($thumbType);
				$thumbFile = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, $thumbType, false);
			}
		}

		if (!empty($thumbFile) && @file_exists($thumbFile)) {
			if ($version == -1) {
				$photoInfo = csSYNOPhotoDB::GetDBInstance()->GetPhotoInfo($path);
				$version = $photoInfo ? $photoInfo['version'] : -1;
			}
			if (($version % 2) == 1) {
				$tmp = $width;
				$width = $height;
				$height = $tmp;
			}
			$type = $thumbType;
			$result['src'] = '/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName)."&type={$type}&v={$version}";
		} else if (@file_exists($failFile)) {
			if (SYNOPHOTO_THUMBSMALL != $thumbType) {
				$result['src'] = SYNOPHOTO_IMG_BROKEN_BIG;
				$thumbFile = SYNOPHOTO_IMG_BROKEN_BIG_FILE_PATH;
			} else {
				$result['src'] = SYNOPHOTO_IMG_BROKEN;
				$thumbFile = SYNOPHOTO_IMG_BROKEN_FILE_PATH;
			}

		} else {
			if (!csSYNOPhotoMisc::DiskSpaceCheck()) {
				if (SYNOPHOTO_THUMBSMALL != $thumbType) {
					$result['src'] = SYNOPHOTO_IMG_FULL_BIG;
					$thumbFile = SYNOPHOTO_IMG_FULL_BIG_FILE_PATH;
				} else {
					$result['src'] = SYNOPHOTO_IMG_FULL;
					$thumbFile = SYNOPHOTO_IMG_FULL_FILE_PATH;
				}
			} else if (!$isPhotoFileWithThumb) {
				if (SYNOPHOTO_THUMBLARGE_WIDTH >= $width && SYNOPHOTO_THUMBLARGE_HEIGHT >= $height) {
					$result['src'] = '/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName).'&type=2';
					$thumbFile = $path;
				} else {
					// use broken image as thumb image for those gif images with high resolution,
					// to prevend from client site out of memory
					if (SYNOPHOTO_THUMBSMALL != $thumbType) {
						$result['src'] = SYNOPHOTO_IMG_BROKEN_BIG;
						$thumbFile = SYNOPHOTO_IMG_BROKEN_BIG_FILE_PATH;
					} else {
						$result['src'] = SYNOPHOTO_IMG_BROKEN;
						$thumbFile = SYNOPHOTO_IMG_BROKEN_FILE_PATH;
					}
				}

			} else {
				if (SYNOPHOTO_THUMBSMALL != $thumbType) {
					$result['src'] = SYNOPHOTO_IMG_THUMB_BIG;
					$thumbFile = SYNOPHOTO_IMG_THUMB_BIG_FILE_PATH;
				} else {
					$result['src'] = SYNOPHOTO_IMG_THUMB;
					$thumbFile = SYNOPHOTO_IMG_THUMB_FILE_PATH;
				}
				$dirPath = substr($path, 0 , (strlen($path) - strlen($fileName) - 1));
				if (!csSYNOPhotoMisc::ThumbingCheck($dirPath)) {
					@system('/usr/syno/bin/synomkthumb -a '.escapeshellarg($dirPath).' > /dev/null 2>&1');
				}
			}
		}

		if (false !== strpos($result['src'], 'convert.php') && (0 != $width && 0 != $height)) {
			$imageInfo[0] = $width;
			$imageInfo[1] = $height;
		} else {
			$imageInfo = @getImageSize($thumbFile);
		}

		if	(SYNOPHOTO_THUMBSMALL == $thumbType) {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBSMALL_WIDTH, SYNOPHOTO_THUMBSMALL_HEIGHT);
		} else if (SYNOPHOTO_THUMBMEDIUM == $thumbType){
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBMEDIUM_WIDTH, SYNOPHOTO_THUMBMEDIUM_HEIGHT);
		} else if (SYNOPHOTO_THUMBBIG == $thumbType){
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBBIG_WIDTH, SYNOPHOTO_THUMBBIG_HEIGHT);
		} else if (SYNOPHOTO_THUMBLARGE == $thumbType) {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBLARGE_WIDTH, SYNOPHOTO_THUMBLARGE_HEIGHT);
		} else {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBXLARGE_WIDTH, SYNOPHOTO_THUMBXLARGE_HEIGHT);
		}

		$result['width'] = $imageInfo['width'];
		$result['height'] = $imageInfo['height'];

		return $result;
	}
	/*!
	 * Get video thumb info by video file path
	 *
	 * \param $path video file path
	 * \param $isBigThumb return big thumb or not
	 * \param $width video width
	 * \param $height video height
	 *
	 * \return array with thumb info
	 *	- src: link to the thumb file
	 *	- width: thumb width
	 *	- height: thumb height
	 */
	static function GetVideoThumbInfoFromFullPath($path, $thumbType, $width, $height)
	{
		$fileName = basename($path);
		$dir = (false !== strpos($path, SYNOPHOTO_SERVICE_DIR)) ? SYNOPHOTO_SERVICE_DIR.'/' : SYNOPHOTO_SERVICE_REAL_DIR.'/';
		$dir = substr($path, strlen($dir), strlen($path) - strlen($dir) - strlen($fileName) - 1);

		$failFile  = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, $thumbType, true);

		$thumbFile = csSYNOPhotoMisc::GetThumbPathFromFullPath($path, $thumbType, false);


		if (!empty($thumbFile) && @file_exists($thumbFile)) {
			$type = $thumbType;
			$result['src'] = '/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($fileName)."&type={$type}&v=0";
		} else if (@file_exists($failFile)) {
			if (SYNOPHOTO_THUMBSMALL != $thumbType) {
				$result['src'] = SYNOPHOTO_IMG_BROKEN_BIG;
				$thumbFile = SYNOPHOTO_IMG_BROKEN_BIG_FILE_PATH;
			} else {
				$result['src'] = SYNOPHOTO_IMG_BROKEN;
				$thumbFile = SYNOPHOTO_IMG_BROKEN_FILE_PATH;
			}

		} else {
			if (!csSYNOPhotoMisc::DiskSpaceCheck()) {
				if (SYNOPHOTO_THUMBSMALL != $thumbType) {
					$result['src'] = SYNOPHOTO_IMG_FULL_BIG;
					$thumbFile = SYNOPHOTO_IMG_FULL_BIG_FILE_PATH;
				} else {
					$result['src'] = SYNOPHOTO_IMG_FULL;
					$thumbFile = SYNOPHOTO_IMG_FULL_FILE_PATH;
				}
			}  else {
				if (SYNOPHOTO_THUMBSMALL != $thumbType) {
					$result['src'] = SYNOPHOTO_IMG_THUMB_BIG;
					$thumbFile = SYNOPHOTO_IMG_THUMB_BIG_FILE_PATH;
				} else {
					$result['src'] = SYNOPHOTO_IMG_THUMB;
					$thumbFile = SYNOPHOTO_IMG_THUMB_FILE_PATH;
				}
				@system('/usr/syno/bin/synomkflv -a '.escapeshellarg($path).' > /dev/null 2>&1');
			}
		}

		if (false !== strpos($result['src'], 'convert.php') && (0 != $width && 0 != $height)) {
			$imageInfo[0] = $width;
			$imageInfo[1] = $height;
		} else {
			$imageInfo = @getImageSize($thumbFile);
		}

		if	(SYNOPHOTO_THUMBSMALL == $thumbType) {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBSMALL_WIDTH, SYNOPHOTO_THUMBSMALL_HEIGHT);
		} else if (SYNOPHOTO_THUMBMEDIUM == $thumbType){
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBMEDIUM_WIDTH, SYNOPHOTO_THUMBMEDIUM_HEIGHT);
		} else if (SYNOPHOTO_THUMBBIG == $thumbType){
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBBIG_WIDTH, SYNOPHOTO_THUMBBIG_HEIGHT);
		} else if (SYNOPHOTO_THUMBLARGE == $thumbType) {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBLARGE_WIDTH, SYNOPHOTO_THUMBLARGE_HEIGHT);
		} else {
			$imageInfo = csSYNOPhotoMisc::GetJustFitWidthHeight($imageInfo[0], $imageInfo[1], SYNOPHOTO_THUMBXLARGE_WIDTH, SYNOPHOTO_THUMBXLARGE_HEIGHT);
		}

		$result['width'] = $imageInfo['width'];
		$result['height'] = $imageInfo['height'];
		return $result;
	}

	/*!
	 * check album accessible or not
	 *
	 * \param $albumName album name
	 * \return true or false
	 */
	static function CheckAlbumAccessible($albumName, $isNeedRedirect=false)
	{
		if (!file_exists(SYNOPHOTO_SERVICE_DIR."/".$albumName)) {
			if ($isNeedRedirect) {
				header("Location: ".SYNOPHOTO_URL_PREFIX."/photo/index.php");
				exit;
			}
			return false;
		}

		$albumToken = explode('/', $albumName);
		if (1 < count($albumToken)) {
			$albumName = $albumToken[0]."/".$albumToken[1];
		}
		if (1 == count($albumToken)) {
			if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName])) {
				if ($isNeedRedirect) {
					self::RedirectToLoginPage($albumName);
				}
				return false;
			}
			if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName]['password'] &&
				$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'][$albumName]['password'] !=
				$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName]) {
				if ($isNeedRedirect) {
					self::RedirectToLoginPage($albumName, 1);
				}
				return false;
			}
			return true;
		}

		if (!isSet($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName])) {
			if ($isNeedRedirect) {
				self::RedirectToLoginPage($albumName);
			}
			return false;
		}
		if ('f' == $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['public'] &&
			'' == $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password']) {
			return true;
		}
		if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] &&
			$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] ==
			$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName]) {
			return true;
		}
		if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] &&
			$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'][$albumName]['password'] !=
			$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album'][$albumName]) {
			if ($isNeedRedirect) {
				self::RedirectToLoginPage($albumName, 1);
			}
			return false;
		}
		if ('' != $_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']["{$albumToken[0]}"]['password'] &&
			$_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album']["{$albumToken[0]}"]['password'] !=
			$_SESSION[SYNOPHOTO_ADMIN_USER]['password_pass_album']["{$albumToken[0]}"]) {
			if ($isNeedRedirect) {
				self::RedirectToLoginPage($albumToken[0], 1);
			}
			return false;
		}
		return true;
	}

	static function GetAccessibleAlbumQueryCondition()
	{
		if (!empty($_SESSION[SYNOPHOTO_ADMIN_USER]['albumQueryCondition'])) {
			return $_SESSION[SYNOPHOTO_ADMIN_USER]['albumQueryCondition'];
		}

		$albumCond = array();
		$sqlParam = array();

		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_album'] as $item) {
			if (!self::CheckAlbumAccessible($item['sharename'])) {
				continue;
			}
			$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
			$albumCond[] = "(path LIKE ? ".csSYNOPhotoDB::GetDBInstance()->escapeStr." AND path NOT LIKE ? ".csSYNOPhotoDB::GetDBInstance()->escapeStr.") ";
			$sqlParam[] = "{$albumRealPath}/%";
			$sqlParam[] = "{$albumRealPath}/%/%";
		}
		foreach ($_SESSION[SYNOPHOTO_ADMIN_USER]['accessible_subdir'] as $item) {
			if (!self::CheckAlbumAccessible($item['sharename'])) {
				continue;
			}
			$albumRealPath = csSYNOPhotoDB::EscapeLikeParam(SYNOPHOTO_SERVICE_REAL_DIR_PATH."{$item['sharename']}");
			$albumCond[] = "path LIKE ? ".csSYNOPhotoDB::GetDBInstance()->escapeStr;
			$sqlParam[] = "{$albumRealPath}/%";
		}
		$result['albumCond'] = $albumCond;
		$result['sqlParam'] = $sqlParam;
		$_SESSION[SYNOPHOTO_ADMIN_USER]['albumQueryCondition'] = $result;
		return $result;
	}

	/*!
	 * Get converted video list
	 *
	 * \return array with url list
	 */
	static function GetConvertedVideosFileInfoFromFullPath($path)
	{

		$name = basename($path);
		$dir = (false !== strpos($path, SYNOPHOTO_SERVICE_DIR)) ? SYNOPHOTO_SERVICE_DIR.'/' : SYNOPHOTO_SERVICE_REAL_DIR.'/';
		$dir = substr($path, strlen($dir), strlen($path) - strlen($dir) - strlen($name) - 1);
		$url = '/photo/convert.php?dir='.bin2hex($dir).'&name='.bin2hex($name).'&v=0';

		$data = csSYNOPhotoDB::GetDBInstance()->GetConvertedVideoInfoFromFullPath($path);

		$result = array();
		foreach ($data as $item) {
			$filename = basename($item['path']);
			$type = self::getTypeFromFilename($filename);
			if (FALSE !== $type) {
				$result[] = array('src' => $url."&type={$type}", 'bitrate' => $item['bitrate'], 'codec' => $item['codec']);
			}
		}

		if (0 >= count($result)) {
			return array(array('src' => SYNOPHOTO_IMG_BROKEN, 'bitrate' => 0, 'codec' => ''));
		}
		return $result;
	}
	/*!
	 * get the rounded float number
	 *
	 * \param $value the number to be round
	 * \return rounded number
	 */
	static function RoundFloat($value)
	{
		$round = 3;
		$tmp_value = $value * 10 % 10;
		if ($tmp_value < $round) {
			return floor($value);
		} else {
			return ceil($value);
		}
	}
	/*!
	 * Get the scaled size to just fit expected size
	 *
	 * \param $width photo width
	 * \param $height photo height
	 * \param $expectWidth expected width to scale
	 * \param $expectHeight expected height to scale
	 * \return array with scaled size
	 *	- width: scaled width
	 *	- height: scaled height
	 */
	static function GetJustFitWidthHeight($width, $height, $expectWidth, $expectHeight)
	{
		if ($width > $expectWidth && $height > $expectHeight) {
			if (($height / $expectHeight) < ($width / $expectWidth)) {
				$result['width'] = $expectWidth;
				$result['height'] = self::RoundFloat($height * ($expectWidth / $width));
			} else {
				$result['height'] = $expectHeight;
				$result['width'] = self::RoundFloat($width * ($expectHeight / $height));
			}
		} else if ($height > $expectHeight) {
			$result['height'] = $expectHeight;
			$result['width'] = self::RoundFloat($width * ($expectHeight / $height));
		} else if ($width > $expectWidth) {
			$result['width'] = $expectWidth;
			$result['height'] = self::RoundFloat($height*($expectWidth / $width));
		} else {
			$result['width'] = $width;
			$result['height'] = $height;
		}
		return $result;
	}
	/*!
	 * Get the scaled size to over fit expected size
	 * (ie. the shorter side will fit the expected size,
	 * and the longer side will overflow the expected size)
	 *
	 * \param $width photo width
	 * \param $height photo height
	 * \param $expectWidth expected width to scale
	 * \param $expectHeight expected height to scale
	 * \return array with scaled size
	 *	- width: scaled width
	 *	- height: scaled height
	 */
	static function GetOverFitWidthHeight($width, $height, $expectWidth, $expectHeight)
	{
		if ($width > $expectWidth && $height > $expectHeight) {
			if (($height / $expectHeight) > ($width / $expectWidth)) {
				$result['width'] = $expectWidth;
				$result['height'] = self::RoundFloat($height * ($expectWidth / $width));
			} else {
				$result['height'] = $expectHeight;
				$result['width'] = self::RoundFloat($width * ($expectHeight / $height));
			}
		} else if ($height > $expectHeight) {
			$result['width'] = $expectWidth;
			$result['height'] = self::RoundFloat($height*($expectWidth / $width));
		} else if ($width > $expectWidth) {
			$result['height'] = $expectHeight;
			$result['width'] = self::RoundFloat($width * ($expectHeight / $height));
		} else {
			$result['width'] = $width;
			$result['height'] = $height;
		}
		return $result;
	}
	/*!
	 * Get the css style to just fit image
	 *
	 * \param $img array with image info
	 *	- width: image width
	 *	- height: image height
	 * \param $maxWidth
	 * \param $maxHeight
	 */
	static function GetJustFitCenterStyle($img, $maxWidth, $maxHeight)
	{
		if ($img['width'] <= $maxWidth && $img['height'] <= $maxHeight) {
			return self::GetCenterStyle($img, $maxWidth, $maxHeight);
		}
		$scaledImg = self::GetJustFitWidthHeight($img['width'], $img['height'], $maxWidth, $maxHeight);
		if ($scaledImg['width'] > $scaledImg['height']) {
			$top = ($maxHeight - $scaledImg['height'])/2;
			return "width: {$scaledImg['width']}px; margin-top: {$top}px;";
		}
		$left = ($maxWidth - $scaledImg['width'])/2;
		return "height: {$scaledImg['height']}px; margin-left: {$left}px;";
	}
	/*!
	 * Get the css style to over fit image
	 * (ie. the shorter side will fit the expected size,
	 * and the longer side will overflow the expected size)
	 *
	 * \param $img array with image info
	 *	- width: image width
	 *	- height: image height
	 * \param $maxWidth
	 * \param $maxHeight
	 */
	static function GetOverFitCenterStyle($img, $maxWidth, $maxHeight)
	{
		if ($img['width'] <= $maxWidth && $img['height'] <= $maxHeight) {
			return self::GetCenterStyle($img, $maxWidth, $maxHeight);
		}
		$scaledImg = self::GetOverFitWidthHeight($img['width'], $img['height'], $maxWidth, $maxHeight);
		if ($scaledImg['width'] > $scaledImg['height']) {
			$left = ($scaledImg['width'] - $maxWidth)/2;
			return "height: {$scaledImg['height']}px; margin-left: -{$left}px;";
		}
		$top = ($scaledImg['height'] - $maxHeight)/2;
		return "width: {$scaledImg['width']}px; margin-top: -{$top}px;";
	}
	/*!
	 * Get the css style to center image in a block
	 * both image width/height should less then the block
	 *
	 * \param $img array with image info
	 *	- width: image width
	 *	- height: image height
	 * \param $maxWidth
	 * \param $maxHeight
	 */
	static function GetCenterStyle($img, $maxWidth, $maxHeight)
	{
		$style = "";
		if ($img['width'] < $maxWidth) {
			$left = ($maxWidth - $img['width'])/2;
			$style .= "margin-left: {$left}px; ";
		}
		if ($img['height'] < $maxHeight) {
			$top = ($maxHeight - $img['height'])/2;
			$style .= "margin-top: {$top}px; ";
		}
		return $style;
	}
	/*!
	 * Get css styles for various purposes
	 *
	 * \param $imgInfo array with various css style
	 *	- listStyle: img style to over fit div in list mode
	 *	- blockStyle: img style to over fit div in block mode
	 *	- bgAlbumStyle: img style to just fit div in backgrounded album mode
	 *	- bgThumbStyle: img style to just fit div in backgrounded photo mode
	 */
	static function GetThumbStyle($imgInfo)
	{
		$result = array();
		$result['listStyle'] = self::GetOverFitCenterStyle($imgInfo, SYNOPHOTO_THUMBSMALL_WIDTH, SYNOPHOTO_THUMBSMALL_HEIGHT);
		$result['blockStyle'] = self::GetOverFitCenterStyle($imgInfo, SYNOPHOTO_THUMB_WIDTH, SYNOPHOTO_THUMB_HEIGHT);
		$result['bgAlbumStyle'] = self::GetJustFitCenterStyle($imgInfo, SYNOPHOTO_THUMBALBUM_WIDTH, SYNOPHOTO_THUMBALBUM_HEIGHT);
		$result['bgThumbStyle'] = self::GetJustFitCenterStyle($imgInfo, SYNOPHOTO_THUMB_WIDTH, SYNOPHOTO_THUMB_HEIGHT);
		return $result;
	}
	/*!
	 * Get translated string from desktop edition language file by variable name
	 *
	 * \param $token variable name without '$photo_' prefix
	 * \return translated string
	 */
	static function GetPhotoText($token)
	{
		preg_match_all("/^\\\$photo_{$token}\\s*=\\s*'(.+)'/m",
					   file_get_contents(SYNOPHOTO_LANGS_DIR."/{$_SESSION[SYNOPHOTO_ADMIN_USER]['lang']}.php"), $matches, PREG_SET_ORDER);
		return $matches[0][1];
	}
	/*!
	 * Get translated legal information from webman strings
	 *
	 * \return array with translated legal information
	 *	- copyright_mark_desc
	 *	- copyright_note_desc
	 */
	static function GetLegalText()
	{
		preg_match_all('/^(copyright_\w+)\s*=\s*"(.+)"/m',
					   file_get_contents("../../../webman/texts/{$_SESSION[SYNOPHOTO_ADMIN_USER]['lang']}/strings"), $matches, PREG_SET_ORDER);
		$result = array();
		foreach ($matches as $item) {
			$result[$item[1]] = $item[2];
		}
		return $result;
	}
	/*!
	 * Get reduced datetime string
	 *
	 * \param $string the full datetime string: YYYY-mm-dd H:i:s
	 * \return only time if the string is in today, or otherwise only date.
	 */
	static function GetReducedDate($string)
	{
		$date = substr($string, 0, 10);
		if (date('Y-m-d') == $date) {
			return substr($string, 11);
		}
		return $date;
	}
	/*!
	 * Map ##-## language region to ###
	 *
	 * \param $lang language region
	 * \return mapped ### for supported language region, otherwise 'enu'
	 */
	static function GetMappedLanguage($lang)
	{
		if (2 == strlen($lang)) {
			$lang .= '-';
		}
		switch (true) {
			case !strcasecmp($lang, "zh-tw"):
			case !strcasecmp($lang, "zh-hk"):
			case !strcasecmp($lang, "zh-mo"):
			case !strcasecmp($lang, "zh-hant"): // ISO 639
				$lang = 'cht';
				break;
			case !strncasecmp($lang, "zh-", 3):
				$lang = 'chs';
				break;
			case !strncasecmp($lang, "en-", 3):
				$lang = 'enu';
				break;
			case !strncasecmp($lang, "de-", 3):
				$lang = 'ger';
				break;
			case !strncasecmp($lang, "ja-", 3):
				$lang = 'jpn';
				break;
			case !strncasecmp($lang, "ko-", 3):
				$lang = 'krn';
				break;
			case !strncasecmp($lang, "es-", 3):
				$lang = 'spn';
				break;
			case !strncasecmp($lang, "fr-", 3):
				$lang = 'fre';
				break;
			case !strncasecmp($lang, "it-", 3):
				$lang = 'ita';
				break;
			case !strncasecmp($lang, "ru-", 3):
				$lang = 'rus';
				break;
			case !strncasecmp($lang, "nl-", 3):
				$lang = 'nld';
				break;
			case !strncasecmp($lang, "no-", 3):
			case !strncasecmp($lang, "nb-", 3):
			case !strncasecmp($lang, "nn-", 3):
				$lang = 'nor';
				break;
			case !strncasecmp($lang, "sv-", 3):
				$lang = 'sve';
				break;
			case !strncasecmp($lang, "da-", 3):
				$lang = 'dan';
				break;
			case !strncasecmp($lang, "pl-", 3):
				$lang = 'plk';
				break;
			case !strncasecmp($lang, "pt-br", 5):
				$lang = 'ptb';
				break;
			case !strncasecmp($lang, "pt-", 3):
				$lang = 'ptg';
				break;
			case !strncasecmp($lang, "hu-", 3):
				$lang = 'hun';
				break;
			case !strncasecmp($lang, "tr-", 3):
				$lang = 'trk';
				break;
			case !strncasecmp($lang, "cs-", 3):
				$lang = 'csy';
				break;
			default:
				$lang = false;
		}
		return $lang;
	}
	/*!
	 * Get parsed config from file
	 *
	 * \param $cfgFile config file
	 * \param $confKeys config keys that values need to be returned
	 * \return array with parsed data
	 *	- key = 'value' will parse into $result['key'] = value
	 */
	static function GetConfigFile($cfgFile, $confKeys = '.+')
	{
		$trimmedCharSet = " \t\n\r\0\x0B\"'";
		preg_match_all('/^\s*('.$confKeys.')\s*=\s*(.*)/m', file_get_contents($cfgFile), $matches, PREG_SET_ORDER);
		$result = array();
		foreach ($matches as $item) {
			$result[$item[1]] = trim($item[2], $trimmedCharSet);
		}
		return $result;
	}
	/*!
	 * Log message to a file
	 *
	 * \param $string message to be logged
	 */
	static function Synophoto_Mobile_Log($string)
	{
		$handle = fopen("/tmp/synophoto_mobile_log", "a");
		fwrite($handle, date('ymd H:i:s')." => ".$string."\n");
		fclose($handle);
	}

	/*!
	 * Get syno user's email from /etc/synouser.conf
	 *
	 * \param $user username
	 */
	static function GetSynoUserEmail($user)
	{
		$mail = '';
		$file = fopen(SYNO_USER_FILE, 'r');
		while (!feof($file)) {
			$line = fgets($file, 4096);
			$line = trim($line);
			if('' == $line || 0 == strncmp($line, "#", 1)) {
				continue;
			}
			$info = explode(":", $line);
			if ($user == $info[0]) {
				return $info[2];
			}
		}

		return $mail;
	}

	static function getFbSyncConfPath($albumName)
	{
		$dirPath = sprintf("%s/%s", SYNOPHOTO_SERVICE_REAL_DIR, $albumName);
		SYNOPhotoEA::checkFilePath($dirPath, SYNOPhotoEA::FILE_ALBUM_FBSYNC, $confPath);

		return $confPath;
	}

	static function isSetToSyncWithFb($albumName)
	{
		if (null == $conf_path = self::getFbSyncConfPath($albumName)) {
			return FALSE;
		}
		$conf_path = $conf_path.".set";
		if (FALSE == @stat($conf_path)) {
			return FALSE;
		}
		return TRUE;
	}

	/*!
	 * Check if album should be skipped on ui
	 *
	 * \param $path album's directory
	 * \return true or false
	 */
	static function IsSkipPhotoPath($path)
	{
		if (!file_exists($path) || !file_exists('/proc/mounts')) {
			return false;
		}
		if (!($stPath = @stat($path))) {
			return false;
		}

		$handle = @fopen('/proc/mounts', 'r');
		$ret = false;

		while (($buf = fgets($handle, 4096)) != false) {
			list(, $dir, $type, ) = explode(" ", $buf);
			$dir = csSYNOPhotoMisc::decodeName($dir);
			if (!($stMount = @stat($dir))) {
				$ret = false;
				break;
			}
			if ($stMount['dev'] == $stPath['dev']) {
				if ($type == 'cifs' || $type == 'iso9660' || $type == 'udf') {
					$ret = true;
					break;
				}
			}
		}
		fclose($handle);
		return $ret;
	}

	function decodeName($path)
	{
		$i = 0;
		$count = strlen($path);
		$newPath = '';
		while($i < $count) {
			$four = substr($path, $i, 4);
			$two = substr($path, $i, 2);

			if ($four == '\040') {// space
				$newPath .= ' ';
				$i+=4;
			} else if ($four == '\011'){// \t
				$newPath .= "\t";
				$i+=4;
			} else if ($four == '\012') {// \n
				$newPath .= "\n";
				$i+=4;
			} else if ($two == '\\\\') {// \
				$newPath .= '\\';
				$i+=2;
			} else if ($four == '\134') {
				$newPath .= '\\';
				$i+=4;
			} else {
				$newPath .= substr($path, $i, 1);
				$i++;
			}
		}
		return $newPath;
	}

	/**
	 * Given ea filename, return type number.
	 *
	 * @param string
	 *   ea filename.
	 *
	 * @return string
	 *   Return type number if found, otherwise return false.
	 */
	private static function getTypeFromFilename($filename)
	{
		$mapping = array(
			SYNOPhotoEA::FILE_THUMB_S, // 0
			SYNOPhotoEA::FILE_THUMB_B,
			'', // ORIGINAL PHOTO
			SYNOPhotoEA::FILE_FILM_FLV,
			SYNOPhotoEA::FILE_THUMB_M,
			SYNOPhotoEA::FILE_THUMB_L, // 5
			SYNOPhotoEA::FILE_FILM_H_MP4,
			SYNOPhotoEA::FILE_FILM_M_MP4,
			SYNOPhotoEA::FILE_FILM_L_MP4,
			SYNOPhotoEA::FILE_FILM_MOBILE_MP4,
			SYNOPhotoEA::FILE_FILM_MOBILE_IPHONE, // 10
			SYNOPhotoEA::FILE_FILM_MOBILE_ANDROID,
			SYNOPhotoEA::FILE_THUMB_XL,
			SYNOPhotoEA::FILE_FILM_H264_MP4,
			SYNOPhotoEA::FILE_FILM_MPEG4_MP4,
			SYNOPhotoEA::FILE_FILM_CONVERT_MPEG4_MP4,
		);

		// remove prefix SYNOPHOTO_
		$typeString = substr($filename, 10);

		$type = array_search($typeString, $mapping);

		return $type;
	}
}
?>
